/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.inspect.entity.ManualCheckItem;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.ui.logic.ManulyCheckLayoutListener;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManulyCheckLayout
extends JPanel {
    public static final Dimension DIALOG_SIZE = new Dimension(810, 500);
    private static final Logger LOG = LoggerFactory.getLogger(ManulyCheckLayout.class);
    private static final long serialVersionUID = 1L;
    private static final int TABLE_DESC_LINE = 3;
    private static final float TABLE_LINE_HEIGHT = 2.5f;
    private static final int NUM_NE_1 = -1;
    private static final int HEAD_TYPE_SIZE = 60;
    private static final int HEAD_NAME_SIZE = 350;
    private static final int HEAD_IP_SIZE = 220;
    private static final int IDX_TYPE = 0;
    private static final int IDX_NAME = 1;
    private static final int IDX_SN = 2;
    private static final int IDX_IP = 3;
    private static final int IDX_CHECK = 4;
    private static final String[] CHECK_RESULT = new String[]{ResourceUtil.getString((String)"inspect.wizard.manuly.check.result.pass"), ResourceUtil.getString((String)"inspect.wizard.manuly.check.result.notpass"), ResourceUtil.getString((String)"inspect.wizard.manuly.check.result.notrelate")};
    private static final String[] MANUALLY_INPUTS = new String[]{ResourceUtil.getString((String)"inspect.wizard.manuly.check.result.yes"), ResourceUtil.getString((String)"inspect.wizard.manuly.check.result.no")};
    private static final Color[] COLORS = new Color[]{new Color(3967563), new Color(0xBB1B1B), new Color(0x616161)};
    private static final ImageIcon[] ICONS = new ImageIcon[]{ResourceUtil.getImage((String)"success.png"), ResourceUtil.getImage((String)"failed.png"), ResourceUtil.getImage((String)"nosupport.png")};
    private String[] header = null;
    private DefaultTableModel model = null;
    private final Pattern URL_REGEX = Pattern.compile("https?://[/a-zA-Z0-9.?=\\-%#&_:]+");
    private IsmTable table = null;
    private JLabel desc = null;
    private ToolHyperLinkLabel viewStandards = null;
    private JButton close = null;
    private JButton save = null;
    private DevNode dev;

    public ManulyCheckLayout(DevNode dev) {
        this.dev = dev;
        this.initUI();
        this.layoutUI();
        this.initTable();
    }

    public DefaultTableModel getModel() {
        return this.model;
    }

    public void setModel(DefaultTableModel model) {
        this.model = model;
    }

    public DevNode getDev() {
        return this.dev;
    }

    public void setDev(DevNode dev) {
        this.dev = dev;
    }

    private void initUI() {
        this.header = new String[]{ResourceUtil.getString((String)"inspect.wizard.manuly.check.tbl.header.checkitem"), ResourceUtil.getString((String)"inspect.wizard.manuly.check.tbl.header.checkdesc"), ResourceUtil.getString((String)"inspect.wizard.manuly.check.tbl.header.checkmode"), ResourceUtil.getString((String)"inspect.wizard.manuly.check.tbl.header.reffer"), ResourceUtil.getString((String)"inspect.wizard.manuly.check.tbl.header.checkrs")};
        this.model = new DefaultTableModel(this.header, new int[0]);
        this.table = new IsmTable((TableModel)this.model);
        TableColumnModel colModel = this.table.getColumnModel();
        this.table.setRowHeight((int)((float)this.table.getRowHeight() * 2.5f));
        colModel.getColumn(0).setPreferredWidth(60);
        colModel.getColumn(1).setPreferredWidth(350);
        colModel.getColumn(3).setPreferredWidth(220);
        this.desc = new JLabel(ResourceUtil.getString((String)"inspect.wizard.manual.check.dialog.desc"));
        this.viewStandards = new ToolHyperLinkLabel(ResourceUtil.getString((String)"inspect.wizard.manuly.check.link.export.viewStandards"));
        this.viewStandards.setName("viewStandards");
        this.viewStandards.addClickListener((ToolHyperLinkLabel.ClickListener)new ManulyCheckLayoutListener(ManulyCheckLayoutListener.ActionType.EXPORT, this));
        this.save = UiMethod.createButton((String)ResourceUtil.getString((String)"inspect.wizard.manuly.check.btn.save"));
        this.close = UiMethod.createButton((String)ResourceUtil.getString((String)"inspect.wizard.manuly.check.btn.close"));
    }

    private void layoutUI() {
        JScrollPane panel = new JScrollPane((Component)this.table);
        panel.setMaximumSize(DIALOG_SIZE);
        panel.setPreferredSize(DIALOG_SIZE);
        JComponent content = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)this.desc), UCD.buildHorizontalBoxLeft((Component)this.viewStandards), panel, UCD.buildButtonBoxRight((JButton[][])new JButton[][]{{this.save, this.close}})});
        this.add((Component)UiMethod.buildFrameSpace((JComponent)content, (int)12), "Center");
    }

    private String getCheckResult(ManualCheckItem checkItem, int idx) {
        ArrayList<String> checkRSList;
        HashMap<String, ArrayList<String>> checkRSMap = BureauDocuService.INS.getCheckRSMap();
        if (checkRSMap.containsKey(this.dev.getDeviceSerialNumber()) && idx < (checkRSList = checkRSMap.get(this.dev.getDeviceSerialNumber())).size()) {
            return checkRSList.get(idx);
        }
        String result = checkItem.getResult();
        if (result == null || "".equals(result)) {
            return null;
        }
        return result;
    }

    private int getCheckResultIndex(ManualCheckItem checkItem, int idx) {
        String item = this.getCheckResult(checkItem, idx);
        String[] keys = null != this.dev.getDevTypeLevel2() && this.dev.getDevTypeLevel2().toString().equals("OceanStor SNS") ? MANUALLY_INPUTS : CHECK_RESULT;
        for (int index = 0; index < keys.length; ++index) {
            if (!keys[index].equals(item)) continue;
            return index;
        }
        return -1;
    }

    private void initTable() {
        HashMap<String, ArrayList<ManualCheckItem>> map = BureauDocuService.INS.getManualCheckItems();
        ArrayList<ManualCheckItem> checkItems = map.get(String.valueOf(this.dev.getDeviceType()));
        int i = 0;
        int selectIndex = 0;
        for (ManualCheckItem checkItem : checkItems) {
            Object[] keys;
            int idx = 0;
            DefaultTableRow row = new DefaultTableRow(this.header.length, (Object)checkItem.getName());
            row.setValueAt(idx++, (Object)new IsmTableCell.MultiLineTextCell(StringUtils.isNULLStr((String)checkItem.getName()) ? " " : checkItem.getName(), 3));
            row.setValueAt(idx++, (Object)new IsmTableCell.MultiLineTextCell(StringUtils.isNULLStr((String)checkItem.getDesc()) ? " " : checkItem.getDesc(), 3));
            row.setValueAt(idx++, (Object)new IsmTableCell.MultiLineTextCell(StringUtils.isNULLStr((String)checkItem.getMode()) ? " " : checkItem.getMode(), 3));
            Matcher matcher = this.hasLink(checkItem.getReffer());
            if (null != matcher) {
                row.setValueAt(idx++, (Object)new IsmTableCell.HyperlinkCell(checkItem.getReffer(), (ActionListener)new HyperlinkActionListener(matcher.group()), 3));
            } else {
                row.setValueAt(idx++, (Object)new IsmTableCell.MultiLineTextCell(StringUtils.isNULLStr((String)checkItem.getReffer()) ? " " : checkItem.getReffer(), 3));
            }
            selectIndex = this.getCheckResultIndex(checkItem, i);
            Object[] objectArray = keys = null != this.dev.getDevTypeLevel2() && this.dev.getDevTypeLevel2().toString().equals("OceanStor SNS") ? MANUALLY_INPUTS : CHECK_RESULT;
            if (selectIndex >= 0) {
                row.setValueAt(idx++, (Object)IsmTableCell.ColorfulComboBoxCell.create((Object[])keys, (Color[])COLORS, (ImageIcon[])ICONS, (int)selectIndex));
            } else {
                row.setValueAt(idx++, (Object)IsmTableCell.ColorfulComboBoxCell.create((Object[])keys, (Color[])COLORS, (ImageIcon[])ICONS, (Object)ResourceUtil.getString((String)"inspector.result.select")));
            }
            this.model.addRow(new TableRow[]{row});
            ++i;
        }
    }

    private Matcher hasLink(String url) {
        if (null == url) {
            return null;
        }
        Matcher matcher = this.URL_REGEX.matcher(url);
        return matcher.find() ? matcher : null;
    }

    public JButton getClose() {
        return this.close;
    }

    public JButton getSave() {
        return this.save;
    }

    private static class HyperlinkActionListener
    implements ActionListener {
        private String url;

        public HyperlinkActionListener(String url) {
            this.url = url;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OSCmdUtils.openHtmlUrl((String)this.url);
            LOG.info("open url: {}", (Object)this.url);
        }
    }
}

