/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDeviceApplyItemLayout
extends JDialog {
    private static final long serialVersionUID = 4380571325850250106L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectDeviceApplyItemLayout.class);
    private static final Dimension SIZE = new Dimension(450, 470);
    private JButton okBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"toolbox.layout.exit.ok"), (char)'O');
    private JButton cancelBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"toolbox.layout.exit.cancel"), (char)'C');
    private String[] columnNames = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devipaddress"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devversion"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devname")};
    private DefaultTableModel tableModel = new DefaultTableModel(this.columnNames, new int[0]);
    private IsmTable appTable = new IsmTable((TableModel)this.tableModel);
    private TableScrollPane scrollPane = new TableScrollPane(this.appTable, false, false, true);
    private CheckDevNode checkDev = null;
    private List<CheckDevNode> brothersNodes = new ArrayList<CheckDevNode>();

    public SelectDeviceApplyItemLayout(List<CheckDevNode> brothersDevs, CheckDevNode checkDevNode) {
        super((Dialog)InspectContext.getInstance().getMainDialog(), true);
        this.brothersNodes = brothersDevs;
        this.checkDev = checkDevNode;
        this.initUI();
        SwingUtil.putScreenCenter((Window)this);
        this.initListener();
        this.initData(this.brothersNodes);
    }

    private void initData(List<CheckDevNode> checkDevNodes) {
        this.tableModel.removeAll();
        this.appTable.removeAll();
        try {
            String path = this.checkDev.getScriptDir().getCanonicalPath();
            for (int i = 0; i < checkDevNodes.size(); ++i) {
                String filePath = checkDevNodes.get(i).getScriptDir().getCanonicalPath();
                if (!path.equals(filePath)) continue;
                DevNode node = checkDevNodes.get(i).getDevNode();
                DefaultTableRow row = new DefaultTableRow(3, (Object)node, (Object)node.getDeviceSerialNumber());
                int j = 0;
                row.setValueAt(j++, (Object)node.getIp());
                row.setValueAt(j++, (Object)node.getProductVersion());
                row.setValueAt(j++, (Object)node.getDeviceName());
                this.tableModel.addRow(new TableRow[]{row});
                this.appTable.markTableRow(new TableRow[]{row});
            }
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("get DevNode scriptDir paht error", (Throwable)e);
        }
    }

    private void initUI() {
        this.setSize(SIZE);
        this.setTitle(ResourceUtil.getString((String)"inspsctor.applylayout.title"));
        this.setLayout(new BorderLayout());
        JComponent infoComp = UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildLeftLabel((String)ResourceUtil.getString((String)"inspsctor.applylayout.msg"))}), (int)0);
        JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{infoComp, this.scrollPane, UCD.buildHBoxRight((Component[])new Component[]{this.okBtn, this.cancelBtn})});
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)12), "Center");
    }

    private void initListener() {
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDeviceApplyItemLayout.this.checkItemApplicationFunction();
                SelectDeviceApplyItemLayout.this.setVisible(false);
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDeviceApplyItemLayout.this.setVisible(false);
            }
        });
    }

    private void checkItemApplicationFunction() {
        ArrayList<DevNode> devs = new ArrayList<DevNode>();
        List rows = this.appTable.getMarkedRows();
        for (Object row : rows) {
            devs.add((DevNode)row.getUserObject());
        }
        if (devs.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infocollect.apply.ok"));
            LOGGER.info("the choose devices is empty");
            return;
        }
        List<CheckDevNode> brothersNode = this.getSelectApplyNodes(devs);
        for (CheckDevNode node : brothersNode) {
            if (this.checkDev.getDevNode() != null && node.getDevNode().getIp() != null) {
                LOGGER.info("Apply to another device >>  Device {} apply to device {} ][Success", (Object)this.checkDev.getDevNode().getIp(), (Object)node.getDevNode().getIp());
                continue;
            }
            LOGGER.info("Apply to another device][Failed");
        }
        Map<String, List<CheckItem>> items = this.checkDev.getCheckItems();
        ArrayList<String> keys = new ArrayList<String>(items.keySet());
        for (String key : keys) {
            List<CheckItem> itemVal = items.get(key);
            for (CheckItem checkItem : itemVal) {
                this.setDevNodeCheckItem(brothersNode, checkItem, key);
            }
        }
    }

    private List<CheckDevNode> getSelectApplyNodes(List<DevNode> devs) {
        ArrayList<CheckDevNode> brothersNode = new ArrayList<CheckDevNode>();
        for (DevNode dev : devs) {
            String ip = dev.getIp();
            Iterator<CheckDevNode> iterDevNode = this.brothersNodes.iterator();
            while (iterDevNode.hasNext()) {
                CheckDevNode checkDevNode = iterDevNode.next();
                if (!checkDevNode.getDevNode().getIp().equals(ip)) continue;
                brothersNode.add(checkDevNode);
                iterDevNode.remove();
            }
        }
        return brothersNode;
    }

    private void setDevNodeCheckItem(List<CheckDevNode> checkDevNodes, CheckItem checkItem, String checkItemParentkey) {
        for (CheckDevNode checkDevNode : checkDevNodes) {
            List<CheckItem> listCheckItems = checkDevNode.getCheckItems().get(checkItemParentkey);
            if (null == listCheckItems) continue;
            for (CheckItem checkItem2 : listCheckItems) {
                this.applyOtherItems(checkItem, checkDevNode, checkItem2);
            }
        }
    }

    private void applyOtherItems(CheckItem checkItem, CheckDevNode checkDevNode, CheckItem checkItem2) {
        if (checkItem.getName().equals(checkItem2.getName())) {
            checkItem2.setEnable(checkItem.isEnable());
        }
    }
}

