/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.inspect.ui.logic.OpenHelpFile;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ShowSVPInfo
extends PublicDialog {
    private static final long serialVersionUID = 8218275154634607967L;
    private int width;
    private static int widthInChina = 600;
    private static final int HEIGHT = 200;
    private JComponent descArea;
    private static final Pattern LINK_REG = Pattern.compile("\\{(\\d+)\\}");

    public ShowSVPInfo(String title, Object[][] errMsgs, String[] linkTexts, String[] linkPath, Window parent) {
        super(parent, true);
        this.setModal(true);
        this.width = 800;
        this.setTitle(title);
        this.descArea = this.buildDescArea(errMsgs, linkTexts, linkPath);
        if (ApplicationContext.getInstance().getCurrentLanguage().equals(Locale.CHINA)) {
            this.setSize(widthInChina, 200);
        } else {
            this.setSize(this.width, 200);
        }
        this.initUI();
        SwingUtil.putParentCenter((Window)((Object)this), (Window)parent);
    }

    private void initUI() {
        this.setHelpButtonVisiable(false);
        this.setCancelButtonVisible(false);
        this.setAppButtonVisible(false);
        this.getOkBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSVPInfo.this.dispose();
            }
        });
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add((Component)UiMethod.buildFrameSpace((JComponent)this.descArea, (int)12), "Center");
    }

    private JComponent buildDescArea(Object[][] errMsgs, String[] linkTexts, String[] linkPath) {
        Box content = Box.createVerticalBox();
        for (Object[] msgs : errMsgs) {
            Box line = Box.createHorizontalBox();
            for (Object msg : msgs) {
                if (msg instanceof String) {
                    String msgStr = (String)msg;
                    Matcher matcher = LINK_REG.matcher(msgStr);
                    if (matcher.find()) {
                        int linkNum = Integer.valueOf(matcher.group(1));
                        ToolHyperLinkLabel link = new ToolHyperLinkLabel(linkTexts[linkNum]);
                        link.addClickListener((ToolHyperLinkLabel.ClickListener)new OpenHelpFile(linkPath[linkNum], (Window)((Object)this)));
                        line.add((Component)link);
                        continue;
                    }
                    line.add(new JLabel((String)msg));
                    continue;
                }
                if (!(msg instanceof Integer)) continue;
                line.add(Box.createHorizontalStrut((Integer)msg));
            }
            line.add(Box.createHorizontalGlue());
            content.add(line);
        }
        return content;
    }
}

