/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.logic.config.SupportVersion;
import com.huawei.ism.tool.inspect.ui.dialogs.SupportTableLabel;
import com.huawei.ism.tool.inspect.ui.logic.ShowSupportDevLayoutCheckDetailListener;
import com.huawei.ism.tool.inspect.ui.logic.ShowSupportDevLayoutListComparator;
import com.huawei.ism.tool.inspect.utils.ConfigParserUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmAbstractTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowSupportDevLayout
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShowSupportDevLayout.class);
    private static final String VER_REGEX = "V\\d{3}R\\d{3}";
    private static final String VER_REGEX_NEW = "[\\d]{1,4}\\.[\\d]{1,4}\\.[a-zA-Z0-9]{1,14}(\\.[a-zA-Z0-9]{1,8})?(\\.[a-zA-Z0-9]{4})?";
    private static final String KEY_WHITE_LIST = "whitelist";
    private static final String KEY_BLACK_LIST = "blacklist";
    private static final int MAX_WIDTH = 150;
    private static final int MIN_WIDTH = 100;
    private static final int MIN_WIDTH_SECOND = 50;
    private static final long serialVersionUID = -1866574799462546098L;
    private String[] tableColumn = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.devmodel"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.devversion"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.devdetail")};
    private String[] hostTableColumn = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.performinspect.devname"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.devmodel"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.devdetail")};
    private DefaultTableModel hostTableModel = new DefaultTableModel(this.hostTableColumn, new int[]{0, 1, 2});
    private DefaultTableModel tableModel = new DefaultTableModel(this.tableColumn, new int[]{0, 1, 2});
    private IsmTable devListTable = new IsmTable((TableModel)this.tableModel);
    private TableScrollPane tableScrollPane = new TableScrollPane(false, true, false, this.devListTable);
    private JButton closeBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.closebtn"));
    private static final Dimension PRODUCTTYPE_ZH = new Dimension(150, 26);
    private static final Dimension PRODUCTTYPE_EN = new Dimension(170, 26);
    private final List<String> linuxSupportDevices = Arrays.asList(ConfigParserUtils.getConfigureValue("linuxSupportDeviceModels", "").trim().split(","));
    private final List<String> aiSceneSupportDevices = Arrays.asList(ConfigParserUtils.getConfigureValue("aiStorageSupportDeviceModels", "").trim().split(","));
    private SupportTableLabel showStorageDataLabel;
    private boolean selectStorge = true;
    private List<TableRow> storageRowList = new ArrayList<TableRow>();
    private SupportTableLabel showHostDataLabel;
    private boolean selectHost = false;
    private List<TableRow> hostRowList = new ArrayList<TableRow>();
    private Map<String, List<String>> hostSupportVers;

    public ShowSupportDevLayout() {
        this(InspectContext.getInstance().getSupportVers(), InspectContext.getInstance().getExcludeVers(), InspectContext.getInstance().getSupportVersions(), InspectContext.getInstance().getExtendVersions());
    }

    public ShowSupportDevLayout(Set<String> supportVers, Set<String> excludeVers, List<SupportVersion> whitelist) {
        this(supportVers, excludeVers, whitelist, null);
    }

    public ShowSupportDevLayout(Set<String> supportVers, Set<String> excludeVers, List<SupportVersion> whitelist, List<SupportVersion> extendVersions) {
        if (InspectContext.getInstance().getSelectSceneId().equals("realTimed_check") && InspectContext.getInstance().getSelectSeceneInSecondCard().equals("")) {
            String[] temp = new String[]{"T3000", "UltraPath"};
            supportVers.addAll(InspectContext.getInstance().getSupportOrExcludeVersBySpecitySceneIDs(temp, "support"));
            supportVers.addAll(InspectContext.getInstance().getSupportOrExcludeVersBySpecitySceneIDs(temp, "exclude"));
        }
        this.setLayout(new BorderLayout());
        JLabel suggestion = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.suggestion"));
        if (!InspectUtils.isFsExInspect() && !SceneUtils.isA800SceneInTool()) {
            this.hostSupportVers = InspectContext.getInstance().getHostSupportVers();
        }
        Dimension dimension = null;
        dimension = LanguageManager.isEnglish() ? PRODUCTTYPE_EN : PRODUCTTYPE_ZH;
        ArrayList<SupportTableLabel> productCompBox = new ArrayList<SupportTableLabel>(2);
        Font font = new Font(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.font"), 0, 14);
        this.showStorageDataLabel = new SupportTableLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.storage"), 0, new Dimension(dimension), font);
        productCompBox.add(this.showStorageDataLabel);
        this.showHostDataLabel = new SupportTableLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.host"), 0, new Dimension(dimension), font);
        productCompBox.add(this.showHostDataLabel);
        JComponent productHorizotalComp = UCD.buildHorizotalBox(null, (int)0, (Component[])productCompBox.toArray(new Component[productCompBox.size()]));
        this.showStorageDataLabel.setSelectedStatus();
        JComponent vBox = null;
        if (null == this.hostSupportVers || this.hostSupportVers.isEmpty()) {
            vBox = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)suggestion), this.tableScrollPane, UCD.buildHorizontalBoxRight((Component)this.closeBtn)});
        } else {
            this.intHostRowList();
            vBox = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)suggestion), UCD.buildHorizontalBoxLeft((Component)productHorizotalComp), this.tableScrollPane, UCD.buildHorizontalBoxRight((Component)this.closeBtn)});
        }
        this.add((Component)UiMethod.buildFrameSpace((JComponent)vBox, (int)12), "Center");
        this.devListTable.getColumn((Object)this.tableColumn[0]).setMaxWidth(150);
        this.devListTable.getColumn((Object)this.tableColumn[0]).setMinWidth(100);
        this.devListTable.getColumn((Object)this.tableColumn[2]).setMinWidth(50);
        this.devListTable.getColumn((Object)this.tableColumn[2]).setMaxWidth(150);
        if (InspectUtils.isFsExInspect()) {
            this.initExtendVersion(extendVersions);
        } else {
            this.initTableData(supportVers, excludeVers, whitelist, extendVersions);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }

    private void intHostRowList() {
        for (String type : this.hostSupportVers.keySet()) {
            List<String> versions = this.hostSupportVers.get(type);
            DefaultTableRow row = new DefaultTableRow(3, (Object)type);
            HashMap<String, List<String>> verionMap = new HashMap<String, List<String>>();
            verionMap.put(KEY_WHITE_LIST, versions);
            row.setValueAt(0, (Object)type);
            row.setValueAt(1, (Object)StringUtils.deleteFirstLast((String)versions.toString()));
            row.setValueAt(2, (Object)this.createHyperlinkCell(verionMap));
            this.hostRowList.add((TableRow)row);
        }
        for (TableRow row : this.hostRowList) {
            this.hostTableModel.addRow(new TableRow[]{row});
        }
    }

    private void initTableData(Set<String> supportVers, Set<String> excludeVers, List<SupportVersion> whitelist, List<SupportVersion> extendVersions) {
        Map<String, List<String>> baseModelTypes = this.splitModelTypes(supportVers);
        Map<String, List<String>> excludeModelTypes = this.splitModelTypes(excludeVers);
        ArrayList<String> keySet = new ArrayList<String>(baseModelTypes.keySet());
        Collections.sort(keySet);
        for (String model : keySet) {
            if (!this.checkDeviceConformingScene(model)) {
                log.info("{} is not applicable to the current scenario.", (Object)model);
                continue;
            }
            DefaultTableRow row = new DefaultTableRow(3, (Object)model);
            List<String> baseVersion = baseModelTypes.get(model);
            this.sortVersions(baseVersion);
            List<String> blacklistVersion = excludeModelTypes.get(model);
            this.sortVersions(blacklistVersion);
            row.setValueAt(0, (Object)model);
            row.setValueAt(1, (Object)StringUtils.deleteFirstLast((String)baseVersion.toString()));
            Map<String, List<String>> detailedVersions = this.putVersion2Map(model, baseVersion, whitelist, blacklistVersion);
            row.setValueAt(2, (Object)(detailedVersions.isEmpty() ? "" : this.createHyperlinkCell(detailedVersions)));
            if ("Host".equals(model.trim())) continue;
            this.storageRowList.add((TableRow)row);
            this.tableModel.addRow(new TableRow[]{row});
        }
        this.initExtendVersion(extendVersions);
    }

    private void initExtendVersion(List<SupportVersion> extendVersions) {
        if (null != extendVersions && !extendVersions.isEmpty()) {
            for (SupportVersion supportversion : extendVersions) {
                String model = supportversion.getModel();
                if (this.checkSence(supportversion) || !this.checkDeviceConformingScene(model)) {
                    log.info("{} is not applicable to the current scenario.", (Object)model);
                    continue;
                }
                HashMap<String, List<String>> verionMap = new HashMap<String, List<String>>();
                String versionDes = ApplicationContext.getInstance().isEnglishEnv() ? supportversion.getDescEn() : supportversion.getDescZh();
                verionMap.put(KEY_WHITE_LIST, Arrays.asList(versionDes.split(",")));
                DefaultTableRow row = new DefaultTableRow(3, (Object)model);
                row.setValueAt(0, (Object)model);
                row.setValueAt(1, (Object)versionDes);
                row.setValueAt(2, (Object)this.createHyperlinkCell(verionMap));
                this.storageRowList.add((TableRow)row);
                this.tableModel.addRow(new TableRow[]{row});
            }
        }
    }

    private boolean checkDeviceConformingScene(String devModel) {
        log.info("Scenario matching is being performed for the {}", (Object)devModel);
        if (!ApplicationContext.getInstance().isWindowsOS()) {
            return devModel != null && this.linuxSupportDevices.contains(devModel);
        }
        if (SceneUtils.isA800SceneInTool()) {
            return devModel != null && this.aiSceneSupportDevices.contains(devModel);
        }
        return true;
    }

    private boolean checkSence(SupportVersion supportversion) {
        return InspectUtils.isFsExInspect() ? !supportversion.getSupportInspectType().contains(FusionStorageConfig.getFsExpansionCheckId()) : !supportversion.getSupportInspectType().contains(InspectContext.getInstance().getSelectInspectType());
    }

    private IsmTableCell.HyperlinkCell createHyperlinkCell(Map<String, List<String>> detailedVersions) {
        return new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.view"), (ActionListener)new ShowSupportDevLayoutCheckDetailListener(detailedVersions));
    }

    private Map<String, List<String>> putVersion2Map(String model, List<String> baseVersion, List<SupportVersion> whitelistVersion, List<String> blacklistVersion) {
        boolean isEngEnv = ApplicationContext.getInstance().isEnglishEnv();
        HashMap<String, List<String>> verionMap = new HashMap<String, List<String>>();
        List<String> whitelist = new ArrayList<String>();
        if (null != whitelistVersion) {
            for (SupportVersion version : whitelistVersion) {
                if (!model.equals(version.getModel())) continue;
                String desc = isEngEnv ? version.getDescEn() : version.getDescZh();
                Collections.addAll(whitelist, desc.split(","));
            }
            whitelist = this.filterVersions(baseVersion, whitelist);
            this.sortVersions(whitelist);
            verionMap.put(KEY_WHITE_LIST, whitelist);
        }
        ArrayList<String> blacklist = new ArrayList<String>();
        if (null != blacklistVersion && !blacklistVersion.isEmpty()) {
            blacklist.addAll(blacklistVersion);
            this.sortVersions(blacklist);
            verionMap.put(KEY_BLACK_LIST, blacklist);
        }
        return verionMap;
    }

    private void sortVersions(List<String> vers) {
        if (null != vers) {
            Collections.sort(vers, new ShowSupportDevLayoutListComparator());
        }
    }

    private List<String> filterVersions(List<String> baseVersion, List<String> whitelist) {
        ArrayList<String> returnlist = new ArrayList<String>();
        ArrayList<String> templist = new ArrayList<String>();
        for (String white : whitelist) {
            for (String base : baseVersion) {
                if (!white.contains(base)) continue;
                templist.add(white);
            }
        }
        returnlist.addAll(templist);
        ArrayList<String> temp2list = new ArrayList<String>();
        temp2list.addAll(baseVersion);
        block2: for (String base : baseVersion) {
            for (String white : templist) {
                if (!white.contains(base)) continue;
                temp2list.remove(base);
                continue block2;
            }
        }
        returnlist.addAll(temp2list);
        return returnlist;
    }

    private Map<String, List<String>> splitModelTypes(Set<String> vers) {
        HashMap<String, List<String>> modelTypes = new HashMap<String, List<String>>();
        if (null != vers) {
            for (String ver : vers) {
                String matchStr = StringUtils.findMatchStr((String)ver, (String)VER_REGEX, (int)0);
                String version = "";
                if (StringUtils.isNULLStr((String)matchStr)) {
                    matchStr = StringUtils.findMatchStr((String)ver, (String)VER_REGEX_NEW, (int)0);
                    if (!StringUtils.isNULLStr((String)matchStr)) {
                        version = ver.substring(ver.indexOf(matchStr)).trim();
                    } else {
                        String[] types = ver.split(" ");
                        version = types[types.length - 1].trim();
                    }
                } else {
                    version = ver.substring(ver.indexOf(matchStr)).trim();
                }
                String model = ver.replace(version, "").trim();
                model = this.checkSpace(model);
                version = this.checkSpace(version);
                if (modelTypes.containsKey(model)) {
                    ((List)modelTypes.get(model)).add(version);
                    continue;
                }
                ArrayList<String> verions = new ArrayList<String>();
                verions.add(version);
                modelTypes.put(model, verions);
            }
        }
        return modelTypes;
    }

    private String checkSpace(String model) {
        byte[] tempByte = new byte[model.length()];
        int i = 0;
        int findCount = 0;
        int modelLen = model.getBytes(Charset.defaultCharset()).length;
        for (int index = 0; index < modelLen; ++index) {
            byte b = model.getBytes(Charset.defaultCharset())[index];
            if (b != 92) {
                tempByte[i] = b;
            } else if (index < modelLen && 115 == model.getBytes(Charset.defaultCharset())[index + 1]) {
                tempByte[i] = 32;
                ++index;
                ++findCount;
            }
            ++i;
        }
        return new String(tempByte, 0, tempByte.length - findCount, Charset.defaultCharset());
    }

    public void showStorageTable() {
        if (!this.selectStorge) {
            this.selectStorge = true;
            this.showStorageDataLabel.setSelectedStatus();
            this.selectHost = false;
            this.showHostDataLabel.setRecoverStatus();
            this.tableModel.removeAll();
            for (TableRow row : this.storageRowList) {
                String model = (String)row.getValueAt(0);
                if (!this.checkDeviceConformingScene(model)) {
                    log.info("{} is not applicable to the current scenario.", (Object)model);
                    continue;
                }
                this.tableModel.addRow(new TableRow[]{row});
            }
            this.devListTable.setModel((IsmAbstractTableModel)this.tableModel);
        }
    }

    public void showHostTable() {
        if (!this.selectHost) {
            this.selectHost = true;
            this.showHostDataLabel.setSelectedStatus();
            this.selectStorge = false;
            this.showStorageDataLabel.setRecoverStatus();
            this.tableModel.removeAll();
            for (TableRow row : this.hostRowList) {
                this.tableModel.addRow(new TableRow[]{row});
            }
            this.devListTable.setModel((IsmAbstractTableModel)this.hostTableModel);
        }
    }

    public String[] getTableColumn() {
        if (this.tableColumn != null) {
            return (String[])this.tableColumn.clone();
        }
        return new String[0];
    }

    public void setTableColumn(String[] tableColumn) {
        this.tableColumn = tableColumn != null ? (String[])tableColumn.clone() : null;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(DefaultTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public IsmTable getDevListTable() {
        return this.devListTable;
    }

    public void setDevListTable(IsmTable devListTable) {
        this.devListTable = devListTable;
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }

    public void setCloseBtn(JButton closeBtn) {
        this.closeBtn = closeBtn;
    }

    public SupportTableLabel getShowHostDataLabel() {
        return this.showHostDataLabel;
    }

    public void setShowHostDataLabel(SupportTableLabel showHostDataLabel) {
        this.showHostDataLabel = showHostDataLabel;
    }

    public SupportTableLabel getShowStorageDataLabel() {
        return this.showStorageDataLabel;
    }

    public void setShowStorageDataLabel(SupportTableLabel showStorageDataLabel) {
        this.showStorageDataLabel = showStorageDataLabel;
    }

    public boolean isSelectHost() {
        return this.selectHost;
    }

    public boolean isSelectStorge() {
        return this.selectStorge;
    }
}

