/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportDevDetailLayout
extends JPanel {
    private static final long serialVersionUID = 6208606589592453809L;
    private static final String KEY_WHITE_LIST = "whitelist";
    private static final String KEY_BLACK_LIST = "blacklist";
    private static final Logger LOGGER = LoggerFactory.getLogger(SupportDevDetailLayout.class);
    private String[] supportTableHeader = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.supportedver")};
    private String[] unsupportTableHeader = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.unsupportedver")};
    private DefaultTableModel supportTableModel = new DefaultTableModel(this.supportTableHeader, new int[]{0});
    private DefaultTableModel unsupportTableModel = new DefaultTableModel(this.unsupportTableHeader, new int[]{0});
    private IsmTable supportTable = new IsmTable((TableModel)this.supportTableModel);
    private IsmTable unsupportTable = new IsmTable((TableModel)this.unsupportTableModel);
    private JButton closeBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.closebtn"));
    private boolean hasWhitelist = false;
    private boolean hasBlacklist = false;

    public SupportDevDetailLayout(Map<String, List<String>> versionMap) {
        this.setLayout(new BorderLayout());
        this.initData(versionMap);
        JComponent view = null;
        if (this.hasWhitelist && this.hasBlacklist) {
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{new JScrollPane((Component)this.supportTable), new JScrollPane((Component)this.unsupportTable), UCD.buildHorizontalBoxRight((Component)this.closeBtn)});
        } else if (this.hasWhitelist) {
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{new JScrollPane((Component)this.supportTable), UCD.buildHorizontalBoxRight((Component)this.closeBtn)});
        } else if (this.hasBlacklist) {
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{new JScrollPane((Component)this.unsupportTable), UCD.buildHorizontalBoxRight((Component)this.closeBtn)});
        }
        if (view == null) {
            LOGGER.info("view is null");
            return;
        }
        this.add((Component)UiMethod.buildFrameSpace(view, (int)12), "Center");
    }

    private void initData(Map<String, List<String>> versionMap) {
        DefaultTableRow row;
        List<String> versions = versionMap.get(KEY_WHITE_LIST);
        if (null != versions && !versions.isEmpty()) {
            for (String version : versions) {
                row = new DefaultTableRow(1, (Object)version);
                row.setValueAt(0, (Object)version.trim());
                this.supportTableModel.addRow(new TableRow[]{row});
            }
            this.hasWhitelist = true;
        }
        if (null != (versions = versionMap.get(KEY_BLACK_LIST)) && !versions.isEmpty()) {
            for (String version : versions) {
                row = new DefaultTableRow(1, (Object)version);
                row.setValueAt(0, (Object)version.trim());
                this.unsupportTableModel.addRow(new TableRow[]{row});
            }
            this.hasBlacklist = true;
        }
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }
}

