/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lombok.Generated;

public class WarringDialogWithInputBox
extends JDialog
implements DialogsConstants {
    private static final int INSETS_EMPTY = 0;
    private static final long serialVersionUID = -7858562840591485694L;
    private static final double WEIGHTX_1 = 0.1;
    private static final double WEIGHTY_1 = 0.1;
    private static JTextField inputJTF;
    private static Box inputJtfBox;
    private static final Dimension SIZE;
    private int dialogValue = -1;
    private JButton cannelButton;
    private JButton confirmButton;
    private JPanel displayPanel;
    private IsmTextArea displayPrompt;
    private IsmTextArea displayTip;
    private IsmTextArea displayAuthInfo;
    private JPanel wholePanel;
    private JPanel displayPromptPanel;
    private JPanel authPanel;
    private Box buttonPanel;

    public WarringDialogWithInputBox(JDialog parent, String msg) {
        super(parent);
        this.initInputBox();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.toFront();
        this.initInputDialog(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.info"), msg);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    public void setValue(int value) {
        if (Utils.isJunitTest()) {
            this.dialogValue = value;
        }
    }

    private void initInputBox() {
        inputJTF = new JTextField();
        inputJtfBox = Box.createHorizontalBox();
        inputJtfBox.add(inputJTF);
        UiMethod.setComponentSize((Dimension)SIZE, (Component[])new Component[]{inputJtfBox});
        inputJTF.getDocument().addDocumentListener(new InputListener());
    }

    private void initInputDialog(String title, String newMessage) {
        this.cannelButton = UCD.createButton((String)ResourceManager.getString((String)"COMMON.TXT.CANCEL"), (char)'C');
        this.confirmButton = UCD.createButton((String)ResourceManager.getString((String)"COMMON.TXT.CONFIRM"), (char)'O');
        this.displayPanel = new JPanel();
        this.initDisplayPrompt();
        this.initDisplayTip();
        this.wholePanel = new JPanel();
        this.initComponent();
        this.initButtonEvent();
        super.setTitle(title);
        this.displayPrompt.setText(newMessage);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        this.setBackground(LayoutConstants.BACKGROUND_COLOR);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        SwingUtil.putParentCenter((Window)this, (Window)this.getOwner());
        SwingUtil.setName((Container)this);
        this.setCompName();
        this.getRootPane().setDefaultButton(this.confirmButton);
    }

    private void initDisplayTip() {
        this.displayTip = new IsmTextArea();
        this.displayTip.setEditable(false);
        this.displayTip.setColumns(31);
        this.displayTip.setText(ResourceUtil.getString((String)"inspect.wizard.inspectDetailDialog.repair.tip"));
        this.displayAuthInfo = new IsmTextArea();
        this.displayAuthInfo.setEditable(false);
        this.displayTip.setColumns(31);
        this.displayAuthInfo.setFont(new Font("Arail", 1, 13));
        this.displayAuthInfo.setText(ResourceUtil.getString((String)"inspect.wizard.inspectDetailDialog.repair.auth"));
        this.authPanel = new JPanel();
        this.authPanel.setLayout(new GridLayout(3, 1, 3, 3));
        this.authPanel.add((Component)this.displayTip);
        this.authPanel.add((Component)this.displayAuthInfo);
        this.authPanel.add(inputJtfBox);
        this.pack();
    }

    private void initDisplayPrompt() {
        this.displayPrompt = new IsmTextArea();
        this.displayPrompt.setEditable(false);
        this.displayPrompt.setColumns(31);
        this.displayPrompt.setName("ISMV1R2_framework_WarningDialog_tipLabel");
        this.displayPromptPanel = new JPanel();
        this.displayPromptPanel.setBackground(new Color(255, 255, 255));
        this.displayPromptPanel.add((Component)this.displayPrompt);
    }

    private void initButtonEvent() {
        this.confirmButton.addActionListener(event -> this.addConfirmButtonListener());
        this.cannelButton.addActionListener(event -> this.cancelButtonAction());
    }

    private void addConfirmButtonListener() {
        if (!this.verifyInputInfo()) {
            return;
        }
        this.confirmButtonAction();
    }

    private boolean verifyInputInfo() {
        String inputInfo = InspectContext.getInstance().getRepairInput();
        if (inputInfo.equals(ResourceUtil.getString((String)"inspect.wizard.inspectDetailDialog.repair.auth"))) {
            return true;
        }
        DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"inspect.wizard.inspectDetailDialog.repair.auth.fail"));
        return false;
    }

    private void confirmButtonAction() {
        this.dialogValue = 0;
        this.dispose();
    }

    private void cancelButtonAction() {
        this.dialogValue = 1;
        this.dispose();
    }

    private void setCompName() {
        this.cannelButton.setName("_Button_cancelButton");
        this.confirmButton.setName("_Button_confirmButton");
        this.displayPrompt.setName("_TextArea_displayPrompt");
    }

    protected void initComponent() {
        int margin = 8;
        this.displayPanel();
        JSeparator separator = new JSeparator();
        this.innerPanel(margin, separator);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.panelBackground(gridBagConstraints);
        this.manageLayer();
    }

    private void manageLayer() {
        this.displayPanel.setLayout(new GridBagLayout());
        this.displayPromptPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 3, 10, 0);
        this.displayPanel.add((Component)this.displayPromptPanel, gridBagConstraints);
        this.displayPrompt.setMargin(new Insets(0, 0, 3, 0));
        gridBagConstraints = new GridBagConstraints();
        this.authPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.displayPanel.add((Component)this.authPanel, gridBagConstraints);
        this.pack();
    }

    private void displayPanel() {
        this.setDefaultCloseOperation(2);
        this.wholePanel.setLayout(new GridBagLayout());
        this.add((Component)this.wholePanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 9, 0, 12);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.wholePanel.add((Component)this.displayPanel, gridBagConstraints);
    }

    private void innerPanel(int margin, JSeparator separator) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        Box innerBox = Box.createVerticalBox();
        innerBox.add(separator);
        JComponent boxStruts = (JComponent)Box.createVerticalStrut(margin);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            boxStruts.setOpaque(true);
            boxStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        innerBox.add(boxStruts);
        this.wholePanel.add((Component)innerBox, gridBagConstraints);
    }

    private void panelBackground(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        this.buttonPanel = UCD.buildHBoxCentert((Component[])new Component[]{this.confirmButton, this.cannelButton});
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.buttonPanel.setOpaque(true);
            this.buttonPanel.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        JComponent bottomStruts = (JComponent)Box.createVerticalStrut(12);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            bottomStruts.setOpaque(true);
            bottomStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        Box bottomPanel = Box.createVerticalBox();
        bottomPanel.add(this.buttonPanel);
        bottomPanel.add(bottomStruts);
        this.wholePanel.add((Component)bottomPanel, gridBagConstraints);
    }

    @Generated
    public int getDialogValue() {
        return this.dialogValue;
    }

    static {
        SIZE = new Dimension(355, 22);
    }

    private static class InputListener
    implements DocumentListener {
        private InputListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            String text = inputJTF.getText().trim();
            InspectContext.getInstance().setRepairInput(text);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            String text = inputJTF.getText().trim();
            InspectContext.getInstance().setRepairInput(text);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            String text = inputJTF.getText().trim();
            InspectContext.getInstance().setRepairInput(text);
        }
    }
}

