/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class AdanceCompileRemotePyScript
implements Runnable {
    private static final String PYTHON_ENV = "py_java_env";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AdanceCompileRemotePyScript.class);
    public static final String BASE_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + SysConfiguration.PRODUCTS_FOLDER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map<File, JythonExecuter> requireCheckMap;
        LOGGER.info("compile remote python script start!");
        long startTime = System.currentTimeMillis();
        Map<File, JythonExecuter> map = requireCheckMap = InspectContext.getInstance().getRequireCheckMap();
        synchronized (map) {
            for (Product product : InspectContext.getInstance().getInspectProducts()) {
                File reuqireCheckPyFile;
                String reuqireCheckPyFilePath = product.getRequireCheckFile();
                if (StringUtils.isNULLStr((String)reuqireCheckPyFilePath) || !(reuqireCheckPyFile = new File(BASE_PATH + File.separator + reuqireCheckPyFilePath)).isFile() || requireCheckMap.get(reuqireCheckPyFile) != null) continue;
                File scriptFolder = reuqireCheckPyFile.getParentFile();
                JythonExecuter jythonExecuter = new JythonExecuter(scriptFolder);
                HashMap<String, Object> env = new HashMap<String, Object>();
                env.put("isInSvp", LocalHostUtil.isRunInSvp());
                env.put("allStrgHyprMtrLns", InspectContext.getInstance().getAllStrgHyprMtrLns());
                env.put("objectForPy", InspectContext.getInstance().getObjectForPy());
                env.put("lang", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
                env.put("hostLauncherWwnList", InspectContext.getInstance().getHostLauncherWwnList());
                jythonExecuter.set(PYTHON_ENV, env);
                try {
                    jythonExecuter.compileScript(reuqireCheckPyFile);
                    requireCheckMap.put(reuqireCheckPyFile, jythonExecuter);
                }
                catch (Exception e) {
                    LOGGER.error("compile remote python script error", (Throwable)e);
                }
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("compile remote python script finish, take" + (System.currentTimeMillis() - startTime));
        }
    }
}

