/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.logic.config.FlowConfig;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class AutoInitInspectCardTask {
    private static CustMsgProgressDialog progressDialog = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoInitInspectCardTask.class);
    public static final InspectWorktaker WORKTAKER = InspectContext.getInstance().getInspectWorktaker();
    private static ExecutorService autoInspectTask = Executors.newSingleThreadExecutor();
    private static List<Future<Object>> tasksFuture = new ArrayList<Future<Object>>();
    private static List<Class> clazzs = new LinkedList<Class>();

    public static List<Future<Object>> autoInvokeInit() throws Exception {
        List<AutoTask> autoInvokedTasks = AutoInitInspectCardTask.getInvokedTask();
        for (AutoTask autoTask : autoInvokedTasks) {
            Future<Object> f = autoInspectTask.submit(autoTask);
            tasksFuture.add(f);
        }
        autoInspectTask.shutdown();
        return tasksFuture;
    }

    public static List<AutoTask> getInvokedTask() throws Exception {
        LinkedList<AutoTask> autoInvokedTasks = new LinkedList<AutoTask>();
        for (Class clazz : clazzs) {
            AutoTask task = (AutoTask)clazz.newInstance();
            Map<String, Object> args = FlowConfig.getViewConfig().getTaskImplMap().get(clazz);
            task.setPriority(Integer.parseInt((String)args.get("priority")));
            task.setCondition(args.get("condition") != null && (Boolean)args.get("condition") != false);
            autoInvokedTasks.add(task);
        }
        Collections.sort(autoInvokedTasks);
        return autoInvokedTasks;
    }

    public static void disposeProgressDialog() {
        if (null == progressDialog) {
            return;
        }
        SwingUtil.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
            }
        });
    }

    public static void showProgressDialog() {
        if (null == progressDialog) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.getIconLabel().updateUI();
            }
        });
    }

    public static CustMsgProgressDialog getProgressDialog() {
        return progressDialog;
    }

    public static void setProgressDialog(CustMsgProgressDialog progressDialog) {
        AutoInitInspectCardTask.progressDialog = progressDialog;
    }

    static {
        FlowConfig.Config viewConfig = FlowConfig.getViewConfig();
        if (null != viewConfig && !viewConfig.getTaskImplMap().isEmpty()) {
            clazzs.addAll(viewConfig.getTaskImplMap().keySet());
        }
    }

    static class AutoInitSetResultSaveCardTask
    extends AutoTask {
        public AutoInitSetResultSaveCardTask() {
            this.priority = 15;
        }

        @Override
        public Object call() throws Exception {
            LOGGER.info("auto invoke init SetResultSaveCard task");
            Object defaultPathObj = HibernateContainer.getInstance().get((Object)"inspect_saveresult_path_id001");
            String defaultName = InspectUtils.buildResultFileName("").getName();
            String resultSaveDir = "";
            if (SceneUtils.isScene()) {
                resultSaveDir = InspectContext.getInstance().getSceneCollectDir();
            } else if (defaultPathObj != null) {
                File oldFile = new File(defaultPathObj.toString());
                resultSaveDir = oldFile.getParent();
            } else {
                resultSaveDir = FilesUtil.getCanonicalPath((File)FileUtils.getDefaultDirectory());
            }
            WORKTAKER.put("check_savepath", resultSaveDir);
            WORKTAKER.put("check_savepath_filename", defaultName);
            return null;
        }
    }

    static class AutoInitSelectItemCardTask
    extends AutoTask {
        public AutoInitSelectItemCardTask() {
            this.priority = 10;
        }

        @Override
        public Object call() throws Exception {
            LOGGER.info("auto invoke init SelectItemCard task");
            WORKTAKER.initDebugPwdDevs();
            return null;
        }
    }

    static class AutoInitSelectDeviceCardTask
    extends AutoTask {
        public AutoInitSelectDeviceCardTask() {
            this.priority = 5;
        }

        @Override
        public Object call() throws Exception {
            LOGGER.info("Auto invoke init SelectDeviveCard task");
            List<DevNode> selectDevs = SelectDeviceCard.getDevManagerList();
            if (SelectDeviceCard.getDevSupport() == 3 || this.isStorageDeployNoFindDev(selectDevs)) {
                DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"scene.dev.no.support"));
                InspectContext.getInstance().fireToolStopped();
            } else if (SelectDeviceCard.getDevSupport() == 2) {
                if (!SceneUtils.isSpecialScence((String)System.getenv("jsonScene"), (String[])new String[]{"Storage Deploy"})) {
                    DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"scene.dev.part.support"));
                }
                LOGGER.info("Meet storage deploy, ignore the part support.");
            }
            if (!this.condition(selectDevs)) {
                LOGGER.info("Meet condition,finish this task.");
                return null;
            }
            WORKTAKER.put("select_dev_nodes", selectDevs);
            WORKTAKER.put("scene_hyper_metro_nodes", InspectUtils.getHyperMetroDevNodeList());
            List<CheckDevNode> checkdevNodes = WORKTAKER.loadProductConfigByDevNode(null);
            WORKTAKER.put("check_dev_nodes", checkdevNodes);
            return null;
        }

        private boolean isStorageDeployNoFindDev(List<DevNode> selectDevs) {
            return SceneUtils.isSpecialScence((String)System.getenv("jsonScene"), (String[])new String[]{"Storage Deploy"}) && selectDevs.isEmpty();
        }

        private boolean condition(List<DevNode> selectDevs) {
            boolean goOn = true;
            if (null != selectDevs && this.condition) {
                boolean hasDsStorage;
                if (InspectContext.getInstance().isBureauSupport() && BureauDocuService.INS.hasSupportedDev(selectDevs)) {
                    InspectUIUtil.insertStepCard(CardModelEnum.SELECTDEVICE, CardModelEnum.MANULY);
                }
                if (hasDsStorage = selectDevs.stream().anyMatch(DevNode::isDsStorage)) {
                    InspectUIUtil.insertStepCard(CardModelEnum.SELECTDEVICE, CardModelEnum.SELECT_CLUSTER_NODES);
                    goOn = false;
                }
                boolean hasHyper = selectDevs.stream().anyMatch(DevNode::isHyperMetro);
                boolean hasHostOrServer = InspectContext.havaHostOrServer();
                if (hasHyper) {
                    goOn = false;
                    if (hasHostOrServer) {
                        InspectUIUtil.insertStepCard(CardModelEnum.SELECTDEVICE, CardModelEnum.HYPER_MANULY_CHECK);
                    }
                }
                boolean hasMetaVision = selectDevs.stream().anyMatch(EntityUtils::isComputeStorageDevLoginThroughFcv);
                if (goOn && !hasMetaVision && !SceneUtils.isA800SceneInTool()) {
                    InspectUIUtil.removeStepCard(CardModelEnum.SELECTDEVICE);
                }
            }
            return goOn;
        }
    }

    static class AutoInitWelcomeCardTask
    extends AutoTask {
        public AutoInitWelcomeCardTask() {
            this.priority = 0;
        }

        @Override
        public Object call() throws Exception {
            LOGGER.info("auto invoke init WelcomeCard task");
            InspectContext.getInstance().getIsScenesInspect().clear();
            String sceneArg = InspectContext.getArgsParamFormSceneConfig("sceneInsepctObject");
            if (StringUtils.isNULLStr((String)sceneArg)) {
                sceneArg = "realTimed_check";
            }
            InspectContext.getInstance().getIsScenesInspect().put(sceneArg, true);
            WORKTAKER.put("select_sceneId", sceneArg);
            InspectContext.getInstance().setBureauCheckSelected("bureau_check".equalsIgnoreCase(sceneArg));
            return null;
        }
    }

    public static class AutoTask
    implements Comparable<AutoTask>,
    Callable<Object> {
        int priority = 0;
        boolean condition = false;

        public boolean isCondition() {
            return this.condition;
        }

        public void setCondition(boolean condition) {
            this.condition = condition;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        @Override
        public int compareTo(AutoTask task) {
            return this.priority - task.getPriority();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.priority;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AutoTask other = (AutoTask)obj;
            return this.priority == other.priority;
        }

        @Override
        public Object call() throws Exception {
            return null;
        }
    }
}

