/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.inspect.entity.BureauDocuConfig;
import com.huawei.ism.tool.inspect.entity.BureauFile;
import com.huawei.ism.tool.inspect.entity.ExcelLocation;
import com.huawei.ism.tool.inspect.entity.ManualCheckItem;
import com.huawei.ism.tool.inspect.ui.logic.ManulyCheckListener;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import utils.FilesUtil;

public enum BureauDocuService {
    INS;

    private static final Logger LOG;
    private static final String TAG_CONFIG = "config";
    private static final String TAG_TYPE = "type";
    private static final String TAG_VERSION = "version";
    private static final String TAG_URL_ZH = "url_zh";
    private static final String TAG_URL_EN = "url_en";
    private static final String TAG_LOCAL_RESOURCE_ZH = "localResource_zh";
    private static final String TAG_LOCAL_RESOURCE_EN = "localResource_en";
    private static final String TAG_URL = "url";
    private static final String ATT_URL = "url";
    private static final String ATT_NAME = "name";
    private static final String ATT_DEFAULT_NAME = "defaultName";
    private static final String REG_COMMA = "\\s*,\\s*";
    private static final String DOT = ".";
    private static final String REG_AND = "\\s*&\\s*";
    private static final String UNDERLINE = "_";
    private static final String SLASH = "/";
    private static final String XML_PATH = "/packages/inspector/products/bureauConfig.xml";
    private static final String ZIP = ".zip";
    private static final ExcelLocation SCORE_LOC;
    private static final ExcelLocation TYPE_LOC;
    private static final ExcelLocation PICS_LOC;
    private static final ExcelLocation SN_LOC;
    private static final String URL_FIX = "file:///";
    private static final String FILE_FIX = "[a-zA-Z]:";
    private static final String BUREAU_FOLDER = "doc";
    private static final String PICTURES_FOLDER = "files";
    private static final List<BureauDocuConfig> CONFIGS;
    private static final int FONT_SIZE = 11;
    private int uid = 0;
    private String mainURL;
    private static final int MANUAL_CHECK_SHEET_IDX = 0;
    private static final int ROW_MAX = 100;
    private static final int ROW_BEGIN = 1;
    private static final int CHECK_NAME_COL = 1;
    private static final int CHECK_DESC_COL = 3;
    private static final int CHECK_MODE_COL = 4;
    private static final int CHECK_REFFER_COL = 5;
    private HashMap<String, ArrayList<String>> checkRSMap = new HashMap();
    private HashMap<String, String> passRateMap = new HashMap();

    public HashMap<String, String> getPassRateMap() {
        return this.passRateMap;
    }

    public HashMap<String, ArrayList<String>> getCheckRSMap() {
        return this.checkRSMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConfig() {
        File xml = new File(ApplicationContext.getInstance().getWorkPath() + XML_PATH);
        LOG.info("bureau document config file XML_PATH: " + FilesUtil.getCanonicalPath((File)xml));
        FileInputStream is = null;
        Document document = null;
        try {
            is = new FileInputStream(xml);
            document = XmlUtils.parseDocument((InputStream)is);
        }
        catch (IOException e) {
            LOG.error("parse bureau document config file error, init config failed", (Throwable)e);
            return;
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)is);
        }
        Element root = document.getDocumentElement();
        this.mainURL = root.getAttribute("url");
        NodeList list = root.getElementsByTagName(TAG_CONFIG);
        this.setStringLink(list);
        LOG.info("init bureau document config service DONE.");
    }

    void setStringLink(NodeList list) {
        if (null != list && list.getLength() > 0) {
            for (int index = 0; index < list.getLength(); ++index) {
                boolean check;
                String defaultName;
                String localResource;
                String url;
                Element element = (Element)list.item(index);
                String name = element.getAttribute(ATT_NAME);
                String type = this.getTagContent(element, TAG_TYPE);
                String version = this.getTagContent(element, TAG_VERSION);
                if (Locale.ENGLISH.equals(LanguageManager.getInstance().getCurrentLanguage())) {
                    url = this.getTagContent(element, TAG_URL_EN);
                    localResource = this.getTagContent(element, TAG_LOCAL_RESOURCE_EN);
                    defaultName = this.getTagAtt(element, TAG_LOCAL_RESOURCE_EN, ATT_DEFAULT_NAME);
                } else {
                    url = this.getTagContent(element, TAG_URL_ZH);
                    localResource = this.getTagContent(element, TAG_LOCAL_RESOURCE_ZH);
                    defaultName = this.getTagAtt(element, TAG_LOCAL_RESOURCE_ZH, ATT_DEFAULT_NAME);
                }
                LOG.info(String.format(Locale.ENGLISH, "config type: %s, version: %s, url: %s", type, version, url));
                boolean bl = check = StringUtils.isNULLStr((String)name) || StringUtils.isNULLStr((String)type) || StringUtils.isNULLStr((String)version) || StringUtils.isNULLStr((String)url) || StringUtils.isNULLStr((String)localResource) || StringUtils.isNULLStr((String)defaultName);
                if (check) continue;
                String[] types = type.split(REG_COMMA);
                String[] versions = version.split(REG_COMMA);
                boolean bl2 = check = null == types || 0 == types.length || null == versions || 0 == versions.length;
                if (check) continue;
                CONFIGS.add(new BureauDocuConfig().addName(name).addTypes(Arrays.asList(types)).addVersions(Arrays.asList(versions)).addUrl(url.trim()).addLocalResource(localResource).addDefaultName(defaultName));
            }
        }
    }

    public String getUrl(String type) {
        BureauDocuConfig config = this.getConfig(type);
        if (null == config) {
            return null;
        }
        return config.getUrl();
    }

    public boolean isSameDevType(List<DevNode> devs) {
        if (null == devs || devs.isEmpty()) {
            return false;
        }
        if (devs.size() == 1) {
            return true;
        }
        DeviceType type = devs.get(0).getDeviceType();
        for (DevNode dev : devs) {
            if (type.equals((Object)dev.getDeviceType())) continue;
            return false;
        }
        return true;
    }

    public void filterDevs(List<DevNode> devs) {
        if (null == devs || devs.isEmpty()) {
            return;
        }
        ArrayList<DevNode> delDevs = new ArrayList<DevNode>();
        for (DevNode dev : devs) {
            if (this.isDevSupport(dev)) continue;
            delDevs.add(dev);
        }
        devs.removeAll(delDevs);
    }

    public boolean hasSupportedDev(List<DevNode> devs) {
        if (null == devs || devs.isEmpty()) {
            return false;
        }
        for (DevNode dev : devs) {
            if (!this.isDevSupport(dev)) continue;
            return true;
        }
        return false;
    }

    public boolean isDevSupport(DevNode dev) {
        BureauDocuConfig config = this.getConfig(String.valueOf(dev.getDeviceType()));
        if (null == config) {
            return false;
        }
        return config.versionContains(dev.getProductVersion());
    }

    public boolean isDevSupportWithAllConditions(DevNode dev) {
        return this.isDevSupport(dev) && InspectContext.getInstance().isBureauCheck();
    }

    public String getLocalResource(String type) {
        BureauDocuConfig config = this.getConfig(type);
        return config == null ? null : config.getLocalResource();
    }

    public String getDefaultName(String type) {
        BureauDocuConfig config = this.getConfig(type);
        return config == null ? null : config.getDefaultName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int parseScore(DevNode dev) {
        int n;
        BureauFile file = InspectContext.getInstance().getBureauFile(dev);
        if (null == file || null == file.getFile() || !file.getFile().exists()) {
            LOG.error("get bureau file error, dev: " + (dev == null ? "null" : dev.getIp()));
            return -1;
        }
        FileInputStream is = null;
        XSSFWorkbook book = null;
        try {
            is = new FileInputStream(file.getFile());
            book = new XSSFWorkbook((InputStream)is);
            XSSFSheet sheet = book.getSheetAt(SCORE_LOC.getSheet());
            XSSFRow row = sheet.getRow(SCORE_LOC.getRow());
            XSSFCell cell = row.getCell(SCORE_LOC.getCol());
            LOG.info("source data: " + cell.getNumericCellValue());
            n = new BigDecimal(String.valueOf(cell.getNumericCellValue())).setScale(0, 4).intValue();
        }
        catch (IOException e) {
            int n2;
            try {
                LOG.error("parse score of dev: " + dev.getIp() + "error.", (Throwable)e);
                n2 = -1;
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, book);
                StreamUtils.closeResource(null, (Closeable)is);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)book);
            StreamUtils.closeResource(null, (Closeable)is);
            return n2;
        }
        StreamUtils.closeResource(null, (Closeable)book);
        StreamUtils.closeResource(null, (Closeable)is);
        return n;
    }

    public String getAnnex(DevNode node) {
        BureauFile file = InspectContext.getInstance().getBureauFile(node);
        if (null == file) {
            return null;
        }
        return ".\\..\\..\\..\\doc\\" + node.getIp() + UNDERLINE + node.getDeviceSerialNumber() + ZIP;
    }

    public void handleFilesWithDocu(File path) {
        Set<Map.Entry<DevNode, BureauFile>> entries = InspectContext.getInstance().getBureauFiles().entrySet();
        if (entries.isEmpty()) {
            return;
        }
        File docuDir = new File(path, "doc/");
        if (!docuDir.mkdirs()) {
            LOG.error("create folder error, folder: " + FilesUtil.getCanonicalPath((File)docuDir));
            return;
        }
        for (Map.Entry<DevNode, BureauFile> entry : entries) {
            this.handleOneFile(entry.getValue(), docuDir, entry.getKey());
        }
    }

    public void handleFilesWithDocuByDevNode(File path, DevNode node) {
        BureauFile bureauFile = InspectContext.getInstance().getBureauFile(node);
        if (null == bureauFile) {
            return;
        }
        File docuDir = new File(path, "doc/");
        if (!docuDir.exists() && !docuDir.mkdirs()) {
            LOG.error("create folder error.");
            return;
        }
        this.handleOneFile(bureauFile, docuDir, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOneFile(BureauFile file, File docuDir, DevNode dev) {
        File picPath = new File(docuDir, dev.getIp() + UNDERLINE + dev.getDeviceSerialNumber() + SLASH + PICTURES_FOLDER + SLASH);
        if (!picPath.mkdirs()) {
            LOG.error("mkdir for file error, file: " + FilesUtil.getCanonicalPath((File)picPath) + ", dev: " + dev.getIp());
        }
        File devPath = picPath.getParentFile();
        FileInputStream is = null;
        XSSFWorkbook book = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(file.getFile());
            book = new XSSFWorkbook((InputStream)is);
            XSSFCreationHelper helper = new XSSFCreationHelper(book);
            this.rewriteSN(book, dev.getDeviceSerialNumber());
            int numSheet = book.getNumberOfSheets();
            for (int index = PICS_LOC.getSheet(); index < numSheet; ++index) {
                this.handleOneSheet(book, helper, book.getSheetAt(index), file.getFile(), picPath);
            }
            os = new FileOutputStream(new File(devPath, file.getFileName()));
            book.write((OutputStream)os);
        }
        catch (Exception e) {
            try {
                LOG.error("handle bureauFile error, file: " + file.getFile(), (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, book);
                StreamUtils.closeResource(null, os);
                StreamUtils.closeResource(null, (Closeable)is);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)book);
            StreamUtils.closeResource(null, os);
            StreamUtils.closeResource(null, (Closeable)is);
        }
        StreamUtils.closeResource(null, (Closeable)book);
        StreamUtils.closeResource(null, (Closeable)os);
        StreamUtils.closeResource(null, (Closeable)is);
        try {
            boolean compressSucc = FileAssistant.compressFileZipSaveMode((String)(devPath.getCanonicalPath() + ZIP), (String[])new String[]{devPath.getCanonicalPath()});
            boolean deleteFile = false;
            if (compressSucc) {
                deleteFile = FileAssistant.delDirAndFile((String)devPath.getCanonicalPath());
            }
            LOG.info("compress file for " + devPath.getCanonicalPath() + ": " + compressSucc + ", delete file: " + deleteFile);
        }
        catch (IOException e) {
            LOG.error("get path error.", (Throwable)e);
        }
    }

    private void rewriteSN(XSSFWorkbook book, String sn) {
        XSSFCell cell = this.getCell(book, SN_LOC);
        if (null == cell) {
            LOG.error("sn cell is null, rewrite sn failed.");
            return;
        }
        LOG.info("sn cell original value: " + cell.getStringCellValue());
        cell.setCellValue(sn);
        try {
            XSSFCellStyle style = cell.getCellStyle().copy();
            XSSFFont font = book.createFont();
            font.setFontName("\u9ed1\u4f53");
            font.setFontHeightInPoints((short)11);
            style.setFont((Font)font);
            style.setDataFormat(book.createDataFormat().getFormat("@"));
            cell.setCellStyle((CellStyle)style);
        }
        catch (Exception e) {
            LOG.error("set cell style error.", (Throwable)e);
        }
    }

    private void handleOneSheet(XSSFWorkbook book, XSSFCreationHelper helper, XSSFSheet sheet, File excel, File picPath) {
        for (int rowIndex = PICS_LOC.getRow(); rowIndex < sheet.getLastRowNum(); ++rowIndex) {
            XSSFRow row = sheet.getRow(rowIndex);
            for (int colIndex = PICS_LOC.getCol(); colIndex < row.getPhysicalNumberOfCells(); ++colIndex) {
                XSSFCell cell = row.getCell(colIndex);
                try {
                    this.handleOneCell(book, helper, cell, excel, picPath);
                    continue;
                }
                catch (Exception e) {
                    LOG.error("handle cell error. ", (Throwable)e);
                }
            }
        }
    }

    private void handleOneCell(XSSFWorkbook book, XSSFCreationHelper helper, XSSFCell cell, File excel, File picPath) {
        if (null == cell) {
            return;
        }
        XSSFHyperlink link = cell.getHyperlink();
        if (null == link) {
            return;
        }
        String address = link.getAddress();
        LOG.info("row address: " + address);
        try {
            address = URLDecoder.decode(address, "UTF-8");
        }
        catch (Exception e1) {
            try {
                address = URLDecoder.decode(address, "GBK");
            }
            catch (Exception e) {
                LOG.error("deocde address error, address: " + address, (Throwable)e);
            }
        }
        LOG.info("decoded address: " + address);
        File srcFile = null;
        srcFile = address.startsWith(URL_FIX) ? new File(address.substring(URL_FIX.length())) : (address.startsWith(FILE_FIX) ? new File(address) : new File(excel.getParentFile(), address));
        try {
            srcFile = srcFile.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.error("get canonical file error", (Throwable)e);
        }
        LOG.info("src file: " + FilesUtil.getCanonicalPath((File)srcFile));
        File targetFile = this.getTargetCopyFile(picPath, srcFile.getName());
        boolean copyFileError = false;
        try {
            FileUtils.copyFile((File)srcFile, (File)targetFile);
            LOG.info("target file: " + FilesUtil.getCanonicalPath((File)targetFile));
        }
        catch (IOException e) {
            LOG.error("copy file error, srcFile: " + FilesUtil.getCanonicalPath((File)srcFile) + ", targetFile: " + FilesUtil.getCanonicalPath((File)targetFile), (Throwable)e);
            copyFileError = true;
        }
        this.setHyperNewLink(book, helper, cell, srcFile, targetFile, copyFileError);
    }

    private void setHyperNewLink(XSSFWorkbook book, XSSFCreationHelper helper, XSSFCell cell, File srcFile, File targetFile, boolean copyFileError) {
        try {
            if (copyFileError) {
                cell.setCellValue("Copy file error, source file may not exist. source file: " + FilesUtil.getCanonicalPath((File)srcFile));
                cell.setHyperlink(null);
                XSSFCellStyle style = cell.getCellStyle().copy();
                XSSFFont font = book.createFont();
                font.setFontName("\u9ed1\u4f53");
                style.setFont((Font)font);
                style.setDataFormat(book.createDataFormat().getFormat("@"));
                cell.setCellStyle((CellStyle)style);
                return;
            }
            cell.setCellValue(targetFile.getName());
            XSSFHyperlink newLink = helper.createHyperlink(HyperlinkType.FILE);
            String addressEncoded = URLEncoder.encode(PICTURES_FOLDER + File.separator + targetFile.getName(), "UTF-8");
            LOG.info("address encoded: " + addressEncoded);
            newLink.setAddress(addressEncoded);
            cell.setHyperlink(null);
            cell.setHyperlink((Hyperlink)newLink);
        }
        catch (Exception e) {
            LOG.error("set new link error", (Throwable)e);
        }
    }

    private File getTargetCopyFile(File path, String name) {
        String fix = name.substring(name.lastIndexOf(DOT) + 1);
        File res = new File(path, this.getFileName(fix));
        while (res.exists()) {
            res = new File(path, this.getFileName(fix));
        }
        return res;
    }

    private synchronized String getFileName(String fix) {
        return "FILE_" + this.uid++ + DOT + fix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BureauFile isDocuSupportDev(File file, DevNode dev) {
        BureauFile bureauFile;
        int score;
        XSSFWorkbook book;
        FileInputStream is;
        block7: {
            XSSFCell scoreCell;
            XSSFCell typeCell;
            block6: {
                is = null;
                book = null;
                is = new FileInputStream(file);
                book = new XSSFWorkbook((InputStream)is);
                typeCell = this.getCell(book, TYPE_LOC);
                scoreCell = this.getCell(book, SCORE_LOC);
                if (null != typeCell && null != scoreCell) break block6;
                BureauFile bureauFile2 = null;
                StreamUtils.closeResource(null, (Closeable)book);
                StreamUtils.closeResource(null, (Closeable)is);
                return bureauFile2;
            }
            String typeStr = typeCell.getStringCellValue();
            score = new BigDecimal(String.valueOf(scoreCell.getNumericCellValue())).setScale(0, 4).intValue();
            LOG.info(String.format(Locale.ENGLISH, "get type supported from file:types: %s, score: %s, srcScore: %s", typeStr, score, scoreCell.getNumericCellValue()));
            List<String> types = Arrays.asList(typeStr.split(REG_AND));
            if (dev != null && types.contains(String.valueOf(dev.getDeviceType()))) break block7;
            BureauFile bureauFile3 = null;
            StreamUtils.closeResource(null, (Closeable)book);
            StreamUtils.closeResource(null, (Closeable)is);
            return bureauFile3;
        }
        try {
            BureauFile res = new BureauFile(file);
            res.setScore(score);
            bureauFile = res;
        }
        catch (Exception e) {
            BureauFile bureauFile4;
            try {
                LOG.error("parse excel file error, ", (Throwable)e);
                bureauFile4 = null;
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, book);
                StreamUtils.closeResource(null, (Closeable)is);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)book);
            StreamUtils.closeResource(null, (Closeable)is);
            return bureauFile4;
        }
        StreamUtils.closeResource(null, (Closeable)book);
        StreamUtils.closeResource(null, (Closeable)is);
        return bureauFile;
    }

    private XSSFCell getCell(XSSFWorkbook book, ExcelLocation location) {
        XSSFSheet sheet = book.getSheetAt(location.getSheet());
        if (null == sheet) {
            return null;
        }
        XSSFRow row = sheet.getRow(location.getRow());
        if (null == row) {
            return null;
        }
        return row.getCell(location.getCol());
    }

    public BureauDocuConfig getConfig(String type) {
        if (StringUtils.isNULLStr((String)type)) {
            return null;
        }
        for (BureauDocuConfig config : CONFIGS) {
            if (!config.containType(type)) continue;
            return config;
        }
        return null;
    }

    public List<BureauDocuConfig> getConfigs(List<DevNode> nodes) {
        HashSet<BureauDocuConfig> res = new HashSet<BureauDocuConfig>();
        for (DevNode node : nodes) {
            res.add(this.getConfig(String.valueOf(node.getDeviceType())));
        }
        return new ArrayList<BureauDocuConfig>(res);
    }

    public List<String> getUrls(List<DevNode> nodes) {
        HashSet<String> res = new HashSet<String>();
        for (DevNode node : nodes) {
            res.add(this.getUrl(String.valueOf(node.getDeviceType())));
        }
        return new ArrayList<String>(res);
    }

    private Element getTag(Element element, String tag) {
        NodeList nodeList = element.getElementsByTagName(tag);
        if (null != nodeList && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private String getTagAtt(Element element, String tag, String attribute) {
        Element e = this.getTag(element, tag);
        return null == e ? null : e.getAttribute(attribute);
    }

    private String getTagContent(Element element, String tag) {
        Element e = this.getTag(element, tag);
        return null == e ? null : e.getTextContent();
    }

    public String getMainURL() {
        return this.mainURL;
    }

    public List<BureauDocuConfig> getConfigs() {
        return CONFIGS;
    }

    public HashMap<String, ArrayList<ManualCheckItem>> getManualCheckItems() {
        return this.getManualCheckItems(this.getConfigs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, ArrayList<ManualCheckItem>> getManualCheckItems(List<BureauDocuConfig> manualCheckConfigs) {
        XSSFWorkbook book = null;
        InputStream input = null;
        HashMap<String, ArrayList<ManualCheckItem>> map = new HashMap<String, ArrayList<ManualCheckItem>>();
        for (BureauDocuConfig config : manualCheckConfigs) {
            try {
                XSSFCell name;
                input = ManulyCheckListener.class.getResourceAsStream(config.getLocalResource());
                book = new XSSFWorkbook(input);
                ArrayList<ManualCheckItem> checkItems = new ArrayList<ManualCheckItem>();
                for (int row = 1; row < 100 && (name = this.getCell(book, new ExcelLocation(0, row, 1))) != null && !"".equals(name.getStringCellValue()); ++row) {
                    XSSFCell desc = this.getCell(book, new ExcelLocation(0, row, 3));
                    XSSFCell mode = this.getCell(book, new ExcelLocation(0, row, 4));
                    XSSFCell reffer = this.getCell(book, new ExcelLocation(0, row, 5));
                    ManualCheckItem checkItem = new ManualCheckItem();
                    checkItem.setName(String.valueOf(name));
                    checkItem.setDesc(String.valueOf(desc));
                    checkItem.setMode(String.valueOf(mode));
                    checkItem.setReffer(String.valueOf(reffer));
                    checkItems.add(checkItem);
                }
                for (String type : config.getTypes()) {
                    map.put(type, checkItems);
                }
            }
            catch (Exception e) {
                HashMap<String, ArrayList<ManualCheckItem>> hashMap;
                try {
                    LOG.error("parse excel file error, ", (Throwable)e);
                    map.clear();
                    hashMap = map;
                }
                catch (Throwable throwable) {
                    StreamUtils.closeResource(null, book);
                    StreamUtils.closeResource(null, (Closeable)input);
                    throw throwable;
                }
                StreamUtils.closeResource(null, (Closeable)book);
                StreamUtils.closeResource(null, (Closeable)input);
                return hashMap;
            }
            StreamUtils.closeResource(null, (Closeable)book);
            StreamUtils.closeResource(null, (Closeable)input);
        }
        return map;
    }

    static {
        LOG = LoggerFactory.getLogger(BureauDocuService.class);
        SCORE_LOC = new ExcelLocation(1, 5, 1);
        TYPE_LOC = new ExcelLocation(0, 13, 1);
        PICS_LOC = new ExcelLocation(2, 1, 11);
        SN_LOC = new ExcelLocation(1, 3, 1);
        CONFIGS = new ArrayList<BureauDocuConfig>();
    }
}

