/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessToFile;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.logic.inspector.ResultCalc;
import com.huawei.ism.tool.inspect.service.implement.ExecuteTask;
import com.huawei.ism.tool.inspect.ui.dialogs.InspectDetailLayout;
import com.huawei.ism.tool.inspect.utils.InspectCommonResBundle;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.DefaultListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTaskProgressObserver
implements IUiObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteTaskProgressObserver.class);
    private static final int MAX_PROGRESS = 100;
    private static final Object SILENT_RESULTS_LOCK = new Object();
    private final ExecuteTask executeTask;
    private Map<DevNode, SilentProcessData> silentResults = new ConcurrentHashMap<DevNode, SilentProcessData>();
    private Map<DevNode, CheckDevNode> dev2CheckDevMap = new ConcurrentHashMap<DevNode, CheckDevNode>();
    private SilentProcessData totalProcessData = new SilentProcessData();
    private String progressWorkPath = InspectContext.getInstance().getSilentWorkPath();
    private static final int MAX_ITEM_PROGRESS = 95;
    private ScheduledThreadPoolExecutor updater = new ScheduledThreadPoolExecutor(1);
    private static final int XML_UPDATE_PERIOD = 8;
    private static final int MAX_PASS_RATE = 100;

    public ExecuteTaskProgressObserver(ExecuteTask executeTask) {
        this.executeTask = executeTask;
    }

    public void startScheduleUpdate() {
        this.updater.scheduleAtFixedRate(this::scheduleUpdate, 8L, 8L, TimeUnit.SECONDS);
    }

    private void scheduleUpdate() {
        ArrayList<SilentProcessData> dataList = new ArrayList<SilentProcessData>(this.silentResults.size());
        this.silentResults.forEach((dev, data) -> {
            try {
                CheckDevNode checkDev = this.dev2CheckDevMap.get(dev);
                if (null != checkDev) {
                    this.updateDevProgress(checkDev);
                    data.setReturnData(this.buildReturnData(checkDev));
                }
                LOGGER.info("Update progress {} .", data);
                dataList.add((SilentProcessData)data);
            }
            catch (Exception e) {
                LOGGER.error("update progress failed.");
            }
        });
        this.updateSilentResult(dataList);
    }

    public void init(List<DevNode> devs) {
        if (devs.isEmpty()) {
            LOGGER.warn("dev list is empty!");
            return;
        }
        ArrayList devsList = new ArrayList(devs.size());
        devs.forEach(dev -> {
            SilentProcessData data = new SilentProcessData();
            data.setDevNode(EntityUtils.toNewDev((DevNode)dev));
            data.setStatus("running");
            data.setUsedTime(String.valueOf(0));
            devsList.add(data);
            this.silentResults.put((DevNode)dev, data);
        });
        SilentProcessToFile.updateDevsData(devsList, (String)this.progressWorkPath);
    }

    @Override
    public void finishAll(long during) {
        this.executeTask.setCurrentProgress(100);
        this.executeTask.setStatus("finished");
        this.executeTask.setAllFinished(true);
        LOGGER.info("getFinishedCheckNode().size() : {}", (Object)this.executeTask.getFinishedCheckNode().size());
        this.updater.shutdown();
        try {
            this.updater.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.error("# wait updater exit error.");
        }
        this.scheduleUpdate();
        this.updateFinishTotalProgressFile();
    }

    @Override
    public void finished(CheckDevNode checkDev) {
        this.executeTask.getFinishedCheckNode().add(checkDev);
        SilentProcessData data = this.silentResults.get(checkDev.getDevNodeSafe());
        data.setProcess(String.valueOf(100));
        data.setStatus("finished");
        boolean success = checkDev.isExecuteSuc() && (InspectUtils.isEClient() || data.getPassRate() == 100);
        data.setResult(success ? "success" : "failed");
        data.setUsedTime(String.valueOf(checkDev.getInspectTimeInMillis()));
        LOGGER.info("Finished inspection of device: {}", (Object)checkDev.getDevNodeSafe().getIp());
    }

    @Override
    public void update(CheckDevNode checkDev, CheckItem checkItem, String message, int step, Calendar calendar) {
        this.update(checkDev, checkItem, message, step, calendar, RecordStatus.NORMAL);
    }

    @Override
    public void update(CheckDevNode checkDev, CheckItem checkItem, String msg, int progressStep, Calendar time, RecordStatus status) {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDev);
        List<Record> records = InspectUIUtil.initRecords(checkDev, checkItem, msg, time, status);
        ui = InspectUIUtil.initUiUpdatePair(ui, checkDev, progressStep);
        InspectUIUtil.updateRecordStatus(ui, checkItem, status, records);
        DefaultListModel model = ui.getListMode();
        for (Record rec : records) {
            rec.setStatus(status);
            model.addElement(rec);
        }
        this.dev2CheckDevMap.putIfAbsent(checkDev.getDevNodeSafe(), checkDev);
    }

    @Override
    public void updateAllStatus(InspectStatus inspectStatus) {
        LOGGER.info("Start to inspect.");
    }

    @Override
    public void updateReporttingMsg(String msg) {
    }

    @Override
    public void updateCurrentStatus(CheckDevNode checkDev, RecordStatus status) {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDev);
        if (!ui.isRecordsEmpty()) {
            ui.getRecord(ui.getRecordSize() - 1).setStatus(status);
        }
    }

    public synchronized void updateTotalProgressFile() {
        try {
            int progress = this.calcDevProgressSum() / this.silentResults.size();
            this.totalProcessData.setProcess(String.valueOf(Math.min(progress, 95)));
            this.totalProcessData.setStatus("running");
            LOGGER.info("update total progress data: {}", (Object)this.totalProcessData);
            SilentProcessToFile.updateProcessData((SilentProcessData)this.totalProcessData, (String)this.progressWorkPath);
        }
        catch (Exception e) {
            LOGGER.error("Update total progress failed.", (Throwable)e);
        }
    }

    public synchronized void updateFinishTotalProgressFile() {
        try {
            long failedCount = this.silentResults.values().stream().filter(this::isDevFailed).count();
            this.totalProcessData.setResult(failedCount == 0L ? "success" : "failed");
            this.totalProcessData.setProcess(String.valueOf(100));
            this.totalProcessData.setStatus("finished");
            LOGGER.info("update total progress data: {}", (Object)this.totalProcessData);
            SilentProcessToFile.updateProcessData((SilentProcessData)this.totalProcessData, (String)this.progressWorkPath);
        }
        catch (Exception e) {
            LOGGER.error("Update total progress failed.", (Throwable)e);
        }
    }

    private int calcDevProgressSum() {
        AtomicInteger totalPro = new AtomicInteger(0);
        this.silentResults.values().forEach(data -> totalPro.addAndGet(Integer.parseInt(data.getProcess())));
        return totalPro.get();
    }

    private boolean isDevFailed(SilentProcessData data) {
        return "failed".equals(data.getResult());
    }

    public void updateFiledDev(List<DevNode> devs, String msg) {
        if (devs == null || devs.isEmpty()) {
            return;
        }
        ArrayList<SilentProcessData> failedDevs = new ArrayList<SilentProcessData>(devs.size());
        devs.forEach(dev -> {
            SilentProcessData data = this.silentResults.get(dev);
            data.setProcess(String.valueOf(100));
            data.setErrMsg(msg);
            data.setPassRate(0);
            data.setStatus("finished");
            data.setResult("failed");
            data.setUsedTime(String.valueOf(0));
            failedDevs.add(data);
        });
        this.updateSilentResult(failedDevs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSilentResult(List<SilentProcessData> datas) {
        Object object = SILENT_RESULTS_LOCK;
        synchronized (object) {
            SilentProcessToFile.updateDevsData(datas, (String)this.progressWorkPath);
            this.updateTotalProgressFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSilentResult(SilentProcessData data) {
        Object object = SILENT_RESULTS_LOCK;
        synchronized (object) {
            LOGGER.info("update progress {} ", (Object)data);
            SilentProcessToFile.updateDeviceData((SilentProcessData)data, (String)this.progressWorkPath);
            this.updateTotalProgressFile();
        }
    }

    private void updateDevProgress(CheckDevNode devNode) {
        SilentProcessData data = this.silentResults.get(devNode.getDevNodeSafe());
        if ("finished".equals(data.getStatus())) {
            data.setProcess(String.valueOf(100));
            return;
        }
        if (devNode.getDevNodeSafe().isDsStorage()) {
            data.setProcess(String.valueOf(Math.min(InspectContext.getInstance().getUiUpdatePair(devNode).getProgress(), 95)));
            return;
        }
        int ret = devNode.getCurNodeFinishedItemNum() * 95 / Math.max(1, devNode.getAllItemSize());
        int curPro = Math.min(ret, 100);
        int oldPro = Integer.parseInt(data.getProcess());
        data.setProcess(String.valueOf(Math.min(100, Math.max(curPro, oldPro))));
    }

    public void calcPassRate(CheckDevNode node, ResultCalc calc) {
        if (null == node) {
            LOGGER.info("check devnode is null, calc pass rate faild, return 0.");
            return;
        }
        int passedCount = calc.getAllCheckNumCount() - calc.getFaildCount() - calc.getWarningCount();
        int passRate = passedCount * 100 / Math.max(1, calc.getAllCheckNumCount());
        passRate = calc.getAllCheckNumCount() == 0 ? 100 : passRate;
        LOGGER.info("pass rate of dev: {} is : {} ", (Object)node.getDevNodeSafe().getDeviceSerialNumber(), (Object)passRate);
        SilentProcessData data = this.silentResults.get(node.getDevNodeSafe());
        data.setPassRate(Math.max(0, Math.min(passRate, 100)));
        if (data.getPassRate() != 100) {
            data.setErrMsg(ResourceUtil.getString((String)"silent.errmsg.notpass"));
        }
    }

    private synchronized String buildReturnData(CheckDevNode devNode) {
        String detail = "";
        if (!InspectUtils.isEClient()) {
            return "";
        }
        JSONObject detailJson = new JSONObject();
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(devNode);
        if (ui == null) {
            return detail;
        }
        DefaultListModel model = ui.getListMode();
        JSONArray details = new JSONArray();
        for (int i = 0; i < model.size(); ++i) {
            Record record = (Record)model.get(i);
            details.put((Object)this.buildDevJsonRecord(record));
        }
        detailJson.put("detail", (Object)details);
        return detailJson.toString();
    }

    private JSONObject buildDevJsonRecord(Record record) {
        JSONObject jsonRecord = new JSONObject();
        jsonRecord.put("checkResult", (Object)this.buildCheckResult(record));
        jsonRecord.put("checkResultDetail", (Object)this.buildResultDetail(record));
        jsonRecord.put("detail", (Object)this.buildDetail(record));
        jsonRecord.put("executeTime", (Object)StringUtils.formatDate((Object)record.getDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        jsonRecord.put("itemName", (Object)record.getMessage());
        RecordStatus status = record.getStatus();
        if (RecordStatus.RUNNING.equals((Object)status) || RecordStatus.PROCESSING.equals((Object)status) || RecordStatus.RETRY.equals((Object)status)) {
            jsonRecord.put("progress", record.getProgress());
        } else {
            jsonRecord.put("progress", 0);
        }
        return jsonRecord;
    }

    private ResultStatus buildCheckResult(Record rec) {
        CheckItem item = rec.getCheckItem();
        RItem rItem = rec.getItem();
        if (item == null || rItem == null) {
            return ResultStatus.NORMAL;
        }
        if (rec.getCheckDevNode().getDevNodeSafe().isDsStorage() && rec.getStatus() == RecordStatus.RUNNING) {
            return ResultStatus.NORMAL;
        }
        if (rItem.isFailed()) {
            return ResultStatus.NOT_PASS;
        }
        if (rItem.isNoSupport()) {
            return ResultStatus.NO_SUPPORT;
        }
        if (rItem.isNoCheck()) {
            return ResultStatus.NOCHECK;
        }
        if (rItem.isWarning()) {
            return ResultStatus.WARING;
        }
        if (rItem.isManualConfirmation()) {
            return ResultStatus.WARING;
        }
        return ResultStatus.PASS;
    }

    private String buildResultDetail(Record rec) {
        String result = rec.getStatus() == RecordStatus.INTERRUPPED ? ResourceUtil.getString((String)"inspsctor.wizard.performinspect.execfaild.item") : (rec.getStatus() == RecordStatus.FAILED ? ResourceUtil.getString((String)"inspsctor.wizard.performinspect.execwarning") : (rec.getStatus() == RecordStatus.RUNNING ? ResourceUtil.getString((String)"inspsctor.wizard.performinspect.execing") : (rec.getStatus() == RecordStatus.RETRY ? ResourceUtil.getString((String)"inspsctor.wizard.performinspect.retry") : (rec.getStatus() == RecordStatus.PROCESSING ? ResourceUtil.getString((String)"inspsctor.wizard.performinspect.processing") : this.buildItemResultDetail(rec)))));
        return result;
    }

    private String buildItemResultDetail(Record rec) {
        String itemResultDetail = "";
        CheckItem item = rec.getCheckItem();
        RItem rItem = rec.getItem();
        if (item == null || rItem == null) {
            return itemResultDetail;
        }
        itemResultDetail = rec.getItem().isFailed() ? ResourceUtil.getString((String)"inspsctor.wizard.performinspect.failed") : (rec.getItem().isNoSupport() ? ResourceUtil.getString((String)"inspsctor.wizard.performinspect.nosupport") : (rec.getItem().isNoCheck() ? ResourceUtil.getString((String)"inspsctor.wizard.performinspect.nocheck") : (rec.getItem().isWarning() ? ResourceUtil.getString((String)"inspsctor.wizard.performinspect.warning") : (rec.getItem().isManualConfirmation() ? ResourceUtil.getString((String)"inspsctor.wizard.performinspect.manualconfirmation") : ResourceUtil.getString((String)"inspsctor.wizard.performinspect.success")))));
        return itemResultDetail;
    }

    private String buildDetail(Record record) {
        CheckItem item = record.getCheckItem();
        RItem rItem = record.getItem();
        if (item == null || rItem == null) {
            return "";
        }
        if (record.getCheckDevNode().getDevNodeSafe().isDsStorage() && record.getStatus() == RecordStatus.RUNNING) {
            return "";
        }
        StringBuffer itemDetail = new StringBuffer();
        String errMsg = item.getErrorInfo();
        if (!StringUtils.isNULLStr((String)errMsg)) {
            itemDetail.append(errMsg).append('\n');
        }
        if (rItem.isWarning() || rItem.isFailed()) {
            String id = record.getItemResourceId();
            itemDetail.append(InspectDetailLayout.suggestHandle(record, record.getCheckItem(), id, record.getCheckDevNode().getResourceBundle(), InspectCommonResBundle.INS.getUnifiedResBundle()));
        }
        return itemDetail.toString();
    }

    @Override
    public void updateErrMsg(CheckDevNode checkDevNode, String msg) {
        checkDevNode.setError(true);
        SilentProcessData data = this.silentResults.get(checkDevNode.getDevNodeSafe());
        data.setErrMsg(msg);
        data.setResult("failed");
    }

    @Override
    public void updateChildItems(CheckDevNode checkDev, Map<String, Object> jsonMsg) {
        List<CheckItem> checkItems = InspectUIUtil.convertMsg2CheckItems(jsonMsg);
        for (CheckItem checkItem : checkItems) {
            RecordStatus status = checkItem.getCheckResult().getRecordStatus();
            Calendar time = Calendar.getInstance();
            String name = checkItem.getName();
            this.update(checkDev, checkItem, name, 0, time, status);
            if (status.isRunning()) continue;
            InspectContext.getInstance().setInnerCheckResult(checkDev.getDevNode().getIp(), checkItem);
        }
    }

    static enum ResultStatus {
        NORMAL,
        PASS,
        NOT_PASS,
        NOCHECK,
        WARING,
        NO_SUPPORT;

    }
}

