/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.inspect.entity.FsNodeExpansionInfo;
import com.huawei.ism.tool.inspect.ui.dialogs.FusionStoragePoolExpansionDialog;
import com.huawei.ism.tool.obase.entity.FusionStorDiskInfo;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTable;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTableModel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JDialog;

public class FsStoragePoolConfigTreeMouseListener
extends MouseAdapter {
    private static final int MAIN_STORAGE_NUMBER_INDEX = 5;
    private static final int CACHE_NUMBER_INDEX = 6;
    private final FusionStoragePoolExpansionDialog dialog;

    public FsStoragePoolConfigTreeMouseListener(FusionStoragePoolExpansionDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        int row;
        TreeTable table = this.dialog.getFsLayout().getTable();
        TreeTableModel model = table.getTreeTableModel();
        TreeTableModel.RowItem item = model.getRowElement(row = table.rowAtPoint(event.getPoint()));
        if (item == null) {
            return;
        }
        int eventX = event.getX();
        if (table.isaContractionAndUnfold(table, item, eventX)) {
            return;
        }
        if (!table.isMutliSelected()) {
            return;
        }
        if (table.selsectCheckBox(item, eventX)) {
            ITreeTableRow fsRow = item.getTableRow();
            this.updateRowsInfo(item, (ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)fsRow, item.getSelectType());
            this.dialog.updateNodeStatisticsView();
            this.dialog.updateSelectAllCheckBox();
        }
        this.updateMarkDiskInfoRow(table);
    }

    private void updateMarkDiskInfoRow(TreeTable table) {
        table.getMarkedRows().stream().map(markRow -> (ITreeTableRow)markRow).filter(this::isDiskInfoRow).forEach(fsRow -> this.updateRowsInfo(table, (ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)fsRow));
        table.revalidate();
        table.repaint();
    }

    private boolean isDiskInfoRow(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> fsRow) {
        return ((FsNodeExpansionInfo)fsRow.getUserObject()).getConfigType() == FsNodeExpansionInfo.ConfigType.DISK_INFO_ROW;
    }

    private void updateRowsInfo(TreeTable table, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> fsRow) {
        TreeTableModel.RowItem rowItem = table.getTreeTableModel().getRowItem(fsRow.getIdentifier());
        this.updateRowsInfo(rowItem, fsRow, rowItem.getSelectType());
    }

    private void updateRowsInfo(TreeTableModel.RowItem item, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> fsRow, TreeTableModel.SelectType selectType) {
        if (((FsNodeExpansionInfo)fsRow.getUserObject()).isNodeRow()) {
            if (this.checkByGroupRow(item, fsRow, selectType)) {
                return;
            }
            FsStoragePoolConfigTreeMouseListener.getAllDiskRow(fsRow).forEach(subRow -> FsStoragePoolConfigTreeMouseListener.updateSubRowDiskNumber((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)subRow, selectType));
            ((FsNodeExpansionInfo)fsRow.getUserObject()).setSelectType(selectType);
            FsStoragePoolConfigTreeMouseListener.updateDiskNumberByParentRow(fsRow);
        } else if (((FsNodeExpansionInfo)fsRow.getUserObject()).isDiskZone() || ((FsNodeExpansionInfo)fsRow.getUserObject()).isCacheGroup()) {
            if (this.checkByGroupRow(item, fsRow, selectType)) {
                this.updateSelectTypeBySubRows(item.getParent());
                return;
            }
            FsStoragePoolConfigTreeMouseListener.getAllDiskRow(fsRow).forEach(subRow -> FsStoragePoolConfigTreeMouseListener.updateSubRowDiskNumber((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)subRow, selectType));
            ((FsNodeExpansionInfo)fsRow.getUserObject()).setSelectType(selectType);
            FsStoragePoolConfigTreeMouseListener.updateDiskNumberByParentRow((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)item.getParent().getTableRow());
            this.updateSelectTypeBySubRows(item.getParent());
        } else if (((FsNodeExpansionInfo)fsRow.getUserObject()).isDiskInfoRow()) {
            if (this.checkByDiskRow(item, fsRow)) {
                return;
            }
            FsStoragePoolConfigTreeMouseListener.updateSubRowDiskNumber(fsRow, selectType);
            ((FsNodeExpansionInfo)fsRow.getParentRow().getUserObject()).setSelectType(item.getParent().getSelectType());
            FsStoragePoolConfigTreeMouseListener.updateDiskNumberByParentRow((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)fsRow.getParentRow());
            if (item.getParent().getParent() != null) {
                this.updateSelectTypeBySubRows(item.getParent().getParent());
            }
        } else if (((FsNodeExpansionInfo)fsRow.getUserObject()).isTips()) {
            this.selectToUnBySub((FsNodeExpansionInfo)fsRow.getUserObject(), item);
            this.showSelectTipsRow();
        }
    }

    private boolean checkByDiskRow(TreeTableModel.RowItem item, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> fsRow) {
        if (this.forbidSelect()) {
            this.selectToUnBySub((FsNodeExpansionInfo)fsRow.getUserObject(), item);
            this.showPrompt();
            return true;
        }
        if (this.checkSelectNodesType(item, fsRow)) {
            this.selectToUnBySub((FsNodeExpansionInfo)fsRow.getUserObject(), item);
            this.showDifferentTypeNodeMsg();
            return true;
        }
        if (((FsNodeExpansionInfo)fsRow.getUserObject()).isTips()) {
            this.selectToUnBySub((FsNodeExpansionInfo)fsRow.getUserObject(), item);
            this.showSelectTipsRow();
            return true;
        }
        if (this.checkConfigByExistCustomBySubRow(fsRow)) {
            this.selectToUnBySub((FsNodeExpansionInfo)fsRow.getUserObject(), item);
            return true;
        }
        return false;
    }

    private boolean checkByGroupRow(TreeTableModel.RowItem item, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> fsRow, TreeTableModel.SelectType selectType) {
        if (this.forbidSelect()) {
            this.selectToUnByParent(fsRow, item);
            this.showPrompt();
            return true;
        }
        if (this.checkSelectNodesType(item, fsRow)) {
            this.selectToUnByParent(fsRow, item);
            this.showDifferentTypeNodeMsg();
            return true;
        }
        if (this.checkTipsRowByNodeRow(item, fsRow)) {
            this.selectToUnByParent(fsRow, item);
            this.showSelectTipsRow();
            return true;
        }
        return this.checkConfigByExistCustom(item, selectType);
    }

    private boolean checkSelectNodesType(TreeTableModel.RowItem item, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> fsRow) {
        if (((FsNodeExpansionInfo)fsRow.getUserObject()).isNodeRow()) {
            return this.hasDifferentTypeNode((FsNodeExpansionInfo)fsRow.getUserObject());
        }
        if (((FsNodeExpansionInfo)fsRow.getUserObject()).isDiskZone() || ((FsNodeExpansionInfo)fsRow.getUserObject()).isCacheGroup()) {
            return this.hasDifferentTypeNode((FsNodeExpansionInfo)item.getParent().getTableRow().getUserObject());
        }
        if (((FsNodeExpansionInfo)fsRow.getUserObject()).isDiskInfoRow()) {
            if (item.getParent().getParent() == null) {
                return this.hasDifferentTypeNode((FsNodeExpansionInfo)item.getParent().getTableRow().getUserObject());
            }
            return this.hasDifferentTypeNode((FsNodeExpansionInfo)item.getParent().getParent().getTableRow().getUserObject());
        }
        return false;
    }

    private boolean hasDifferentTypeNode(FsNodeExpansionInfo thisNodeInfo) {
        if (this.dialog.getStoragePool().isNullPool() && !this.dialog.getStoragePoolLayout().getTreeTableModel().getAllItemList().stream().anyMatch(rowItem -> {
            FsNodeExpansionInfo fsInfo = (FsNodeExpansionInfo)rowItem.getTableRow().getUserObject();
            if (thisNodeInfo == fsInfo) {
                return false;
            }
            return fsInfo.isNodeRow() && !fsInfo.isUnSelect();
        })) {
            return false;
        }
        return thisNodeInfo.isPacificNode() != this.dialog.poolNodeTypeIsPacific() || thisNodeInfo.isEastOceanSingle() != this.dialog.poolNodeTypeIsEastOcean(true) || thisNodeInfo.isEastOceanDouble() != this.dialog.poolNodeTypeIsEastOcean(false);
    }

    private boolean checkTipsRowByNodeRow(TreeTableModel.RowItem item, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> fsRow) {
        List<FsNodeExpansionInfo> rowInfoList = FsStoragePoolConfigTreeMouseListener.getAllTipsRow((FsNodeExpansionInfo)fsRow.getUserObject());
        if (((FsNodeExpansionInfo)fsRow.getUserObject()).isNodeRow() && ((FsNodeExpansionInfo)fsRow.getUserObject()).involveDiskZone()) {
            if (rowInfoList.size() > ((FsNodeExpansionInfo)fsRow.getUserObject()).getDiskZoneNum()) {
                return true;
            }
            ArrayList<TreeTableModel.RowItem> groupRowItemList = new ArrayList<TreeTableModel.RowItem>();
            TreeTable table = this.dialog.getFsLayout().getTable();
            table.getTreeTableModel().getAllItemList().forEach(subItem -> this.updateAllRowByNode(item, (List<TreeTableModel.RowItem>)groupRowItemList, table, (TreeTableModel.RowItem)subItem));
            groupRowItemList.add(item);
            if (item.getParent() != null) {
                groupRowItemList.add(item.getParent());
            }
            groupRowItemList.forEach(this::updateSelectTypeBySubRows);
            return false;
        }
        return ((FsNodeExpansionInfo)fsRow.getUserObject()).getChildren().stream().anyMatch(FsNodeExpansionInfo::isTips);
    }

    private void updateAllRowByNode(TreeTableModel.RowItem item, List<TreeTableModel.RowItem> groupRowItemList, TreeTable table, TreeTableModel.RowItem subItem) {
        if (subItem == null) {
            return;
        }
        if (table.isSubRow(item, subItem)) {
            FsNodeExpansionInfo subItemInfo = (FsNodeExpansionInfo)subItem.getTableRow().getUserObject();
            if (subItemInfo.isTips()) {
                subItem.setSelectType(TreeTableModel.SelectType.UNSELECT);
                subItemInfo.setSelectType(TreeTableModel.SelectType.UNSELECT);
            } else if (subItemInfo.isDiskZone() || subItemInfo.isCacheGroup()) {
                groupRowItemList.add(subItem);
            } else {
                subItemInfo.setSelectType(subItem.getSelectType());
            }
        }
    }

    public static List<FsNodeExpansionInfo> getAllTipsRow(FsNodeExpansionInfo rootRowInfo) {
        ArrayList<FsNodeExpansionInfo> rowList = new ArrayList<FsNodeExpansionInfo>();
        FsStoragePoolConfigTreeMouseListener.buildAllTipsRow(rootRowInfo, rowList);
        return rowList;
    }

    private static void buildAllTipsRow(FsNodeExpansionInfo rootRowInfo, List<FsNodeExpansionInfo> rowInfoList) {
        rootRowInfo.getChildren().forEach(row -> {
            if (row.isTips()) {
                rowInfoList.add((FsNodeExpansionInfo)row);
            } else {
                FsStoragePoolConfigTreeMouseListener.buildAllTipsRow(row, rowInfoList);
            }
        });
    }

    public static List<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> getAllDiskRow(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row) {
        ArrayList<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> rowList = new ArrayList<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>>();
        FsStoragePoolConfigTreeMouseListener.buildAllDiskRow(row, rowList);
        return rowList;
    }

    private static void buildAllDiskRow(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, List<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> rowList) {
        row.getSubRowList().forEach(subRow -> {
            if (((FsNodeExpansionInfo)subRow.getUserObject()).isDiskInfoRow()) {
                rowList.add((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)subRow);
            } else {
                FsStoragePoolConfigTreeMouseListener.buildAllDiskRow((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)subRow, rowList);
            }
        });
    }

    private boolean checkConfigByExistCustomBySubRow(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> fsRow) {
        if (!((FsNodeExpansionInfo)fsRow.getUserObject()).isCustomConfig()) {
            return false;
        }
        String erroMsg = FusionStoragePoolExpansionDialog.checkCustomRowFinish(fsRow);
        if (StringUtils.isNULLStr((String)erroMsg)) {
            return false;
        }
        DialogUtils.showInfoDialog((JDialog)this.dialog, (String)erroMsg);
        return true;
    }

    private boolean checkConfigByExistCustom(TreeTableModel.RowItem item, TreeTableModel.SelectType selectType) {
        ArrayList errorMsgList = new ArrayList();
        ArrayList<TreeTableModel.RowItem> groupRowItemList = new ArrayList<TreeTableModel.RowItem>();
        TreeTable table = this.dialog.getFsLayout().getTable();
        table.getTreeTableModel().getAllItemList().stream().filter(Objects::nonNull).forEach(subItem -> {
            if (table.isSubRow(item, subItem)) {
                this.updateSelectTypeByCustomRow(selectType, errorMsgList, (List<TreeTableModel.RowItem>)groupRowItemList, (TreeTableModel.RowItem)subItem);
            }
        });
        if (!errorMsgList.isEmpty()) {
            groupRowItemList.add(item);
            groupRowItemList.forEach(this::updateSelectTypeBySubRows);
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)((String)errorMsgList.get(0)));
            return true;
        }
        return false;
    }

    private void updateSelectTypeByCustomRow(TreeTableModel.SelectType selectType, List<String> errorMsgList, List<TreeTableModel.RowItem> groupRowItemList, TreeTableModel.RowItem subItem) {
        ITreeTableRow subRow = subItem.getTableRow();
        if (((FsNodeExpansionInfo)subRow.getUserObject()).isCustomConfig()) {
            String erroMsg = FusionStoragePoolExpansionDialog.checkCustomRowFinish((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)subRow);
            if (!StringUtils.isNULLStr((String)erroMsg)) {
                subItem.setSelectType(TreeTableModel.SelectType.UNSELECT);
                ((FsNodeExpansionInfo)subRow.getUserObject()).setSelectType(TreeTableModel.SelectType.UNSELECT);
                errorMsgList.add(erroMsg);
            } else {
                FsStoragePoolConfigTreeMouseListener.updateSubRowDiskNumber((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)subRow, selectType);
            }
        }
        if (((FsNodeExpansionInfo)subRow.getUserObject()).isCacheGroup() || ((FsNodeExpansionInfo)subRow.getUserObject()).isDiskZone()) {
            groupRowItemList.add(subItem);
        }
    }

    private void updateSelectTypeBySubRows(TreeTableModel.RowItem item) {
        ITreeTableRow fsRow = item.getTableRow();
        List<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> allDiskRow = FsStoragePoolConfigTreeMouseListener.getAllDiskRow((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)fsRow);
        long selectSubRowsCount = allDiskRow.stream().filter(rowItem -> ((FsNodeExpansionInfo)rowItem.getUserObject()).isSelect()).count();
        long unSelectSubRowsCount = allDiskRow.stream().filter(rowItem -> ((FsNodeExpansionInfo)rowItem.getUserObject()).isUnSelect()).count();
        long allSubRowSize = allDiskRow.size();
        if (!((FsNodeExpansionInfo)fsRow.getUserObject()).isNodeRow() || !((FsNodeExpansionInfo)fsRow.getUserObject()).isPacificNode()) {
            long tipsRowSize = FsStoragePoolConfigTreeMouseListener.getAllTipsRow((FsNodeExpansionInfo)fsRow.getUserObject()).size();
            unSelectSubRowsCount += tipsRowSize;
            allSubRowSize += tipsRowSize;
        }
        TreeTableModel.SelectType type = allDiskRow.isEmpty() ? TreeTableModel.SelectType.UNSELECT : (selectSubRowsCount == allSubRowSize ? TreeTableModel.SelectType.SELECT : (unSelectSubRowsCount == allSubRowSize ? TreeTableModel.SelectType.UNSELECT : TreeTableModel.SelectType.HALF));
        item.setSelectType(type);
        ((FsNodeExpansionInfo)fsRow.getUserObject()).setSelectType(type);
    }

    private boolean forbidSelect() {
        return this.dialog.getStoragePool().getMainStorageDiskType() == null;
    }

    private void selectToUnBySub(FsNodeExpansionInfo config, TreeTableModel.RowItem item) {
        item.setSelectType(TreeTableModel.SelectType.UNSELECT);
        config.setSelectType(TreeTableModel.SelectType.UNSELECT);
        this.updateSelectTypeByParentsRow(item);
    }

    private void updateSelectTypeByParentsRow(TreeTableModel.RowItem row) {
        TreeTableModel.RowItem parentItem = row.getParent();
        if (parentItem == null) {
            return;
        }
        this.updateSelectTypeBySubRows(parentItem);
        this.updateSelectTypeByParentsRow(parentItem);
    }

    private void selectToUnByParent(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> fsRow, TreeTableModel.RowItem item) {
        TreeTable table = this.dialog.getFsLayout().getTable();
        item.setSelectType(TreeTableModel.SelectType.UNSELECT);
        ((FsNodeExpansionInfo)fsRow.getUserObject()).setSelectType(TreeTableModel.SelectType.UNSELECT);
        table.getTreeTableModel().getAllItemList().forEach(subItem -> {
            if (subItem == null) {
                return;
            }
            if (table.isSubRow(item, subItem)) {
                subItem.setSelectType(TreeTableModel.SelectType.UNSELECT);
                ((FsNodeExpansionInfo)subItem.getTableRow().getUserObject()).setSelectType(TreeTableModel.SelectType.UNSELECT);
            }
        });
        if (item.getParent() != null) {
            item.getParent().setSelectType(TreeTableModel.SelectType.UNSELECT);
            ((FsNodeExpansionInfo)item.getParent().getTableRow().getUserObject()).setSelectType(TreeTableModel.SelectType.UNSELECT);
        }
    }

    private void showSelectTipsRow() {
        DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.node.add.tips.row.msg"));
    }

    private void showPrompt() {
        DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"inspsctor.fs.expansion.creat.storage.pool.no.select.disk.type.msg"));
    }

    private void showDifferentTypeNodeMsg() {
        DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"inspsctor.fs.expansion.storage.pool.config.different.type.node"));
    }

    public static void updateSubRowDiskNumber(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, TreeTableModel.SelectType selectType) {
        IsmTableCell.MsgTextCell cell;
        ((FsNodeExpansionInfo)row.getUserObject()).setSelectType(selectType);
        if (((FsNodeExpansionInfo)row.getUserObject()).isTips()) {
            return;
        }
        if (row.getValue(4) instanceof IsmTableCell.MsgTextCell) {
            cell = (IsmTableCell.MsgTextCell)row.getValue(4);
        } else if (row.getValue(5) instanceof IsmTableCell.MsgTextCell) {
            cell = (IsmTableCell.MsgTextCell)row.getValue(5);
        } else {
            return;
        }
        String value = cell.getEditor().getCellEditorValue().toString();
        int number = 0;
        if (StringUtils.isNULLStr((String)value)) {
            if (((FsNodeExpansionInfo)row.getUserObject()).isSelect()) {
                cell.setText(((FsNodeExpansionInfo)row.getUserObject()).getChildDiskMaxNumber() + "");
                number = ((FsNodeExpansionInfo)row.getUserObject()).getChildDiskMaxNumber();
            }
        } else {
            number = Integer.parseInt(value);
        }
        ((FsNodeExpansionInfo)row.getUserObject()).setChildDiskNumber(number);
        if (((FsNodeExpansionInfo)row.getUserObject()).isCustomConfig()) {
            FsStoragePoolConfigTreeMouseListener.updateCustomConfig(row);
        }
    }

    private static void updateCustomConfig(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row) {
        if (!((FsNodeExpansionInfo)row.getUserObject()).isSelect()) {
            return;
        }
        if (row.getValue(4) instanceof IsmTableCell.ComboBoxCell && row.getValue(3) instanceof IsmTableCell.MsgTextCell) {
            IsmTableCell.MsgTextCell capacityCell = (IsmTableCell.MsgTextCell)row.getValue(3);
            IsmTableCell.ComboBoxCell capacityUnitCell = (IsmTableCell.ComboBoxCell)row.getValue(4);
            ((FsNodeExpansionInfo)row.getUserObject()).getChildrenConfigDisk().setCapacityAndUnit(capacityCell.getEditor().getCellEditorValue().toString(), FusionStorDiskInfo.CapacityUnit.mappingEnum((String)capacityUnitCell.getSelectedItem().toString()));
        }
    }

    public static void updateDiskNumberByParentRow(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> parent) {
        FsNodeExpansionInfo parentConfig = (FsNodeExpansionInfo)parent.getUserObject();
        ITreeTableRow actualParent = parent;
        if (parentConfig.isDiskZone() || parentConfig.isCacheGroup()) {
            actualParent = actualParent.getParentRow();
            parentConfig = (FsNodeExpansionInfo)actualParent.getUserObject();
        }
        int[] summarize = new int[]{0, 0};
        FsStoragePoolConfigTreeMouseListener.getAllDiskRow((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)actualParent).forEach(subRow -> {
            FsNodeExpansionInfo subConfig = (FsNodeExpansionInfo)subRow.getUserObject();
            if (subConfig.isMainStorageChild()) {
                summarize[0] = summarize[0] + subConfig.getChildDiskNumberBySelectType();
            } else {
                summarize[1] = summarize[1] + subConfig.getChildDiskNumberBySelectType();
            }
        });
        parentConfig.setCongfigMainStorageNumber(summarize[0]);
        parentConfig.setCongfigCacheMaxNumber(summarize[1]);
        actualParent.setValue(5, (Object)(summarize[0] + "/" + parentConfig.getMainStorageMaxNumber()));
        actualParent.setValue(6, (Object)(summarize[1] + "/" + parentConfig.getCacheMaxNumber()));
    }
}

