/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.inspect.entity.HyperHostManualCheckItem;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HyperHostListener
implements ItemListener {
    private HyperHostManualCheckItem hostItem;
    private String checkItemName;
    private Map hostInContext;

    public HyperHostListener(HyperHostManualCheckItem item, String name) {
        this.hostItem = item;
        this.checkItemName = name;
        this.initHostInContext();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            int checkResultNub = 0;
            String select = event.getItem().toString();
            for (int nub = 0; nub < HyperHostManualCheckItem.CHECK_RESULT.length; ++nub) {
                if (!HyperHostManualCheckItem.CHECK_RESULT[nub].equals(select)) continue;
                checkResultNub = nub;
            }
            this.hostItem.setSelectValue(this.checkItemName, checkResultNub);
            this.hostInContext.put(this.checkItemName, checkResultNub);
        }
    }

    private void initHostInContext() {
        ConcurrentHashMap<String, Object> tmpObj = InspectContext.getInstance().getObjectForPy();
        Map serverAndHost = (Map)tmpObj.get("HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO");
        List hostList = (List)serverAndHost.get("NOT_ADD_HOST_LIST");
        String uniqueSign = this.hostItem.getHostInitiator();
        for (Map hostInfo : hostList) {
            String hostInContextUniqueSign = hostInfo.get("initiator").toString();
            if (!uniqueSign.equals(hostInContextUniqueSign)) continue;
            this.hostInContext = hostInfo;
        }
    }
}

