/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.inspect.entity.HyperQuoServerManualCheckItem;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HyperQuoServerListener
implements ItemListener {
    private HyperQuoServerManualCheckItem serverItem;
    private String checkItemName;
    private Map serverInContext;

    public HyperQuoServerListener(HyperQuoServerManualCheckItem item, String name) {
        this.serverItem = item;
        this.checkItemName = name;
        this.initServerInContext();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            int checkResultNub = 0;
            String select = event.getItem().toString();
            for (int nub = 0; nub < HyperQuoServerManualCheckItem.CHECK_RESULT.length; ++nub) {
                if (!HyperQuoServerManualCheckItem.CHECK_RESULT[nub].equals(select)) continue;
                checkResultNub = nub;
            }
            if ("isThirdPartStation".equals(this.checkItemName)) {
                this.serverItem.setIsThirdPartStation(checkResultNub);
                this.serverInContext.put("isThirdPartStation", checkResultNub);
            }
            if ("isUseStorage".equals(this.checkItemName)) {
                this.serverItem.setIsUseStorageResource(checkResultNub);
                this.serverInContext.put("isUseStorage", checkResultNub);
            }
        }
    }

    private void initServerInContext() {
        ConcurrentHashMap<String, Object> tmpObj = InspectContext.getInstance().getObjectForPy();
        Map serverAndHost = (Map)tmpObj.get("HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO");
        List serverList = (List)serverAndHost.get("QUO_SERVER_LIST");
        String ip = this.serverItem.getQuoServerIp();
        for (Map serverInfo : serverList) {
            if (!ip.equals(serverInfo.get("ip"))) continue;
            this.serverInContext = serverInfo;
        }
    }
}

