/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.inspect.entity.BureauDocuConfig;
import com.huawei.ism.tool.inspect.ui.dialogs.ManulyCheckLayout;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JDialog;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManulyCheckLayoutListener
implements ActionListener,
ToolHyperLinkLabel.ClickListener {
    private static final long serialVersionUID = -7661199144770585489L;
    private static final Logger LOG = LoggerFactory.getLogger(ManulyCheckLayoutListener.class);
    private static final String EXPORT_FILE_PATH_ID = "manulycheck_burean_export_file_path_id_001";
    private ActionType type;
    private ManulyCheckLayout card;

    public ManulyCheckLayoutListener(ActionType type, ManulyCheckLayout card) {
        this.type = type;
        this.card = card;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (null == this.type) {
            LOG.error("type is null, action return.");
            return;
        }
        this.type.action(this.card);
    }

    public void clickLink(MouseEvent me) {
        this.actionPerformed(null);
    }

    public static enum ActionType {
        EXPORT{

            @Override
            public void action(ManulyCheckLayout card) {
                LOG.info("export file.");
                if (null == card) {
                    LOG.error("card is null.");
                    return;
                }
                DevNode node = card.getDev();
                if (null == node) {
                    LOG.error("selected dev is null.");
                    return;
                }
                BureauDocuConfig config = BureauDocuService.INS.getConfig(String.valueOf(node.getDeviceType()));
                if (null == config) {
                    LOG.error("selected dev's config is null, dev type: " + node.getDeviceType());
                    return;
                }
                JDialog mainDialog = InspectContext.getInstance().getMainDialog();
                String title = ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.browspath");
                String suffix = "xlsx";
                String selectFilePath = ToolFileChooser.getSaveFilePath((String)title, (String)suffix, (Window)mainDialog, (String)config.getDefaultName(), (String)ManulyCheckLayoutListener.EXPORT_FILE_PATH_ID, (boolean)true);
                LOG.info("export path: {}", (Object)selectFilePath);
                if (null == selectFilePath) {
                    return;
                }
                InputStream is = null;
                try {
                    is = ManulyCheckLayoutListener.class.getResourceAsStream(config.getLocalResource());
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)new File(selectFilePath));
                    LOG.info("export file success.");
                }
                catch (IOException e) {
                    DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.manualcheck.export.file.error"));
                    LOG.error("export file error, file: " + selectFilePath, (Throwable)e);
                }
            }
        };


        public abstract void action(ManulyCheckLayout var1);
    }
}

