/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.inspect.entity.BureauDocuConfig;
import com.huawei.ism.tool.inspect.entity.BureauFile;
import com.huawei.ism.tool.inspect.ui.dialogs.ManulyCheckDialog;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.ui.wizard.ManulyCheckCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.JDialog;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class ManulyCheckListener
implements ActionListener,
ToolHyperLinkLabel.ClickListener {
    private static final long serialVersionUID = -7661199144770585489L;
    private static final Logger LOG = LoggerFactory.getLogger(ManulyCheckListener.class);
    private static final String EXPORT_FILE_PATH_ID = "manulycheck_burean_export_file_path_id_001";
    private static final int IMPORT_FILE_INDEX = 4;
    private static final int SCORE_INDEX = 5;
    private ActionType type;
    private ManulyCheckCard card;
    private static final int TOTALSCORE = 100;

    public ManulyCheckListener(ActionType type, ManulyCheckCard card) {
        this.type = type;
        this.card = card;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (null == this.type) {
            LOG.error("type is null, action return.");
            return;
        }
        this.type.action(this.card);
    }

    public void clickLink(MouseEvent me) {
        this.actionPerformed(null);
    }

    public static enum ActionType {
        MANUAL_CHECK{

            @Override
            public void action(ManulyCheckCard card) {
                DevNode selectedDev = card.getSelectedDev();
                if (selectedDev == null) {
                    LOG.error("selectedDevNode is null!");
                    return;
                }
                ManulyCheckDialog dialog = new ManulyCheckDialog(selectedDev);
                dialog.setVisible(true);
                ActionType.showPassRate(card, selectedDev);
            }
        }
        ,
        IMPORT{

            @Override
            public void action(ManulyCheckCard card) {
                LOG.info("import file.");
                if (null == card) {
                    LOG.error("card is null.");
                    return;
                }
                File selectFile = ActionType.importFile();
                if (null == selectFile) {
                    LOG.info("select file is null.");
                    return;
                }
                LOG.info("select file: {}", (Object)FilesUtil.getCanonicalPath((File)selectFile));
                DevNode dev = card.getSelectedDev();
                BureauFile file = BureauDocuService.INS.isDocuSupportDev(selectFile, dev);
                if (null == file) {
                    DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.manualcheck.import.type.check.not.pass"));
                    LOG.info("check file failed, file illegal or not support the dev, dev: {}", (Object)dev);
                    return;
                }
                InspectContext.getInstance().addBureauFile(dev, file);
                ActionType.showImportedFileScore(card, dev, file);
            }
        }
        ,
        EXPORT{

            @Override
            public void action(ManulyCheckCard card) {
                LOG.info("export file.");
                if (null == card) {
                    LOG.error("card is null.");
                    return;
                }
                DevNode node = card.getSelectedDev();
                if (null == node) {
                    LOG.error("selected dev is null.");
                    return;
                }
                BureauDocuConfig config = BureauDocuService.INS.getConfig(String.valueOf(node.getDeviceType()));
                if (null == config) {
                    LOG.error("selected dev's config is null, dev type: " + node.getDeviceType());
                    return;
                }
                JDialog mainDialog = InspectContext.getInstance().getMainDialog();
                String title = ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.browspath");
                String suffix = "xlsx";
                String selectFilePath = ToolFileChooser.getSaveFilePath((String)title, (String)suffix, (Window)mainDialog, (String)config.getDefaultName(), (String)ManulyCheckListener.EXPORT_FILE_PATH_ID, (boolean)true);
                LOG.info("export path: {}", (Object)selectFilePath);
                if (null == selectFilePath) {
                    return;
                }
                InputStream is = null;
                try {
                    is = ManulyCheckListener.class.getResourceAsStream(config.getLocalResource());
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)new File(selectFilePath));
                    LOG.info("export file success.");
                }
                catch (IOException e) {
                    DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.manualcheck.export.file.error"));
                    LOG.error("export file error, file: " + selectFilePath, (Throwable)e);
                }
            }
        }
        ,
        GET_DEV_XLSX{

            @Override
            public void action(ManulyCheckCard card) {
                LOG.info("get file.");
                if (null == card) {
                    LOG.error("card is null.");
                    return;
                }
                DevNode dev = card.getSelectedDev();
                if (null == dev) {
                    return;
                }
                String url = BureauDocuService.INS.getUrl(String.valueOf(dev.getDeviceType()));
                if (StringUtils.isNULLStr((String)url)) {
                    return;
                }
                LOG.info(String.format(Locale.ENGLISH, "get url, dev: %s, type: %s, url: %s", dev.getIp(), String.valueOf(dev.getDeviceType()), url));
                OSCmdUtils.openHtmlUrl((String)url);
            }
        }
        ,
        OPEN_URL{

            @Override
            public void action(ManulyCheckCard card) {
                String url = BureauDocuService.INS.getMainURL();
                LOG.info("click main url: {}", (Object)url);
                if (StringUtils.isNULLStr((String)url)) {
                    return;
                }
                OSCmdUtils.openHtmlUrl((String)url);
            }
        }
        ,
        EXPLORE_FILE{

            @Override
            public void action(ManulyCheckCard card) {
                LOG.info("explore saved file.");
                if (null == card) {
                    LOG.error("card is null.");
                    return;
                }
                TableRow row = card.getCardLayout().getTable().getMarkedRow();
                if (null == row) {
                    LOG.info("selected row is null.");
                    return;
                }
                if (row.getUserObject() == null) {
                    LOG.info(" Devnode is null.");
                    return;
                }
                BureauFile bureauFile = InspectContext.getInstance().getBureauFile((DevNode)row.getUserObject());
                if (bureauFile == null) {
                    LOG.info(" bureauFile is null.");
                    return;
                }
                OSCmdUtils.explorerFile((File)bureauFile.getFile());
            }
        };


        public abstract void action(ManulyCheckCard var1);

        private static File importFile() {
            HashMap<String, String> extParams = new HashMap<String, String>();
            extParams.put("description", "*.xlsx");
            extParams.put("PathId", "Inspect_ManulyCheck_ImportFile_id001");
            extParams.put("title", ResourceUtil.getString((String)"inspect.wizard.manualcheck.import.title"));
            return ToolFileChooser.selectFile((Window)InspectContext.getInstance().getMainDialog(), (String[])new String[]{"xlsx"}, (int)0, (boolean)true, extParams);
        }

        private static void showPassRate(ManulyCheckCard card, DevNode dev) {
            List rows = card.getCardLayout().getTable().getMarkedRows();
            if (null == rows || rows.isEmpty()) {
                return;
            }
            HashMap<String, ArrayList<String>> checkRSMap = BureauDocuService.INS.getCheckRSMap();
            for (TableRow row : rows) {
                if (!row.getUserObject().equals(dev) || !checkRSMap.containsKey(dev.getDeviceSerialNumber())) continue;
                ArrayList<String> checkRSList = checkRSMap.get(dev.getDeviceSerialNumber());
                int passCnt = 0;
                int settingInputItms = 0;
                for (String checkRs : checkRSList) {
                    if (ResourceUtil.getString((String)"inspect.wizard.manuly.check.result.pass").equals(checkRs) || ResourceUtil.getString((String)"inspect.wizard.manuly.check.result.notrelate").equals(checkRs)) {
                        ++passCnt;
                    }
                    if (!ResourceUtil.getString((String)"inspect.wizard.manuly.check.result.yes").equals(checkRs) && !ResourceUtil.getString((String)"inspect.wizard.manuly.check.result.no").equals(checkRs)) continue;
                    ++settingInputItms;
                }
                String passRate = "0%";
                if (passCnt > 0) {
                    passRate = String.valueOf(passCnt * 100 / (checkRSList.size() - settingInputItms) + "%");
                } else if (checkRSList.size() == settingInputItms) {
                    passRate = ResourceUtil.getString((String)"inspect.wizard.manuly.check.result.notrelate");
                }
                row.setValueAt(5, (Object)new IsmTableCell.TextCell(passRate, false, 0));
                HashMap<String, String> passRateMap = BureauDocuService.INS.getPassRateMap();
                passRateMap.put(dev.getDeviceSerialNumber(), passRate);
                card.updateNavigationBar();
                return;
            }
        }

        private static void showImportedFileScore(ManulyCheckCard card, DevNode dev, BureauFile file) {
            List rows = card.getCardLayout().getTable().getMarkedRows();
            if (null == rows || rows.isEmpty() || null == file) {
                LOG.info("selected rows is null or empty, or file is null.");
                return;
            }
            for (TableRow row : rows) {
                if (!row.getUserObject().equals(dev)) continue;
                IsmTableCell.HyperlinkCell cell = new IsmTableCell.HyperlinkCell(String.valueOf(file.getScore()), (ActionListener)new ManulyCheckListener(EXPLORE_FILE, card));
                row.setValueAt(4, (Object)card.getImportAgainCell());
                row.setValueAt(5, (Object)cell);
                card.updateNavigationBar();
                return;
            }
        }
    }
}

