/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.fusioncube.entity.MetaVisionReportItem;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.ui.dialogs.InspectDetailDialog;
import com.huawei.ism.tool.inspect.ui.wizard.PerformInspectCardLayout;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;

public class PerformInspectListMouseAdapter
extends MouseAdapter {
    private PerformInspectCardLayout inspectCardLayout;

    public PerformInspectListMouseAdapter(PerformInspectCardLayout inspectCardLayout) {
        this.inspectCardLayout = inspectCardLayout;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event) || event.getClickCount() > 1) {
            return;
        }
        int index = this.getListIndex(event.getPoint(), this.inspectCardLayout.getDetailList());
        if (-1 == index) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.inspectCardLayout.getDetailList().getModel();
        Object obj = model.getElementAt(index);
        if (obj instanceof Record) {
            Record rec = (Record)obj;
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            if (RecordStatus.INTERRUPPED.equals((Object)rec.getStatus())) {
                DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.performinspect.execfaild.message"));
                return;
            }
            CheckItem item = rec.getCheckItem();
            if (null != item && "baseinfo".equals(item.getItemId())) {
                return;
            }
            if (null == rec.getItem()) {
                return;
            }
            if (RecordStatus.RUNNING.equals((Object)rec.getStatus())) {
                return;
            }
            if (rec.getCheckDevNode().getProduct().isOld()) {
                DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.performinspect.notsupportdetail"));
                return;
            }
            if (this.isMetaVisionAndNotFinish(rec)) {
                DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.step6.metavision.item.running.click.detail"));
                return;
            }
            InspectDetailDialog detailDialog = new InspectDetailDialog(mainDialog, rec);
            detailDialog.setVisible(true);
        }
    }

    private boolean isMetaVisionAndNotFinish(Record rec) {
        if (!"MetaVision".equals(rec.getCheckDevNode().getProduct().getProductName())) {
            return false;
        }
        if (rec.getCheckItem() instanceof MetaVisionReportItem) {
            MetaVisionReportItem reportItem = (MetaVisionReportItem)rec.getCheckItem();
            return reportItem.getCheckMethod() == null && reportItem.getCheckCriterion() == null;
        }
        return false;
    }

    private int getListIndex(Point point, JList detailList) {
        int index = -1;
        ListUI obj = detailList.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)detailList.getUI();
            index = ui.locationToRow(point);
        } else {
            index = detailList.getSelectedIndex();
        }
        return index;
    }
}

