/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCard;
import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCardLayout;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDevUpdateNavigationListener
implements ListSelectionListener {
    private final SelectDeviceCard card;
    private static final Logger LOG = LoggerFactory.getLogger(SelectDevUpdateNavigationListener.class);
    private boolean shouldBreakLoop = false;
    private List<TableRow> lastSlection = new ArrayList<TableRow>();

    public SelectDevUpdateNavigationListener(SelectDeviceCard card) {
        this.card = card;
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getValueIsAdjusting() || this.shouldBreakLoop) {
            return;
        }
        this.card.updateNavigationBar();
        InspectContext.getInstance().updateNavigationBar(this.card);
        this.setSelectRow();
    }

    public void setSelectRow() {
        SelectDeviceCardLayout layout = this.card.getSelectDeviceCardLayout();
        IsmTable table = layout.getDeviceTable();
        DefaultTableModel model = layout.getTableModel();
        if (table.getRowCount() == 0) {
            LOG.info("row count 0");
            return;
        }
        this.shouldBreakLoop = true;
        List rows = table.getMarkedRows();
        if (this.lastSlection.size() > rows.size() && this.checkChildList(this.lastSlection, rows)) {
            this.shouldBreakLoop = false;
            this.lastSlection = rows;
            return;
        }
        List<TableRow> res = this.getRows2BeSelected(layout.getSelectedDevs(), model);
        table.markTableRow(res.toArray(new TableRow[res.size()]));
        this.lastSlection = res;
        this.shouldBreakLoop = false;
    }

    private boolean checkChildList(List<TableRow> big, List<TableRow> small) {
        for (TableRow row : small) {
            if (big.contains(row)) continue;
            return false;
        }
        return true;
    }

    private List<TableRow> getRows2BeSelected(List<DevNode> selectedDevs, DefaultTableModel model) {
        ArrayList<TableRow> res = new ArrayList<TableRow>();
        for (DevNode node : selectedDevs) {
            List sns;
            TableRow<?, ?> self = InspectContext.getInstance().getRow(node.getDeviceSerialNumber());
            if (!res.contains(self)) {
                res.add(self);
            }
            if ((sns = node.getRemoteSNs()) == null) continue;
            for (String sn : sns) {
                TableRow<?, ?> row = InspectContext.getInstance().getRow(sn);
                if (null == row || res.contains(row)) continue;
                res.add(row);
            }
        }
        return res;
    }

    public boolean isShouldBreakLoop() {
        return this.shouldBreakLoop;
    }

    public void setShouldBreakLoop(boolean shouldBreakLoop) {
        this.shouldBreakLoop = shouldBreakLoop;
    }
}

