/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.inspect.ui.wizard.SetResultSaveCardLayout;
import com.huawei.ism.tool.inspect.utils.FileAssistant;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JTextField;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class SelectPathListener
implements ActionListener {
    private SetResultSaveCardLayout layout;

    public SelectPathListener(SetResultSaveCardLayout layout) {
        this.layout = layout;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File defaultFile;
        String suffix;
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        JTextField pathTextArea = this.layout.getPathTextArea();
        String title = ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.browspath");
        String selectFilePath = ToolFileChooser.getSaveFilePath((String)title, (String)(suffix = "zip"), (Window)mainDialog, (String)(defaultFile = new File(FilePathUtils.checkFile((String)pathTextArea.getText()))).getName(), (String)"inspect_saveresult_path_id001", (boolean)false);
        if (null == selectFilePath) {
            throw new NullPointerException();
        }
        if (!FileAssistant.checkPatch(mainDialog, selectFilePath)) {
            return;
        }
        File file = new File(selectFilePath);
        String dirPath = "";
        try {
            dirPath = file.getParentFile().getCanonicalPath();
        }
        catch (IOException e1) {
            ToolLoggerFactory.getLogger(this.getClass()).error("file Canonical path" + e1);
        }
        if (StringUtils.hasMatchStr((String)dirPath, (String)"\\s{2,}")) {
            HibernateContainer.getInstance().put("inspect_saveresult_path_id001", (Object)pathTextArea.getText());
            String msg = ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.pathinvaild");
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)msg);
            return;
        }
        LoggerFactory.getLogger(SetResultSaveCardLayout.class).info("Change inspection directory >> " + FilesUtil.getCanonicalPath((File)defaultFile) + " -> " + selectFilePath + "][Success");
        pathTextArea.setText(selectFilePath);
        this.layout.getCurrentCard().updateNavigationBar();
    }
}

