/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.logic;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.ui.logic.SilentUpdateHelpFileRunnable;
import com.huawei.ism.tool.inspect.ui.logic.UnzipForNewThread;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class StartInspectTools
implements Callable<Object> {
    @Override
    public Object call() {
        AsyncExcutor.submit((Runnable)new SilentUpdateHelpFileRunnable());
        SysConfiguration.getInstance().initSysconf();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHelpFile() {
        long id = System.currentTimeMillis();
        LoggerFactory.getLogger(this.getClass()).info("decompress help case start. id -> " + id);
        try {
            File scriptFile = new File(InspectContext.INSPECT_CONFPATH + File.separator + "products");
            File[] scriptFiles = scriptFile.listFiles();
            if (scriptFiles == null) {
                LoggerFactory.getLogger(this.getClass()).info("scriptFiles is null!");
                return;
            }
            ExecutorService executorService = ThreadPoolHelper.getFixedNumThreadPool((int)3, (String)"decompressHelpcaseThread");
            for (File file : scriptFiles) {
                File scriptHelpDir = new File(file, "helpCase");
                File scriptHelpZip = new File(file, "helpCase.zip");
                if (scriptHelpDir.exists()) {
                    FileUtils.deleteFile((File)scriptHelpDir);
                }
                if (!scriptHelpZip.exists()) continue;
                executorService.execute(new UnzipForNewThread(scriptHelpDir, scriptHelpZip));
            }
            executorService.shutdown();
            executorService.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("eror!", (Throwable)e);
        }
        finally {
            InspectContext.getInstance().setDecompressHelpcaseionFinish(true);
            LoggerFactory.getLogger(this.getClass()).info("decompress help case finish. id -> " + id);
        }
    }
}

