/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.tool;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.ClusterNodeStatus;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectClusterNodeCardService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectClusterNodeCardService.class);

    public List<String> findFirstSelectAllNodeIps(List<CheckDevNode> checkDevNodes) {
        return checkDevNodes.stream().filter(checkDevNode -> InspectUtils.isDistributedAndAllNodeSelect(checkDevNode) && !InspectUtils.isRecordSnToLocal(checkDevNode.getDevNode().getDeviceSerialNumber())).map(CheckDevNode::getDevNode).map(DevNode::getIp).collect(Collectors.toList());
    }

    public String getIpsJoinStr(List<String> ips, int maxIpsNumber) {
        return ips.size() <= maxIpsNumber ? ips.stream().collect(Collectors.joining(", ")) : ips.stream().limit(maxIpsNumber).collect(Collectors.joining(", ")) + ",...";
    }

    public boolean isDsDeviceAndNotSelectClusterNode(CheckDevNode checkDevNode) {
        if (checkDevNode.isIntegration() || checkDevNode.getDevNode() == null || !checkDevNode.getDevNode().isDsStorage()) {
            return false;
        }
        return checkDevNode.getDevNode().getClusterNodes().stream().noneMatch(ClusterNode::isSelected);
    }

    public boolean isCurrentClusterNodeSelect(DevNode dev, String clusterSn) {
        return dev.getClusterNodes().stream().anyMatch(clusterNode -> clusterNode.isSelected() && clusterNode.getSerialNumber().equals(clusterSn));
    }

    public Map<DevNode, Map<String, ClusterNodeStatus>> parseAllDevClusterInfo(Map<DevNode, JSONArray> allDevClusterInfo) {
        HashMap<DevNode, Map<String, ClusterNodeStatus>> deviceClusterNodeStatusMap = new HashMap<DevNode, Map<String, ClusterNodeStatus>>();
        for (Map.Entry<DevNode, JSONArray> entry : allDevClusterInfo.entrySet()) {
            JSONArray clusterInfo = entry.getValue();
            if (clusterInfo == null) continue;
            HashMap<String, ClusterNodeStatus> clusterNodeStatusMap = new HashMap<String, ClusterNodeStatus>();
            for (int i = 0; i < clusterInfo.length(); ++i) {
                JSONObject jsonData = clusterInfo.getJSONObject(i);
                String nodeIp = jsonData.getStringOrDefault("management_ip", "");
                ClusterNodeStatus status = ClusterNodeStatus.getClusterNodeStatus((int)jsonData.getInt("status"));
                clusterNodeStatusMap.put(nodeIp, status);
            }
            deviceClusterNodeStatusMap.put(entry.getKey(), clusterNodeStatusMap);
        }
        return deviceClusterNodeStatusMap;
    }

    public void updateClusterNodeStatus(Map<DevNode, Map<String, ClusterNodeStatus>> allNodeStatusMap) {
        allNodeStatusMap.forEach((devNode, nodeStatusMap) -> devNode.getClusterNodes().forEach(clusterNode -> clusterNode.setStatus((ClusterNodeStatus)nodeStatusMap.get(clusterNode.getManagementIp()))));
    }

    public List<List<String>> getAbnormalClusterNodeInfo(Map<DevNode, Map<String, ClusterNodeStatus>> allNodeStatusMap) {
        ArrayList<List<String>> abnormalNodes = new ArrayList<List<String>>();
        for (Map.Entry<DevNode, Map<String, ClusterNodeStatus>> deviceEntry : allNodeStatusMap.entrySet()) {
            DevNode devNode = deviceEntry.getKey();
            Map<String, ClusterNodeStatus> nodeStatusMap = deviceEntry.getValue();
            Set<String> selectClusterNodeIps = this.getSelectClusterNodeIps(devNode);
            for (Map.Entry<String, ClusterNodeStatus> clusterNodeEntry : nodeStatusMap.entrySet()) {
                String clusterNodeIp = clusterNodeEntry.getKey();
                ClusterNodeStatus clusterNodeStatus = clusterNodeEntry.getValue();
                if (clusterNodeStatus.isNormal() || !selectClusterNodeIps.contains(clusterNodeIp)) continue;
                abnormalNodes.add(Arrays.asList(devNode.getIp(), clusterNodeIp));
            }
        }
        log.info("The abnormal node information is as follows:{}", abnormalNodes);
        return abnormalNodes;
    }

    private Set<String> getSelectClusterNodeIps(DevNode devNode) {
        return devNode.getClusterNodes().stream().filter(ClusterNode::isSelected).map(ClusterNode::getManagementIp).collect(Collectors.toSet());
    }
}

