/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.huawei.ism.tool.inspect.entity.A800ExpansionDiskInfo;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.ExtendModel;
import com.huawei.ism.tool.inspect.logic.config.CheckItemPlatformAdapterInInspect;
import com.huawei.ism.tool.inspect.ui.wizard.A800ExpansionStrategySettingCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class A800ExpansionStrategySettingCard
extends InspectCard {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(A800ExpansionStrategySettingCard.class);
    private static final long serialVersionUID = 1L;
    private static final String A800_EXPANSION_TEMPLATE_NAME = "A800ExpansionTemplate";
    private final A800ExpansionStrategySettingCardLayout layout = new A800ExpansionStrategySettingCardLayout();
    private String expMode = "";
    private String inputInterfaceBom = "";
    private String inputCtrBom = "";
    private List<A800ExpansionDiskInfo> expansionDiskInfos = new ArrayList<A800ExpansionDiskInfo>();

    public A800ExpansionStrategySettingCard(ToolWizardDialog.Card card, ToolWizardDialog.Navigation[] navigations) {
        super(card, navigations);
        super.addLayout(this.layout);
        this.initLayoutByExpModel(Objects.requireNonNull(this.layout.getExpModelBox().getSelectedItem()));
        this.bindListener();
    }

    @NonNull
    private static String getFilePath() {
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            return "config/template/A800/A800_Expansion_en.xlsx";
        }
        return "config/template/A800/A800_Expansion_zh.xlsx";
    }

    private static List<TableRow> createTableRows(List<A800ExpansionDiskInfo> diskInfos) {
        return diskInfos.stream().map(A800ExpansionStrategySettingCard::createOneRow).collect(Collectors.toList());
    }

    @NonNull
    private static TableRow<A800ExpansionDiskInfo, A800ExpansionDiskInfo> createOneRow(A800ExpansionDiskInfo disk) {
        DefaultTableRow row = new DefaultTableRow(A800ExpansionStrategySettingCardLayout.A800_DISK_HEADERS.length, (Object)disk, (Object)disk);
        int i = 0;
        row.setValueAt(i++, (Object)disk.getZoneId());
        row.setValueAt(i++, (Object)disk.getEngineId());
        row.setValueAt(i++, (Object)disk.getPoolId());
        row.setValueAt(i++, (Object)disk.getDiskBom());
        row.setValueAt(i++, (Object)disk.getDiskNum());
        row.setValueAt(i++, (Object)(disk.getDiskCapacity() + " " + disk.getCapacityUnit()));
        row.setValueAt(i++, (Object)disk.getDiskType());
        return row;
    }

    private static void export(Dialog mainDialog, String selectFilePath) {
        boolean isError = false;
        try (InputStream is = A800ExpansionStrategySettingCard.class.getClassLoader().getResourceAsStream(A800ExpansionStrategySettingCard.getFilePath());){
            if (is == null) {
                log.error("export file error, file: {} return null", (Object)selectFilePath);
                isError = true;
            }
            FileUtils.copyInputStreamToFile((InputStream)is, (File)new File(selectFilePath));
            log.info("export file to {} success.", (Object)selectFilePath);
        }
        catch (IOException e) {
            log.error("export file error, file: {}", (Object)selectFilePath, (Object)e);
            isError = true;
        }
        if (isError) {
            DialogUtils.showErrorDialog((Window)mainDialog, (String)ResourceUtil.getString((String)"inspect.wizard.manualcheck.export.file.error"));
            return;
        }
        OSCmdUtils.explorerFile((String)selectFilePath);
    }

    private void bindListener() {
        this.layout.getExpModelBox().addItemListener(this::updateUiWhenExpModelChange);
        this.layout.getExportTemplate().addClickListener(this::exportTemplate);
        this.layout.getImportTemplate().addClickListener(this::importTemplate);
    }

    private void exportTemplate(MouseEvent mouseEvent) {
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        String selectFilePath = ToolFileChooser.getSaveFilePath((String)ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.browspath"), (String)"xlsx", (Window)mainDialog, (String)A800_EXPANSION_TEMPLATE_NAME, (String)A800_EXPANSION_TEMPLATE_NAME, (boolean)true);
        if (null == selectFilePath) {
            return;
        }
        A800ExpansionStrategySettingCard.export(mainDialog, selectFilePath);
    }

    private void importTemplate(MouseEvent mouseEvent) {
        WarningDialog dialog;
        if (!this.layout.getTable().getAllRows().isEmpty() && !(dialog = DialogUtils.showYesNoDialog((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.reImport.waring"))).isConfirmClick()) {
            log.info("abort re-import of expansion config.");
            return;
        }
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("description", "*.xlsx");
        extParams.put("PathId", A800_EXPANSION_TEMPLATE_NAME);
        extParams.put("title", ResourceUtil.getString((String)"inspsctor.wizard.A800strategysetting.import.title"));
        File selectFile = ToolFileChooser.selectFile((Window)InspectContext.getInstance().getMainDialog(), (String[])new String[]{".xlsx"}, (int)0, (boolean)true, extParams);
        if (null == selectFile) {
            log.info("select file is null.");
            return;
        }
        log.info("import file: {}", (Object)FilesUtil.getCanonicalPath((File)selectFile));
        A800ExpansionDiskInfo.A800ExpansionDiskInfoDataValidator readListener = new A800ExpansionDiskInfo.A800ExpansionDiskInfoDataValidator();
        A800ExpansionStrategySettingCard.readData(selectFile, readListener);
        this.syncData2Table(readListener);
    }

    private void syncData2Table(A800ExpansionDiskInfo.A800ExpansionDiskInfoDataValidator readListener) {
        if (!readListener.getInvalidData().isEmpty()) {
            log.warn("exist invalid data, abort sycn data.");
            return;
        }
        if (readListener.getValidData().isEmpty()) {
            log.info("no valid data, abort sync data.");
            DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspsctor.wizard.A800ExpansionDiskInfo.tableData.empty.errMsg1"));
            return;
        }
        this.initTableData(readListener.getValidData());
    }

    private static void readData(File selectFile, A800ExpansionDiskInfo.A800ExpansionDiskInfoDataValidator readListener) {
        try {
            ((ExcelReaderSheetBuilder)((ExcelReaderBuilder)EasyExcelFactory.read((File)selectFile).head(A800ExpansionDiskInfo.class)).sheet(Integer.valueOf(0)).registerReadListener((ReadListener)readListener)).doReadSync();
        }
        catch (ExcelAnalysisException | ExcelDataConvertException e) {
            log.error("parse excel data error ,path {}", (Object)selectFile.getPath(), (Object)e);
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspsctor.wizard.A800ExpansionDiskInfoDataValidator.dialog.error"));
        }
    }

    private void initTableData(List<A800ExpansionDiskInfo> diskInfos) {
        this.layout.getModel().removeAll();
        this.layout.getModel().addRows(A800ExpansionStrategySettingCard.createTableRows(diskInfos));
    }

    private void updateUiWhenExpModelChange(ItemEvent event) {
        Object expModel = event.getItem();
        this.initLayoutByExpModel(expModel);
    }

    private void initLayoutByExpModel(Object expModel) {
        if (expModel.equals((Object)ExtendModel.A800_DD_EXP_INSPECT)) {
            this.layout.showExpDDArea();
            this.layout.getExportTemplate().addClickListener(this::exportTemplate);
            this.layout.getImportTemplate().addClickListener(this::importTemplate);
            this.expMode = "EXTEND_DD";
        } else if (expModel.equals((Object)ExtendModel.INTF_CARD_EXP_INSPECT)) {
            this.layout.showInterBomArea();
        } else if (expModel.equals((Object)ExtendModel.CTRL_EXP_INSPECT)) {
            this.layout.showCtrlArea();
            this.expMode = "EXTEND_CTRL";
        } else {
            this.layout.clearDataArea();
        }
        this.updateUi();
    }

    private void updateUi() {
        SwingUtilities.invokeLater(() -> {
            this.revalidate();
            this.repaint();
        });
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step.extend.setting");
    }

    public int getStep() {
        return this.getStep(CardModelEnum.A800STRATEGYSETTING);
    }

    protected ToolWizardDialog.Card getNextCard() {
        this.initCacheData();
        if (!this.checkDataAndCacheData()) {
            return this;
        }
        InspectUIUtil.removeOtherZoneInnerCheckItems(WORKTAKER.getCheckDevNodes());
        this.layout.saveExpansionDiskInfo(this.expansionDiskInfos);
        this.synchData2Context();
        InspectWorktaker workTaker = InspectContext.getInstance().getInspectWorktaker();
        List checkDevs = (List)workTaker.get("check_dev_nodes");
        this.initCheckItem(checkDevs);
        return InspectUIUtil.getNextCard(CardModelEnum.A800STRATEGYSETTING, this);
    }

    private void synchData2Context() {
        InspectContext.getInstance().setInterfaceBom(this.inputInterfaceBom);
        InspectContext.getInstance().setEncBom(this.inputCtrBom);
        InspectContext.getInstance().setExpansionA800DiskInfos(this.expansionDiskInfos);
        InspectContext.getInstance().setExpMode(this.expMode);
        InspectContext.getInstance().setExpModeOri(this.layout.getExpModelBox().getSelectedItem().toString());
    }

    private void initCheckItem(List<CheckDevNode> checkDevs) {
        ExtendModel configMode = (ExtendModel)((Object)this.layout.getExpModelBox().getSelectedItem());
        log.info("extend config mode: {}", (Object)configMode);
        for (CheckDevNode checkDevNode : checkDevs) {
            CheckItemPlatformAdapterInInspect.getInstance().addCheckConfigItem(checkDevNode.getCheckItems(), checkDevNode);
            InspectContext.getInstance().filterItemWhitScene(checkDevNode, configMode.getKey());
        }
    }

    private boolean checkDataAndCacheData() {
        JDialog main = InspectContext.getInstance().getMainDialog();
        if (ExtendModel.INTF_CARD_EXP_INSPECT.equals(this.layout.getExpModelBox().getSelectedItem())) {
            if (!SwingUtil.validateInput(this.layout.getExpInterfaceTextField(), (Window)main)) {
                return false;
            }
            this.inputInterfaceBom = this.layout.getInterfaceBomJTF().getText();
        } else if (ExtendModel.CTRL_EXP_INSPECT.equals(this.layout.getExpModelBox().getSelectedItem())) {
            if (!SwingUtil.validateInput(this.layout.getExpCtrlInputTextField(), (Window)main) || !this.validateTableDataForExpCtrl(main)) {
                return false;
            }
            this.inputCtrBom = this.layout.getCtrlBomJTF().getText();
            this.inputInterfaceBom = this.layout.getInterfaceBomJTF().getText();
            this.expansionDiskInfos = this.getExpansionDiskInfo();
        } else if (ExtendModel.A800_DD_EXP_INSPECT.equals(this.layout.getExpModelBox().getSelectedItem())) {
            if (!this.validateTableData(main)) {
                return false;
            }
            this.expansionDiskInfos = this.getExpansionDiskInfo();
        } else {
            return true;
        }
        return true;
    }

    private boolean validateTableDataForExpCtrl(Dialog main) {
        if (!this.getExpansionDiskInfo().isEmpty()) {
            return true;
        }
        WarningDialog result = DialogUtils.showYesNoDialog((Window)main, (String)ResourceUtil.getString((String)"inspsctor.wizard.A800ExpansionDiskInfo.tableData.empty.warning"));
        return 0 == result.getValue();
    }

    private boolean validateTableData(Dialog main) {
        if (this.getExpansionDiskInfo().isEmpty()) {
            DialogUtils.showErrorDialog((Window)main, (String)ResourceUtil.getString((String)"inspsctor.wizard.A800ExpansionDiskInfo.tableData.empty.errMsg"));
            return false;
        }
        return true;
    }

    @NonNull
    private List<A800ExpansionDiskInfo> getExpansionDiskInfo() {
        return this.layout.getTable().getAllRows().stream().map(TableRow::getUserObject).filter(A800ExpansionDiskInfo.class::isInstance).map(A800ExpansionDiskInfo.class::cast).collect(Collectors.toList());
    }

    private void initCacheData() {
        this.inputInterfaceBom = "";
        this.inputCtrBom = "";
        this.expansionDiskInfos = new ArrayList<A800ExpansionDiskInfo>();
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }
}

