/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.inspect.entity.A800ExpansionDiskInfo;
import com.huawei.ism.tool.inspect.entity.ExtendModel;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.combo.IsmComboBox;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import javax.swing.text.PlainDocument;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A800ExpansionStrategySettingCardLayout
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(A800ExpansionStrategySettingCardLayout.class);
    static final String[] A800_DISK_HEADERS = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.zoneId"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.engineId"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.poolId"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskBom"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskCount"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskCapacity"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskModel")};
    private static final Dimension CONFIG_BOX_SIZE = new Dimension(370, 22);
    private static final Dimension EXTEND_SCENE_SIZE = new Dimension(645, 310);
    private static final Dimension BOM_BOX_SIZE = new Dimension(355, 22);
    private static final List<ExtendModel> EXTEND_MODELS = Arrays.asList(ExtendModel.EXTEND_DEFAULT, ExtendModel.CTRL_EXP_INSPECT, ExtendModel.INTF_CARD_EXP_INSPECT, ExtendModel.A800_DD_EXP_INSPECT);
    private static final Map<String, List<ExtendModel>> EXTEND_MODELS_MAP = new HashMap<String, List<ExtendModel>>();
    private static final Pattern CTRL_BOM_PATTERN = Pattern.compile("(?![0-9]{8})(?![a-zA-Z]{8})[0-9A-Za-z]{8}");
    private static final Pattern INTERFACE_BOM_PATTERN = Pattern.compile("(?![a-zA-Z]{8})[0-9A-Za-z]{8}");
    private static final String BOM_SPLITER = ",";
    private final Box mainBox;
    private ToolHyperLinkLabel exportTemplate;
    private ToolHyperLinkLabel importTemplate;
    private IsmComboBox expModelBox;
    private IsmTextField interfaceBomJTF;
    private Box noticeBomBox;
    private IsmTextField ctrlBomJTF;
    private TableScrollPane scrollPane;
    private IsmTable table;
    private DefaultTableModel model;
    private JComponent tableDescArea;
    private JComponent tableDataArea;
    private JComponent interBomArea;
    private JComponent ctrlArea;

    public A800ExpansionStrategySettingCardLayout() {
        JComponent expModel = this.createExpModelComboBox();
        JComponent topComponent = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{A800ExpansionStrategySettingCardLayout.createTopDesc(), expModel});
        this.initInterBomArea();
        this.initTableDataArea();
        this.initCtrlArea();
        this.mainBox = Box.createVerticalBox();
        this.mainBox.add(UCD.buildVBoxTop((int)12, (Component[])new Component[]{topComponent, new JSeparator()}));
        UiMethod.buildFrameSpace((JComponent)this.mainBox, (int)12);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainBox, "North");
    }

    @NonNull
    private static Box createTopDesc() {
        Box topDesc = Box.createHorizontalBox();
        topDesc.add(new JLabel(ResourceUtil.getString((String)"inspect.wizard.strategysetting.desc.top")));
        topDesc.add(Box.createHorizontalGlue());
        return topDesc;
    }

    private void initTableDataArea() {
        this.model = new DefaultTableModel(A800_DISK_HEADERS, new int[0]);
        this.table = new IsmTable((TableModel)this.model, true);
        this.scrollPane = TableScrollPane.createTablePane((IsmTable)this.table, (boolean)false, (TableScrollPane.CountArea)TableScrollPane.CountArea.TABLE_LEFT_UP, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.TABLE_RIGHT_UP, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.NONE);
        UiMethod.setComponentSize((Dimension)EXTEND_SCENE_SIZE, (Component[])new Component[]{this.scrollPane});
        this.tableDescArea = this.createTableDesc();
        this.tableDataArea = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{Box.createVerticalBox(), this.tableDescArea, this.scrollPane});
    }

    private JComponent createTableDesc() {
        Box noticeDesc = UCD.buildHBoxLeft((Component[])new Component[]{new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.A800strategysetting.expdd.desc1")), Box.createHorizontalGlue()});
        this.exportTemplate = new ToolHyperLinkLabel(ResourceUtil.getString((String)"inspsctor.wizard.A800strategysetting.export.link"));
        this.importTemplate = new ToolHyperLinkLabel(ResourceUtil.getString((String)"inspsctor.wizard.A800strategysetting.import.link"));
        JComponent noticeDecs1 = this.initNoticeDesc();
        return UCD.buildVBoxTop((int)0, (Component[])new Component[]{noticeDesc, noticeDecs1});
    }

    private void updateNoticeInExpModel() {
        this.tableDescArea = UCD.buildVBoxTop((int)0, (Component[])new Component[]{this.initNoticeDesc()});
        this.tableDataArea = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{Box.createVerticalBox(), this.tableDescArea, this.scrollPane});
    }

    @NonNull
    private JComponent initNoticeDesc() {
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            return UCD.buildVBoxTop((int)0, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.A800strategysetting.expdd.desc2")), this.exportTemplate}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.A800strategysetting.expdd.desc3")), this.importTemplate})});
        }
        return UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.A800strategysetting.expdd.desc2")), this.exportTemplate, new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.A800strategysetting.expdd.desc3")), this.importTemplate});
    }

    private JComponent createExpModelComboBox() {
        this.expModelBox = new IsmComboBox();
        String sceneType = InspectContext.getArgsParamFormSceneConfig("sceneType");
        log.info("The current scene:{}", (Object)sceneType);
        List<ExtendModel> extendModelList = EXTEND_MODELS_MAP.getOrDefault(sceneType, EXTEND_MODELS);
        extendModelList.forEach(arg_0 -> this.expModelBox.addItem(arg_0));
        UiMethod.setComponentSize((Dimension)CONFIG_BOX_SIZE, (Component[])new Component[]{this.expModelBox});
        return UCD.buildHBoxLeft((int)12, (Component[])new Component[]{new JLabel(ResourceUtil.getString((String)"inspect.wizard.strategysetting.desc.scene")), this.expModelBox});
    }

    public void saveExpansionDiskInfo(List<A800ExpansionDiskInfo> expansionDiskInfos) {
        if (!Objects.requireNonNull(this.getExpModelBox().getSelectedItem()).equals((Object)ExtendModel.A800_DD_EXP_INSPECT)) {
            return;
        }
        File rootDir = new File(ApplicationContext.getInstance().getWorkPath()).getParentFile().getParentFile();
        String expDiskInfoFile = String.join((CharSequence)File.separator, rootDir.toString(), "temp", "expanEval", "expansionEvalConfig.dat");
        log.info("file dir: {}", (Object)expDiskInfoFile);
        File directory = new File(expDiskInfoFile).getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        try (FileWriter writer = new FileWriter(expDiskInfoFile);){
            writer.write(JSON.toJSONString(expansionDiskInfos));
        }
        catch (IOException e) {
            log.error("write expansion disk info file error!", (Throwable)e);
        }
    }

    public void showExpDDArea() {
        this.clearDataArea();
        this.initTableDataArea();
        this.updateNoticeInExpModel();
        this.mainBox.add(this.tableDataArea);
    }

    public void showInterBomArea() {
        this.clearDataArea();
        this.initInterBomArea();
        this.mainBox.add(this.interBomArea);
    }

    public void showCtrlArea() {
        this.clearDataArea();
        this.mainBox.add(this.ctrlArea);
    }

    public void clearDataArea() {
        this.mainBox.remove(this.interBomArea);
        this.mainBox.remove(this.tableDataArea);
        this.mainBox.remove(this.ctrlArea);
    }

    private void initInterBomArea() {
        this.noticeBomBox = Box.createHorizontalBox();
        this.noticeBomBox.add(new JLabel(ResourceUtil.getString((String)"inspect.wizard.strategysetting.notice.bom")));
        this.noticeBomBox.add(Box.createHorizontalGlue());
        this.interfaceBomJTF = new IsmTextField(new PlainDocument(), "", 120);
        this.interfaceBomJTF.addInputValidator(new InputValidator(){

            public String validateInput(String input, String inputValueName) {
                if (this.isExpCtrlModelAndAllowEmptyBom(input)) {
                    return null;
                }
                if (A800ExpansionStrategySettingCardLayout.this.isInterfaceBomInvalid(input)) {
                    return ResourceUtil.getString((String)"inspect.wizard.A800ExpansionDiskInfoDataValidator.invalid.interface.bom");
                }
                return null;
            }

            private boolean isExpCtrlModelAndAllowEmptyBom(String input) {
                return ExtendModel.CTRL_EXP_INSPECT.equals(A800ExpansionStrategySettingCardLayout.this.getExpModelBox().getSelectedItem()) && StringUtils.isNULLStr((String)input);
            }

            public String getToolTip() {
                return ResourceUtil.getString((String)"inspect.wizard.strategysetting.invalid.interface.bom");
            }
        });
        UiMethod.setComponentSize((Dimension)BOM_BOX_SIZE, (Component[])new Component[]{this.interfaceBomJTF});
        this.interBomArea = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{Box.createVerticalGlue(), this.noticeBomBox, this.createInterBom()});
    }

    private boolean isCtrlBomInvalid(String bom) {
        String[] bomList;
        if (bom == null) {
            return true;
        }
        for (String bomNum : bomList = bom.split(BOM_SPLITER)) {
            if (CTRL_BOM_PATTERN.matcher(bomNum).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isInterfaceBomInvalid(String bom) {
        String[] bomList;
        if (bom == null) {
            return true;
        }
        for (String bomNum : bomList = bom.split(BOM_SPLITER)) {
            if (INTERFACE_BOM_PATTERN.matcher(bomNum).matches()) continue;
            return true;
        }
        return false;
    }

    private void initCtrlArea() {
        this.ctrlBomJTF = new IsmTextField(new PlainDocument(), "", 60);
        this.ctrlBomJTF.addInputValidator(new InputValidator(){

            public String validateInput(String input, String inputValueName) {
                if (A800ExpansionStrategySettingCardLayout.this.isCtrlBomInvalid(input)) {
                    return ResourceUtil.getString((String)"inspect.wizard.A800ExpansionDiskInfoDataValidator.invalid.enc.bom");
                }
                return null;
            }

            public String getToolTip() {
                return null;
            }
        });
        UiMethod.setComponentSize((Dimension)BOM_BOX_SIZE, (Component[])new Component[]{this.ctrlBomJTF});
        this.ctrlArea = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{Box.createVerticalGlue(), this.noticeBomBox, this.createCtrlBom(), this.createInterBom(), this.tableDescArea, this.scrollPane});
    }

    private JComponent createCtrlBom() {
        JLabel tipLabel = new JLabel(ResourceUtil.getImage((String)"question.png"));
        tipLabel.setToolTipText(ResourceUtil.getString((String)"get.bom.from.deivce.list"));
        return UiMethod.buildCompsLeft((Component[])new Component[]{UiMethod.createRequiredLabel((String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.enc.bom"), (boolean)true), this.ctrlBomJTF, tipLabel, Box.createHorizontalGlue()});
    }

    @NonNull
    private JComponent createInterBom() {
        return UiMethod.buildCompsLeft((Component[])new Component[]{UiMethod.createRequiredLabel((String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.interface.bom"), (boolean)false), this.interfaceBomJTF, Box.createHorizontalStrut(14), Box.createHorizontalGlue()});
    }

    public List<IsmTextField> getExpCtrlInputTextField() {
        return Arrays.asList(this.ctrlBomJTF, this.interfaceBomJTF);
    }

    public List<IsmTextField> getExpInterfaceTextField() {
        return Collections.singletonList(this.interfaceBomJTF);
    }

    @Generated
    public ToolHyperLinkLabel getExportTemplate() {
        return this.exportTemplate;
    }

    @Generated
    public ToolHyperLinkLabel getImportTemplate() {
        return this.importTemplate;
    }

    @Generated
    public IsmComboBox getExpModelBox() {
        return this.expModelBox;
    }

    @Generated
    public IsmTextField getInterfaceBomJTF() {
        return this.interfaceBomJTF;
    }

    @Generated
    public Box getNoticeBomBox() {
        return this.noticeBomBox;
    }

    @Generated
    public IsmTextField getCtrlBomJTF() {
        return this.ctrlBomJTF;
    }

    @Generated
    public TableScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Generated
    public IsmTable getTable() {
        return this.table;
    }

    @Generated
    public DefaultTableModel getModel() {
        return this.model;
    }

    static {
        EXTEND_MODELS_MAP.put("expCtrl", Collections.singletonList(ExtendModel.CTRL_EXP_INSPECT));
        EXTEND_MODELS_MAP.put("expDD", Collections.singletonList(ExtendModel.A800_DD_EXP_INSPECT));
    }
}

