/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.ui.wizard.AuthClusterNodeCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.ScrollCardUiUtil;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;

public class AuthClusterNodeCard
extends InspectCard {
    private final List<CheckDevNode> checkDevNodes = (List)WORKTAKER.get("check_dev_nodes");
    private final AuthClusterNodeCardLayout authClusterNodeCardLayout = new AuthClusterNodeCardLayout(InspectUtils.getDistributedStorageCheckDev(this.checkDevNodes));

    public AuthClusterNodeCard(ToolWizardDialog.Card preCard, ToolWizardDialog.Navigation[] navigations) {
        super(preCard, navigations);
        this.addLayout(this.authClusterNodeCardLayout);
        this.updateNavigationBar();
    }

    @Override
    public void initData() {
        this.authClusterNodeCardLayout.initData();
        this.authClusterNodeCardLayout.setComponentsName();
        this.authClusterNodeCardLayout.initBmcListener();
        this.showAuthTips();
    }

    private void showAuthTips() {
        DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspsctor.wizard.step.select.cluster.nodes.auth.tips"));
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step.select.cluster.nodes.auth");
    }

    protected ToolWizardDialog.Card getNextCard() {
        if (!this.authComplete(this.checkDevNodes)) {
            return this;
        }
        return InspectUIUtil.getNextCard(CardModelEnum.AUTH_CLUSTER_NODES, this);
    }

    private boolean authComplete(List<CheckDevNode> checkDevNodes) {
        Map<String, List<String>> needBmcAuthDevs = CheckItemUtils.getNeedBmcAuthDev(checkDevNodes);
        if (needBmcAuthDevs.isEmpty()) {
            return true;
        }
        return ScrollCardUiUtil.showNoAuthConfirmDialog(needBmcAuthDevs);
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    public int getStep() {
        return this.getStep(CardModelEnum.AUTH_CLUSTER_NODES);
    }
}

