/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.inspect.entity.ConstantField;
import com.huawei.ism.tool.inspect.entity.DevInfo4Exp;
import com.huawei.ism.tool.inspect.entity.ExtendModel;
import com.huawei.ism.tool.inspect.entity.SCMDisk;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.table.TableModel;
import utils.Products;

public class ExpandScmPanel {
    private static ExpandScmPanel scmPanel = new ExpandScmPanel();
    private static final String[] DISK_TAB_HEADERS = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.location"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskType"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.healthStatus"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.runningStatus"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.capacity")};
    private TableScrollPane scmScrollPane;
    private IsmTable table;
    private Box scmBox;
    private List<SCMDisk> scmDisks = new ArrayList<SCMDisk>();

    private ExpandScmPanel() {
    }

    public static ExpandScmPanel getInstance() {
        return scmPanel;
    }

    public void initComponents() {
        DefaultTableModel tableModel = new DefaultTableModel(DISK_TAB_HEADERS, new int[0]);
        this.table = new IsmTable((TableModel)tableModel, false);
        this.table.setRowSorter(null);
        this.scmScrollPane = TableScrollPane.createTablePane((IsmTable)this.table, (boolean)true, (TableScrollPane.CountArea)TableScrollPane.CountArea.TABLE_LEFT_UP, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.NONE, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.NONE);
        this.scmBox = Box.createHorizontalBox();
        this.scmBox.add(new JLabel(ResourceUtil.getString((String)"inspect.wizard.strategysetting.notice.selectdisk")));
        this.setComponentsVisible(false);
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        this.scmDisks = devInfo.getSmartCachePoolInfoForNas().getNotInPoolDiskList();
        this.scmDisks.forEach(disk -> tableModel.addRow(new TableRow[]{this.createRow((SCMDisk)disk)}));
        InspectContext.getInstance().getScmExpInfo().clear();
    }

    public boolean verify(ExtendModel configMode) {
        if (!ExtendModel.SCM_EXP_INSPECT.equals((Object)configMode)) {
            return true;
        }
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        if ("-1".equals(devInfo.getSmartCachePoolInfoForNas().getPoolId())) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.scm.no.cache.pool"));
            return false;
        }
        if (this.getSelectDisks().size() == 0) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.scm.noselectdisk"));
            return false;
        }
        return true;
    }

    public void active(boolean enable) {
        this.setComponentsVisible(enable);
        if (!enable) {
            return;
        }
        if (!ExpandScmPanel.isSupport()) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.scm.nosupport"));
            return;
        }
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        if ("-1".equals(devInfo.getSmartCachePoolInfoForNas().getPoolId())) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.scm.no.cache.pool"));
            return;
        }
        if (this.scmDisks.size() == 0) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.scm.nodisk"));
        }
    }

    public void saveData(ExtendModel configMode) {
        if (!ExtendModel.SCM_EXP_INSPECT.equals((Object)configMode)) {
            return;
        }
        Map<String, String> scmExpInfo = InspectContext.getInstance().getScmExpInfo();
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        scmExpInfo.put("pool_id", devInfo.getSmartCachePoolInfoForNas().getPoolId());
        scmExpInfo.put("disk_location", this.getSelectDisks().stream().map(SCMDisk::getLocation).collect(Collectors.joining(",")));
    }

    private void setComponentsVisible(boolean visible) {
        this.scmScrollPane.setVisible(visible);
        this.scmBox.setVisible(visible);
    }

    public static boolean isSupport() {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        return ConstantField.DORADO_V6_DEV.contains(devInfo.getDevType().toUpperCase(Locale.ENGLISH)) && Products.compareVersion((String)devInfo.getProductVersion(), (String)"6.1.RC3") >= 0;
    }

    private List<SCMDisk> getSelectDisks() {
        ArrayList<SCMDisk> devs = new ArrayList<SCMDisk>();
        List rows = this.table.getMarkedRows();
        for (TableRow row : rows) {
            devs.add((SCMDisk)row.getIdentifier());
        }
        return devs;
    }

    private TableRow<String, SCMDisk> createRow(SCMDisk disk) {
        DefaultTableRow row = new DefaultTableRow(DISK_TAB_HEADERS.length, (Object)disk.getLocation(), (Object)disk);
        int colNum = 0;
        row.setValueAt(colNum++, (Object)disk.getLocation());
        row.setValueAt(colNum++, (Object)disk.getType());
        row.setValueAt(colNum++, (Object)disk.getHealthStatus());
        row.setValueAt(colNum++, (Object)disk.getRunningStatus());
        row.setValueAt(colNum++, (Object)disk.getCapacity());
        return row;
    }

    public Box getExpandScmBox() {
        Box innerBox = Box.createVerticalBox();
        innerBox.add(this.scmBox);
        Box boardBox = Box.createHorizontalBox();
        boardBox.add(innerBox);
        boardBox.add(Box.createHorizontalGlue());
        return boardBox;
    }

    public TableScrollPane getScmScrollPane() {
        return this.scmScrollPane;
    }

    public void setScmScrollPane(TableScrollPane scmScrollPane) {
        this.scmScrollPane = scmScrollPane;
    }

    public IsmTable getTable() {
        return this.table;
    }

    public void setTable(IsmTable table) {
        this.table = table;
    }

    public Box getScmBox() {
        return this.scmBox;
    }

    public void setScmBox(Box scmBox) {
        this.scmBox = scmBox;
    }
}

