/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DSstorageInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.FsNodeExpansionConfig;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ExpansionTaskUtils;
import com.huawei.ism.tool.inspect.ui.action.DelFsExpansionNodeAction;
import com.huawei.ism.tool.inspect.ui.action.FsExpansionConfigAction;
import com.huawei.ism.tool.inspect.ui.dialogs.ProgressStepDialog;
import com.huawei.ism.tool.inspect.ui.logic.AddDstorageListener;
import com.huawei.ism.tool.inspect.ui.logic.AddNewExpansionNodeListener;
import com.huawei.ism.tool.inspect.ui.logic.DeviceListClickListener;
import com.huawei.ism.tool.inspect.ui.logic.QueryDevStatusCallable;
import com.huawei.ism.tool.inspect.ui.logic.SelectDevListenerByFsExpansion;
import com.huawei.ism.tool.inspect.ui.wizard.FsExpansionSelectDeviceCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCard;
import com.huawei.ism.tool.inspect.utils.IPUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FusionStorDiskInfo;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class FsExpansionSelectDeviceCard
extends InspectCard
implements INodeObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(FsExpansionSelectDeviceCard.class);
    private FsExpansionSelectDeviceCardLayout layout = new FsExpansionSelectDeviceCardLayout();
    private String addExpansionConfig = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.add.config");
    private String newExpansionNodeName = ResourceUtil.getString((String)"inspsctor.wizard.new.expansion.node.name");
    private String updateExpansionConfig = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.update.config");
    private String delNodeConfig = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.delete");
    private String splitStr = ResourceUtil.getString((String)"check.need.bmc.auth.massege.splitStr");
    private SelectDevListenerByFsExpansion selectDevListenerByFsExpansion = new SelectDevListenerByFsExpansion(this);
    private static int newExpansionNumber = 0;

    public FsExpansionSelectDeviceCard(ToolWizardDialog.Card previousCard, ToolWizardDialog.Navigation[] supportedNavigation) {
        super(previousCard, supportedNavigation);
        this.addLayout(this.layout);
        if ("test".equals(System.getenv("runMode"))) {
            InspectContext.getInstance().getInspectWorktaker().put("check_savepath", FilesUtil.getCanonicalPath((File)FileUtils.getDefaultDirectory()) + File.separator);
        }
        InspectContext.getInstance().getInspectWorktaker().put("check_savepath_filename", InspectUtils.buildResultFileName("").getName());
        WORKTAKER.put("scene_hyper_metro_nodes", InspectUtils.getHyperMetroDevNodeList());
        DefaultNodeProviderImpl.getInstance().addNodeObservers((INodeObserver)this);
        this.initTableData();
        this.initListener();
    }

    private void initListener() {
        this.initAddDevAndNodeLListener();
        this.layout.getDeviceListLink().addClickListener((ToolHyperLinkLabel.ClickListener)new DeviceListClickListener());
        this.layout.getDeviceTable().getSelectionModel().addListSelectionListener(this.selectDevListenerByFsExpansion);
    }

    private String isExistInStorage(List<DevNode> addNodeList) {
        List storageList = this.layout.getStorageRowList().stream().map(row -> (DevNode)row.getUserObject()).collect(Collectors.toList());
        List existNewNodeIpList = this.layout.getNodeRowList().stream().map(row -> (DevNode)row.getUserObject()).map(DevNode::getIp).map(ip -> StringUtils.isIpv6Address((String)ip) ? IPUtils.getNormalIPv6(ip) : ip).collect(Collectors.toList());
        List clusterManagementIpNodes = storageList.stream().flatMap(devNode -> devNode.getClusterNodes().stream()).map(ClusterNode::getManagementIp).map(ip -> StringUtils.isIpv6Address((String)ip) ? IPUtils.getNormalIPv6(ip) : ip).collect(Collectors.toList());
        clusterManagementIpNodes.addAll(existNewNodeIpList);
        List<DevNode> nodeAlreadyExistInStorageList = addNodeList.stream().filter(devNode -> {
            boolean isExist = StringUtils.isIpv6Address((String)devNode.getIp()) ? clusterManagementIpNodes.contains(IPUtils.getNormalIPv6(devNode.getIp())) : clusterManagementIpNodes.contains(devNode.getIp());
            if (!isExist) {
                if (StringUtils.isIpv6Address((String)devNode.getIp())) {
                    clusterManagementIpNodes.add(IPUtils.getNormalIPv6(devNode.getIp()));
                } else {
                    clusterManagementIpNodes.add(devNode.getIp());
                }
            }
            return isExist;
        }).collect(Collectors.toList());
        this.deleteAlreadyNode(nodeAlreadyExistInStorageList, addNodeList);
        StringBuilder stringBuilder = new StringBuilder();
        nodeAlreadyExistInStorageList.forEach(node -> stringBuilder.append(node.getIp()).append(","));
        return stringBuilder.toString();
    }

    private void deleteAlreadyNode(List<DevNode> nodeAlreadyExistInStorageList, List<DevNode> addNodeList) {
        nodeAlreadyExistInStorageList.forEach(node -> {
            try {
                addNodeList.remove(node);
                InspectContext.getInstance().getNewExpansionNode().remove(node);
                DefaultNodeProviderImpl.getInstance().removeNode(node);
            }
            catch (ToolException toolException) {
                LOGGER.error("delete failed,node:{}", (Object)node.getIp(), (Object)toolException);
            }
        });
    }

    public void refreshNodeTable() {
        List<TableRow> nodeRowList = this.layout.getNodeRowList();
        List oldNodeList = this.layout.getNodeRowList().stream().map(row -> (DevNode)row.getUserObject()).collect(Collectors.toList());
        List<DevNode> addNodeList = FsExpansionSelectDeviceCard.getDevNodeList().stream().filter(dmDevNode -> !oldNodeList.contains(dmDevNode)).collect(Collectors.toList());
        if (addNodeList.isEmpty()) {
            return;
        }
        String nodeIpAlreadyExistInStorage = this.isExistInStorage(addNodeList);
        if (!StringUtils.isNULLStr((String)nodeIpAlreadyExistInStorage)) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getStringWithParams((String)"inspsctor.wizard.fs.expansion.select.device.card.node.warning", (Object[])new Object[]{nodeIpAlreadyExistInStorage}));
        }
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        ProgressDialog progressDialog = new ProgressDialog((Window)mainDialog, ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.query.storage.info"), 400);
        AsyncExcutor.execute((ProgressDialog)progressDialog, (mainDialog != null ? 1 : 0) != 0, (long)0L, (Callable[])new Callable[]{() -> this.queryStorageInfo(addNodeList, "execute_node")});
        for (int i = 0; i < addNodeList.size(); ++i) {
            addNodeList.get(i).setDeviceName(this.newExpansionNodeName + ++newExpansionNumber);
        }
        InspectContext.getInstance().getNewExpansionNode().addAll(addNodeList);
        List addRows = addNodeList.stream().map(newNode -> this.createNodeRow((DevNode)newNode)).collect(Collectors.toList());
        if (!addRows.isEmpty()) {
            nodeRowList.addAll(0, addRows);
            this.layout.updateAndShowNodeTable();
        }
    }

    public void refreshStorageTable() {
        List<TableRow> storageRowList = this.layout.getStorageRowList();
        List oldNodeList = this.layout.getStorageRowList().stream().map(row -> (DevNode)row.getUserObject()).collect(Collectors.toList());
        List addNodeList = FsExpansionSelectDeviceCard.getDevManagerList().stream().filter(dmDevNode -> !oldNodeList.contains(dmDevNode)).collect(Collectors.toList());
        if (addNodeList.isEmpty()) {
            return;
        }
        ArrayList nodeErrorIpList = new ArrayList();
        ArrayList normalDevLit = new ArrayList();
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        ProgressDialog progressDialog = new ProgressDialog((Window)mainDialog, ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.query.storage.info"), 400);
        AsyncExcutor.execute((ProgressDialog)progressDialog, (mainDialog != null ? 1 : 0) != 0, (long)0L, (Callable[])new Callable[]{() -> this.queryInfoByDStorage(addNodeList, nodeErrorIpList, normalDevLit)});
        List addRows = normalDevLit.stream().map(newNode -> this.createRow((DevNode)newNode)).collect(Collectors.toList());
        if (!addRows.isEmpty()) {
            storageRowList.addAll(0, addRows);
            this.layout.updateAndShowStorageTable();
        }
        if (!nodeErrorIpList.isEmpty()) {
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getStringWithParams((String)"inspsctor.wizard.fs.select.dev.query.node.error", (Object[])new Object[]{String.join((CharSequence)this.splitStr, nodeErrorIpList)}));
        }
    }

    private List<DevNode> queryNodeInfo(List<DevNode> addNodeList, List<String> nodeErrorIpList) {
        return addNodeList.stream().filter(devNode -> {
            List nodes = devNode.getClusterNodes();
            if (this.queryClusterNodes(nodeErrorIpList, (DevNode)devNode, nodes)) {
                return false;
            }
            InspectContext.getInstance().queryBmcInfo((DevNode)devNode);
            return true;
        }).collect(Collectors.toList());
    }

    private boolean queryClusterNodes(List<String> nodeErrorIpList, DevNode devNode, List<ClusterNode> nodes) {
        DSstorageInfoQryServiceImpl restQueryService;
        TaskResult taskResult;
        if ((nodes == null || nodes.isEmpty()) && (taskResult = (restQueryService = new DSstorageInfoQryServiceImpl()).queryNodeInfo(devNode, DeviceOpr.ADD, null)).getResult() != TaskResult.Result.SUCCESS) {
            try {
                DefaultNodeProviderImpl.getInstance().removeNode(devNode);
            }
            catch (ToolException e) {
                LOGGER.error("Remove dev error.", (Throwable)e);
            }
            nodeErrorIpList.add(devNode.getIp());
            return true;
        }
        return false;
    }

    private Boolean queryInfoByDStorage(List<DevNode> addNodeList, List<String> nodeErrorIpList, List<DevNode> normalDevLit) {
        normalDevLit.addAll(this.queryNodeInfo(addNodeList, nodeErrorIpList));
        return this.queryStorageInfo(normalDevLit, "execute_storage");
    }

    private Boolean queryStorageInfo(List<DevNode> addNodeList, String invokeFunctionName) {
        File expansionDir = new File(ExpansionTaskUtils.PY_SCRIPTS_DIR);
        String pyFramePth = FilesUtil.getCanonicalPath((File)expansionDir.getParentFile().getParentFile()) + File.separator + "pyframe";
        ArrayList<File> pyClassPths = new ArrayList<File>();
        pyClassPths.add(new File(pyFramePth));
        pyClassPths.add(expansionDir);
        JythonExecuter jythonExecuter = new JythonExecuter(pyClassPths);
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("lang", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
        env.put("devInfoList", addNodeList);
        env.put("logger", LOGGER);
        jythonExecuter.set("py_java_env", env);
        String fileName = "query_dstorage_info.py";
        File pythonScFile = new File(ExpansionTaskUtils.PY_SCRIPTS_DIR, fileName);
        if (pythonScFile.exists()) {
            try {
                jythonExecuter.compileScript(pythonScFile);
                List retList = jythonExecuter.invokeFunction(invokeFunctionName, new Object[0]);
            }
            catch (Throwable e) {
                LOGGER.error("", e);
            }
        }
        return true;
    }

    private void initTableData() {
        this.refreshStorageTable();
        this.layout.showStorageTable();
    }

    private TableRow<DevNode, DevNode> createRow(DevNode node) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getNodeTableHeader().length, (Object)node, (Object)node);
        this.updateRow((TableRow<DevNode, DevNode>)row, node);
        return row;
    }

    private TableRow<DevNode, DevNode> createNodeRow(DevNode node) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getNodeTableHeader().length, (Object)node, (Object)node);
        this.updateNodeRow((TableRow<DevNode, DevNode>)row, node);
        return row;
    }

    private void updateNodeRow(TableRow<DevNode, DevNode> row, DevNode node) {
        int i = 0;
        row.setValueAt(i++, (Object)node.getIp());
        row.setValueAt(i++, (Object)node.getDeviceName());
        row.setValueAt(i++, (Object)node.getProductModel());
        row.setValueAt(i++, (Object)node.getDeviceType().toString());
        row.setValueAt(i++, (Object)node.getDeviceSerialNumber());
        row.setValueAt(i++, (Object)new IsmTableCell.HyperlinkCell(this.delNodeConfig, (ActionListener)new DelFsExpansionNodeAction(node, this.layout, row, this)));
    }

    private void updateRow(TableRow<DevNode, DevNode> row, DevNode node) {
        int i = 0;
        row.setValueAt(i++, (Object)node.getIp());
        row.setValueAt(i++, (Object)node.getDeviceName());
        row.setValueAt(i++, (Object)node.getProductModel());
        row.setValueAt(i++, (Object)node.getProductVersion());
        row.setValueAt(i++, (Object)node.getDeviceSerialNumber());
        row.setValueAt(i++, (Object)new IsmTableCell.HyperlinkCell(this.addExpansionConfig, (ActionListener)new FsExpansionConfigAction(node, InspectContext.getInstance().getNewExpansionNode(), row, this)));
    }

    private static List<DevNode> getDevNodeList() {
        List devs = DefaultNodeProviderImpl.getInstance().getNodeList();
        return devs.stream().filter(node -> node.getItDeviceType().equals((Object)ItDeviceType.FUIONSTOR_EXP_NEW_NODE)).collect(Collectors.toList());
    }

    public void updateRowByUpdateExpansionConfig(TableRow<DevNode, DevNode> row, DevNode node) {
        row.setValueAt(5, (Object)new IsmTableCell.HyperlinkCell(this.updateExpansionConfig, (ActionListener)new FsExpansionConfigAction(node, InspectContext.getInstance().getNewExpansionNode(), row, this)));
    }

    public static List<DevNode> getDevManagerList() {
        List devs = DefaultNodeProviderImpl.getInstance().getNodeList();
        return devs.stream().filter(DevNode::isDsStorage).filter(node -> InspectContext.getInstance().isSupportDev((DevNode)node)).collect(Collectors.toList());
    }

    private void initAddDevAndNodeLListener() {
        this.layout.getAddNewExpansionNodeLink().addClickListener((ToolHyperLinkLabel.ClickListener)new AddNewExpansionNodeListener(this));
        this.layout.getAddDeviceLink().addClickListener((ToolHyperLinkLabel.ClickListener)new AddDstorageListener(this));
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion");
    }

    protected ToolWizardDialog.Card getNextCard() {
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        if (this.checkNodeExpansionConfig(mainDialog)) {
            return this;
        }
        List<DevNode> selectDevs = this.layout.getSelectedDevs();
        WORKTAKER.put("select_dev_nodes", selectDevs);
        LOGGER.info("load products.....");
        ProgressStepDialog progressDialog = new ProgressStepDialog(mainDialog, SelectDeviceCard.getRealDealCount(selectDevs));
        Future futu = AsyncExcutor.submit((Callable)new QueryDevStatusCallable(WORKTAKER, progressDialog, selectDevs));
        if (progressDialog.isDisplayable()) {
            progressDialog.setVisible(true);
        }
        Object result = null;
        try {
            result = futu.get();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.loadconfigerror"));
            return this;
        }
        if (!this.checkResult(mainDialog, result)) {
            return this;
        }
        return InspectUIUtil.getNextCard(CardModelEnum.FS_SELECTDEVICE, this);
    }

    private boolean checkNodeExpansionConfig(JDialog mainDialog) {
        String msg;
        WarningDialog warn;
        ArrayList ipList = new ArrayList();
        this.layout.getDeviceTable().getMarkedRows().stream().forEach(row -> {
            if (row.getUserObject() instanceof DevNode && !this.hasExpansionConfig((DevNode)row.getUserObject())) {
                ipList.add(((DevNode)row.getUserObject()).getIp());
            }
        });
        return !ipList.isEmpty() && 0 != (warn = DialogUtils.showYesNoDialog((Window)mainDialog, (String)(msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.fs.expansion.node.no.config", (Object[])new Object[]{String.join((CharSequence)this.splitStr, ipList)})))).getValue();
    }

    private boolean checkResult(JDialog mainDialog, Object result) {
        if (result == null) {
            return true;
        }
        if (result instanceof Exception) {
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.loadconfigerror"));
            return false;
        }
        return true;
    }

    public int getStep() {
        return this.getStep(CardModelEnum.FS_SELECTDEVICE);
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.Next == navigation) {
            if (this.layout == null) {
                return false;
            }
            return this.layout.getDeviceTable().getMarkedRows().stream().anyMatch(row -> row.getUserObject() instanceof DevNode && this.hasExpansionConfig((DevNode)row.getUserObject()));
        }
        return true;
    }

    public boolean hasExpansionConfig(DevNode devNode) {
        if (!devNode.isDsStorage()) {
            return false;
        }
        return devNode.getStoragePools().stream().anyMatch(storagePool -> this.hasExpansionConfigByPool((FusionStorStoragePool)storagePool) || storagePool.getDiskPools().stream().anyMatch(diskPool -> this.hasExpansionConfigByPool((FusionStorStoragePool)diskPool)));
    }

    private boolean hasExpansionConfigByPool(FusionStorStoragePool storagePool) {
        return !storagePool.getExpansionNodeList().isEmpty() || !storagePool.getExpansionClusterNode().isEmpty() || this.hasExpansionConfig(storagePool.getJoinedClusterNode());
    }

    private boolean hasExpansionConfig(List<ClusterNode> joinedClusterNode) {
        return joinedClusterNode.stream().anyMatch(node -> {
            FsNodeExpansionConfig config = InspectContext.getInstance().getFsExpansionConfig((ClusterNode)node);
            return this.hasExpansionDisk(config.getExpansionCacheDisk()) || this.hasExpansionDisk(config.getExpansionMainStorageDisk());
        });
    }

    private boolean hasExpansionDisk(Map<FusionStorDiskInfo, Integer> expansionDisk) {
        return expansionDisk.values().stream().anyMatch(number -> number != null && number > 0);
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    public void fireNodeAdd(DevNode dev) throws ToolException {
    }

    public void fireNodeDelete(DevNode dev) throws ToolException {
    }

    public void fireNodeModify(DevNode dev) throws ToolException {
    }
}

