/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.inspect.ui.dialogs.SupportTableLabel;
import com.huawei.ism.tool.inspect.ui.wizard.FirstCardLayout;
import com.huawei.ism.tool.inspect.utils.UI;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmAbstractTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsExpansionSelectDeviceCardLayout
extends FirstCardLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(FsExpansionSelectDeviceCardLayout.class);
    private static final Dimension PRODUCTTYPE_ZH = new Dimension(150, 26);
    private static final Dimension PRODUCTTYPE_EN = new Dimension(170, 26);
    private String[] storageTableHeader = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devipaddress"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devname"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devmodel"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devversion"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.sn"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.step")};
    private String[] nodeTableHeader = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devipaddress"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devname"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.node.server.type"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.node.os.type"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.sn"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.step")};
    private TableScrollPane tableScrollPane = null;
    private ToolHyperLinkLabel addDeviceLink = null;
    private ToolHyperLinkLabel addNewExpansionNodeLink = null;
    private ToolHyperLinkLabel deviceListLink = null;
    private SupportTableLabel showStorageLabel;
    private SupportTableLabel showNewExpansionNodeLabel;
    private boolean selectNode = false;
    private boolean selectStorge = true;
    private List<TableRow> storageRowList = new ArrayList<TableRow>();
    private List<TableRow> nodeRowList = new ArrayList<TableRow>();
    private DefaultTableModel storageTableModel = new DefaultTableModel(this.storageTableHeader, new int[0]);
    private DefaultTableModel nodeTableModel = new DefaultTableModel(this.nodeTableHeader, new int[0]);
    private IsmTable deviceTable = null;

    public FsExpansionSelectDeviceCardLayout() {
        JComponent topLabel = this.builedTestAndDevAdd();
        JComponent devSupportLabel = this.builddevSupportLabel();
        JComponent devHorizotalComp = this.builedDevAndNewNodeLabel();
        this.builedDevTable();
        this.initShowStorageLabelListener();
        this.initShowNewExpansionNodeLabelListener();
        JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{topLabel, devSupportLabel, devHorizotalComp, this.tableScrollPane});
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)0), "Center");
    }

    private void builedDevTable() {
        this.deviceTable = new IsmTable((TableModel)this.storageTableModel);
        this.deviceTable.setName("insepct_deviceTable");
        this.tableScrollPane = new TableScrollPane(false, false, true, this.deviceTable);
        Dimension dimension = new Dimension(800, 440);
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            dimension = new Dimension(800, 410);
        }
        this.tableScrollPane.setPreferredSize(dimension);
    }

    private JComponent builedTestAndDevAdd() {
        JLabel addDeviceDesc1 = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.add.device.1"));
        this.addDeviceLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.add.device.addDev"));
        JLabel addDeviceDesc2 = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.add.device.2"));
        this.addNewExpansionNodeLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.add.new.expansion.node.link"));
        JLabel addDeviceDesc3 = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.add.device.3"));
        JComponent addDevDes = UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{addDeviceDesc1, this.addDeviceLink, addDeviceDesc2, this.addNewExpansionNodeLink, addDeviceDesc3});
        JLabel addDeviceDesc4 = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.add.device.4"));
        JComponent topLabel = UCD.buildVerticalBox(null, (Component[])new Component[]{addDevDes, UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{addDeviceDesc4})});
        this.addDeviceLink.setName("inspect_select_addDevice");
        return topLabel;
    }

    private JComponent builddevSupportLabel() {
        this.deviceListLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.devicelist"));
        JLabel showDevlistDesc = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.devicelistdesc"));
        JComponent devSupportLabel = null;
        devSupportLabel = ApplicationContext.getInstance().isEnglishEnv() ? UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{showDevlistDesc, this.deviceListLink, UI.buildLabel("inspsctor.wizard.selectdevice.devicelistlast"), Box.createHorizontalGlue()}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{UI.buildLabel("inspsctor.wizard.selectdevice.package"), UI.buildLabel("inspsctor.wizard.selectdevice.sugend")})}) : UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{showDevlistDesc, this.deviceListLink, UI.buildLabel("inspsctor.wizard.selectdevice.devicelistlast"), UI.buildLabel("inspsctor.wizard.selectdevice.sugend"), Box.createHorizontalGlue()});
        this.deviceListLink.setName("inspect_selectLink");
        return UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{devSupportLabel});
    }

    private JComponent builedDevAndNewNodeLabel() {
        Dimension dimension = null;
        dimension = LanguageManager.isEnglish() ? PRODUCTTYPE_EN : PRODUCTTYPE_ZH;
        ArrayList<SupportTableLabel> devCompBox = new ArrayList<SupportTableLabel>(2);
        Font font = new Font(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.support.font"), 0, 14);
        this.showStorageLabel = new SupportTableLabel(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.select.device.card.storage"), 0, new Dimension(dimension), font);
        devCompBox.add(this.showStorageLabel);
        this.showNewExpansionNodeLabel = new SupportTableLabel(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.select.device.card.new.node"), 0, new Dimension(dimension), font);
        devCompBox.add(this.showNewExpansionNodeLabel);
        JComponent devHorizotalComp = UCD.buildHorizotalBox(null, (int)0, (Component[])devCompBox.toArray(new Component[devCompBox.size()]));
        this.showStorageLabel.setSelectedStatus();
        return UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{devHorizotalComp});
    }

    @Override
    public JComponent getDescPanel() {
        return null;
    }

    @Override
    public String getTittle() {
        return null;
    }

    private void initShowNewExpansionNodeLabelListener() {
        this.showNewExpansionNodeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent paramMe) {
                FsExpansionSelectDeviceCardLayout.this.showNewExpansionNodeLabel.setSelectedStatus();
                FsExpansionSelectDeviceCardLayout.this.showNodeTable();
            }

            @Override
            public void mouseEntered(MouseEvent paramMe) {
                if (!FsExpansionSelectDeviceCardLayout.this.selectNode) {
                    FsExpansionSelectDeviceCardLayout.this.showNewExpansionNodeLabel.setMouseOnStatus();
                }
            }

            @Override
            public void mouseExited(MouseEvent paramMe) {
                if (!FsExpansionSelectDeviceCardLayout.this.selectNode) {
                    FsExpansionSelectDeviceCardLayout.this.showNewExpansionNodeLabel.setRecoverStatus();
                }
            }
        });
    }

    private void initShowStorageLabelListener() {
        this.showStorageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent paramMe) {
                FsExpansionSelectDeviceCardLayout.this.showStorageLabel.setSelectedStatus();
                FsExpansionSelectDeviceCardLayout.this.showStorageTable();
            }

            @Override
            public void mouseEntered(MouseEvent paramMe) {
                if (!FsExpansionSelectDeviceCardLayout.this.selectStorge) {
                    FsExpansionSelectDeviceCardLayout.this.showStorageLabel.setMouseOnStatus();
                }
            }

            @Override
            public void mouseExited(MouseEvent paramMe) {
                if (!FsExpansionSelectDeviceCardLayout.this.selectStorge) {
                    FsExpansionSelectDeviceCardLayout.this.showStorageLabel.setRecoverStatus();
                }
            }
        });
    }

    public void showStorageTable() {
        if (!this.selectStorge) {
            this.updateAndShowStorageTable();
        }
    }

    public void updateAndShowStorageTable() {
        this.selectStorge = true;
        this.showStorageLabel.setSelectedStatus();
        this.selectNode = false;
        this.showNewExpansionNodeLabel.setRecoverStatus();
        this.storageTableModel.removeAll();
        for (TableRow row : this.storageRowList) {
            this.storageTableModel.addRow(new TableRow[]{row});
        }
        this.deviceTable.setModel((IsmAbstractTableModel)this.storageTableModel);
    }

    public void showNodeTable() {
        if (!this.selectNode) {
            this.updateAndShowNodeTable();
        }
    }

    public void updateAndShowNodeTable() {
        this.selectStorge = false;
        this.showStorageLabel.setRecoverStatus();
        this.selectNode = true;
        this.showNewExpansionNodeLabel.setSelectedStatus();
        this.storageTableModel.removeAll();
        for (TableRow row : this.nodeRowList) {
            this.storageTableModel.addRow(new TableRow[]{row});
        }
        this.nodeTableModel.removeAll();
        for (TableRow row : this.nodeRowList) {
            this.nodeTableModel.addRow(new TableRow[]{row});
        }
        this.deviceTable.setModel((IsmAbstractTableModel)this.nodeTableModel);
    }

    public List<DevNode> getSelectedDevs() {
        return this.deviceTable.getMarkedRows().stream().map(row -> (DevNode)row.getUserObject()).filter(devNode -> devNode.isDsStorage()).collect(Collectors.toList());
    }

    public ToolHyperLinkLabel getAddDeviceLink() {
        return this.addDeviceLink;
    }

    public ToolHyperLinkLabel getAddNewExpansionNodeLink() {
        return this.addNewExpansionNodeLink;
    }

    public List<TableRow> getStorageRowList() {
        return this.storageRowList;
    }

    public List<TableRow> getNodeRowList() {
        return this.nodeRowList;
    }

    public String[] getNodeTableHeader() {
        return this.nodeTableHeader;
    }

    public ToolHyperLinkLabel getDeviceListLink() {
        return this.deviceListLink;
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }
}

