/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.HyperHostManualCheckItem;
import com.huawei.ism.tool.inspect.ui.dialogs.HyperManualCheckBatchDialog;
import com.huawei.ism.tool.inspect.ui.wizard.HyperManualCheckCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperManualCheckCard
extends InspectCard {
    private static final long serialVersionUID = 199630063526238188L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HyperManualCheckCard.class);
    private HyperManualCheckCardLayout hyperManualCheckCardLayout;
    private List<String> needsDebugDevs = new ArrayList<String>();
    private List<CheckDevNode> checkDevNodes;
    private static final String NOT_COMPLETED_FLAG = "0";
    private static String splitStr = "\uff0c";

    public HyperManualCheckCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        this.hyperManualCheckCardLayout = new HyperManualCheckCardLayout();
        this.addLayout(this.hyperManualCheckCardLayout);
        this.initListener();
        this.updateNavigationBar();
    }

    @Override
    public void initData() {
        this.hyperManualCheckCardLayout.initData();
        this.updateNavigationBar();
    }

    private void initListener() {
        this.hyperManualCheckCardLayout.getBulkSettingBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HyperManualCheckBatchDialog dialog = new HyperManualCheckBatchDialog(HyperManualCheckCard.this.hyperManualCheckCardLayout);
                dialog.setVisible(true);
            }
        });
        this.hyperManualCheckCardLayout.getHilpTips().addMouseListener(new HlepTipslinkMouseListener());
    }

    protected ToolWizardDialog.Card getNextCard() {
        if (this.hasNostSelectItemWarning()) {
            return this;
        }
        WORKTAKER.initDebugPwdDevs();
        InspectContext.getInstance().setFinishHyperManualCheck(true);
        return InspectUIUtil.getNextCard(CardModelEnum.HYPER_MANULY_CHECK, this);
    }

    public boolean checkResult(JDialog mainDialog, Object result) {
        if (null == result) {
            return true;
        }
        if (result instanceof ToolException) {
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)((ToolException)((Object)result)).getErrorLocaleDescription());
            return false;
        }
        if (result instanceof Exception) {
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.loadconfigerror"));
            return false;
        }
        if (result instanceof Map) {
            IDeviceManageUI connUi = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
            return connUi.showMultiInfoDialog((Map)result, (Window)mainDialog, true);
        }
        return true;
    }

    private boolean hasNostSelectItemWarning() {
        boolean hasNostSelectItem;
        String notCompletedHost = this.checkAllHost();
        String notCompletedServer = this.checkAllServer();
        boolean bl = hasNostSelectItem = !StringUtils.isNULLStr((String)notCompletedHost) || !StringUtils.isNULLStr((String)notCompletedServer);
        if (hasNostSelectItem) {
            String prompt = null;
            prompt = !StringUtils.isNULLStr((String)notCompletedHost) && !StringUtils.isNULLStr((String)notCompletedServer) ? notCompletedHost + System.lineSeparator() + notCompletedServer : notCompletedHost + notCompletedServer;
            prompt = prompt + System.lineSeparator() + ResourceUtil.getString((String)"inspsctor.wizard.selectitem.ignore");
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            WarningDialog warn = DialogUtils.showYesNoDialog((Window)mainDialog, (String)prompt);
            return 0 != warn.getValue();
        }
        return hasNostSelectItem;
    }

    private String checkAllHost() {
        ConcurrentHashMap<String, Object> tmpObj = InspectContext.getInstance().getObjectForPy();
        Map serverAndHost = (Map)tmpObj.get("HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO");
        HashSet<String> notCompletedHostType = new HashSet<String>();
        if (serverAndHost.containsKey("NOT_ADD_HOST_LIST")) {
            List hostList = (List)serverAndHost.get("NOT_ADD_HOST_LIST");
            for (Map hostInfo : hostList) {
                String[] itemKeys;
                for (String itemKey : itemKeys = HyperHostManualCheckItem.getEditItemKeys()) {
                    Object type;
                    if (hostInfo.containsKey(itemKey) && !NOT_COMPLETED_FLAG.equals(hostInfo.get(itemKey).toString()) || null == (type = hostInfo.get("hostType"))) continue;
                    notCompletedHostType.add(type.toString());
                }
            }
        }
        if (notCompletedHostType.isEmpty()) {
            return "";
        }
        return ResourceUtil.getStringWithParams((String)"inspsctor.wizard.selectitem.nocheckhyperhost", (Object[])new Object[]{String.join((CharSequence)splitStr, notCompletedHostType)});
    }

    private String checkAllServer() {
        ConcurrentHashMap<String, Object> tmpObj = InspectContext.getInstance().getObjectForPy();
        Map serverAndHost = (Map)tmpObj.get("HYPER_QUO_SERVER_AND_NOT_ADD_HOST_INFO");
        StringBuffer notCompletedServer = new StringBuffer();
        if (serverAndHost.containsKey("QUO_SERVER_LIST")) {
            List serverList = (List)serverAndHost.get("QUO_SERVER_LIST");
            for (Map serverInfo : serverList) {
                if (serverInfo.containsKey("isThirdPartStation") && serverInfo.containsKey("isUseStorage") && !serverInfo.get("isThirdPartStation").toString().equals(NOT_COMPLETED_FLAG) && !serverInfo.get("isUseStorage").toString().equals(NOT_COMPLETED_FLAG)) continue;
                if (notCompletedServer.length() > 0) {
                    notCompletedServer.append(",");
                }
                notCompletedServer.append(serverInfo.get("ip"));
            }
        }
        if (notCompletedServer.length() == 0) {
            return "";
        }
        return ResourceUtil.getStringWithParams((String)"inspsctor.wizard.selectitem.nocheckhyperserver", (Object[])new Object[]{HyperManualCheckCard.enComma2zhComma(notCompletedServer.toString())});
    }

    public static String enComma2zhComma(String str) {
        String enComma = ",";
        String zhComma = "\uff0c";
        if (StringUtils.isNULLStr((String)str)) {
            return "";
        }
        if (!ApplicationContext.getInstance().isEnglishEnv() && str.contains(enComma)) {
            return str.replaceAll(enComma, zhComma);
        }
        return str;
    }

    public int getStep() {
        return this.getStep(CardModelEnum.HYPER_MANULY_CHECK);
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step4");
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    public List<String> getNeedsDebugDevs() {
        return this.needsDebugDevs;
    }

    static {
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            splitStr = ",";
        }
    }

    private class HlepTipslinkMouseListener
    extends MouseAdapter {
        private HlepTipslinkMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent paramMe) {
            FileUtils.openHelpFile((String)"Inspect\\HyperManualCheck", (Window)InspectContext.getInstance().getMainDialog(), (String)".chm");
        }
    }
}

