/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.inspect.entity.HyperHostManualCheckItem;
import com.huawei.ism.tool.inspect.entity.HyperQuoServerManualCheckItem;
import com.huawei.ism.tool.inspect.ui.logic.HyperHostListener;
import com.huawei.ism.tool.inspect.ui.logic.HyperQuoServerListener;
import com.huawei.ism.tool.inspect.ui.wizard.FirstCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.HyperManualCheckCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckBoxTree;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmAbstractTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperManualCheckCardLayout
extends FirstCardLayout {
    private static final long serialVersionUID = -4577354391589834887L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HyperManualCheckCardLayout.class);
    private static final int HEIGHE = 460;
    private static final int DEVICE_WIDTH = 150;
    private static final int HEIGHE_EN = 440;
    private static final int DEVICE_WIDTH_EN = 150;
    private JLabel help;
    private JLabel hilpTips;
    private static final Color COLOR_AFTER_CLICK = new Color(7581426);
    private static final Color COLOR_BEFORE_CLICK = new Color(4359891);
    private static final Color COLOR_MOUSE_OVER = new Color(16542473);
    private CheckTreeNode deviceRootNode;
    private JTree deviceTree;
    private JScrollPane deviceScroll;
    private HyperManualCheckCard selectItemCard;
    private JButton bulkSettingBtn;
    private TableScrollPane rightItemScroll;
    private IsmTable rightTable;
    private DefaultTableModel rightTableModel;
    private DefaultTableModel rightTableModelNew;
    private JComponent buttomBox;
    private String selectTreeNode;
    private List<HyperQuoServerManualCheckItem> serverItemList = new ArrayList<HyperQuoServerManualCheckItem>();
    private List<HyperHostManualCheckItem> hostItemList = new ArrayList<HyperHostManualCheckItem>();

    public HyperManualCheckCardLayout() {
        this.initHostAndServer();
        this.initRightItemScroll();
        JComponent view = this.initUI();
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)0), "Center");
    }

    public void initData() {
        this.initTree();
        this.deviceScroll.setViewportView(this.deviceTree);
        this.deviceScroll.setBorder(BorderFactory.createEtchedBorder());
        this.deviceTree.setSelectionPath(this.deviceTree.getPathForRow(1));
    }

    private void initHostAndServer() {
        this.serverItemList.addAll(InspectContext.getServerItemListByContext());
        this.hostItemList.addAll(InspectContext.getHostItemListByContext());
    }

    private void bindListener() {
        this.deviceTree.addTreeSelectionListener(new TreeSelecListener(this));
    }

    public String getSelectTreeNode() {
        return this.selectTreeNode;
    }

    private void changeSelectDevice(TreeSelectionEvent event) {
        this.bulkSettingBtn.setEnabled(false);
        TreePath treePath = event.getPath();
        CheckTreeNode treeNode = (CheckTreeNode)treePath.getLastPathComponent();
        String pathStr = treePath.toString();
        String[] tmpPathList = pathStr.split(",");
        this.selectTreeNode = treeNode.toString();
        LOGGER.info("Select node.TreePath is {}, node is {}", (Object)pathStr, (Object)treeNode.toString());
        if (pathStr.contains(HyperHostManualCheckItem.HOST)) {
            if (!this.selectTreeNode.equals(HyperHostManualCheckItem.HOST)) {
                this.bulkSettingBtn.setEnabled(true);
            }
            this.initHostLayoutUI(this.selectTreeNode);
        }
        if (pathStr.contains(HyperQuoServerManualCheckItem.QUE_SERVER)) {
            this.initQuoServerLayoutUI(this.selectTreeNode);
        }
    }

    private void initHostLayoutUI(String hostType) {
        this.rightTableModel.removeAll();
        this.rightTableModel.setAllColumnNames(HyperHostManualCheckItem.getTittle());
        for (HyperHostManualCheckItem hostItem : this.hostItemList) {
            if (!hostItem.getHostType().equals(hostType)) continue;
            this.rightTableModel.addRow(new TableRow[]{HyperManualCheckCardLayout.createHostTableRow(hostItem)});
        }
        this.rightTableModelNew = new DefaultTableModel(HyperHostManualCheckItem.getTittle(), HyperHostManualCheckItem.getVisibleColumnIds());
        for (HyperHostManualCheckItem hostItem : this.hostItemList) {
            if (!hostItem.getHostType().equals(hostType)) continue;
            this.rightTableModelNew.addRow(new TableRow[]{HyperManualCheckCardLayout.createHostTableRow(hostItem)});
        }
        this.rightTable.setModel((IsmAbstractTableModel)this.rightTableModelNew);
    }

    private void initQuoServerLayoutUI(String ip) {
        this.rightTableModel.removeAll();
        this.rightTableModel.setAllColumnNames(HyperQuoServerManualCheckItem.TITLE_BY_QUE_SERVER);
        for (HyperQuoServerManualCheckItem serverItem : this.serverItemList) {
            if (!serverItem.getQuoServerIp().equals(ip)) continue;
            this.rightTableModel.addRow(new TableRow[]{HyperManualCheckCardLayout.createQuoServerTableRow(serverItem)});
        }
        this.rightTableModelNew = new DefaultTableModel(HyperQuoServerManualCheckItem.TITLE_BY_QUE_SERVER, new int[0]);
        for (HyperQuoServerManualCheckItem serverItem : this.serverItemList) {
            if (!serverItem.getQuoServerIp().equals(ip)) continue;
            this.rightTableModelNew.addRow(new TableRow[]{HyperManualCheckCardLayout.createQuoServerTableRow(serverItem)});
        }
        this.rightTable.setModel((IsmAbstractTableModel)this.rightTableModelNew);
    }

    private static TableRow<String, String> createQuoServerTableRow(HyperQuoServerManualCheckItem serverItem) {
        DefaultTableRow row = new DefaultTableRow(HyperHostManualCheckItem.getTittleLength(), (Object)serverItem.getQuoServerIp());
        int idx = 0;
        row.setValueAt(idx++, (Object)serverItem.getQuoServerName());
        row.setValueAt(idx++, (Object)serverItem.getQuoServerIp());
        row.setValueAt(idx++, (Object)serverItem.getQuoServerSN());
        Integer isThirdPartStation = serverItem.getIsThirdPartStation();
        Integer isUseStorageResource = serverItem.getIsUseStorageResource();
        row.setValueAt(idx++, (Object)new IsmTableCell.ComboBoxCell((Object[])HyperQuoServerManualCheckItem.CHECK_RESULT, (Object)HyperQuoServerManualCheckItem.CHECK_RESULT[isThirdPartStation], (ItemListener)new HyperQuoServerListener(serverItem, "isThirdPartStation")));
        row.setValueAt(idx++, (Object)new IsmTableCell.ComboBoxCell((Object[])HyperQuoServerManualCheckItem.CHECK_RESULT, (Object)HyperQuoServerManualCheckItem.CHECK_RESULT[isUseStorageResource], (ItemListener)new HyperQuoServerListener(serverItem, "isUseStorage")));
        return row;
    }

    private static TableRow<String, String> createHostTableRow(HyperHostManualCheckItem hostItem) {
        DefaultTableRow row = new DefaultTableRow(HyperHostManualCheckItem.getTittleLength(), (Object)hostItem.getHostInitiator());
        int idx = 0;
        row.setValueAt(idx++, (Object)hostItem.getHostName());
        row.setValueAt(idx++, (Object)hostItem.getHostInitiator());
        row.setValueAt(idx++, (Object)hostItem.getArraySn());
        for (int i = 0; i < HyperHostManualCheckItem.getEditItemsName().length; ++i) {
            row.setValueAt(idx++, (Object)new IsmTableCell.ComboBoxCell((Object[])HyperHostManualCheckItem.CHECK_RESULT, (Object)HyperHostManualCheckItem.CHECK_RESULT[hostItem.getEditItemValue(i)], (ItemListener)new HyperHostListener(hostItem, HyperHostManualCheckItem.getEditItemKeys()[i])));
        }
        return row;
    }

    private JComponent initUI() {
        this.deviceScroll = new JScrollPane();
        JLabel suggestionHead = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.hypermanualcheck.suggestion"));
        this.hilpTips = new JLabel(ResourceUtil.getImage((String)"hyper_manual_hlep.png"));
        JLabel suggestionEnd = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.dot"));
        Locale language = ApplicationContext.getInstance().getCurrentLanguage();
        this.help = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.hypermanualcheck.help"));
        this.help.setForeground(COLOR_BEFORE_CLICK);
        this.help.addMouseListener(new LinkMouseListener());
        if (!Locale.SIMPLIFIED_CHINESE.equals(language)) {
            UiMethod.setComponentSize((Dimension)new Dimension(150, 440), (Component[])new Component[]{this.deviceScroll});
        } else {
            UiMethod.setComponentSize((Dimension)new Dimension(150, 460), (Component[])new Component[]{this.deviceScroll});
        }
        UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildFrameSpace((JComponent)this.deviceScroll, (int)4)});
        this.bulkSettingBtn = new JButton(ResourceUtil.getString((String)"inspsctor.wizard.hypermanualcheck.batchbutton"));
        UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildFrameSpace((JComponent)this.rightItemScroll, (int)4)});
        this.buttomBox = UCD.buildHorizotalBox(null, (int)8, (Component[])new Component[]{this.deviceScroll, this.rightItemScroll});
        JComponent view = null;
        if (!Locale.SIMPLIFIED_CHINESE.equals(language)) {
            JLabel suggestionMid = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.hypermanualcheck.suggestion.mid"));
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((int)0, (Component[])new Component[]{suggestionHead})}), UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((int)0, (Component[])new Component[]{suggestionMid, this.help, this.hilpTips, suggestionEnd})}), UCD.buildHBoxRight((Component[])new Component[]{this.bulkSettingBtn}), this.buttomBox});
        } else {
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((int)0, (Component[])new Component[]{suggestionHead, this.help, this.hilpTips, suggestionEnd})}), UCD.buildHBoxRight((Component[])new Component[]{this.bulkSettingBtn}), this.buttomBox});
        }
        return view;
    }

    private void initRightItemScroll() {
        this.rightTableModel = !this.hostItemList.isEmpty() ? new DefaultTableModel(HyperHostManualCheckItem.getTittle(), HyperHostManualCheckItem.getVisibleColumnIds()) : new DefaultTableModel(HyperQuoServerManualCheckItem.TITLE_BY_QUE_SERVER, new int[0]);
        this.rightTable = new IsmTable((TableModel)this.rightTableModel);
        this.rightItemScroll = new TableScrollPane(false, false, false, this.rightTable);
    }

    private void initTree() {
        CheckTreeNode checkTreeNodeRoot;
        this.deviceRootNode = new CheckTreeNode();
        if (!this.hostItemList.isEmpty()) {
            ArrayList<String> hostTypesList = new ArrayList<String>();
            for (HyperHostManualCheckItem hostItem : this.hostItemList) {
                String hostType = hostItem.getHostType();
                if (hostTypesList.contains(hostType)) continue;
                hostTypesList.add(hostType);
            }
            checkTreeNodeRoot = new CheckTreeNode((Object)HyperHostManualCheckItem.HOST, true, true);
            this.deviceRootNode.add((MutableTreeNode)checkTreeNodeRoot);
            this.initDeviceTree(checkTreeNodeRoot, hostTypesList);
        }
        if (!this.serverItemList.isEmpty()) {
            ArrayList<String> serverTypesList = new ArrayList<String>();
            for (HyperQuoServerManualCheckItem serverItem : this.serverItemList) {
                String quoServerIp = serverItem.getQuoServerIp();
                if (serverTypesList.contains(quoServerIp)) continue;
                serverTypesList.add(quoServerIp);
            }
            checkTreeNodeRoot = new CheckTreeNode((Object)HyperQuoServerManualCheckItem.QUE_SERVER, true, true);
            this.deviceRootNode.add((MutableTreeNode)checkTreeNodeRoot);
            this.initDeviceTree(checkTreeNodeRoot, serverTypesList);
        }
        this.deviceTree = new CheckBoxTree(this.deviceRootNode, false);
        this.bindListener();
        this.deviceTree.setShowsRootHandles(true);
    }

    private void initDeviceTree(CheckTreeNode deviceRootCheckNode, List<String> hostTypeList) {
        List<String> keys = hostTypeList;
        for (String key : keys) {
            CheckTreeNode checkTreeNode = new CheckTreeNode((Object)key, true, true);
            checkTreeNode.setSelected(true);
            deviceRootCheckNode.add((MutableTreeNode)checkTreeNode);
        }
    }

    @Override
    public JComponent getDescPanel() {
        return this;
    }

    @Override
    public String getTittle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step3.hyper.manual.check");
    }

    public List<HyperQuoServerManualCheckItem> getServerItemList() {
        return this.serverItemList;
    }

    public void setServerItemList(List<HyperQuoServerManualCheckItem> serverItemList) {
        this.serverItemList = serverItemList;
    }

    public List<HyperHostManualCheckItem> getHostItemList() {
        return this.hostItemList;
    }

    public void setHostItemList(List<HyperHostManualCheckItem> hostItemList) {
        this.hostItemList = hostItemList;
    }

    public IsmTable getRightTable() {
        return this.rightTable;
    }

    public JButton getBulkSettingBtn() {
        return this.bulkSettingBtn;
    }

    public JLabel getHilpTips() {
        return this.hilpTips;
    }

    static /* synthetic */ Color access$200() {
        return COLOR_BEFORE_CLICK;
    }

    private class LinkMouseListener
    extends MouseAdapter {
        private Color curColor = HyperManualCheckCardLayout.access$200();

        private LinkMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent paramMe) {
            LOGGER.info("Click HyperManualCheck help.");
            FileUtils.openHelpFile((String)String.join((CharSequence)File.separator, "Inspect", "HyperManualCheck"), (Window)InspectContext.getInstance().getMainDialog(), (String)".chm");
        }

        @Override
        public void mouseEntered(MouseEvent paramMe) {
            HyperManualCheckCardLayout.this.help.setCursor(new Cursor(12));
            HyperManualCheckCardLayout.this.help.setForeground(COLOR_MOUSE_OVER);
        }

        @Override
        public void mouseExited(MouseEvent paramMe) {
            HyperManualCheckCardLayout.this.help.setForeground(this.curColor);
        }
    }

    private static class TreeSelecListener
    implements TreeSelectionListener {
        private HyperManualCheckCardLayout layout;

        public TreeSelecListener(HyperManualCheckCardLayout layout) {
            this.layout = layout;
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            this.layout.changeSelectDevice(event);
        }
    }
}

