/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import java.awt.BorderLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import javax.swing.JComponent;

public abstract class InspectCard
extends ToolWizardDialog.Card {
    public static final InspectWorktaker WORKTAKER = InspectContext.getInstance().getInspectWorktaker();
    public static final int STEP_0 = 0;
    public static final int STEP_1 = 1;
    public static final int STEP_2 = 2;
    public static final int STEP_3 = 3;
    public static final int STEP_4 = 4;
    public static final int STEP_5 = 5;
    public static final int FILEPATH_LEN = 200;
    private static FileLock fileLock = null;
    private static final long serialVersionUID = -6185750471568376694L;

    public InspectCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
    }

    public InspectWorktaker getWorktaker() {
        return WORKTAKER;
    }

    public static FileLock getFileLock() {
        return fileLock;
    }

    public static void setFileLock(FileLock fileLock) {
        InspectCard.fileLock = fileLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doCancelTask() {
        if (InspectContext.getInstance().isBackProcessRunning()) {
            InspectContext.getInstance().setForeProcessRunning(false);
            FileOutputStream fos = ApplicationContext.getInstance().getToolLockStream();
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    fos = null;
                }
            }
            File file = new File("runningFlag");
            boolean fileDel = file.delete();
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("delete runningFlag === " + fileDel);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream("backFlag");
                FileLock lock = os.getChannel().tryLock();
                if (null == lock) return;
                InspectCard.setFileLock(lock);
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("create back lock success " + fileLock);
                return;
            }
            catch (IOException e1) {
                ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("create back lock failed");
                if (null == os) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e) {
                    ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Release FileOutPutStream of lock file failed.", (Throwable)e);
                }
                return;
            }
            finally {
                StreamUtils.closeStream((OutputStream)os, null);
            }
        }
        InspectContext.getInstance().fireToolStopped();
    }

    protected void addLayout(JComponent layout) {
        this.setLayout(new BorderLayout());
        this.add(layout, "Center");
    }

    protected int getStep(CardModelEnum step) {
        return InspectUIUtil.getCardIndex(step);
    }

    public void initData() {
    }
}

