/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.inspect.entity.BureauFile;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.ManualCheckItem;
import com.huawei.ism.tool.inspect.ui.dialogs.ManulyCheckSupportDevDialog;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.ui.logic.ManulyCheckListener;
import com.huawei.ism.tool.inspect.ui.logic.ManulyCheckUpdateNavigationListener;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.ManulyCheckCardLayout;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManulyCheckCard
extends InspectCard {
    private static final long serialVersionUID = 4999361954412348580L;
    private static final Logger LOG = LoggerFactory.getLogger(ManulyCheckCard.class);
    private ManulyCheckCardLayout layout = new ManulyCheckCardLayout();
    private HashMap<String, ManualCheckItem> map = new HashMap();
    private final IsmTableCell manualCheckCell = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"inspect.wizard.manualcheck.layout.link.manualCheck"), (ActionListener)new ManulyCheckListener(ManulyCheckListener.ActionType.MANUAL_CHECK, this));
    private final IsmTableCell getDocCell = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"inspect.wizard.manualcheck.layout.link.getdoc"), (ActionListener)new ManulyCheckListener(ManulyCheckListener.ActionType.EXPORT, this));
    private final IsmTableCell importCell = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"inspect.wizard.manualcheck.layout.link.import"), (ActionListener)new ManulyCheckListener(ManulyCheckListener.ActionType.IMPORT, this));
    private final IsmTableCell importAgainCell = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"inspect.wizard.manualcheck.layout.link.import.again"), (ActionListener)new ManulyCheckListener(ManulyCheckListener.ActionType.IMPORT, this));
    public static final int PASS_RATE_INDEX = 5;

    public HashMap<String, ManualCheckItem> getMap() {
        return this.map;
    }

    public void setMap(HashMap<String, ManualCheckItem> map) {
        this.map = map;
    }

    public ManulyCheckCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        super.addLayout(this.layout);
        InspectContext.getInstance().getBureauFiles().clear();
        this.initDevs();
        this.initListener();
    }

    private void initDevs() {
        List devs = (List)WORKTAKER.get("select_dev_nodes");
        if (null == devs) {
            return;
        }
        BureauDocuService.INS.filterDevs(devs);
        ArrayList<TableRow<DevNode, DevNode>> rows = new ArrayList<TableRow<DevNode, DevNode>>();
        for (DevNode node : devs) {
            rows.add(this.createTableRow(node));
            InspectContext.getInstance().addBureauFile(node, new BureauFile());
        }
        this.layout.getModel().addRows(rows);
    }

    private void initListener() {
        this.layout.getTable().getSelectionModel().addListSelectionListener(new ManulyCheckUpdateNavigationListener(this));
        this.layout.getSupportDevs().addClickListener((ToolHyperLinkLabel.ClickListener)new SupportDevsListener());
    }

    public DevNode getSelectedDev() {
        List<DevNode> list = this.getSelectedDevs();
        return list.isEmpty() ? null : list.get(0);
    }

    public List<DevNode> getSelectedDevs() {
        List rows = this.layout.getTable().getMarkedRows();
        ArrayList<DevNode> list = new ArrayList<DevNode>();
        for (TableRow row : rows) {
            list.add((DevNode)row.getUserObject());
        }
        return list;
    }

    private TableRow<DevNode, DevNode> createTableRow(DevNode node) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getTableHeaderLength(), (Object)node, (Object)node);
        int index = 0;
        row.setValueAt(index++, (Object)node.getDeviceType());
        row.setValueAt(index++, (Object)node.getDeviceName());
        row.setValueAt(index++, (Object)node.getDeviceSerialNumber());
        row.setValueAt(index++, (Object)new IpAddressStrategy(node.getIp()));
        if (null != node.getDevTypeLevel2() && node.getDevTypeLevel2().toString().equals("OceanStor SNS")) {
            row.setValueAt(index++, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"inspect.wizard.manualcheck.layout.link.manualCheck"), (ActionListener)new ManulyCheckListener(ManulyCheckListener.ActionType.MANUAL_CHECK, this)));
        } else {
            row.setValueAt(index++, (Object)this.manualCheckCell);
        }
        HashMap<String, String> passRateMap = BureauDocuService.INS.getPassRateMap();
        if (passRateMap.containsKey(node.getDeviceSerialNumber())) {
            row.setValueAt(5, (Object)new IsmTableCell.TextCell(passRateMap.get(node.getDeviceSerialNumber()), false, 0));
        }
        return row;
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step3");
    }

    public int getStep() {
        return this.getStep(CardModelEnum.MANULY);
    }

    protected ToolWizardDialog.Card getNextCard() {
        if (!this.verify()) {
            return this;
        }
        SwingUtilities.invokeLater(new NextCardRunnableHelper());
        return InspectUIUtil.getNextCard(CardModelEnum.MANULY, this);
    }

    private boolean verify() {
        if (null == this.layout || BureauDocuService.INS.getPassRateMap().size() == 0) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.manualcheck.layout.msg.uncheck"));
            return false;
        }
        List rows = this.layout.getTable().getAllRows();
        if (null == rows || rows.isEmpty()) {
            return true;
        }
        for (TableRow row : rows) {
            Object passRate = row.getValueAt(5);
            if (passRate != null) continue;
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.manualcheck.layout.msg.uncheck"));
            return false;
        }
        return true;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    public ManulyCheckCardLayout getCardLayout() {
        return this.layout;
    }

    public IsmTableCell getImportAgainCell() {
        return this.importAgainCell;
    }

    static class CalcScoreRunnableHelper
    implements Runnable {
        CalcScoreRunnableHelper() {
        }

        @Override
        public void run() {
            for (Map.Entry<DevNode, BureauFile> entry : InspectContext.getInstance().getBureauFiles().entrySet()) {
                BureauFile file = entry.getValue();
                LOG.info(String.format(Locale.ENGLISH, "bureau file, ip: %s, score: %d", entry.getKey().getIp(), file.getScore()));
                if (0 <= entry.getValue().getScore()) continue;
                int score = BureauDocuService.INS.parseScore(entry.getKey());
                entry.getValue().setScore(score);
                LOG.info("parse bureau docu score, dev: {}, score: {}", (Object)entry.getKey().getIp(), (Object)score);
            }
        }
    }

    static class NextCardRunnableHelper
    implements Runnable {
        NextCardRunnableHelper() {
        }

        @Override
        public void run() {
            new Thread(new CalcScoreRunnableHelper()).start();
        }
    }

    private static class SupportDevsListener
    implements ToolHyperLinkLabel.ClickListener {
        private static final long serialVersionUID = 1L;

        private SupportDevsListener() {
        }

        public void clickLink(MouseEvent me) {
            ManulyCheckSupportDevDialog dialog = new ManulyCheckSupportDevDialog();
            dialog.setVisible(true);
        }
    }
}

