/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.InspectionGradientGuidance;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.ui.componet.table.CheckResultCell;
import com.huawei.ism.tool.inspect.ui.dialogs.BatchNodeDetailDialog;
import com.huawei.ism.tool.inspect.ui.logic.OpenResultIndexClickListener;
import com.huawei.ism.tool.inspect.ui.logic.OpenResultLinkClickListener;
import com.huawei.ism.tool.inspect.ui.logic.PerformInspectListMouseAdapter;
import com.huawei.ism.tool.inspect.ui.logic.PerformInspectUpdateUIRunable;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.PerformInspectCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTableModel;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformInspectCard
extends InspectCard
implements IUiObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformInspectCard.class);
    private static final long serialVersionUID = 4201735442959613176L;
    private final Object lock = new Object();
    private static final int RETINFO_WIDTH = 460;
    private static final int RETINFO_HIGHT = 21;
    private static final int SLEEP_TIME = 50;
    private static final int NUMBER_THREE = 3;
    private static final int NUMBER_FOUR = 4;
    private static final int NUMBER_FIVE = 5;
    private PerformInspectCardLayout inspectCardLayout = new PerformInspectCardLayout();
    private CheckDevNode currDevNode = null;
    private InspectContext context = InspectContext.getInstance();
    private volatile boolean scollVerBar = true;
    private Timer resetScollTimer = new Timer(10000, new ResetScollAction());

    public PerformInspectCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        this.addLayout(this.inspectCardLayout);
        this.addToTable();
        this.bindListener();
    }

    @Override
    public void start() {
        InspectContext.getInstance().setInspectStep(this.getStep());
        InspectContext.getInstance().setPerformInspectCard(this);
        InspectContext.getInstance().setForeProcessRunning(true);
        WORKTAKER.startInspector(this);
        this.updateNavigationBar();
    }

    private void addToTable() {
        List checkDevs = (List)WORKTAKER.get("check_dev_nodes");
        ListOrderedMap<String, List<CheckDevNode>> result = InspectUtils.classifyDevs(checkDevs);
        List keys = result.keyList();
        ArrayList<ITreeTableRow<CheckDevNode, CheckDevNode>> rows = new ArrayList<ITreeTableRow<CheckDevNode, CheckDevNode>>();
        for (String key : keys) {
            ITreeTableRow<CheckDevNode, CheckDevNode> parentRow;
            List checkDev = (List)result.get((Object)key);
            CheckDevNode tmp = (CheckDevNode)checkDev.get(0);
            CheckDevNode rootNode = new CheckDevNode();
            rootNode.setNodeName(key);
            if (tmp.isIntegration()) {
                parentRow = this.inspectCardLayout.createRow(rootNode);
                ArrayList<CheckDevNode> devs = new ArrayList<CheckDevNode>();
                for (CheckDevNode dev : checkDev) {
                    devs.addAll(dev.getAllCheckNode());
                }
                for (CheckDevNode dev : devs) {
                    ITreeTableRow<CheckDevNode, CheckDevNode> row = this.inspectCardLayout.createRow(dev);
                    parentRow.addSubRow(row);
                }
                rows.add(parentRow);
                continue;
            }
            parentRow = this.inspectCardLayout.createRow(rootNode);
            for (CheckDevNode dev : checkDev) {
                ITreeTableRow<CheckDevNode, CheckDevNode> row = this.inspectCardLayout.createRow(dev);
                parentRow.addSubRow(row);
            }
            rows.add(parentRow);
        }
        this.inspectCardLayout.getTreeTableModel().setRows(rows.toArray(new ITreeTableRow[rows.size()]));
        this.inspectCardLayout.getTable().addRowSelectionInterval(1, 1);
    }

    private void bindListener() {
        JList detailList = this.inspectCardLayout.getDetailList();
        detailList.addMouseListener(new PerformInspectListMouseAdapter(this.inspectCardLayout));
        ToolHyperLinkLabel openResultLink = this.inspectCardLayout.getOpenResultLink();
        openResultLink.addClickListener((ToolHyperLinkLabel.ClickListener)new OpenResultLinkClickListener(WORKTAKER));
        ToolHyperLinkLabel openResultIndexHtml = this.inspectCardLayout.getOpenResultIndexHtml();
        openResultIndexHtml.addClickListener((ToolHyperLinkLabel.ClickListener)new OpenResultIndexClickListener(WORKTAKER));
        this.inspectCardLayout.getDetailScorllPan().getVerticalScrollBar().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                PerformInspectCard.this.scollVerBar = false;
                PerformInspectCard.this.resetScollTimer.restart();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishAll(long during) {
        Object object = this.lock;
        synchronized (object) {
            boolean isOpenReport;
            InspectContext.getInstance().setForeProcessRunning(false);
            this.updateNavigationBar();
            List checkDevs = (List)WORKTAKER.get("check_dev_nodes");
            if (null == checkDevs) {
                return;
            }
            int allNum = 0;
            for (CheckDevNode dev : checkDevs) {
                allNum += dev.getAllCheckNode().size();
            }
            int passedNum = InspectUtils.getPassedDeviceNum(checkDevs);
            String retInfo = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.resultdesc", (Object[])new Object[]{allNum, passedNum, allNum - passedNum, StringUtils.millls2FormatString((long)during)});
            UiMethod.setComponentSize((Dimension)new Dimension(460, 21), (Component[])new Component[]{this.inspectCardLayout.getResultSuggestion()});
            boolean bl = isOpenReport = !WORKTAKER.isConnectedDevEmpty();
            if (WORKTAKER.isRetFilewhether()) {
                String diskfullres = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.diskfull.res");
                this.inspectCardLayout.getResultSuggestion().setText(retInfo + diskfullres);
                this.inspectCardLayout.getResultSuggestion().setToolTipText(this.context.getToolTip(retInfo + diskfullres));
                isOpenReport = false;
            } else {
                this.inspectCardLayout.getResultSuggestion().setText(retInfo);
                this.inspectCardLayout.getResultSuggestion().setToolTipText(this.context.getToolTip(retInfo));
            }
            this.inspectCardLayout.getOpenResultIndexHtml().setEnabled(isOpenReport);
            JButton button = (JButton)this.getNavigationButtons().get(ToolWizardDialog.Navigation.Cancel);
            button.setEnabled(!WORKTAKER.isFinished());
            if (ResourceUtil.getString((String)"inspsctor.wizard.performinspect.stopinspect").equals(ToolWizardDialog.Navigation.Next.toString())) {
                JButton stopButton = (JButton)this.getNavigationButtons().get(ToolWizardDialog.Navigation.Next);
                stopButton.setEnabled(!WORKTAKER.isFinished());
            }
            List checkDevices = (List)WORKTAKER.get("check_dev_nodes");
            this.checkAnalyzeDevice(checkDevices);
        }
    }

    private void checkAnalyzeDevice(List<CheckDevNode> checkDevices) {
        for (CheckDevNode checkDevNode : checkDevices) {
            if (checkDevNode.getDevNode() == null) continue;
            if (InspectUtils.checkFaultItemNum(checkDevNode) == 0) {
                LOGGER.info("Inspect complete >> Analyze device {} end][Success", (Object)checkDevNode.getDevNode().getIp());
                continue;
            }
            LOGGER.info("Inspect complete >> Analyze device {} end][Failed", (Object)checkDevNode.getDevNode().getIp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(CheckDevNode checkDev) {
        Object object = this.lock;
        synchronized (object) {
            UiUpdatePair uiUpdatePair = InspectUIUtil.updateUiUpdatePairWhenFinished(checkDev);
            InspectUIUtil.syncItemFailedWhenExecFailed(this, checkDev, uiUpdatePair);
            TreeTableModel.RowItem item = this.inspectCardLayout.getTreeTableModel().getRowItem((Object)checkDev);
            if (null != item) {
                ITreeTableRow row = item.getTableRow();
                row.setValue(3, (Object)uiUpdatePair.getInspectStatus());
                row.setValue(4, (Object)new IsmTableCell.ProgressCell(uiUpdatePair.getProgress()));
                if (checkDev.isExecuteSuc() || checkDev.isStop()) {
                    row.setValue(5, (Object)new CheckResultCell((Object)uiUpdatePair.getItemStatus()));
                }
                this.inspectCardLayout.getTreeTableModel().updateRow(row);
            }
            this.inspectCardLayout.getTable().repaint();
        }
    }

    protected ToolWizardDialog.Card getNextCard() {
        return null;
    }

    public int getStep() {
        return this.getStep(CardModelEnum.PERFORMINSPECT);
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step6");
    }

    protected boolean isValid(ToolWizardDialog.Navigation nav) {
        if (ToolWizardDialog.Navigation.Complete == nav || ToolWizardDialog.Navigation.Previous == nav) {
            return WORKTAKER.isFinished();
        }
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        if (ToolWizardDialog.Navigation.Previous.equals((Object)navigation)) {
            InspectContext.getInstance().setNeedCheckHighUsage(true);
            WarningDialog dialog = DialogUtils.showYesNoDialog((Window)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.performinspect.reinspect.info"), (boolean)true);
            if (0 == dialog.getValue()) {
                ToolWizardDialog.Navigation.Previous.setName(null);
                ToolWizardDialog.Navigation.Next.setName(null);
                ToolWizardDialog.Card preCard = this.getSelectedCard(this.getPreviousCard());
                this.setPreviousCard(preCard);
                InspectContext.getInstance().clearTempFile();
                InspectContext.getInstance().cleanInnerCheckResult();
                InspectContext.getInstance().setInspectionGradientGuidance(new InspectionGradientGuidance());
                return true;
            }
            return false;
        }
        if (ToolWizardDialog.Navigation.Next.equals((Object)navigation) && ResourceUtil.getString((String)"inspsctor.wizard.performinspect.stopinspect").equals(ToolWizardDialog.Navigation.Next.toString())) {
            boolean isAllInSummary;
            InspectionGradientGuidance guidance = InspectContext.getInstance().getInspectionGradientGuidance();
            Map<String, Boolean> isInSummaryMap = guidance.getDeviceInInfoSummaryMap();
            boolean bl = isAllInSummary = MapUtils.isNotEmpty(isInSummaryMap) && isInSummaryMap.values().stream().allMatch(Boolean::booleanValue);
            if (isAllInSummary) {
                DialogUtils.showYesDialog((Window)mainDialog, (String)ResourceUtil.getString((String)"dsstorage.batch.inspect.all.device.info.summary.stop.msg"));
                return true;
            }
            WarningDialog dialog = DialogUtils.showYesNoDialog((Window)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.performinspect.stopinspect.info"), (boolean)true);
            if (dialog.getValue() == 0) {
                guidance.setStop(true);
                ((JButton)this.getNavigationButtons().get(ToolWizardDialog.Navigation.Next)).setEnabled(false);
            }
        }
        return true;
    }

    private ToolWizardDialog.Card getSelectedCard(ToolWizardDialog.Card current) {
        ToolWizardDialog.Card preCard = current.getPreviousCard();
        if (null == preCard) {
            return current;
        }
        if (!SceneUtils.isScene() && preCard instanceof SelectDeviceCard) {
            return preCard;
        }
        return this.getSelectedCard(preCard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(CheckDevNode checkDev, CheckItem checkItem, String msg, int progressStep, Calendar time, RecordStatus status) {
        Object object = this.lock;
        synchronized (object) {
            try {
                SwingUtilities.invokeLater(new PerformInspectUpdateUIRunable(this, checkDev, checkItem, msg, progressStep, time, status));
            }
            catch (RuntimeException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
            }
        }
    }

    @Override
    public void update(CheckDevNode checkDev, CheckItem checkItem, String msg, int progressStep, Calendar time) {
        this.update(checkDev, checkItem, msg, progressStep, time, RecordStatus.NORMAL);
    }

    public void updateUI(CheckDevNode checkDev, CheckItem checkItem, String msg, int progressStep, Calendar time, RecordStatus status) {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDev);
        List<Record> records = InspectUIUtil.initRecords(checkDev, checkItem, msg, time, status);
        ui = InspectUIUtil.initUiUpdatePair(ui, checkDev, progressStep);
        InspectUIUtil.updateRecordStatus(ui, checkItem, status, records);
        DefaultListModel model = ui.getListMode();
        for (Record rec : records) {
            if (RecordStatus.RUNNING == status) {
                rec.setStatus(RecordStatus.RUNNING);
            } else if (status == RecordStatus.STOPPED) {
                rec.setStatus(RecordStatus.STOPPED);
            }
            this.updateModel(model, rec);
            this.updateDetailList(checkDev);
        }
        this.updateTable(checkDev);
    }

    private void updateModel(DefaultListModel model, Record rec) {
        if (model.contains(rec)) {
            model.setElementAt(rec, model.indexOf(rec));
        } else {
            model.addElement(rec);
        }
    }

    @Override
    public void updateChildItems(CheckDevNode checkDev, Map<String, Object> jsonMsg) {
        try {
            List<CheckItem> checkItems = InspectUIUtil.convertMsg2CheckItems(jsonMsg);
            for (CheckItem checkItem : checkItems) {
                RecordStatus status = checkItem.getCheckResult().getRecordStatus();
                Calendar time = Calendar.getInstance();
                String name = checkItem.getName();
                if (!status.isRunning()) {
                    InspectContext.getInstance().setInnerCheckResult(checkDev.getDevNode().getIp(), checkItem);
                }
                this.updateUI(checkDev, checkItem, name, 0, time, status);
            }
        }
        catch (Exception e) {
            LOGGER.error("updateChildItems exception", (Throwable)e);
        }
    }

    private void fireListAdd() {
        try {
            Thread.sleep(50L);
            this.scrollToView();
        }
        catch (InterruptedException ee) {
            LOGGER.error("");
        }
    }

    public void updateDetailList(CheckDevNode checkDev) {
        int selectRow = this.inspectCardLayout.getTable().getSelectedRow();
        CheckDevNode dev = null;
        if (-1 == selectRow) {
            try {
                if (this.currDevNode != null) {
                    int index = this.inspectCardLayout.getTreeTableModel().getRowIndex((Object)this.currDevNode);
                    this.inspectCardLayout.getTable().addRowSelectionInterval(index, index);
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("The treeTable is hidden.");
                dev = checkDev;
            }
        } else {
            TreeTableModel.RowItem item = this.inspectCardLayout.getTreeTableModel().getRowElement(this.inspectCardLayout.getTable().convertRowIndexToModel(selectRow));
            if (null != item) {
                ITreeTableRow row = item.getTableRow();
                dev = (CheckDevNode)row.getUserObject();
                if (dev.getProduct() == null) {
                    dev = this.currDevNode;
                } else {
                    this.currDevNode = dev;
                }
            }
        }
        if (checkDev != this.currDevNode) {
            return;
        }
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(dev);
        if (ui.getListMode() != this.inspectCardLayout.getDetailList().getModel()) {
            this.inspectCardLayout.getDetailList().setModel(ui.getListMode());
        }
        if (this.scollVerBar) {
            this.fireListAdd();
        }
        this.updateTable(checkDev);
    }

    private void scrollToView() {
        int lastIndex = this.inspectCardLayout.getDetailList().getModel().getSize();
        Rectangle rect = this.inspectCardLayout.getDetailList().getCellBounds(lastIndex - 1, lastIndex - 1);
        JViewport view = this.inspectCardLayout.getDetailScorllPan().getViewport();
        if (null != view && null != rect) {
            view.scrollRectToVisible(rect);
        }
    }

    private void updateTable(CheckDevNode checkDev) {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDev);
        TreeTableModel.RowItem item = this.inspectCardLayout.getTreeTableModel().getRowItem((Object)checkDev);
        if (null != item) {
            ITreeTableRow row = item.getTableRow();
            row.setValue(3, (Object)ui.getInspectStatus());
            row.setValue(4, (Object)new IsmTableCell.ProgressCell(ui.getProgress()));
            this.inspectCardLayout.getTreeTableModel().updateRow(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAllStatus(InspectStatus inspectStatus) {
        Object object = this.lock;
        synchronized (object) {
            List checkDevs = (List)WORKTAKER.get("check_dev_nodes");
            for (CheckDevNode dev : checkDevs) {
                for (CheckDevNode d : dev.getAllCheckNode()) {
                    int rowIndex = this.inspectCardLayout.getTreeTableModel().getRowIndex((Object)d);
                    if (-1 == rowIndex) continue;
                    ITreeTableRow row = this.inspectCardLayout.getTreeTableModel().getRow(rowIndex);
                    row.setValue(3, (Object)inspectStatus);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReporttingMsg(String msg) {
        Object object = this.lock;
        synchronized (object) {
            this.inspectCardLayout.getResultSuggestion().setText(msg);
            this.inspectCardLayout.getResultSuggestion().setToolTipText(this.context.getToolTip(msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBottomMsgInpsecting() {
        Object object = this.lock;
        synchronized (object) {
            String msg = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.inspectingdesc");
            this.inspectCardLayout.getResultSuggestion().setText(msg);
            this.inspectCardLayout.getResultSuggestion().setToolTipText(msg);
        }
    }

    @Override
    public void updateCurrentStatus(CheckDevNode checkDev, RecordStatus status) {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDev);
        if (!ui.isRecordsEmpty()) {
            ui.getRecord(ui.getRecordSize() - 1).setStatus(status);
        }
    }

    public void updateNodeTabelStatus(CheckDevNode checkDevNode, String batchRadioDesc, Map<String, Integer> ipBatchMap, Map<String, String> ipStatusMap) {
        TreeTableModel.RowItem item = this.inspectCardLayout.getTreeTableModel().getRowItem((Object)checkDevNode);
        if (item == null) {
            return;
        }
        List selectClusterNodes = checkDevNode.getDevNode().getClusterNodes().stream().filter(ClusterNode::isSelected).collect(Collectors.toList());
        List<String> selectNodeIps = selectClusterNodes.stream().map(ClusterNode::getManagementIp).sorted(this.sortIpByBatch(ipBatchMap)).collect(Collectors.toList());
        Map<String, String> ipRoleMap = selectClusterNodes.stream().collect(Collectors.toMap(ClusterNode::getManagementIp, clusterNode -> String.join((CharSequence)",", clusterNode.getRoles())));
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDevNode);
        ITreeTableRow row = item.getTableRow();
        String dot = ResourceUtil.getString((String)"dsstorage.batch.inspect.dot");
        row.setValueAt(3, (Object)new IsmTableCell.HyperlinkCell((Object)((Object)ui.getInspectStatus()) + dot + batchRadioDesc, (ActionListener)new BatchNodeProgressListener(selectNodeIps, ipRoleMap, ipBatchMap, ipStatusMap)));
        this.inspectCardLayout.getTreeTableModel().updateRow(row);
    }

    private Comparator<String> sortIpByBatch(Map<String, Integer> ipBatchMap) {
        return (ip1, ip2) -> {
            int batch2;
            int batch1 = ipBatchMap.getOrDefault(ip1, 0);
            if (batch1 != (batch2 = ipBatchMap.getOrDefault(ip2, 0).intValue())) {
                return batch1 - batch2;
            }
            return ip1.compareTo((String)ip2);
        };
    }

    class BatchNodeProgressListener
    implements ActionListener {
        private List<String> nodeIps;
        private Map<String, String> ipRoleMap;
        private Map<String, Integer> ipBatchMap;
        private Map<String, String> ipStatusMap;

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            BatchNodeDetailDialog dialog = new BatchNodeDetailDialog(mainDialog);
            this.nodeIps.forEach(nodeIp -> dialog.addDefaultTableRow((String)nodeIp, this.ipRoleMap.get(nodeIp), this.ipBatchMap.get(nodeIp), this.ipStatusMap.get(nodeIp)));
            dialog.setVisible(true);
        }

        @Generated
        public BatchNodeProgressListener(List<String> nodeIps, Map<String, String> ipRoleMap, Map<String, Integer> ipBatchMap, Map<String, String> ipStatusMap) {
            this.nodeIps = nodeIps;
            this.ipRoleMap = ipRoleMap;
            this.ipBatchMap = ipBatchMap;
            this.ipStatusMap = ipStatusMap;
        }
    }

    class ResetScollAction
    implements ActionListener {
        ResetScollAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PerformInspectCard.this.scollVerBar = true;
            PerformInspectCard.this.resetScollTimer.stop();
        }
    }
}

