/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.UpdateItemHandle;
import com.huawei.ism.tool.inspect.ui.tool.SelectClusterNodeCardService;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.SelectClusterNodeCardLayout;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.PatchImport;
import com.huawei.ism.tool.inspect.utils.ScrollCardUiUtil;
import com.huawei.ism.tool.obase.entity.ClusterNodeStatus;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.ResourceUsageService;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.service.BatchPatchImportImp;
import com.huawei.ism.tool.service.patch.service.IHandler;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.MultiErrorYesOrNoDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectClusterNodeCard
extends InspectCard {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectClusterNodeCard.class);
    private static final long serialVersionUID = 199630063526238187L;
    private static final SelectClusterNodeCardService SERVICE = new SelectClusterNodeCardService();
    private static final int MAX_SHOW_IP_MSG_NUMBER = 5;
    private static final String[] ABNORMAL_NODE_COLUMN_NAME = new String[]{ResourceUtil.getString((String)"dsstorage.inspsctor.query.nodes.status.error.table.device.ip"), ResourceUtil.getString((String)"dsstorage.inspsctor.query.nodes.status.error.table.clusternode.ip")};
    private final SelectClusterNodeCardLayout selectClusterNodeCardLayout;
    private final List<CheckDevNode> checkDevNodes = (List)WORKTAKER.get("check_dev_nodes");

    public SelectClusterNodeCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        List<CheckDevNode> dsCheckDevNodes = InspectUtils.getDistributedStorageCheckDev(this.checkDevNodes);
        this.selectClusterNodeCardLayout = new SelectClusterNodeCardLayout(dsCheckDevNodes);
        this.addLayout(this.selectClusterNodeCardLayout);
        this.updateNavigationBar();
        this.initBmcListener();
    }

    private void initBmcListener() {
        if (!InspectContext.getInstance().isBureauCheckSelected()) {
            return;
        }
        ArrayList<SelectClusterNodeCardLayout> importListener = new ArrayList<SelectClusterNodeCardLayout>();
        importListener.add(this.selectClusterNodeCardLayout);
        DeviceCenterContext.getInstance().getDeviceTables().put("deviceTables", importListener);
        this.selectClusterNodeCardLayout.initBmcAuthBtnListener();
    }

    @Override
    public void initData() {
        this.selectClusterNodeCardLayout.initData();
        this.selectClusterNodeCardLayout.setComponentsName();
        this.selectClusterNodeCardLayout.getComponent().setPostHandler((IHandler)new UpdateItemHandle(this.selectClusterNodeCardLayout));
    }

    protected ToolWizardDialog.Card getNextCard() {
        if (!this.checkCanNext()) {
            return this;
        }
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        if (this.hasBadClusterNodes(mainDialog)) {
            return this;
        }
        List<DevNode> devNodeList = this.checkDevNodes.stream().map(CheckDevNode::getDevNode).collect(Collectors.toList());
        if (this.hasHardwareHighUsageNode(mainDialog, devNodeList)) {
            return this;
        }
        Context.INS.setNfvMode(InspectContext.getInstance().isNfvMode());
        if (this.isUploadPackageFailed(mainDialog)) {
            return this;
        }
        return InspectUIUtil.getNextCard(CardModelEnum.SELECT_CLUSTER_NODES, this);
    }

    private boolean hasHardwareHighUsageNode(JDialog mainDialog, List<DevNode> devNodeList) {
        List highUsageData = ResourceUsageService.getHardwareHighUsageData((JDialog)mainDialog, devNodeList);
        if (CollectionUtils.isEmpty((Collection)highUsageData)) {
            return false;
        }
        boolean isContinue = ResourceUsageService.isHighUsageWarningContinue((JDialog)mainDialog, (List)highUsageData);
        InspectContext.getInstance().setNeedCheckHighUsage(!isContinue);
        log.info("user select continue inspect result is {} when node has high usage", (Object)isContinue);
        return !isContinue;
    }

    private boolean hasBadClusterNodes(JDialog mainDialog) {
        Map<DevNode, JSONArray> allDevClusterInfo = this.queryAllDevClusterInfo(mainDialog);
        Map<DevNode, Map<String, ClusterNodeStatus>> deviceClusterNodeStatusMap = SERVICE.parseAllDevClusterInfo(allDevClusterInfo);
        SERVICE.updateClusterNodeStatus(deviceClusterNodeStatusMap);
        List<List<String>> abnormalNodeInfos = SERVICE.getAbnormalClusterNodeInfo(deviceClusterNodeStatusMap);
        if (CollectionUtils.isNotEmpty(abnormalNodeInfos)) {
            String tip = ResourceUtil.getString((String)"dsstorage.inspsctor.query.nodes.status.error.table.tip");
            MultiErrorYesOrNoDialog multiErrorYesOrNoDialog = DialogUtils.createMultiWarningYesNoDialogWithSize((Window)mainDialog, (String)tip, (String[])ABNORMAL_NODE_COLUMN_NAME, abnormalNodeInfos, Arrays.asList(0, 0));
            multiErrorYesOrNoDialog.setVisible(true);
            return multiErrorYesOrNoDialog.getValue() != 0;
        }
        return false;
    }

    private boolean isUploadPackageFailed(JDialog mainDialog) {
        int width = 350;
        ProgressDialog progressDialog = new ProgressDialog((Window)mainDialog, ResourceUtil.getString((String)"patch.ui.init.checkItem"), width);
        List executeList = AsyncExcutor.execute((ProgressDialog)progressDialog, (mainDialog != null ? 1 : 0) != 0, (long)0L, (Callable[])new Callable[]{() -> PatchImport.builder().checkDevNodes(this.checkDevNodes).build().autoImport()});
        List taskResultList = (List)executeList.get(0);
        if (BatchPatchImportImp.isUploadFailed((List)taskResultList)) {
            List failResults = taskResultList.stream().filter(result -> !result.isTaskSuccess()).collect(Collectors.toList());
            MultiErrorYesOrNoDialog batchImportDialog = BatchPatchImportImp.getNodeUploadFailedTipDialog((Window)mainDialog, failResults, (boolean)true);
            batchImportDialog.setVisible(true);
            return batchImportDialog.getValue() != 0;
        }
        return false;
    }

    private boolean checkCanNext() {
        if (!this.hasSelectedNodes() || this.hasFirstSelectAllNodesAndClickCancel()) {
            return false;
        }
        if (!this.selectClusterNodeCardLayout.getComponent().leaveCheck()) {
            return false;
        }
        return this.checkBmcAuthComplete();
    }

    private boolean hasFirstSelectAllNodesAndClickCancel() {
        if (InspectContext.getInstance().isBureauCheckSelected()) {
            return false;
        }
        List<String> ips = SERVICE.findFirstSelectAllNodeIps(this.checkDevNodes);
        return CollectionUtils.isNotEmpty(ips) && !this.isClickContinue(ips);
    }

    private boolean isClickContinue(List<String> ips) {
        log.info("There are devices first select all nodes, and the device ip is {}", ips);
        String ipsJoinStr = SERVICE.getIpsJoinStr(ips, 5);
        String msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.first.select.all.node.msg", (Object[])new Object[]{ips.size(), ipsJoinStr});
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        WarningDialog warningDialog = this.showContinueOrNotDialog(mainDialog, msg);
        if (warningDialog.isConfirmClick()) {
            log.info("user click continue,the device ip is {}", ips);
            return true;
        }
        log.info("user click cancel,the device ip is {}", ips);
        return false;
    }

    private boolean checkBmcAuthComplete() {
        if (InspectContext.getInstance().isDetachCheck()) {
            return true;
        }
        Map<String, List<String>> needBmcAuthDev = this.getNeedBmcAuthDev();
        if (needBmcAuthDev.isEmpty()) {
            return true;
        }
        return ScrollCardUiUtil.showNoAuthConfirmDialog(needBmcAuthDev);
    }

    private Map<String, List<String>> getNeedBmcAuthDev() {
        return CheckItemUtils.getNeedBmcAuthDev(this.checkDevNodes);
    }

    public static List<String> getExistBadClusterDevIps(Map<DevNode, JSONArray> allDevClusterInfo) {
        ArrayList<String> existBadClusterDevIps = new ArrayList<String>();
        for (Map.Entry<DevNode, JSONArray> entry : allDevClusterInfo.entrySet()) {
            DevNode devNode = entry.getKey();
            JSONArray clusterInfo = entry.getValue();
            if (clusterInfo == null) continue;
            HashMap<String, ClusterNodeStatus> clusterStatusMap = new HashMap<String, ClusterNodeStatus>();
            ArrayList<String> statusAbnormalNodes = new ArrayList<String>();
            boolean existBadCluster = false;
            for (int i = 0; i < clusterInfo.length(); ++i) {
                JSONObject jsonData = clusterInfo.getJSONObject(i);
                int statusCode = jsonData.getInt("status");
                String nodeId = jsonData.getStringOrDefault("id", "null");
                ClusterNodeStatus status = ClusterNodeStatus.getClusterNodeStatus((int)statusCode);
                String serialNo = jsonData.getString("serial_number");
                if (!status.isNormal() && SERVICE.isCurrentClusterNodeSelect(devNode, serialNo)) {
                    existBadCluster = true;
                    statusAbnormalNodes.add(nodeId);
                }
                clusterStatusMap.put(serialNo, status);
            }
            SelectClusterNodeCard.updateClusterStatus(devNode, clusterStatusMap);
            if (!existBadCluster) continue;
            existBadClusterDevIps.add(devNode.getIp());
            log.error("device:[{}] node id:{} status is abnormal", (Object)devNode.getIp(), statusAbnormalNodes);
        }
        return existBadClusterDevIps;
    }

    private Map<DevNode, JSONArray> queryAllDevClusterInfo(JDialog parent) {
        HashMap<DevNode, JSONArray> result = new HashMap<DevNode, JSONArray>();
        List fsDevList = InspectUtils.getDistributedStorageCheckDev(this.checkDevNodes).stream().map(CheckDevNode::getDevNode).collect(Collectors.toList());
        int width = 320;
        ProgressDialog progressDialog = new ProgressDialog((Window)parent, ResourceUtil.getString((String)"inspect.ui.next.query.cluster"), width);
        for (DevNode devNode : fsDevList) {
            Object clusterInfo;
            if (devNode.isA3000() || devNode.is2910V7() || !((clusterInfo = AsyncExcutor.execute((ProgressDialog)progressDialog, (parent != null ? 1 : 0) != 0, (long)0L, (Callable[])new Callable[]{() -> this.queryOneDevClusterInfo(devNode)}).get(0)) instanceof JSONArray)) continue;
            result.put(devNode, (JSONArray)clusterInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray queryOneDevClusterInfo(DevNode devNode) {
        ResponseInfo clusterNodesResp = null;
        try {
            RestConnection restConn = RestConnectionManager.getRestConnection((DevNode)devNode);
            if (restConn == null) {
                log.error("rest connection is null!");
                JSONArray jSONArray = null;
                return jSONArray;
            }
            clusterNodesResp = restConn.execGet(RestUtil.getClusterNodesUri((DevNode)devNode));
        }
        catch (ToolException e) {
            log.error("query fs dev cluster info fail", (Throwable)e);
            JSONArray jSONArray = null;
            return jSONArray;
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
        long errorCode = (Long)clusterNodesResp.getContentMap().get("errorCode");
        String errorDes = (String)clusterNodesResp.getContentMap().get("description");
        String suggest = (String)clusterNodesResp.getContentMap().get("suggestion");
        if (errorCode != 0L) {
            log.error("Query cluster nodes failed, error code:{}, error description:{}, suggestion:{}", new Object[]{errorCode, errorDes, suggest});
            return null;
        }
        return (JSONArray)clusterNodesResp.getContentMap().get("data");
    }

    private static void updateClusterStatus(DevNode dev, Map<String, ClusterNodeStatus> clusterStatus) {
        dev.getClusterNodes().forEach(clusterNode -> {
            String serialNo = clusterNode.getSerialNumber();
            clusterNode.setStatus((ClusterNodeStatus)clusterStatus.get(serialNo));
        });
    }

    private WarningDialog showContinueOrNotDialog(JDialog mainDialog, String msg) {
        return DialogUtils.showYesNoDialog((Window)mainDialog, (String)msg, (String)ResourceUtil.getString((String)"inspect.modify.button.continue"), (String)ResourceUtil.getString((String)"inspect.modify.button.cancel"), (int)100, (int)100);
    }

    private boolean hasSelectedNodes() {
        Object obj = WORKTAKER.get("check_dev_nodes");
        if (obj == null) {
            return false;
        }
        List nodes = (List)obj;
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        for (CheckDevNode chkDevNode : nodes) {
            if (!SERVICE.isDsDeviceAndNotSelectClusterNode(chkDevNode)) continue;
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getStringWithParams((String)"inspsctor.wizard.select.nodes.no.nodes.checked", (Object[])new Object[]{chkDevNode.getProduct().getProductName() + " " + chkDevNode.getDevNode().getIp()}));
            return false;
        }
        return true;
    }

    public int getStep() {
        return this.getStep(CardModelEnum.SELECT_CLUSTER_NODES);
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step.select.cluster.nodes");
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }
}

