/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.FusionCubeInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.implement.BaseExecuter;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.former.service.IntelligentComputeSceneImpl;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.fusioncube.dialog.MetaVisionInputTableDialog;
import com.huawei.ism.tool.fusioncube.service.MetaVisionInspectService;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.DevInfo4Exp;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.inspect.logic.config.ArrayProductParser;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.service.implement.BatchUpgradeConfigCheck;
import com.huawei.ism.tool.inspect.ui.action.FusionCubeAuthAction;
import com.huawei.ism.tool.inspect.ui.dialogs.InspectMultiInfoDialog;
import com.huawei.ism.tool.inspect.ui.dialogs.ProgressStepDialog;
import com.huawei.ism.tool.inspect.ui.logic.AdanceCompileRemotePyScript;
import com.huawei.ism.tool.inspect.ui.logic.AddDeviceClickListener;
import com.huawei.ism.tool.inspect.ui.logic.DeviceListClickListener;
import com.huawei.ism.tool.inspect.ui.logic.QueryDevStatusCallable;
import com.huawei.ism.tool.inspect.ui.logic.SelectDevUpdateNavigationListener;
import com.huawei.ism.tool.inspect.ui.logic.SelectDeviceCardAnalyzeCallable;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.SelectItemCard;
import com.huawei.ism.tool.inspect.utils.ComputerStorageUtils;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.ResultDevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.MultiErrorDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.ListSelectionModel;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;
import utils.Products;

public class SelectDeviceCard
extends InspectCard
implements INodeObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectDeviceCard.class);
    private static final long serialVersionUID = 2158537927653474490L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectDeviceCard.class);
    private SelectDeviceCardLayout selectDeviceCardLayout = new SelectDeviceCardLayout();
    public static final int ALL_SUPPORT = 1;
    public static final int PART_SUPPORT = 2;
    public static final int ALL_NOT_SUPPORT = 3;
    public static final int SNS_LIST_MAX_LENTH = 3;
    private static int devSupport = 1;
    private static String[] tableHeader = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devipaddress"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.sn"), ResourceUtil.getString((String)"check.need.fusioncube.auth.status"), ResourceUtil.getString((String)"check.need.fusioncube.auth.operation")};
    private SelectDevUpdateNavigationListener listener = new SelectDevUpdateNavigationListener(this);

    public SelectDeviceCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        String scenceInfo;
        this.addLayout(this.selectDeviceCardLayout);
        InspectContext.getInstance().setSelectSeceneInSecondCard("");
        this.init();
        DefaultNodeProviderImpl.getInstance().addNodeObservers((INodeObserver)this);
        this.initTableData();
        this.bindListener();
        if (ApplicationContext.getInstance().isSpecificDeviceMode() && !SceneUtils.isScene()) {
            this.selectDeviceCardLayout.getAddDevDes().setVisible(this.showSvpAddDevice(SelectDeviceCard.getDevManagerList()));
        }
        if (SceneUtils.isSpecialScence((String)(scenceInfo = System.getenv("jsonScene")), (String[])InspectConstans.mainScene()) && this.showSvpAddDevice(SelectDeviceCard.getDevManagerList()) || this.isSwitchDpaScence(scenceInfo)) {
            this.selectDeviceCardLayout.getAddDeviceLink().setEnabled(true);
        }
    }

    @Override
    public void initData() {
        InspectContext.getInstance().updateNavigationBar(this);
        this.updateNavigationBar();
    }

    private boolean isSwitchDpaScence(String scenceInfo) {
        return SceneUtils.isSpecialScence((String)scenceInfo, (String[])new String[]{"Switch Inspector"}) || SceneUtils.isSpecialScence((String)scenceInfo, (String[])new String[]{"Switch Quality Checks"}) || SceneUtils.isSpecialScence((String)scenceInfo, (String[])new String[]{"DPA Inspector"});
    }

    private void init() {
        if (SceneUtils.isScene()) {
            InspectContext.getInstance().getInspectWorktaker().put("check_savepath", InspectContext.getInstance().getSceneCollectDir());
        } else if ("test".equals(System.getenv("runMode"))) {
            InspectContext.getInstance().getInspectWorktaker().put("check_savepath", FilesUtil.getCanonicalPath((File)FileUtils.getDefaultDirectory()) + File.separator);
        }
        InspectContext.getInstance().getInspectWorktaker().put("check_savepath_filename", InspectUtils.buildResultFileName("").getName());
        WORKTAKER.put("scene_hyper_metro_nodes", InspectUtils.getHyperMetroDevNodeList());
    }

    private void bindListener() {
        ListSelectionModel model = this.selectDeviceCardLayout.getDeviceTable().getSelectionModel();
        model.addListSelectionListener(this.listener);
        ToolHyperLinkLabel addDeviceLink = this.selectDeviceCardLayout.getAddDeviceLink();
        addDeviceLink.addClickListener((ToolHyperLinkLabel.ClickListener)new AddDeviceClickListener(this));
        ToolHyperLinkLabel deviceListLink = this.selectDeviceCardLayout.getDeviceListLink();
        deviceListLink.addClickListener((ToolHyperLinkLabel.ClickListener)new DeviceListClickListener());
    }

    public void refreshDevTable() {
        ListSelectionModel model = this.selectDeviceCardLayout.getDeviceTable().getSelectionModel();
        model.removeListSelectionListener(this.listener);
        this.updateTable();
        this.listener.setSelectRow();
        this.initData();
        model.addListSelectionListener(this.listener);
    }

    private void updateTable() {
        List allRows = this.selectDeviceCardLayout.getTableModel().getAllRows();
        List<DevNode> allDevs = SelectDeviceCard.getDevManagerList();
        ArrayList<DevNode> newAddedDev = new ArrayList<DevNode>(allDevs.size());
        newAddedDev.addAll(allDevs);
        for (TableRow tableRow : allRows) {
            for (DevNode devNode : allDevs) {
                if (!devNode.equals(tableRow.getUserObject())) continue;
                newAddedDev.remove(devNode);
            }
        }
        if (newAddedDev.isEmpty()) {
            return;
        }
        for (DevNode devNode : newAddedDev) {
            TableRow<?, ?> row = this.createRow(devNode);
            this.addDevRow(devNode.getDeviceSerialNumber(), row);
            this.selectDeviceCardLayout.getDeviceTable().markTableRows(new Object[]{devNode});
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }

    private void initTableData() {
        List<DevNode> devManagerdevs = SelectDeviceCard.getDevManagerList();
        int index = 0;
        for (DevNode node : devManagerdevs) {
            this.changeSelectStatus(node);
            TableRow<?, ?> row = this.createRow(node);
            this.addDevRow(node.getDeviceSerialNumber(), row);
            if (SceneUtils.isScene() && InspectContext.getInstance().sceneSelectDevNode(node)) {
                this.selectDeviceCardLayout.getDeviceTable().addRowSelectionInterval(index, index);
            }
            ++index;
        }
    }

    void changeSelectStatus(DevNode node) {
        if (!InspectUtils.isDistributedFrw() && !InspectUtils.isBatchUpgradeScene()) {
            log.info("By default, all nodes need to be selected.");
            return;
        }
        if (InspectUtils.isDistributedFrw()) {
            node.getClusterNodes().stream().peek(clusterNode -> clusterNode.setSelected(false)).filter(clusterNod -> this.isStorageNodeSelected(node, (ClusterNode)clusterNod)).forEach(clusterNode -> clusterNode.setSelected(true));
        } else {
            List<String> selectDpcNodes = BatchUpgradeConfigCheck.getSelectedDpcIps(node);
            if (CollectionUtils.isEmpty(selectDpcNodes)) {
                log.warn("The configured DPC node information is not found in batch upgrade scene.");
                return;
            }
            node.getClusterNodes().stream().peek(clusterNode -> clusterNode.setSelected(false)).filter(clusterNod -> this.needSelected(selectDpcNodes, (ClusterNode)clusterNod)).forEach(clusterNode -> clusterNode.setSelected(true));
        }
    }

    private boolean needSelected(List<String> selectDpcNodes, ClusterNode clusterNode) {
        return selectDpcNodes.contains(clusterNode.getManagementIp()) || !clusterNode.isOnlyComputeNode();
    }

    private boolean isStorageNodeSelected(DevNode devNode, ClusterNode clusterNode) {
        return devNode.getSelectedNodeIps().contains(clusterNode.getManagementIp()) && clusterNode.isStorageNode();
    }

    public static List<DevNode> getDevManagerList() {
        List devs = DefaultNodeProviderImpl.getInstance().getNodeList();
        devSupport = 1;
        if (SceneUtils.isA800UpgradeCheck()) {
            return devs;
        }
        if (SceneUtils.isA800Upgrade()) {
            return SelectDeviceCard.getA800UpgradeDevNode();
        }
        if (SceneUtils.isA800SceneInTool()) {
            return SelectDeviceCard.getA800InspectionDevs(devs);
        }
        int srcDevCount = devs.size();
        InspectContext context = InspectContext.getInstance();
        Iterator<DevNode> iter = devs.iterator();
        while (iter.hasNext()) {
            DevNode dev = (DevNode)iter.next();
            SelectDeviceCard.removeUnsupportDev(context, iter, dev);
        }
        if (srcDevCount == 0) {
            devSupport = 1;
        } else if (srcDevCount == devs.size()) {
            devSupport = 1;
        } else if (!devs.isEmpty() && srcDevCount > devs.size()) {
            devSupport = 2;
        } else if (devs.isEmpty()) {
            devSupport = 3;
        }
        return devs;
    }

    private static List<DevNode> getA800UpgradeDevNode() {
        List aiDevNodes = new IntelligentComputeSceneImpl().readExtend();
        return aiDevNodes.stream().flatMap(aiDevNode -> aiDevNode.getA800Nodes().stream()).filter(DmeNode::isSelect).flatMap(a800Node -> a800Node.getZones().stream()).filter(devnode -> SelectDeviceCard.nonNullUser(devnode.getLoginUser())).collect(Collectors.toList());
    }

    private static List<DevNode> getA800InspectionDevs(List<DevNode> devs) {
        return devs.stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).flatMap(aiDevNode -> Stream.concat(SelectDeviceCard.getA800Zones(aiDevNode).stream(), SelectDeviceCard.getA800OmNodes(aiDevNode).stream())).collect(Collectors.toList());
    }

    private static void removeUnsupportDev(InspectContext context, Iterator<DevNode> iter, DevNode dev) {
        if (!context.isSupportDev(dev) || SelectDeviceCard.isUnsupportedComputerDev(dev) || SelectDeviceCard.isUnsupportedDevNode(dev)) {
            iter.remove();
            if (dev.getItDeviceType().equals((Object)ItDeviceType.T3000) || dev.getItDeviceType().equals((Object)ItDeviceType.UltraPath)) {
                SelectDeviceCard.removeDevice(dev);
            }
        }
    }

    private static List<DmeNode> getA800Zones(AiDevNode devs) {
        return devs.getA800Nodes().stream().filter(DmeNode::isSelect).flatMap(a800Node -> a800Node.getZones().stream()).filter(devnode -> SelectDeviceCard.nonNullUser(devnode.getLoginUser())).collect(Collectors.toList());
    }

    private static List<DmeNode> getA800OmNodes(AiDevNode devs) {
        return devs.getOmNodes().stream().filter(devnode -> devnode.isSelect() && SelectDeviceCard.nonNullUser(devnode.getLoginUser())).collect(Collectors.toList());
    }

    static boolean nonNullUser(User user) {
        return Objects.nonNull(user) && !StringUtils.isNULLStr((String)user.getUserName()) && !StringUtils.isNULLStr((String)user.getPassword());
    }

    private static boolean isUnsupportedDevNode(DevNode dev) {
        String version;
        String userName = dev.getLoginUser().getUserName();
        if (!userName.startsWith("domain/")) {
            log.info("The device {} is not logged in as a domain user.", (Object)dev.getIp());
            return false;
        }
        String model = dev.getDeviceType().toString();
        return !Products.isSpecifiedDoradoOrNewDoradoDev((String)model, (String)(version = dev.getProductVersion())) && !Products.isSpecifiedOceanProtectDev((String)model, (String)version) && !Products.isSpecifiedMicroDev((String)model, (String)version);
    }

    private static void removeDevice(DevNode dev) {
        try {
            DefaultNodeProviderImpl.getInstance().removeNode(dev);
        }
        catch (ToolException e) {
            LOGGER.error("delete device faild . device ip is:" + dev.getIp());
        }
    }

    private static boolean isUnsupportedComputerDev(DevNode dev) {
        if (EntityUtils.isComputeStorageDevLoginThroughFcv((DevNode)dev) && ComputerStorageUtils.isUnsupportedDevice(dev.getProductVersion())) {
            DialogUtils.showInfoDialogOnTop((String)ResourceUtil.getString((String)"metavision.device.unsupported"));
            SelectDeviceCard.removeDevice(dev);
            return true;
        }
        return false;
    }

    private TableRow<?, ?> createRow(DevNode node) {
        DefaultTableRow row = null;
        row = ApplicationContext.getInstance().isSpecificDeviceMode() ? new DefaultTableRow(this.selectDeviceCardLayout.getSpecificDeviceModeTableHeader().length, (Object)node, (Object)node) : new DefaultTableRow(this.selectDeviceCardLayout.getTableHeader().length, (Object)node, (Object)node);
        int i = 0;
        row.setValueAt(i++, this.getProductModel(node));
        row.setValueAt(i++, (Object)node.getDisplayProductVersion());
        row.setValueAt(i++, (Object)node.getDeviceName());
        row.setValueAt(i++, (Object)new IpAddressStrategy(node.getIp()));
        row.setValueAt(i++, (Object)node.getDeviceSerialNumber());
        return row;
    }

    private Object getProductModel(DevNode devNode) {
        DeviceType type;
        if (InspectContext.getInstance().isOemOutTool()) {
            return devNode.getOemModel();
        }
        if (!StringUtils.isNULLStr((String)devNode.getProductSubModel())) {
            return devNode.getProductSubModel();
        }
        DeviceType deviceType = type = InspectContext.DEVNODE_TYPE.get(devNode) == null ? devNode.getDeviceType() : DeviceType.valueOf((String)InspectContext.DEVNODE_TYPE.get(devNode));
        if (devNode.isHyperMetro()) {
            IsmTableCell.TextIconCell cell = new IsmTableCell.TextIconCell(type.toString(), (Icon)ResourceUtil.getImage((String)"hyperMetroIcon.png"));
            String sns = devNode.getRemoteSNs().toString();
            sns = sns.substring(sns.indexOf(91) + 1, sns.indexOf(93));
            sns = this.cutTooLongSns2Lines(sns);
            cell.setTips(ResourceUtil.getStringWithParams((String)"inspect.card.selectdev.layout.hypermetro.device.tips", (Object[])new Object[]{sns}));
            return cell;
        }
        if (NodeAddEnum.COLLECT_FILE.equals((Object)devNode.getNodeAddType())) {
            IsmTableCell.TextIconCell cell = new IsmTableCell.TextIconCell(type.toString(), (Icon)ResourceUtil.getImage((String)"fileHostIcon.png"));
            cell.setTips(ResourceUtil.getStringWithParams((String)"inspect.card.selectdev.layout.fileHost.device.tips", (Object[])new Object[0]));
            return cell;
        }
        return type;
    }

    private String cutTooLongSns2Lines(String sns) {
        String[] snsList = sns.split(",");
        StringBuffer snsParsed = new StringBuffer();
        for (int poi = 0; poi < snsList.length; ++poi) {
            if (poi != 0 && poi % 3 == 0) {
                snsParsed.append(snsList[poi] + ",<br/>");
                continue;
            }
            if (poi + 1 == snsList.length) {
                snsParsed.append(snsList[poi]);
                continue;
            }
            snsParsed.append(snsList[poi] + ",");
        }
        return snsParsed.toString();
    }

    protected ToolWizardDialog.Card getNextCard() {
        String selectScene;
        boolean isPass;
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        List<DevNode> selectDevs = this.selectDeviceCardLayout.getSelectedDevs();
        if (this.isBureauAnd2910V7(selectDevs, mainDialog)) {
            return this;
        }
        List<DevNode> allDevs = this.selectDeviceCardLayout.getAllDevs();
        List<DevNode> dpaDevices = selectDevs.stream().filter(devNode -> devNode.getProductModel().toLowerCase(Locale.ENGLISH).contains("cdm")).collect(Collectors.toList());
        if (!dpaDevices.isEmpty()) {
            try {
                File reuqireCheckPyFile = this.getReuqireCheckPyFile(dpaDevices);
                File scriptFolder = reuqireCheckPyFile.getParentFile();
                JythonExecuter jythonExecuter = this.getJythonExecuter(scriptFolder);
                try {
                    jythonExecuter.compileScript(reuqireCheckPyFile);
                }
                catch (Exception e) {
                    LOGGER.error("compile remote python script error", (Throwable)e);
                }
                List result = jythonExecuter.invokeFunction("execute", new Object[]{dpaDevices, selectDevs, allDevs});
                if (!this.isContinue(result)) {
                    return this;
                }
            }
            catch (ToolException e) {
                LOGGER.error("get py script error.", (Throwable)e);
            }
        }
        if (this.dataValid(selectDevs, mainDialog)) {
            return this;
        }
        if (InspectUtils.isPreExpEvaluation().booleanValue()) {
            boolean isAllHostflag = true;
            for (DevNode devNode2 : selectDevs) {
                if (!SelectDeviceCard.isStorageDev(devNode2)) continue;
                isAllHostflag = false;
                break;
            }
            if (isAllHostflag) {
                DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.host.check"));
                return this;
            }
        }
        boolean bl = isPass = (selectScene = InspectContext.getInstance().getSelectSeceneInSecondCard()).contains("realTimed_check") && (selectScene.contains(ItDeviceType.Storage.getName()) || selectScene.contains(ItDeviceType.T3000.getName()) || selectScene.contains(ItDeviceType.UltraPath.getName()));
        if (isPass) {
            for (DevNode node : selectDevs) {
                if (selectScene.contains(node.getItDeviceType().getName())) continue;
                DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspect.wizard.selectScene.fromPage2to1"));
                return this;
            }
        }
        if (!this.checkFusionCubeVm(selectDevs)) {
            return this;
        }
        if (!this.validateMetaVisionAccountSuccess(selectDevs)) {
            return this;
        }
        WORKTAKER.put("select_dev_nodes", selectDevs);
        LOGGER.info("load products.....");
        ProgressStepDialog progressStepDialog = new ProgressStepDialog(mainDialog, SelectDeviceCard.getRealDealCount(selectDevs));
        Future futu = AsyncExcutor.submit((Callable)new QueryDevStatusCallable(WORKTAKER, progressStepDialog, this.getSelectDeviceCardLayout().getAllDevs()));
        Future fu = AsyncExcutor.submit((Callable)new SelectDeviceCardAnalyzeCallable(futu, progressStepDialog));
        if (progressStepDialog.isDisplayable()) {
            progressStepDialog.setVisible(true);
        }
        WORKTAKER.initDebugPwdDevs();
        try {
            WORKTAKER.updateCluterBmcInfo(WORKTAKER.getCheckDevNodes());
        }
        catch (ToolException e) {
            LOGGER.info("Failed to update the BMC node information.", (Throwable)e);
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.loadconfigerror"));
            return this;
        }
        return this.execCall(mainDialog, fu, WORKTAKER.getCheckDevNodes());
    }

    private static boolean isStorageDev(DevNode devNode) {
        return ItDeviceType.Storage.equals((Object)devNode.getItDeviceType()) | ItDeviceType.A800_NODE.equals((Object)devNode.getItDeviceType());
    }

    boolean isBureauAnd2910V7(List<DevNode> selectDevs, JDialog parent) {
        if (InspectContext.getInstance().isBureauCheckSelected() && selectDevs.stream().anyMatch(DevNode::is2910V7)) {
            String select2910V7Ips = selectDevs.stream().map(DevNode::getIp).collect(Collectors.joining(","));
            DialogUtils.showInfoDialog((JDialog)parent, (String)ResourceUtil.getStringWithParams((String)"inspsctor.wizard.selectdevice.deployment.check", (Object[])new Object[]{SelectItemCard.enComma2zhComma(select2910V7Ips)}));
            log.info("OceanStor 2910 V7 device do not support site deployment quality inspection. ip: {}", (Object)select2910V7Ips);
            return true;
        }
        return false;
    }

    private boolean validateMetaVisionAccountSuccess(List<DevNode> selectDevs) {
        if (InspectContext.getInstance().isBureauCheckSelected()) {
            return true;
        }
        List<DevNode> metaVisionDevs = this.getMetaVisionDevs(selectDevs);
        if (CollectionUtils.isEmpty(metaVisionDevs)) {
            return true;
        }
        return this.createTableDialog(metaVisionDevs);
    }

    private boolean createTableDialog(List<DevNode> metaVisionDevs) {
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        MetaVisionInputTableDialog inputTableDialog = new MetaVisionInputTableDialog(mainDialog);
        inputTableDialog.setSelectDeviceCard(this);
        metaVisionDevs.forEach(inputTableDialog::addDefaultTableRow);
        inputTableDialog.setVisible(true);
        return inputTableDialog.isLoginAllSuccess();
    }

    private List<DevNode> getMetaVisionDevs(List<DevNode> selectDevs) {
        return selectDevs.stream().filter(devNode -> MetaVisionInspectService.isSupportsMetaVisionNodeInspection(devNode) && !RestConnectionManager.isPoolExistConnection((String)("MetaVision" + devNode.getIp()))).collect(Collectors.toList());
    }

    private boolean checkFusionCubeVm(List<DevNode> selectDevs) {
        if (!InspectContext.getInstance().isBureauCheckSelected()) {
            return true;
        }
        selectDevs.stream().filter(DevNode::isFusionCube).filter(devNode -> CollectionUtils.isEmpty((Collection)devNode.getClusterNodes())).forEach(devNode -> {
            try {
                new DevUtil(null).initDistributedDevNode((DevNode)devNode);
            }
            catch (ToolException e) {
                LOGGER.error("init node error", (Throwable)e);
            }
        });
        List<DevNode> vmDevNodes = selectDevs.stream().filter(DevNode::isFusionCube).filter(dev -> org.apache.commons.lang3.StringUtils.equalsAnyIgnoreCase((CharSequence)dev.getScenarioInfo(), (CharSequence[])new CharSequence[]{"VMwareIaSS", "VSPHERE"})).filter(dev -> this.notQueryBmcInfo((DevNode)dev)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(vmDevNodes)) {
            return true;
        }
        List<DevNode> vmDevNodes6x = vmDevNodes.stream().filter(this::isFusionCube6).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(vmDevNodes6x)) {
            FusionCubeInfoQryServiceImpl infoQryService = new FusionCubeInfoQryServiceImpl();
            vmDevNodes6x.forEach(dev -> infoQryService.queryBmcInfo(dev));
        }
        vmDevNodes.removeAll(vmDevNodes6x);
        if (CollectionUtils.isEmpty(vmDevNodes)) {
            return true;
        }
        return this.showNoAuthConfirmDialogWithTable(vmDevNodes);
    }

    private boolean isFusionCube6(DevNode devNode) {
        return org.apache.commons.lang3.StringUtils.startsWith((CharSequence)devNode.getProductVersion(), (CharSequence)"6.");
    }

    private boolean notQueryBmcInfo(DevNode dev) {
        return Optional.ofNullable(dev.getClusterNodes()).orElseGet(ArrayList::new).stream().filter(node -> node.includedStorageService() || node.includeManagementRole()).anyMatch(node -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)node.getBmcIp()) || node.getBmcNode() == null || StringUtils.isNULLStr((String)node.getBmcNode().getIp()));
    }

    private boolean showNoAuthConfirmDialogWithTable(List<DevNode> vmDevNodes) {
        String prompt = SelectDeviceCard.buildNoAuthTipsInfo();
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        DefaultTableModel table = new DefaultTableModel(tableHeader, new int[0]);
        List<TableRow> tableRows = this.buildTableRow(vmDevNodes);
        table.setTableData(tableRows);
        MultiErrorDialog multiErrorDialog = DialogUtils.showMultiWarningDialogWithIgnoreButtonAndTable((Window)mainDialog, (String)prompt, (String[])tableHeader, (DefaultTableModel)table);
        return multiErrorDialog.getDialogValue() == 0;
    }

    private List<TableRow> buildTableRow(List<DevNode> vmDevNodes) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>(0);
        for (DevNode node : vmDevNodes) {
            DefaultTableRow tableRow = new DefaultTableRow(tableHeader.length, (Object)"", (Object)SelectDeviceCard.getNoStripUUID());
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(node.getIp());
            row.add(node.getDeviceSerialNumber());
            row.add(ResourceUtil.getString((String)"check.need.fusioncube.auth.status.not.auth"));
            row.add(this.getFusionCubeAuthCell(node, (DefaultTableRow<String, String>)tableRow));
            tableRow.setValues(row);
            tableRows.add((TableRow)tableRow);
        }
        return tableRows;
    }

    private static String getNoStripUUID() {
        UUID uuid = UUID.randomUUID();
        String str = uuid.toString();
        return str.replaceAll("-", "");
    }

    private Object getFusionCubeAuthCell(DevNode dev, DefaultTableRow<String, String> tableRow) {
        String operation = ResourceUtil.getString((String)"check.need.fusioncube.auth.button");
        return new IsmTableCell.HyperlinkCell(operation, (ActionListener)new FusionCubeAuthAction(dev, tableRow));
    }

    private static String buildNoAuthTipsInfo() {
        return ResourceUtil.getString((String)"check.need.fusioncube.auth.massege.head") + System.lineSeparator() + ResourceUtil.getString((String)"check.need.fusioncube.auth.massege.tailing");
    }

    private boolean isContinue(List<Object> result) {
        boolean isRight;
        if (!result.isEmpty() && !(isRight = ((Boolean)result.get(0)).booleanValue())) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)String.valueOf(result.get(1)));
            return false;
        }
        return true;
    }

    private File getReuqireCheckPyFile(List<DevNode> dpaDevices) throws ToolException {
        String pyScriptFilePath = InspectContext.getInstance().getProductByDevNode(dpaDevices.get(0)).getRequireCheckFile();
        return new File(AdanceCompileRemotePyScript.BASE_PATH + File.separator + pyScriptFilePath);
    }

    private JythonExecuter getJythonExecuter(File scriptFolder) {
        JythonExecuter jythonExecuter = new JythonExecuter(scriptFolder);
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("isInSvp", LocalHostUtil.isRunInSvp());
        env.put("allStrgHyprMtrLns", InspectContext.getInstance().getAllStrgHyprMtrLns());
        env.put("objectForPy", InspectContext.getInstance().getObjectForPy());
        env.put("lang", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
        env.put("hostLauncherWwnList", InspectContext.getInstance().getHostLauncherWwnList());
        jythonExecuter.set("py_java_env", env);
        return jythonExecuter;
    }

    private boolean dataValid(List<DevNode> selectDevs, JDialog mainDialog) {
        if (this.isDetachCheckAndHasNotDsStorage()) {
            DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.detach.check.only.distribute.storage"));
            return true;
        }
        if (!this.checkSelectDevNode(selectDevs) && !InspectUtils.isDpaInspectScene()) {
            DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.host.check"));
            return true;
        }
        return false;
    }

    private boolean isDetachCheckAndHasNotDsStorage() {
        if (!InspectContext.getInstance().isDetachCheck()) {
            return false;
        }
        return !this.getSelectDeviceCardLayout().getSelectedDevs().stream().allMatch(DevNode::isDsStorage);
    }

    private ToolWizardDialog.Card execCall(JDialog mainDialog, Future fu, List<CheckDevNode> checkDevNode) {
        Object result = null;
        try {
            result = fu.get();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.loadconfigerror"));
            return this;
        }
        if (!this.checkResult(mainDialog, result)) {
            return this;
        }
        List preFailRet = (List)WORKTAKER.get("exception_dev_nodes");
        if (checkDevNode.isEmpty() || !preFailRet.isEmpty()) {
            if (this.hasSnChangeDevNode(mainDialog, preFailRet) || this.hasFailDevNode(mainDialog, preFailRet)) {
                return this;
            }
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.loadconfigerror"));
            return this;
        }
        InspectContext.getInstance().setFinishHyperManualCheck(false);
        this.refreshDevTable();
        return InspectUIUtil.getNextCard(CardModelEnum.SELECTDEVICE, this);
    }

    private boolean hasFailDevNode(JDialog mainDialog, List<DevNode> devNodeList) {
        List failDevIps = devNodeList.stream().map(DevNode::getIp).map(xva$0 -> Arrays.asList(xva$0)).collect(Collectors.toList());
        if (failDevIps.isEmpty()) {
            return false;
        }
        String[] columnName = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devipaddress")};
        DialogUtils.showMultiWarningDialog((Window)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.loadconfigerror.with.detail"), (String[])columnName, failDevIps);
        return true;
    }

    private boolean hasSnChangeDevNode(JDialog mainDialog, List<DevNode> devNodeList) {
        String snChangeDevIps = devNodeList.stream().filter(this::judgeIfDevSnChange).map(DevNode::getIp).collect(Collectors.joining(", "));
        if (StringUtils.isNULLStr((String)snChangeDevIps)) {
            return false;
        }
        DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getStringWithParams((String)"inspsctor.wizard.selectdevice.dstoage.sn.change", (Object[])new Object[]{snChangeDevIps}));
        return true;
    }

    private boolean judgeIfDevSnChange(DevNode node) {
        return "sn_change_err".equals(node.getErrorDecs());
    }

    public Map<String, Map<String, String>> queryDevStatus(List<CheckDevNode> checkDevNodes) {
        List<com.huawei.ism.tool.obase.entity.CheckDevNode> newCheckDevNodes = this.getNeedQueryStatusDevNodes(checkDevNodes);
        Map<String, Object> devStatusInfo = new HashMap<String, ResultDevNode>();
        if (!newCheckDevNodes.isEmpty()) {
            String language = ApplicationContext.getInstance().getCurrentLanguage().toString();
            LOGGER.info("executer:{}_checkDevodes size:{}", (Object)language, (Object)newCheckDevNodes.size());
            BaseExecuter executer = new BaseExecuter(language, newCheckDevNodes);
            devStatusInfo = executer.queryDevStatus();
        }
        List<String> needsDebugDevs = WORKTAKER.initDebugPwdDevs();
        LOGGER.info("needsDebugDevs size:{}", (Object)needsDebugDevs.size());
        return this.buildResult(checkDevNodes, devStatusInfo, needsDebugDevs);
    }

    private Map<String, Map<String, String>> buildResult(List<CheckDevNode> checkDevNodes, Map<String, ResultDevNode> devStatusInfo, List<String> needsDebugDevs) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (CheckDevNode devNode : checkDevNodes) {
            List<CheckDevNode> allCheckNode = devNode.getAllCheckNode();
            if (allCheckNode.size() > 1) {
                CheckDevNode headCheckDevNode = allCheckNode.get(0);
                String headIp = headCheckDevNode.getDevNode().getIp();
                String headStatusInfo = this.getStatusInfo(devStatusInfo, needsDebugDevs, headCheckDevNode);
                HashMap<String, String> excludeHeadMTmp = new HashMap<String, String>();
                this.putExcludeData(devStatusInfo, needsDebugDevs, allCheckNode, excludeHeadMTmp);
                HashMap<String, String> mTmp = new HashMap<String, String>();
                this.putMtmpData(headIp, headStatusInfo, excludeHeadMTmp, mTmp);
                if (mTmp.isEmpty()) continue;
                result.put(headIp, mTmp);
                continue;
            }
            CheckDevNode checkDevNode = allCheckNode.get(0);
            String statusInfo = this.getStatusInfo(devStatusInfo, needsDebugDevs, checkDevNode);
            if (null == statusInfo) continue;
            HashMap<String, String> mTmp = new HashMap<String, String>();
            String ip = checkDevNode.getDevNode().getIp();
            mTmp.put(ip, statusInfo);
            result.put(ip, mTmp);
        }
        return result;
    }

    private void putMtmpData(String headIp, String headStatusInfo, Map<String, String> excludeHeadMTmp, Map<String, String> mTmp) {
        if (!excludeHeadMTmp.isEmpty()) {
            if (null != headStatusInfo) {
                mTmp.put(headIp, headStatusInfo);
                mTmp.putAll(excludeHeadMTmp);
            } else {
                mTmp.putAll(excludeHeadMTmp);
            }
        } else if (null != headStatusInfo) {
            mTmp.put(headIp, headStatusInfo);
        }
    }

    private void putExcludeData(Map<String, ResultDevNode> devStatusInfo, List<String> needsDebugDevs, List<CheckDevNode> allCheckNode, Map<String, String> excludeHeadMTmp) {
        for (int i = 1; i < allCheckNode.size(); ++i) {
            CheckDevNode checkDevNode = allCheckNode.get(i);
            String statusInfo = this.getStatusInfo(devStatusInfo, needsDebugDevs, checkDevNode);
            if (null == statusInfo) continue;
            excludeHeadMTmp.put(checkDevNode.getDevNode().getIp(), statusInfo);
        }
    }

    private String getStatusInfo(Map<String, ResultDevNode> devStatusInfo, List<String> needsDebugDevs, CheckDevNode checkDevNode) {
        String statusInfo = null;
        String devIp = checkDevNode.getDevNode().getIp();
        if (devStatusInfo.containsKey(checkDevNode.getDevNode().getIp())) {
            ResultDevNode resultDevNode = devStatusInfo.get(devIp);
            if (resultDevNode.isFlag()) {
                statusInfo = resultDevNode.getInfoMsg();
            }
            return statusInfo;
        }
        if (needsDebugDevs.contains(devIp)) {
            statusInfo = ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.needdebug");
        }
        return statusInfo;
    }

    private List<com.huawei.ism.tool.obase.entity.CheckDevNode> getNeedQueryStatusDevNodes(List<CheckDevNode> checkDevNodes) {
        ArrayList<com.huawei.ism.tool.obase.entity.CheckDevNode> newCheckDevNodes = new ArrayList<com.huawei.ism.tool.obase.entity.CheckDevNode>();
        for (CheckDevNode devNode : checkDevNodes) {
            File scriptFile;
            List<CheckDevNode> checkDevNodeChilders = devNode.getChildrens();
            if (checkDevNodeChilders.size() > 1) {
                newCheckDevNodes.addAll(this.getNeedQueryStatusDevNodes(checkDevNodeChilders));
            }
            if (null == (scriptFile = devNode.getScriptDir()) || !scriptFile.exists()) {
                LOGGER.warn("devNode scriptFile:" + scriptFile);
                continue;
            }
            File file = new File(devNode.getScriptDir().getParentFile(), "queryDevStatus.py");
            LOGGER.info("query path:{}", (Object)FilesUtil.getCanonicalPath((File)file));
            if (!file.exists()) continue;
            newCheckDevNodes.add(EntityUtils.toNewCheckDevNode((DevNode)devNode.getAllCheckNode().get(0).getDevNode(), (File)devNode.getScriptDir().getParentFile()));
        }
        return newCheckDevNodes;
    }

    private boolean checkResult(JDialog mainDialog, Object result) {
        if (InspectUtils.isPreExpEvaluation().booleanValue()) {
            DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
            if (null == devInfo) {
                DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.getinfo.error"));
                return false;
            }
            if (!devInfo.isSuccess()) {
                DialogUtils.showErrorDialog((JDialog)mainDialog, (String)devInfo.getErrMsg());
                return false;
            }
            String expType = InspectContext.getInstance().getExpScene();
            if ("expCtrl".equals(expType) && (null == devInfo.getExpSpec() || devInfo.getExpSpec().isEmpty())) {
                DialogUtils.showErrorDialog((JDialog)mainDialog, (String)devInfo.getErrMsg());
                return false;
            }
        }
        if (null == result) {
            return true;
        }
        if (result instanceof ToolException) {
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)((ToolException)((Object)result)).getErrorLocaleDescription());
            return false;
        }
        if (result instanceof Exception) {
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.loadconfigerror"));
            return false;
        }
        if (result instanceof List) {
            return this.showMultiInfoDialog((List)result, mainDialog);
        }
        return true;
    }

    public int getStep() {
        return this.getStep(CardModelEnum.SELECTDEVICE);
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step2");
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.Next == navigation) {
            if (null == this.selectDeviceCardLayout) {
                return false;
            }
            return this.selectDeviceCardLayout.getDeviceTable().getSelectedRowCount() != 0;
        }
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        if (!navigation.equals((Object)ToolWizardDialog.Navigation.Previous)) {
            return true;
        }
        String selectSeceneInSecondCard = InspectContext.getInstance().getSelectSeceneInSecondCard();
        if (selectSeceneInSecondCard.equals("") || selectSeceneInSecondCard.equals("realTimed_check")) {
            return true;
        }
        String msg = null;
        msg = selectSeceneInSecondCard.contains("T3000") ? "T3000" : ResourceUtil.getStringWithParams((String)"inspect.wizard.selectScene.fromPage2to1.UltraPath", (Object[])new Object[0]);
        WarningDialog chooseDialog = DialogUtils.showYesNoDialog((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getStringWithParams((String)"inspect.wizard.selectScene.fromPage2to1.warn", (Object[])new Object[]{msg}));
        int userChoice = chooseDialog.getValue();
        return 0 == userChoice;
    }

    public void fireNodeAdd(DevNode dev) throws ToolException {
    }

    public void fireNodeDelete(DevNode dev) throws ToolException {
    }

    public void fireNodeModify(DevNode dev) throws ToolException {
    }

    public static int getDevSupport() {
        return devSupport;
    }

    public SelectDeviceCardLayout getSelectDeviceCardLayout() {
        return this.selectDeviceCardLayout;
    }

    private boolean showMultiInfoDialog(List<List<ArrayList<Object>>> result, Window parent) {
        if (result.size() < 2 || result.get(0) == null || result.get(1) == null || result.get(0).isEmpty() && result.get(1).isEmpty()) {
            return true;
        }
        try {
            return this.prepareAndShowDialog(result, parent);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("show failed", (Throwable)e);
            return true;
        }
    }

    private boolean prepareAndShowDialog(List<List<ArrayList<Object>>> result, Window parent) {
        ConcurrentHashMap<String, Object> objectForPy = InspectContext.getInstance().getObjectForPy();
        HashMap<String, String> hostInfoMap = new HashMap<String, String>();
        InspectMultiInfoDialog multiInfoDialog = null;
        if (SceneUtils.isScene()) {
            result.set(0, new ArrayList());
        }
        List<DevNode> selectDevs = this.selectDeviceCardLayout.getSelectedDevs();
        String title = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.info");
        String[] table1Titles = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectitem.storage.name"), ResourceUtil.getString((String)"inspsctor.wizard.selectitem.storage.ipaddr"), ResourceUtil.getString((String)"inspsctor.wizard.selectitem.storage.sn"), ResourceUtil.getString((String)"inspsctor.wizard.selectitem.storage.remotesn")};
        String[] table2Titles = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectitem.host.name"), ResourceUtil.getString((String)"inspsctor.wizard.selectitem.host.wwn"), ResourceUtil.getString((String)"inspsctor.wizard.selectitem.host.linksn")};
        String[] msg1 = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectitem.device.info.msg")};
        String helpInfo = ResourceUtil.getString((String)"inspsctor.wizard.selectitem.device.info.msg.help");
        ArrayList table1Rows = new ArrayList();
        this.setTable1Row(result, table1Rows);
        ArrayList table2Rows = new ArrayList();
        this.setTable2Row(result, hostInfoMap, selectDevs, table2Rows);
        if (table2Rows.isEmpty()) {
            result.set(1, new ArrayList());
            hostInfoMap.clear();
        }
        objectForPy.put("notAddedHostsInfo", hostInfoMap);
        if (result.get(0).isEmpty() && result.get(1).isEmpty()) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("currently in scene scenario, all hosts has been added to inspect. not tip is shown. ");
            return true;
        }
        multiInfoDialog = this.getInspectMultiInfoDialog(result, parent, selectDevs, title, table1Titles, table2Titles, msg1, helpInfo, table1Rows, table2Rows);
        return multiInfoDialog.isOkPerformed();
    }

    private void setTable1Row(List<List<ArrayList<Object>>> result, List table1Rows) {
        for (ArrayList<Object> row : result.get(0)) {
            DefaultTableRow table1Row = new DefaultTableRow(4, (Object)"", (Object)StringUtils.getNoStripUUID());
            table1Row.setValues(row);
            table1Rows.add(table1Row);
        }
    }

    private void setTable2Row(List<List<ArrayList<Object>>> result, HashMap<String, String> hostInfoMap, List<DevNode> selectDevs, List table2Rows) {
        for (ArrayList<Object> row : result.get(1)) {
            boolean isAlreadyAdded = this.checkWhetherHostHasAdded(selectDevs, row);
            if (isAlreadyAdded) continue;
            DefaultTableRow table2Row = new DefaultTableRow(3, (Object)"", (Object)StringUtils.getNoStripUUID());
            String hostInfoStr = hostInfoMap.get(row.get(2).toString());
            if (null == hostInfoStr) {
                hostInfoStr = "";
            }
            hostInfoStr = hostInfoStr + System.lineSeparator() + row.get(0).toString() + ":" + row.get(1);
            hostInfoMap.put(row.get(2).toString(), hostInfoStr);
            table2Row.setValues(row);
            table2Rows.add(table2Row);
        }
    }

    private InspectMultiInfoDialog getInspectMultiInfoDialog(List<List<ArrayList<Object>>> result, Window parent, List<DevNode> selectDevs, String title, String[] table1Titles, String[] table2Titles, String[] msg1, String helpInfo, List table1Rows, List table2Rows) {
        InspectMultiInfoDialog multiInfoDialog;
        List<DevNode> failedQueryInfoHosts = this.getQueryHBAWwnFailedHost(selectDevs);
        if (!failedQueryInfoHosts.isEmpty()) {
            String[] msg2 = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectitem.host.info.2"), ResourceUtil.getStringWithParams((String)"inspsctor.wizard.selectitem.host.info.3", (Object[])new Object[]{String.valueOf(failedQueryInfoHosts.size())}), ResourceUtil.getString((String)"inspsctor.wizard.selectitem.host.info.4"), ResourceUtil.getString((String)"inspsctor.wizard.selectitem.host.info.5")};
            multiInfoDialog = new InspectMultiInfoDialog(parent, title, table1Titles, table2Titles, msg1, msg2, helpInfo, result, failedQueryInfoHosts);
        } else {
            String[] msg2 = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectitem.host.info.1")};
            multiInfoDialog = new InspectMultiInfoDialog(parent, title, table1Titles, table2Titles, msg1, msg2, helpInfo, result);
        }
        multiInfoDialog.getTopModel().setTableData(table1Rows.toArray(new TableRow[table1Rows.size()]));
        multiInfoDialog.getBotModel().setTableData(table2Rows.toArray(new TableRow[table2Rows.size()]));
        if (ApplicationContext.getInstance().isSpecificDeviceMode()) {
            this.selectDeviceCardLayout.getAddDevDes().setVisible(this.showSvpAddDevice(SelectDeviceCard.getDevManagerList()));
            this.refreshDevTable();
        }
        this.fetchHostStorageAssociation(result);
        multiInfoDialog.setVisible(true);
        return multiInfoDialog;
    }

    private void fetchHostStorageAssociation(List<List<ArrayList<Object>>> result) {
        List hostNodeList = DefaultNodeProviderImpl.getInstance().getHostNodeList();
        for (DevNode devNode : hostNodeList) {
            devNode.getHostAssociatedRemoteSN().clear();
        }
        for (ArrayList arrayList : result.get(1)) {
            for (DevNode host : hostNodeList) {
                List fcWwns = host.getHostFCLauncherWwns();
                List iscsiWwns = host.getHostISCSILauncherWwns();
                List nvmeWwns = host.getHostNvmeLauncherWwns();
                if (!this.isListElementInList(fcWwns, arrayList, host) && !this.isListElementInList(iscsiWwns, arrayList, host) && !this.isListElementInList(nvmeWwns, arrayList, host)) continue;
                String associatedRemoteSN = arrayList.get(2).toString();
                host.getHostAssociatedRemoteSN().add(associatedRemoteSN);
            }
        }
    }

    private List<DevNode> getQueryHBAWwnFailedHost(List<DevNode> selectDevs) {
        ArrayList<DevNode> failedHosts = new ArrayList<DevNode>();
        for (DevNode devNode : selectDevs) {
            if (null != devNode.getHostFCLauncherWwns() || null != devNode.getHostISCSILauncherWwns() || null != devNode.getHostNvmeLauncherWwns()) continue;
            failedHosts.add(devNode);
        }
        return failedHosts;
    }

    private boolean checkWhetherHostHasAdded(List<DevNode> selectDevs, ArrayList row) {
        for (DevNode selectDev : selectDevs) {
            List fcWwns = selectDev.getHostFCLauncherWwns();
            if (this.isListElementInList(fcWwns, row, selectDev)) {
                return true;
            }
            List iscsiWwns = selectDev.getHostISCSILauncherWwns();
            if (this.isListElementInList(iscsiWwns, row, selectDev)) {
                return true;
            }
            List nvmeWwns = selectDev.getHostNvmeLauncherWwns();
            if (!this.isListElementInList(nvmeWwns, row, selectDev)) continue;
            return true;
        }
        return false;
    }

    private boolean isListElementInList(List<String> left, List destination, DevNode selectDev) {
        if (null != left && !left.isEmpty()) {
            for (String element : left) {
                if (!destination.toString().toUpperCase(Locale.ENGLISH).contains(element.toUpperCase(Locale.ENGLISH))) continue;
                return true;
            }
        }
        return false;
    }

    public static int getRealDealCount(List<DevNode> selectDevs) {
        int count = 0;
        for (DevNode devNode : selectDevs) {
            Product product = null;
            try {
                if (devNode.isLikeDsStorage()) continue;
                product = InspectContext.getInstance().getProductByDevNode(devNode);
            }
            catch (ToolException e) {
                LOGGER.error("getproduct failed.", (Throwable)e);
                continue;
            }
            if (null != product && !StringUtils.isNULLStr((String)product.getRequireCheckFile())) {
                ++count;
            }
            if (null == product || !product.getProductResolver().getClass().getSuperclass().equals(ArrayProductParser.class)) continue;
            ++count;
        }
        LOGGER.info("realDealCount: {}", (Object)count);
        return count;
    }

    public void addDevRow(String sn, TableRow<?, ?> row) {
        InspectContext.getInstance().addRow(sn, row);
        this.selectDeviceCardLayout.getTableModel().addRow(new TableRow[]{row});
    }

    public void removeDevRow(String sn, TableRow<?, ?> row) {
        InspectContext.getInstance().removeRow(sn);
        this.selectDeviceCardLayout.getTableModel().removeRow(new TableRow[]{row});
    }

    public boolean checkSelectDevNode(List<DevNode> selectDevs) {
        if (selectDevs.size() == 1) {
            return selectDevs.get(0).getItDeviceType() != ItDeviceType.Host;
        }
        for (DevNode devNode : selectDevs) {
            if (!ItDeviceType.Host.equals((Object)devNode.getItDeviceType())) continue;
            return this.checkIsHyperMetro(devNode, selectDevs);
        }
        return true;
    }

    private void popUpMultiErrorMsgs(List<String> errMsgList) {
        if (null != errMsgList && !errMsgList.isEmpty()) {
            StringBuilder errMsgBuilder = new StringBuilder();
            for (String err : errMsgList) {
                errMsgBuilder.append(err).append(System.lineSeparator());
            }
            DialogUtils.showErrorDialog(null, (String)errMsgBuilder.toString());
        }
    }

    private boolean checkIsHyperMetro(DevNode devNode, List<DevNode> selectDevs) {
        for (DevNode node : selectDevs) {
            if (!node.isHyperMetro() || node == devNode) continue;
            return true;
        }
        return false;
    }

    public boolean showSvpAddDevice(List<DevNode> devNodes) {
        for (DevNode devNode : devNodes) {
            if (!devNode.isHyperMetro()) continue;
            return true;
        }
        return false;
    }
}

