/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.logic.inspector.HardwarePreInspectCallable;
import com.huawei.ism.tool.inspect.logic.inspector.HardwarePreInspectResultCallable;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.PerformSoftInspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.SelectHardwareItemCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.SelectSoftItemCard;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.ScrollCardUiUtil;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectHardwareItemCard
extends InspectCard {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectHardwareItemCard.class);
    private static final int MAX_INSPECT_NUM = 10;
    private final SelectHardwareItemCardLayout selectHardwareItemCardLayout;
    private final List<CheckDevNode> checkDevNodes = CheckItemUtils.getSortedCheckNodes(WORKTAKER);
    private boolean skip = false;

    public SelectHardwareItemCard(ToolWizardDialog.Card preCard, ToolWizardDialog.Navigation[] navigations) {
        super(preCard, navigations);
        this.selectHardwareItemCardLayout = new SelectHardwareItemCardLayout(this);
        this.addLayout(this.selectHardwareItemCardLayout);
        this.updateNavigationBar();
    }

    @Override
    public void initData() {
        this.selectHardwareItemCardLayout.initData(this.checkDevNodes);
    }

    protected ToolWizardDialog.Card getNextCard() {
        if (!this.hasSelectedItem()) {
            return this;
        }
        if (this.skip) {
            this.deleteSoftInspectReport();
            return InspectUIUtil.getNextCard(CardModelEnum.AUTH_CLUSTER_NODES, this);
        }
        if (!InspectUIUtil.displaySignatureBox()) {
            return this;
        }
        if (!this.noticeKeepOsNetConnection()) {
            return this;
        }
        if (!this.preInspect()) {
            return this;
        }
        return InspectUIUtil.getNextCard(CardModelEnum.SELECT_HARDWARE_ITEM, this);
    }

    private boolean noticeKeepOsNetConnection() {
        if (this.getSelectCheckNodes().stream().allMatch(checkDevNode -> CheckItemUtils.getPreCheckItems(checkDevNode).isEmpty())) {
            return true;
        }
        WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspsctor.wizard.hardware.comfirm.is.os.network"), (boolean)false);
        int userOption = warningDialog.getValue();
        log.info("user choose in os net option:{}", (Object)userOption);
        return userOption == 0;
    }

    private void deleteSoftInspectReport() {
        Optional<PerformSoftInspectCard> softCard = this.getSoftInspectCard(this.getPreviousCard());
        if (!softCard.isPresent()) {
            return;
        }
        File reportFile = softCard.get().getReportFile();
        if (Objects.isNull(reportFile)) {
            return;
        }
        if (reportFile.exists()) {
            log.info("delete soft report file");
            FileUtils.deleteFile((File)reportFile);
        }
    }

    private Optional<PerformSoftInspectCard> getSoftInspectCard(ToolWizardDialog.Card previousCard) {
        if (Objects.isNull(previousCard)) {
            return Optional.empty();
        }
        if (previousCard instanceof PerformSoftInspectCard) {
            return Optional.of((PerformSoftInspectCard)previousCard);
        }
        return this.getSoftInspectCard(previousCard.getPreviousCard());
    }

    private boolean preInspect() {
        List<Future<Object>> res = this.executePreInspect();
        return this.waitResult(res);
    }

    private boolean waitResult(List<Future<Object>> res) {
        Future<Object> waitTaskResult = this.waitingResultForPreInspect(res);
        try {
            waitTaskResult.get();
            return true;
        }
        catch (InterruptedException | ExecutionException interruptedException) {
            log.error("pre inspect failed...", (Throwable)interruptedException);
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.loadconfigerror"));
            return false;
        }
    }

    private List<Future<Object>> executePreInspect() {
        ExecutorService executorService = ThreadPoolHelper.getFixedNumThreadPool((int)10, (String)"inspector_thread_pool");
        try {
            List<Future<Object>> list = this.getSelectCheckNodes().stream().map(checkDevNode -> executorService.submit(new HardwarePreInspectCallable((CheckDevNode)checkDevNode))).collect(Collectors.toList());
            return list;
        }
        finally {
            executorService.shutdown();
        }
    }

    private Future<Object> waitingResultForPreInspect(List<Future<Object>> res) {
        ProgressDialog waitingDialog = new ProgressDialog((Window)InspectContext.getInstance().getMainDialog());
        Future submit = AsyncExcutor.submit((Callable)new HardwarePreInspectResultCallable(res, waitingDialog));
        if (waitingDialog.isDisplayable()) {
            waitingDialog.setVisible(true);
        }
        return submit;
    }

    private List<CheckDevNode> getSelectCheckNodes() {
        ListOrderedMap<String, List<CheckDevNode>> result = InspectUtils.classifyDevs(this.checkDevNodes);
        return InspectUtils.getAllDevs(result);
    }

    public int getStep() {
        return this.getStep(CardModelEnum.SELECT_HARDWARE_ITEM);
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step4.soft.check");
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        this.skip = ToolWizardDialog.Navigation.Skip.equals((Object)navigation);
        this.changeHardwareItemSelect(navigation);
        return true;
    }

    private void changeHardwareItemSelect(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.Next.equals((Object)navigation)) {
            this.selectHardwareItemCardLayout.selectAllHardwareItem();
            return;
        }
        if (!(this.skip || ToolWizardDialog.Navigation.Previous.equals((Object)navigation) && this.getPreviousCard() instanceof SelectSoftItemCard)) {
            return;
        }
        this.selectHardwareItemCardLayout.unSelectAllHardwareItem();
    }

    private boolean hasSelectedItem() {
        List<String> notOneCheckNodes;
        List<String> list = notOneCheckNodes = this.skip ? this.getNoOneCheckNodes() : this.getHardwareNoCheckNodes();
        if (!notOneCheckNodes.isEmpty()) {
            ScrollCardUiUtil.showNoSelectItemDialog(notOneCheckNodes);
            return false;
        }
        return true;
    }

    private List<String> getNoOneCheckNodes() {
        List<String> softNoCheckNodes = this.getSoftNoCheckNodes();
        List<String> hardwareNoCheckNodes = this.getHardwareNoCheckNodes();
        softNoCheckNodes.retainAll(hardwareNoCheckNodes);
        return softNoCheckNodes;
    }

    private List<String> getHardwareNoCheckNodes() {
        return this.skip ? this.countAllNode() : CheckItemUtils.getHardwareNoCheckNodes(this.checkDevNodes);
    }

    private List<String> getSoftNoCheckNodes() {
        return this.skippedSoftCheckItem() ? this.countAllNode() : CheckItemUtils.getSoftNoCheckNodes(this.checkDevNodes);
    }

    private List<String> countAllNode() {
        ArrayList<String> noSelectNodeIp = new ArrayList<String>();
        this.checkDevNodes.forEach(checkDevNode -> checkDevNode.getAllCheckNode().forEach(devNode -> noSelectNodeIp.add(devNode.getDevNode().getIp())));
        return noSelectNodeIp;
    }

    private boolean skippedSoftCheckItem() {
        ToolWizardDialog.Card previousCard = this.getPreviousCard();
        while (Objects.nonNull(previousCard)) {
            if (previousCard instanceof SelectSoftItemCard) {
                return ((SelectSoftItemCard)previousCard).isSkip();
            }
            previousCard = previousCard.getPreviousCard();
        }
        return false;
    }
}

