/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.ui.wizard.FirstCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.SelectHardwareItemCard;
import com.huawei.ism.tool.inspect.ui.wizard.model.CheckItemDataModel;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.utils.ScrollCardUiUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class SelectHardwareItemCardLayout
extends FirstCardLayout {
    private JScrollPane deviceScroll;
    private JScrollPane itemScroll;
    private SelectHardwareItemCard selectItemCard;
    private final transient CheckItemDataModel checkItemDataModel = new CheckItemDataModel();

    public SelectHardwareItemCardLayout(SelectHardwareItemCard selectHardwareItemCard) {
        this.setCard(selectHardwareItemCard);
        JComponent view = this.initUI();
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)0), "Center");
    }

    private void initScroll() {
        this.deviceScroll = new JScrollPane();
        this.itemScroll = new JScrollPane();
        ScrollCardUiUtil.setScrollPaneSize(this.deviceScroll, this.itemScroll);
    }

    private JComponent initUI() {
        this.initScroll();
        JLabel rightLabel = this.checkItemDataModel.getRightLabel();
        JComponent rightLabelAuthBox = UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)rightLabel)});
        return ScrollCardUiUtil.createCheckItemScrollUI(this.deviceScroll, this.itemScroll, rightLabelAuthBox, this.checkItemDataModel.getModifyLbl(), this.checkItemDataModel.getApplyBtn());
    }

    public void initData(List<CheckDevNode> checkDevNodes) {
        this.checkItemDataModel.initData(checkDevNodes, this.selectItemCard, checkItem -> Objects.nonNull(checkItem) && !checkItem.isHardWareCheckItem());
        this.setScrollData();
    }

    private void setCard(SelectHardwareItemCard selectHardwareItemCard) {
        this.selectItemCard = selectHardwareItemCard;
    }

    private void setScrollData() {
        this.checkItemDataModel.setCardData(this.deviceScroll, this.itemScroll);
    }

    @Override
    public JComponent getDescPanel() {
        return this;
    }

    @Override
    public String getTittle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step4.hardware.check");
    }

    public void unSelectAllHardwareItem() {
        CheckItemUtils.changeAllItemSelectStatus(false, this.checkItemDataModel.getCheckNodes(), CheckItem.ItemCheckType.HARDWARE);
    }

    public void selectAllHardwareItem() {
        CheckItemUtils.changeAllItemSelectStatus(true, this.checkItemDataModel.getCheckNodes(), CheckItem.ItemCheckType.HARDWARE);
    }
}

