/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.logic.config.TagCondition;
import com.huawei.ism.tool.inspect.ui.dialogs.DevicesModifyDialog;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.SelectItemCardLayout;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.TextInputDialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectItemCard
extends InspectCard {
    private static final long serialVersionUID = 199630063526238187L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectItemCard.class);
    private SelectItemCardLayout selectItemCardLayout;
    private List<String> needsDebugDevs = new ArrayList<String>();
    private List<CheckDevNode> checkDevNodes = this.sort((List)WORKTAKER.get("check_dev_nodes"));

    public SelectItemCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        InspectUIUtil.removeOtherZoneInnerCheckItems(this.checkDevNodes);
        this.selectItemCardLayout = new SelectItemCardLayout(this.checkDevNodes, this);
        this.addLayout(this.selectItemCardLayout);
        this.updateNavigationBar();
    }

    private List<CheckDevNode> sort(List<CheckDevNode> nodeList) {
        ArrayList<CheckDevNode> list = new ArrayList<CheckDevNode>();
        ArrayList<CheckDevNode> listTemp = new ArrayList<CheckDevNode>();
        for (CheckDevNode checkDevNode : nodeList) {
            if (checkDevNode.getDevNode() != null && checkDevNode.getDevNode().isDsStorage()) {
                list.add(checkDevNode);
                continue;
            }
            listTemp.add(checkDevNode);
        }
        for (CheckDevNode checkDevNode : listTemp) {
            list.add(checkDevNode);
        }
        return list;
    }

    @Override
    public void initData() {
        this.selectItemCardLayout.initData();
    }

    protected ToolWizardDialog.Card getNextCard() {
        DevicesModifyDialog dialog;
        if (!this.hasSelectItem()) {
            return this;
        }
        if (!this.displaySignatureBox()) {
            return this;
        }
        List<DevNode> rootDevNodes = this.hasShellItemAndRoot();
        if (!rootDevNodes.isEmpty() && 0 == (dialog = new DevicesModifyDialog((Window)InspectContext.getInstance().getMainDialog(), ResourceUtil.getString((String)"inspect.modify.noticeInfo"), rootDevNodes, true)).getExistCode()) {
            return this;
        }
        String chooseIpStr = this.selectItemCardLayout.getChooseIpStr();
        LOGGER.info("Inspect next step >> Choose device {} inpsection items][Success", (Object)chooseIpStr);
        WORKTAKER.initDebugPwdDevs();
        return InspectUIUtil.getNextCard(CardModelEnum.SELECTITEM, this);
    }

    private boolean displaySignatureBox() {
        if ((InspectUtils.isBureauCheckInspect() || "bureau_check".equals(InspectContext.getInstance().getSelectSceneId())) && StringUtils.isNULLStr((String)InspectContext.getInstance().getQualityCheckUser())) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            TextInputDialog textInputDialog = DialogUtils.createTextInputDialog((JDialog)mainDialog);
            if (textInputDialog.getCloseEventValue() == 0) {
                InspectContext.getInstance().setQualityCheckUser(textInputDialog.getInputTextValue());
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean checkResult(JDialog mainDialog, Object result) {
        if (null == result) {
            return true;
        }
        if (result instanceof ToolException) {
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)((ToolException)((Object)result)).getErrorLocaleDescription());
            return false;
        }
        if (result instanceof Exception) {
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.loadconfigerror"));
            return false;
        }
        if (result instanceof Map) {
            IDeviceManageUI connUi = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
            return connUi.showMultiInfoDialog((Map)result, (Window)mainDialog, true);
        }
        return true;
    }

    private boolean hasSelectItem() {
        Object obj = WORKTAKER.get("check_dev_nodes");
        if (null == obj) {
            return false;
        }
        ArrayList<String> noSelectNodeIp = new ArrayList<String>();
        List nodes = (List)obj;
        for (CheckDevNode devNodes : nodes) {
            for (CheckDevNode dev : devNodes.getAllCheckNode()) {
                Collection<List<CheckItem>> checkItems = dev.getCheckItems().values();
                if (this.hasSelect(checkItems)) continue;
                noSelectNodeIp.add(dev.getDevNode().getIp());
            }
        }
        if (!noSelectNodeIp.isEmpty()) {
            String devs = StringUtils.deleteFirstLast((String)((Object)noSelectNodeIp).toString());
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getStringWithParams((String)"inspsctor.wizard.selectitem.nocheckitemselect", (Object[])new Object[]{SelectItemCard.enComma2zhComma(devs)}));
        }
        return noSelectNodeIp.isEmpty();
    }

    private List<DevNode> hasShellItemAndRoot() {
        Object obj = WORKTAKER.get("check_dev_nodes");
        ArrayList<DevNode> rootDevNodes = new ArrayList<DevNode>();
        if (null == obj) {
            return rootDevNodes;
        }
        ArrayList<CheckDevNode> hasShellItemNodes = new ArrayList<CheckDevNode>();
        List nodes = (List)obj;
        block0: for (CheckDevNode devNodes : nodes) {
            for (CheckDevNode dev : devNodes.getAllCheckNode()) {
                Collection<List<CheckItem>> checkItems = dev.getCheckItems().values();
                if (!this.hasShellItem(checkItems)) continue;
                hasShellItemNodes.add(devNodes);
                continue block0;
            }
        }
        if (!hasShellItemNodes.isEmpty()) {
            for (CheckDevNode devNodes : hasShellItemNodes) {
                Map map = (Map)InspectContext.getInstance().getInspectWorktaker().get("ssh_root_devs");
                if (null != map && null != map.get(devNodes.getDevNode().getDeviceSerialNumber())) {
                    rootDevNodes.add((DevNode)map.get(devNodes.getDevNode().getDeviceSerialNumber()));
                    continue;
                }
                DevNode oldDevNode = devNodes.getDevNode();
                DevNode dStorageRootDevNode = new DevNode();
                String sn = oldDevNode.getDeviceSerialNumber();
                dStorageRootDevNode.setDeviceSerialNumber(sn);
                dStorageRootDevNode.setProductVersion(oldDevNode.getProductVersion());
                dStorageRootDevNode.setDeviceType(oldDevNode.getDeviceType());
                dStorageRootDevNode.setDeviceName(oldDevNode.getDeviceName());
                dStorageRootDevNode.setIp(oldDevNode.getIp());
                dStorageRootDevNode.setSshForwardList(oldDevNode.getSshForwardList());
                dStorageRootDevNode.setSocks5Proxy(oldDevNode.getSocks5Proxy());
                rootDevNodes.add(dStorageRootDevNode);
            }
        }
        return rootDevNodes;
    }

    private boolean hasShellItem(Collection<List<CheckItem>> checkItems) {
        for (List<CheckItem> items : checkItems) {
            for (CheckItem item : items) {
                if (StringUtils.isNULLStr((String)item.getDstorageShellPath()) || !item.isEnable()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasSelect(Collection<List<CheckItem>> checkItems) {
        for (List<CheckItem> items : checkItems) {
            for (CheckItem item : items) {
                if (TagCondition.hasTag(item.getTag(), "HIDDEN") || !item.isEnable()) continue;
                return true;
            }
        }
        return false;
    }

    public static String enComma2zhComma(String str) {
        String enComma = ",";
        String zhComma = "\uff0c";
        if (StringUtils.isNULLStr((String)str)) {
            return "";
        }
        if (!ApplicationContext.getInstance().isEnglishEnv() && str.contains(enComma)) {
            return str.replaceAll(enComma, zhComma);
        }
        return str;
    }

    public int getStep() {
        return this.getStep(CardModelEnum.SELECTITEM);
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step4");
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    public List<String> getNeedsDebugDevs() {
        return this.needsDebugDevs;
    }
}

