/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.SelectSoftItemCardLayout;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.ScrollCardUiUtil;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectSoftItemCard
extends InspectCard {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectSoftItemCard.class);
    private final SelectSoftItemCardLayout selectSoftItemCardLayout;
    private final List<CheckDevNode> checkDevNodes = CheckItemUtils.getSortedCheckNodes(WORKTAKER);
    private boolean skip = false;

    public SelectSoftItemCard(ToolWizardDialog.Card preCard, ToolWizardDialog.Navigation[] navigations) {
        super(preCard, navigations);
        this.selectSoftItemCardLayout = new SelectSoftItemCardLayout();
        this.addLayout(this.selectSoftItemCardLayout);
        this.updateNavigationBar();
    }

    @Override
    public void initData() {
        this.selectSoftItemCardLayout.initData(this.checkDevNodes, this);
    }

    protected ToolWizardDialog.Card getNextCard() {
        InspectContext.getInstance().setInspectStep(this.getStep());
        if (!this.skip && !this.hasSelectItem()) {
            return this;
        }
        if (!this.skip && !InspectUIUtil.displaySignatureBox()) {
            return this;
        }
        return InspectUIUtil.getNextCard(this.skip ? CardModelEnum.PERFORM_SOFT_INSPECT : CardModelEnum.SELECT_SOFT_ITEM, this);
    }

    private boolean hasSelectItem() {
        List<String> softNoCheckNodes = CheckItemUtils.getSoftNoCheckNodes(this.checkDevNodes);
        if (softNoCheckNodes.isEmpty()) {
            return true;
        }
        ScrollCardUiUtil.showNoSelectItemDialog(softNoCheckNodes);
        return false;
    }

    public int getStep() {
        return this.getStep(CardModelEnum.SELECT_SOFT_ITEM);
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step4.soft.check");
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.Skip.equals((Object)navigation)) {
            this.skip = true;
            this.selectSoftItemCardLayout.unSelectAllSoftItem();
        } else {
            this.selectSoftItemCardLayout.selectAllSoftItem();
            this.skip = false;
        }
        return true;
    }

    @Generated
    public boolean isSkip() {
        return this.skip;
    }
}

