/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.ui.wizard.FirstCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.SelectSoftItemCard;
import com.huawei.ism.tool.inspect.ui.wizard.model.CheckItemDataModel;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.utils.ScrollCardUiUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectSoftItemCardLayout
extends FirstCardLayout {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectSoftItemCardLayout.class);
    private JScrollPane deviceScroll;
    private JScrollPane itemScroll;
    private SelectSoftItemCard selectItemCard;
    private final transient CheckItemDataModel checkItemDataModel = new CheckItemDataModel();

    public SelectSoftItemCardLayout() {
        JComponent view = this.initUI();
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)0), "Center");
    }

    private void initScroll() {
        this.deviceScroll = new JScrollPane();
        this.itemScroll = new JScrollPane();
        ScrollCardUiUtil.setScrollPaneSize(this.deviceScroll, this.itemScroll);
    }

    private JComponent initUI() {
        this.initScroll();
        return ScrollCardUiUtil.createCheckItemScrollUI(this.deviceScroll, this.itemScroll, this.checkItemDataModel.getRightLabel(), this.checkItemDataModel.getModifyLbl(), this.checkItemDataModel.getApplyBtn());
    }

    private boolean filterItem(CheckItem checkItem) {
        return Objects.nonNull(checkItem) && checkItem.isHardWareCheckItem();
    }

    public void initData(List<CheckDevNode> checkDevNodes, SelectSoftItemCard selectSoftItemCard) {
        this.setCard(selectSoftItemCard);
        this.checkItemDataModel.initData(checkDevNodes, this.selectItemCard, this::filterItem);
        this.setScrollData();
    }

    private void setCard(SelectSoftItemCard selectSoftItemCard) {
        this.selectItemCard = selectSoftItemCard;
    }

    private void setScrollData() {
        this.checkItemDataModel.setCardData(this.deviceScroll, this.itemScroll);
    }

    @Override
    public JComponent getDescPanel() {
        return this;
    }

    @Override
    public String getTittle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step4.soft.check");
    }

    public void unSelectAllSoftItem() {
        this.changeSelectStatus(false);
    }

    public void selectAllSoftItem() {
        this.changeSelectStatus(true);
    }

    private void changeSelectStatus(boolean select) {
        CheckItemUtils.changeAllItemSelectStatus(select, this.checkItemDataModel.getCheckNodes(), CheckItem.ItemCheckType.SOFT);
    }
}

