/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.SetResultSaveCardLayout;
import com.huawei.ism.tool.inspect.utils.FileAssistant;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.InfoDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.ui.swing.text.validator.NotEmptyInputValidator;
import com.huawei.ism.ui.swing.text.validator.RegexInputValidator;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetResultSaveCard
extends InspectCard {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SetResultSaveCard.class);
    public static final String VERSION_REG = "(?i)^(\\d\\.){3}(SPH|SPC)\\d{3}|^(\\d\\.){3}(HP)\\d{1,3}|^\\d(\\.\\d){2,3}|8.2.0L15Y01|8.2.0L15Y01.(SPH|SPC)\\d{3}|\\d(\\.\\d){2}(RC)\\d{1}|\\d(\\.\\d){2}(RC)\\d{1}(\\.SPH)\\d{3}";
    private static final long serialVersionUID = -5920558473168851114L;
    private static final String BOM_CODE = "[0-9A-Za-z.]*";
    private static final int MAX_LENGTH_CAP = 20;
    private final Map<CheckDevNode, IsmTextField> textCheckInputs = new HashMap<CheckDevNode, IsmTextField>();
    private SetResultSaveCardLayout setResultSaveCardLayout;

    public SetResultSaveCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        this.initTableData();
        this.addLayout(this.setResultSaveCardLayout);
        this.updateNavigationBar();
    }

    private void initTableData() {
        List<CheckDevNode> checkDevNodes = this.getPreUpgradeCheckDevs();
        if (checkDevNodes.isEmpty() || this.isA800DpcUpgrade()) {
            this.setResultSaveCardLayout = new SetResultSaveCardLayout(this, (Boolean)false);
            return;
        }
        this.setResultSaveCardLayout = new SetResultSaveCardLayout(this, (Boolean)true);
        if (SceneUtils.isScene()) {
            this.setResultSaveCardLayout.getPathTextArea().setEnabled(false);
            this.setResultSaveCardLayout.getPathBrows().setEnabled(false);
        }
        checkDevNodes.stream().map(this::createRow).forEach(row -> this.setResultSaveCardLayout.getTableModel().addRow(new TableRow[]{row}));
    }

    private boolean isA800DpcUpgrade() {
        return InspectUtils.isDistributedBatchUpgrade() && SceneUtils.isA800SceneInTool();
    }

    private TableRow<?, ?> createRow(CheckDevNode node) {
        DefaultTableRow row = new DefaultTableRow(this.setResultSaveCardLayout.getTableHeader().length, (Object)node, (Object)node);
        int i = 0;
        IsmTextField versionTextField = IsmTextField.getNameLengthTextField((String)BOM_CODE, (String)"", (int)20, (int)0);
        versionTextField.addInputValidator((InputValidator)new NotEmptyInputValidator());
        versionTextField.addInputValidator((InputValidator)new RegexInputValidator(VERSION_REG, "", ""));
        versionTextField.setToolTipText(ResourceUtil.getString((String)"inspect.wizard.strategysetting.version.input.tip"));
        this.textCheckInputs.put(node, versionTextField);
        row.setValueAt(i++, (Object)node.getDevNode().getProductModel());
        row.setValueAt(i++, (Object)node.getDevNode().getDisplayProductVersion());
        row.setValueAt(i++, (Object)node.getDevNode().getDeviceName());
        row.setValueAt(i++, (Object)new IpAddressStrategy(node.getDevNode().getIp()));
        row.setValueAt(i++, (Object)new IsmTableCell.MsgTextCell((JTextField)versionTextField, "", ""));
        return row;
    }

    private List<CheckDevNode> getPreUpgradeCheckDevs() {
        return WORKTAKER.getCheckDevNodes().stream().filter(InspectUIUtil::isNeedPreUpgradeTable).collect(Collectors.toList());
    }

    private boolean checkInput() {
        ArrayList<IsmTextField> textCheckInput = new ArrayList<IsmTextField>(this.textCheckInputs.values());
        List errText = textCheckInput.stream().filter(textField -> textField.validateInput() != null).collect(Collectors.toList());
        if (errText.isEmpty()) {
            return true;
        }
        List errInput = errText.stream().map(JTextComponent::getText).collect(Collectors.toList());
        if (errInput.contains("")) {
            String errTips = ResourceUtil.getString((String)"inspect.wizard.strategysetting.version.empty_error");
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)errTips);
            return false;
        }
        String errTips = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.version.error", (Object[])new Object[]{String.join((CharSequence)", ", new HashSet(errInput))});
        WarningDialog wd = DialogUtils.showYesNoDialog((Window)InspectContext.getInstance().getMainDialog(), (String)errTips);
        return wd.getValue() == 0;
    }

    protected ToolWizardDialog.Card getNextCard() {
        if (!this.checkInput()) {
            return this;
        }
        if (!this.isModeSelected()) {
            return this;
        }
        if (!this.checkOnceNodeNumberInput()) {
            return this;
        }
        if (!FileAssistant.checkPatch(InspectContext.getInstance().getMainDialog(), this.setResultSaveCardLayout.getPathTextArea().getText())) {
            return this;
        }
        String savePath = this.setResultSaveCardLayout.getPathTextArea().getText();
        this.textCheckInputs.forEach((key1, value1) -> key1.setTargetVersion(value1.getText()));
        File retFile = new File(FilePathUtils.checkFile((String)savePath));
        WORKTAKER.put("check_savepath", retFile.getParent());
        WORKTAKER.put("check_savepath_filename", retFile.getName());
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            InspectContext.getInstance().getMainDialog().pack();
        }
        return InspectUIUtil.getNextCard(CardModelEnum.SETRESULT, this);
    }

    private boolean checkOnceNodeNumberInput() {
        boolean isNeedNodeBatchInput = WORKTAKER.getCheckDevNodes().stream().anyMatch(CheckDevNode::isNeedBatchInspect);
        if (!isNeedNodeBatchInput) {
            return true;
        }
        boolean isStorageValid = this.checkStorageInputNumber();
        boolean isComputeValid = this.checkComputeInputNumber();
        if (!isStorageValid || !isComputeValid) {
            this.showNodeInputErrorDialog(isStorageValid, isComputeValid);
            return false;
        }
        InspectContext.getInstance().getInspectionGradientGuidance().setStorageInputNumber(Integer.parseInt(this.setResultSaveCardLayout.getBatchInputBox().getStorageInputField().getText()));
        InspectContext.getInstance().getInspectionGradientGuidance().setComputeInputNumber(Integer.parseInt(this.setResultSaveCardLayout.getBatchInputBox().getComputeInputField().getText()));
        return true;
    }

    private void showNodeInputErrorDialog(boolean isStorageValid, boolean isComputeValid) {
        StringBuilder errorMsgBuilder = new StringBuilder();
        if (!isStorageValid) {
            errorMsgBuilder.append(ResourceUtil.getStringWithParams((String)"dsstorage.batch.inspect.once.storage.node.input.error.msg", (Object[])new Object[]{InspectConstans.MAX_ONCE_STORAGE_NUM})).append(System.lineSeparator());
        }
        if (!isComputeValid) {
            errorMsgBuilder.append(ResourceUtil.getStringWithParams((String)"dsstorage.batch.inspect.once.compute.node.input.error.msg", (Object[])new Object[]{InspectConstans.MAX_ONCE_COMPUTE_NUM}));
        }
        DialogUtils.showYesDialog((Window)InspectContext.getInstance().getMainDialog(), (String)errorMsgBuilder.toString());
    }

    private boolean isModeSelected() {
        if (InspectUtils.isSceneNeedRecord(WORKTAKER)) {
            if (!this.isSelectExecuteMode()) {
                DialogUtils.showYesDialog((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.execute.mode"));
                return false;
            }
            if (!this.checkNumberOfConcurrent()) {
                DialogUtils.showYesDialog((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.execute.inspect.num.set.error"));
                return false;
            }
            InspectContext.getInstance().getInspectionGradientGuidance().setInspectNum(Integer.parseInt(this.setResultSaveCardLayout.getConcurrentQuantityJTF().getText()));
            if (!this.setResultSaveCardLayout.getNormalMode().isSelected()) {
                return true;
            }
            List recordDeviceIps = WORKTAKER.getCheckDevNodes().stream().filter(CheckDevNode::isDistributed).filter(node -> !InspectUtils.isRecordSnToLocal(node.getDevNode().getDeviceSerialNumber())).map(node -> node.getDevNode().getIp()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(recordDeviceIps)) {
                String snToShow = String.join((CharSequence)System.lineSeparator(), recordDeviceIps);
                String showInfo = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.setresultsave.execute.security.mode.recommended", (Object[])new Object[]{snToShow});
                InfoDialog infoDialog = DialogUtils.showYesNoInfoDialog((Window)InspectContext.getInstance().getMainDialog(), (String)showInfo, (Dimension)new Dimension(300, 125), (boolean)true);
                return infoDialog.getValue() == 0;
            }
        }
        return true;
    }

    private boolean checkNumberOfConcurrent() {
        try {
            int concurrentQuantity = Integer.parseInt(this.setResultSaveCardLayout.getConcurrentQuantityJTF().getText());
            return concurrentQuantity > 0 && concurrentQuantity <= InspectConstans.MAX_INSPECT_NUM;
        }
        catch (NumberFormatException e) {
            log.error("Non-integer character string", (Throwable)e);
            return false;
        }
    }

    private boolean checkStorageInputNumber() {
        try {
            int storageInput = Integer.parseInt(this.setResultSaveCardLayout.getBatchInputBox().getStorageInputField().getText());
            return storageInput > 0 && storageInput <= InspectConstans.MAX_ONCE_STORAGE_NUM;
        }
        catch (NumberFormatException e) {
            log.error("storage node input number is invalid", (Throwable)e);
            return false;
        }
    }

    private boolean checkComputeInputNumber() {
        try {
            int computeInput = Integer.parseInt(this.setResultSaveCardLayout.getBatchInputBox().getComputeInputField().getText());
            return computeInput > 0 && computeInput <= InspectConstans.MAX_ONCE_COMPUTE_NUM;
        }
        catch (NumberFormatException e) {
            log.warn("compute node input number is invalid", (Throwable)e);
            return false;
        }
    }

    private boolean isSelectExecuteMode() {
        return this.setResultSaveCardLayout.getNormalMode().isSelected() || this.setResultSaveCardLayout.getSecurityMode().isSelected();
    }

    public int getStep() {
        return this.getStep(CardModelEnum.SETRESULT);
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step5");
    }

    protected boolean isValid(ToolWizardDialog.Navigation nav) {
        if (ToolWizardDialog.Navigation.Next == nav && this.setResultSaveCardLayout != null) {
            String filePath = this.setResultSaveCardLayout.getPathTextArea().getText();
            return !StringUtils.isNULLStr((String)filePath);
        }
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation nav) {
        if (ApplicationContext.getInstance().isEnglishEnv() && nav == ToolWizardDialog.Navigation.Previous) {
            InspectContext.getInstance().getMainDialog().pack();
        }
        return true;
    }

    @Override
    public void initData() {
        if (ApplicationContext.getInstance().isEnglishEnv() && CollectionUtils.isNotEmpty(this.getPreUpgradeCheckDevs())) {
            InspectContext.getInstance().getMainDialog().setSize(900, 720);
        }
    }
}

