/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.InspectionExecutionMode;
import com.huawei.ism.tool.inspect.entity.InspectionGradientGuidance;
import com.huawei.ism.tool.inspect.logic.entity.InspectTimeSummary;
import com.huawei.ism.tool.inspect.ui.dialogs.DistributedBatchInputBox;
import com.huawei.ism.tool.inspect.ui.logic.SelectPathListener;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class SetResultSaveCardLayout
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SetResultSaveCardLayout.class);
    public static final String SAVEPATH_DEFAULT_ID = "inspect_saveresult_path_id001";
    private static final long serialVersionUID = -6626372882314580200L;
    private static final String[] RECORD_TARGET_VERSION_TABLE_HEADER = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devmodel"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devversion"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devname"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devipaddress"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.targetversion")};
    private static final int COLUMN_MARGIN_PIXEL = 4;
    private final DistributedBatchInputBox batchInputBox = new DistributedBatchInputBox();
    private JButton pathBrows = UiMethod.createButton((String)ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.pathbrrowsbtn"));
    private JTextField pathTextArea = new JTextField();
    private DefaultTableModel tableModel = null;
    private IsmTable deviceTable = null;
    private TableScrollPane tableScrollPane = null;
    private ToolWizardDialog.Card currentCard;
    private JRadioButton normalMode;
    private JRadioButton securityMode;
    private IsmTextField concurrentQuantityJTF = IsmTextField.getNameTextField((String)"[0-9]{1,2}", (String)String.valueOf(InspectConstans.MAX_INSPECT_NUM), (int)2, (int)0);
    private Box concurrentQuantityBox;
    private JLabel concurrentErrorLabel = new JLabel(ResourceUtil.getStringWithParams((String)"number.input.out.of.range.tip", (Object[])new Object[]{InspectConstans.MAX_INSPECT_NUM}));

    public SetResultSaveCardLayout(ToolWizardDialog.Card currentCard, Boolean hasTable) {
        this.currentCard = currentCard;
        JComponent view = this.initUI(hasTable);
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)0), "Center");
        this.bindListener();
        this.computeInspectTime();
        this.pathTextArea.setName("inspect_save");
    }

    private void bindListener() {
        this.pathBrows.addActionListener(new SelectPathListener(this));
        if (InspectUtils.isSceneNeedRecord(InspectContext.getInstance().getInspectWorktaker())) {
            this.normalMode.addActionListener(event -> {
                this.getSecurityMode().setSelected(false);
                this.getConcurrentQuantityBox().setVisible(true);
                InspectContext.getInstance().setInspectionGradientGuidance(new InspectionGradientGuidance(InspectionExecutionMode.NORMAL));
                this.computeInspectTime();
            });
            this.securityMode.addActionListener(event -> {
                this.getNormalMode().setSelected(false);
                this.getConcurrentQuantityBox().setVisible(false);
                InspectContext.getInstance().setInspectionGradientGuidance(new InspectionGradientGuidance(InspectionExecutionMode.SECURITY));
                this.computeInspectTime();
            });
        }
        this.addInputListener(new KeyReleasedListener(e -> this.computeInspectTime()));
        this.addInputListener(new KeyReleasedListener(e -> this.refreshErrorLabelVisible()));
    }

    private void addInputListener(KeyListener computeListener) {
        Optional.ofNullable(this.concurrentQuantityJTF).ifPresent(jTextField -> jTextField.addKeyListener(computeListener));
        this.batchInputBox.getStorageInputField().addKeyListener(computeListener);
        this.batchInputBox.getComputeInputField().addKeyListener(computeListener);
    }

    private JComponent initUI(Boolean hasTable) {
        Object defaultPathObj = HibernateContainer.getInstance().get((Object)SAVEPATH_DEFAULT_ID);
        String defaultName = InspectUtils.buildResultFileName("").getName();
        String scenePath = "";
        if (SceneUtils.isScene()) {
            scenePath = InspectContext.getInstance().getSceneCollectDir();
        }
        if (null != scenePath && !scenePath.isEmpty()) {
            String pathTemp = scenePath + File.separator + defaultName;
            this.pathTextArea.setText(pathTemp);
            this.pathTextArea.setToolTipText(pathTemp);
        } else if (null != defaultPathObj) {
            File oldFile = new File(defaultPathObj.toString());
            this.pathTextArea.setText(oldFile.getParent() + File.separator + defaultName);
        } else {
            File defaultPath = FileUtils.getDefaultDirectory();
            this.pathTextArea.setText(FilesUtil.getCanonicalPath((File)defaultPath) + File.separator + defaultName);
        }
        JComponent headPan = this.createHeadPan();
        JComponent tablePan = this.createTablePan();
        if (hasTable.booleanValue()) {
            JComponent vBox = UCD.buildVerticalBox(null, (Component[])new Component[]{headPan, tablePan});
            return UiMethod.buildFrameSpace((JComponent)vBox, (int)0);
        }
        JComponent vBox = UCD.buildVerticalBox(null, (Component[])new Component[]{headPan});
        return UiMethod.buildVerticalOppositionalPan((Component)headPan, (Component)vBox);
    }

    private JComponent createTablePan() {
        this.tableModel = new DefaultTableModel(RECORD_TARGET_VERSION_TABLE_HEADER, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.tableModel){

            public boolean isCellEditable(int rowIndex, int colIndex) {
                return colIndex == 4;
            }
        };
        this.tableScrollPane = new TableScrollPane(false, false, false, this.deviceTable);
        JLabel tabelName = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.settargetversion.table.name"), 2);
        JLabel tipLabel = new JLabel(ResourceUtil.getImage((String)"question.png"));
        tipLabel.setToolTipText(ResourceUtil.getString((String)"inspect.wizard.strategysetting.version.input.tip.auto.newline"));
        Box headCom = UCD.buildHBoxLeft((int)4, (Component[])new Component[]{tabelName, tipLabel});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)headCom), this.tableScrollPane});
    }

    private JComponent createHeadPan() {
        this.pathBrows.setName("inspect_pathBrows");
        String suggs = ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.suggestion");
        JTextPane suggestion = UiMethod.createTextPaneWithDefaultLeftIdent((String)suggs);
        this.pathBrows.setEnabled(SetResultSaveCardLayout.isSupportModifySavePath());
        this.pathTextArea.setEditable(false);
        String title = ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.pathsuggestion");
        JComponent haed = UiMethod.createImportFileBox(null, (String)title, (JTextComponent)this.pathTextArea, (JButton)this.pathBrows);
        if (InspectUtils.isSceneNeedRecord(InspectContext.getInstance().getInspectWorktaker())) {
            return this.createModeSelectButton(suggestion, haed);
        }
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)suggestion), Box.createVerticalStrut(0), haed, this.batchInputBox.getComponent()});
    }

    public static boolean isSupportModifySavePath() {
        return !SceneUtils.isScene() || SceneUtils.isDpaInspect() || InspectUtils.isSnsInspect() || InspectUtils.isFsExInspect();
    }

    private JComponent createModeSelectButton(JTextPane suggestion, JComponent haed) {
        String modeDsc = ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.execute.mode");
        JTextPane modeJText = UiMethod.createTextPaneWithDefaultLeftIdent((String)modeDsc);
        modeJText.setPreferredSize(new Dimension(100, 24));
        String securityModeTitle = ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.execute.security.mode");
        this.securityMode = new JRadioButton(securityModeTitle);
        String normalModeTitle = ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.execute.normal.mode");
        this.normalMode = new JRadioButton(normalModeTitle);
        this.createConcurrentQuantityBox();
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)suggestion), Box.createVerticalStrut(0), haed, UCD.buildHorizontalBoxLeft((Component)modeJText), UCD.buildHorizontalBoxLeft((Component)this.securityMode), UCD.buildHorizontalBoxLeft((Component)this.normalMode), this.concurrentQuantityBox, this.batchInputBox.getComponent()});
    }

    private boolean isNeedNodeBatchInput() {
        return InspectContext.getInstance().getInspectWorktaker().getCheckDevNodes().stream().anyMatch(CheckDevNode::isNeedBatchInspect);
    }

    private void createConcurrentQuantityBox() {
        String maxInspectNum = String.valueOf(InspectConstans.MAX_INSPECT_NUM);
        Box interfaceCardJtfBox = Box.createHorizontalBox();
        interfaceCardJtfBox.add((Component)this.concurrentQuantityJTF);
        UiMethod.setComponentSize((Dimension)new Dimension(100, 22), (Component[])new Component[]{this.concurrentQuantityJTF});
        this.concurrentQuantityBox = Box.createHorizontalBox();
        this.concurrentQuantityBox.add(new JLabel(ResourceUtil.getStringWithParams((String)"inspsctor.wizard.setresultsave.execute.inspect.num.set", (Object[])new Object[]{maxInspectNum})));
        this.concurrentQuantityBox.add(interfaceCardJtfBox);
        this.concurrentQuantityBox.add(Box.createHorizontalStrut(10));
        this.concurrentErrorLabel.setForeground(Color.RED);
        this.concurrentErrorLabel.setVisible(false);
        this.concurrentQuantityBox.add(this.concurrentErrorLabel);
        this.concurrentQuantityBox.add(Box.createHorizontalGlue());
        this.concurrentQuantityBox.setVisible(false);
    }

    public JTextField getPathTextArea() {
        return this.pathTextArea;
    }

    public String[] getTableHeader() {
        return RECORD_TARGET_VERSION_TABLE_HEADER;
    }

    public ToolWizardDialog.Card getCurrentCard() {
        return this.currentCard;
    }

    private void computeInspectTime() {
        if (!this.isNeedNodeBatchInput()) {
            return;
        }
        if (Objects.nonNull(this.securityMode) && Objects.nonNull(this.normalMode) && !this.securityMode.isSelected() && !this.normalMode.isSelected()) {
            this.batchInputBox.getTimeResultField().setText("--");
            return;
        }
        if (!(this.checkConcurrentNumber() && this.checkStorageInput() && this.checkComputeInput())) {
            this.batchInputBox.getTimeResultField().setText("--");
            return;
        }
        this.showInspectTime();
    }

    private void showInspectTime() {
        List<CheckDevNode> checkDevNodes = InspectContext.getInstance().getInspectWorktaker().getCheckDevNodes();
        boolean isSerial = Objects.nonNull(this.securityMode) && this.securityMode.isSelected();
        int concurrentNumber = isSerial ? 1 : Integer.parseInt(this.concurrentQuantityJTF.getText());
        int storageInputNumber = Integer.parseInt(this.batchInputBox.getStorageInputField().getText());
        int computeInputNumber = Integer.parseInt(this.batchInputBox.getComputeInputField().getText());
        InspectTimeSummary summary = new InspectTimeSummary(checkDevNodes, concurrentNumber, storageInputNumber, computeInputNumber);
        this.batchInputBox.getTimeResultField().setText(String.valueOf(summary.calculateInspectTime()));
    }

    private boolean checkStorageInput() {
        return this.isParamIntValid(this.batchInputBox.getStorageInputField().getText(), InspectConstans.MAX_ONCE_STORAGE_NUM);
    }

    private boolean checkComputeInput() {
        return this.isParamIntValid(this.batchInputBox.getComputeInputField().getText(), InspectConstans.MAX_ONCE_COMPUTE_NUM);
    }

    private void refreshErrorLabelVisible() {
        this.batchInputBox.getStorageErrorLabel().setVisible(!this.checkStorageInput());
        this.batchInputBox.getComputeErrorLabel().setVisible(!this.checkComputeInput());
        this.concurrentErrorLabel.setVisible(!this.checkConcurrentNumber());
    }

    private boolean checkConcurrentNumber() {
        return this.isParamIntValid(this.concurrentQuantityJTF.getText(), InspectConstans.MAX_INSPECT_NUM);
    }

    private boolean isParamIntValid(String inputStr, int maxNumber) {
        try {
            int inputNumber = Integer.parseInt(inputStr);
            return inputNumber > 0 && inputNumber <= maxNumber;
        }
        catch (NumberFormatException e) {
            log.error("parseInt fail for input String:{}", (Object)inputStr);
            return false;
        }
    }

    @Generated
    public DistributedBatchInputBox getBatchInputBox() {
        return this.batchInputBox;
    }

    @Generated
    public JButton getPathBrows() {
        return this.pathBrows;
    }

    @Generated
    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    @Generated
    public JRadioButton getNormalMode() {
        return this.normalMode;
    }

    @Generated
    public JRadioButton getSecurityMode() {
        return this.securityMode;
    }

    @Generated
    public IsmTextField getConcurrentQuantityJTF() {
        return this.concurrentQuantityJTF;
    }

    @Generated
    public Box getConcurrentQuantityBox() {
        return this.concurrentQuantityBox;
    }

    private static class KeyReleasedListener
    extends KeyAdapter {
        private final ActionListener actionListener;

        @Override
        public void keyReleased(KeyEvent e) {
            this.actionListener.actionPerformed(null);
        }

        @Generated
        public KeyReleasedListener(ActionListener actionListener) {
            this.actionListener = actionListener;
        }
    }
}

