/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.bizpack.wizardparse.factory.ConnectorFactory;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.inspect.entity.BomList;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.ConstantField;
import com.huawei.ism.tool.inspect.entity.DevInfo4Exp;
import com.huawei.ism.tool.inspect.entity.Disk;
import com.huawei.ism.tool.inspect.entity.DiskEnclosure;
import com.huawei.ism.tool.inspect.entity.EngineDiskInfo;
import com.huawei.ism.tool.inspect.entity.ExtendModel;
import com.huawei.ism.tool.inspect.entity.RedundantEnclosure;
import com.huawei.ism.tool.inspect.entity.SupportProduct;
import com.huawei.ism.tool.inspect.logic.config.CheckItemPlatformAdapterInInspect;
import com.huawei.ism.tool.inspect.logic.inspector.StrategySettingCardService;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.InnerISshJudge;
import com.huawei.ism.tool.inspect.ui.logic.OpenHelpFile;
import com.huawei.ism.tool.inspect.ui.logic.Strategy;
import com.huawei.ism.tool.inspect.ui.wizard.ExpandScmPanel;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.LimitDiskType;
import com.huawei.ism.tool.inspect.ui.wizard.StrategySettingCardLayout;
import com.huawei.ism.tool.inspect.utils.FileTxtUtil;
import com.huawei.ism.tool.inspect.utils.FsExpansionUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.Utils;
import com.huawei.json.JSONUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import utils.Products;

public class StrategySettingCard
extends InspectCard {
    public static final String DORADO = "dorado";
    public static final String SMART_POOL_FLAG = "smart_pool_flag";
    public static final String GUIDE4DMP = "Inspect" + File.separator + "Check_Veritas_DMP";
    public static final InspectWorktaker WORKTAKER = InspectContext.getInstance().getInspectWorktaker();
    protected static final int INDEX_EXP_MODE = 0;
    protected static final int INDEX_DISK_TYPE = 1;
    protected static final int INDEX_DISK_CAP = 2;
    protected static final int INDEX_DISK_UNIT = 3;
    protected static final int INDEX_DISK_NUM = 4;
    protected static final int INDEX_OP = 5;
    protected static final Float MIN_DISK_CAP = Float.valueOf(100.0f);
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_POOL_EXP_DISK_NUM = "0";
    private static final String MIN_PRODUCT_VERSION = "6.1.6RC1";
    private static final String OCEAN_PROTECT_130 = "1.3.0";
    private static final String MIN_PRODUCT_VERSION_ENTRY_LEVEL = "6.1.6";
    private static final Logger LOG = LoggerFactory.getLogger(StrategySettingCard.class);
    private final IsmTableCell.HyperlinkCell delCell = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"inspect.wizard.strategysetting.oper.del"), (ActionListener)new DelCellAction());
    private static final String REG_CAP = "^[0-9][0-9]{0,11}\\.[0-9]{0,6}$|^[1-9][0-9]{0,11}$";
    private static final String REG_COUNT_SUPPORT_0 = "^[0-9][0-9]{0,9}$";
    private static final String REG_COUNT_NO_SUPPORT_0 = "^[1-9][0-9]{0,9}$";
    private static final String REG_SPLIT_PATTERN = "[\u4e00-\u9fa5]|\\band\\b";
    private static final String REG_COUNT = InspectUtils.isNewOceanStor(InspectContext.getInstance().getDevInfo()) != false ? "^[0-9][0-9]{0,9}$" : "^[1-9][0-9]{0,9}$";
    private static final String BOM_CODE = "^[0-9][A-Z0-9]{0,8}";
    private static final int MAX_LENGTH_CAP = 20;
    private static final int MAX_LENGTH_COUNT = 12;
    private static final int MAX_DISK_NUM_NVME = 25;
    private static final Pattern ENG_NUM = Pattern.compile("CTE(\\d+)");
    private static final String HDD = "SAS";
    private static final String SSD = "SSD";
    private static final String SED = "SED";
    private static final String[] NEW_ARM_DEVS_DIFF_PRODUCT_STRING = new String[]{"2810 V5,2800 V5", "5310 V5,5300 V5", "5310F V5,5300F V5", "5510 V5,5500 V5", "5510F V5,5510F V5 5500F V5", "5610 V5,5610 V5 5600 V5 5600K V5", "5610F V5,5610F V5 5600F V5", "5810 V5,5810 V5 5800 V5 5800K V5", "5810F V5,5810F V5,5800F V5", "6810 V5,6810 V5 6800 V5 6800K V5", "6810F V5,6810F V5 6800F V5", "18510 V5,18510 V5 18500 V5 18500K V5", "18510F V5,18510F V5 18500F V5", "18810 V5,18810 V5 18800 V5 18800K V5", "18810F V5,18810F V5 18800F V5"};
    private static List<SupportProduct> supportBom = new ArrayList<SupportProduct>();
    private static List<BomList> bomLists = new ArrayList<BomList>();
    private static List<BomList> notSupportBomlistsByInternalModel = new ArrayList<BomList>();
    private static final String[] SMART_POOL_DISK_LIMIT = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NVMeSSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NVMeSSDSED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSDSED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SCM"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SCMSED")};
    private static final String[] DISK_TYPE = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SAS"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SATA"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NLSAS"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSDSED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NVMeSSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NVMeSSDSED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SASSED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NLSASSED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SATASED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SCM"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SCMSED")};
    private static final String[] DORADO_NAS_LIMIT = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NAS")};
    private static final String[] DORADO_NO_LIMIT = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSDSED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.HWCMSSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NVMeSSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NVMeSSDSED")};
    private static final String[] DORADO_SAS_LIMIT = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSDSED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.HWCMSSD")};
    private static final String[] DORADO_NVME_LIMIT = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NVMeSSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NVMeSSDSED")};
    private static final String[] DORADO_V6_SAS_LIMIT = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSDSED")};
    private static final String[] OCEAN_PROTECT_HDD_LIMIT = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSDSED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NLSAS"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NLSASSED")};
    private static final String[] NEW_DORADO_HDD_LIMIT = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NLSAS"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NLSASSED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SAS"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SASSED"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SATA"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SATASED")};
    private static final String[] CAPACITY_OPTIMIZED_SSD_LIMIT = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.capacity.optimized.SSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.capacity.optimized.SSDSED")};
    private static final String[] DORADO_V6_NVME_LIMIT = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NVMeSSD"), ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.NVMeSSDSED")};
    private static final String DORADO_DISK_TYPE_CONFIG = ApplicationContext.getInstance().getConfigurationPath() + "Dorado_disk_type.yaml";
    private static final Map<String, Map<String, Map<String, String>>> LIMIT_DISK_TYPE = StrategySettingCard.generateDiskType();
    private static final String[] CAP_UNIT = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"), Strategy.Unit.TB.toString(), Strategy.Unit.GB.toString()};
    private static final int PY_SCRIPT_RETURN_LIST_NUM = 2;
    private static final Integer MIN_DISK_NUM = 4;
    private static final Integer PER_CTRL_NUM_4_6U = 4;
    private StrategySettingCardLayout layout = new StrategySettingCardLayout();
    private String expCtrl;
    private ArrayList<HashMap<String, String>> expDiskList = new ArrayList();
    private ArrayList<Strategy> expStrategyList = new ArrayList();
    private ArrayList<String> expModeList = new ArrayList();
    private Map<String, String> moveCardExpList = new HashMap<String, String>();
    private String expMode = "";
    private boolean checkVeritas = true;
    private boolean requireInnerMetro = false;
    private StrategySettingCardService strategySettingCardService = new StrategySettingCardService();
    private RedundantEnclosure redundantEnclosure = new RedundantEnclosure((ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem()));

    public ArrayList<HashMap<String, String>> getExpDiskList() {
        return this.expDiskList;
    }

    public void setExpDiskList(ArrayList<HashMap<String, String>> expDiskList) {
        this.expDiskList = expDiskList;
    }

    public String getExpCtrl() {
        return this.expCtrl;
    }

    public void setExpCtrl(String expCtrl) {
        this.expCtrl = expCtrl;
    }

    public StrategySettingCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) throws ToolException {
        super(arg0, arg1);
        super.addLayout(this.layout);
        WORKTAKER.initDebugPwdDevs();
        this.initExpConfigMap();
        this.initSupportBomCoding();
        this.initListener();
    }

    private void initSupportBomCoding() {
        try (InputStream resourceAsStream = StrategySettingCard.class.getClassLoader().getResourceAsStream("config/resource/bom_info.txt");){
            if (null == resourceAsStream) {
                LOG.error("get resource as stream failed, resource is null");
                return;
            }
            supportBom = FileTxtUtil.fileToProducts(resourceAsStream);
            DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
            String deviceType = devInfo.getDevType();
            for (SupportProduct product : supportBom) {
                if (!this.isMatchProduct(product, deviceType)) continue;
                bomLists.addAll(product.getBomlist());
            }
            String[] diskBom = this.getBomOfDisk();
            HashMap<String, Disk> devDiskBom = InspectContext.getInstance().getDevInfo().getDevDiskBom();
            for (int i = 1; i < diskBom.length; ++i) {
                BomList bomList = new BomList();
                String[] desc = new String[3];
                Disk disk = (Disk)devDiskBom.get(diskBom[i]);
                bomList.setId(diskBom[i]);
                desc[0] = disk.getType();
                desc[1] = disk.getInputCapacity();
                desc[2] = disk.getInputUnit();
                bomList.setDesc(desc);
                if (this.isSupportedDiskBom(bomList.getId(), bomLists)) continue;
                bomLists.add(bomList);
            }
            List<String> list = Arrays.asList(this.getLimitDiskType());
            if (InspectUtils.isNewOceanStor(devInfo).booleanValue() || InspectUtils.isMicroHybridFlash(devInfo).booleanValue()) {
                return;
            }
            this.getBomlistsByInternalModel(list);
        }
        catch (IOException e) {
            LOG.error("get resource as stream error", (Throwable)e);
        }
    }

    private void getBomlistsByInternalModel(List<BomList> diskType) {
        bomLists.removeIf(bomList -> {
            if (!diskType.contains(bomList.getDesc()[0])) {
                notSupportBomlistsByInternalModel.add((BomList)bomList);
                return true;
            }
            return false;
        });
    }

    private boolean isMatchProduct(SupportProduct product, String deviceType) {
        if (ConstantField.NEW_DORADO_DEV.contains(deviceType)) {
            return product.getProduct().equalsIgnoreCase(deviceType);
        }
        if (product.getProduct().contains(deviceType)) {
            return true;
        }
        return product.getProduct().contains("Dorado") && deviceType.startsWith("Dorado") && product.getProduct().contains(deviceType.replace("Dorado", ""));
    }

    public static boolean isMoveCardScenario(String deviceType, String version) {
        return ConstantField.MOVECARD_TYPE.contains(deviceType.toUpperCase(Locale.ENGLISH)) && version.substring(0, 11).compareTo("V300R002C10") >= 0;
    }

    private String getDisplayEngId(String logicEng) {
        String displayEngId = logicEng;
        int devHeight = InspectContext.getInstance().getDevInfo().getDevHeight();
        if (null == logicEng || !com.huawei.ism.tool.base.utils.StringUtils.isDigit((String)logicEng)) {
            return displayEngId;
        }
        if (devHeight != 6) {
            displayEngId = logicEng + "A/" + logicEng + "B";
            return displayEngId;
        }
        Integer logicEngId = Integer.parseInt(logicEng);
        int realEng = logicEngId / 2;
        displayEngId = logicEngId % 2 == 0 ? realEng + "A/" + realEng + "B" : realEng + "C/" + realEng + "D";
        return displayEngId;
    }

    private ArrayList<String> setEngsByExpCtrlNum(int expCtrlNum) {
        ArrayList<String> engs = new ArrayList<String>();
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        int perEngCtrlNum = 2;
        if (devInfo.getDevHeight() == 6 || devInfo.getDevHeight() == 4) {
            perEngCtrlNum = 4;
        }
        String engHead = "CTE";
        if (devInfo.getEngs().contains("ENG0")) {
            engHead = "ENG";
        }
        int max = (expCtrlNum + perEngCtrlNum / 2) / perEngCtrlNum;
        for (int i = 0; i < max; ++i) {
            engs.add(engHead + i);
        }
        return engs;
    }

    private ArrayList<String> setEngsWhenNotExpEngs() {
        ArrayList<String> engs = new ArrayList<String>();
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        int perEngCtrlNum = 2;
        if (devInfo.getDevHeight() == 6 || devInfo.getDevHeight() == 4) {
            perEngCtrlNum = 4;
        }
        int devControllerNum = devInfo.getDevCtrlsNum();
        String engHead = "CTE";
        if (devInfo.getEngs().contains("ENG0")) {
            engHead = "ENG";
        }
        int max = (int)Math.ceil(Double.valueOf(devControllerNum) / (double)perEngCtrlNum);
        for (int i = 0; i < max; ++i) {
            engs.add(engHead + i);
        }
        return engs;
    }

    private ArrayList<Integer> getLogicEngs(int expCtrlNum) {
        ArrayList<Integer> logicEngs = new ArrayList<Integer>();
        int max = (expCtrlNum + 1) / 2;
        Integer i = 0;
        while (i < max) {
            logicEngs.add(i);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return logicEngs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, Map<String, String>>> generateDiskType() {
        File dumpFile = new File(DORADO_DISK_TYPE_CONFIG);
        FileInputStream fi = null;
        try {
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            LOG.info("dorado limit disk type conifg file path:", (Object)DORADO_DISK_TYPE_CONFIG);
            fi = new FileInputStream(dumpFile);
            Map map = (Map)yaml.load((InputStream)fi);
            StreamUtils.closeStream(null, (InputStream)fi);
            return map;
        }
        catch (FileNotFoundException e) {
            LOG.error("dorado disk type config file not found.");
        }
        finally {
            StreamUtils.closeStream(null, fi);
        }
        return null;
    }

    private HashMap<String, String> getDiskMap4Dorado(boolean hasNewDiskMap) {
        DevInfo4Exp devInfo;
        String[] expModeInfo;
        HashMap<String, String> expDiskMap = new HashMap<String, String>();
        this.expModeList.clear();
        this.expModeList.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"));
        if (hasNewDiskMap) {
            String newDDStr = ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.0");
            this.expModeList.add(newDDStr);
            expDiskMap.put(newDDStr, "new,none");
        }
        if (null == (expModeInfo = (devInfo = InspectContext.getInstance().getDevInfo()).getExpModeInfoList()) || expModeInfo.length == 0) {
            return expDiskMap;
        }
        for (String info : expModeInfo) {
            String[] expInfo = info.split(":");
            if (expInfo.length < 2) continue;
            String engId = expInfo[0];
            String dd = expInfo[1];
            String displayEngId = this.getDisplayEngId(engId);
            String doradoStr = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.2", (Object[])new Object[]{displayEngId, dd});
            this.expModeList.add(doradoStr);
            this.moveCardExpList.put(doradoStr, displayEngId);
            expDiskMap.put(doradoStr, engId + "," + dd);
        }
        return expDiskMap;
    }

    private HashMap<String, String> getDiskMap4V3(boolean hasNewDiskMap, boolean isSelectSubConfig) {
        ArrayList<Integer> logiceEngs;
        ArrayList<String> engs;
        HashMap<String, String> expDiskMap = new HashMap<String, String>();
        this.expModeList.clear();
        this.expModeList.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"));
        if (hasNewDiskMap) {
            String newDDStr = ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.0");
            this.expModeList.add(newDDStr);
            expDiskMap.put(newDDStr, "new,none");
        }
        String subConfigMode = (String)this.layout.getSubConfigBox().getSelectedItem();
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        if (isSelectSubConfig) {
            String expCtrlStr = this.layout.getExpCtrlMap().get(subConfigMode);
            engs = this.setEngsByExpCtrlNum(Integer.parseInt(expCtrlStr));
            logiceEngs = this.getLogicEngs(Integer.parseInt(expCtrlStr));
        } else {
            engs = devInfo.getEngs();
            logiceEngs = this.getLogicEngs(devInfo.getDevCtrlsNum());
        }
        ArrayList<String> devDomains = devInfo.getDevDomains();
        if (devDomains == null || devDomains.isEmpty()) {
            return expDiskMap;
        }
        if (engs == null || engs.isEmpty()) {
            return expDiskMap;
        }
        this.getExpDiskMap(expDiskMap, engs, logiceEngs);
        return expDiskMap;
    }

    private void getExpDiskMap(HashMap<String, String> expDiskMap, ArrayList<String> engs, ArrayList<Integer> logiceEngs) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        ArrayList<String> devDomains = devInfo.getDevDomains();
        String[] expModeInfo = devInfo.getExpModeInfoList();
        if (null == expModeInfo || expModeInfo.length == 0) {
            for (String eng : engs) {
                for (String domain : devDomains) {
                    String doradoStr = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.1", (Object[])new Object[]{eng, domain});
                    this.expModeList.add(doradoStr);
                    String engId = eng.substring(eng.length() - 1, eng.length());
                    expDiskMap.put(doradoStr, engId + "," + domain);
                }
            }
        } else {
            for (Integer eng : logiceEngs) {
                for (String domain : devDomains) {
                    String displayEngId = this.getDisplayEngId(String.valueOf(eng));
                    String doradoStr = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.2", (Object[])new Object[]{displayEngId, domain});
                    this.expModeList.add(doradoStr);
                    expDiskMap.put(doradoStr, eng + "," + domain);
                }
            }
        }
    }

    private HashMap<String, String> getDiskMap4DoradoV6(boolean hasNewDiskMap, boolean isSelectSubConfig, ExtendModel configMode) {
        HashMap<String, String> expDiskMap = new HashMap<String, String>();
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        ArrayList<String> engs = devInfo.getEngs();
        ArrayList<String> pools = devInfo.getDevPools();
        List<String> smartPool = devInfo.getSmartPool();
        this.expModeList.clear();
        this.expModeList.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"));
        if (this.isFlashingDev(devInfo)) {
            String newDDStr;
            int maxSize = this.hasNewDDOptionByHybridFlash(isSelectSubConfig);
            int poolNum = devInfo.getDevPools().size();
            boolean hasAddNewStr = false;
            for (int id = poolNum; id < maxSize; ++id) {
                newDDStr = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.flashing.newPool", (Locale)Locale.ROOT, (Object[])new Object[]{id});
                this.expModeList.add(newDDStr);
                expDiskMap.put(newDDStr, "new,none");
                hasAddNewStr = true;
            }
            int maxPoolSize = this.strategySettingCardService.getMaxPoolSize(devInfo);
            if (!hasAddNewStr && poolNum < maxPoolSize && this.isOceanProtectSupportPools(devInfo)) {
                newDDStr = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.flashing.newPool", (Locale)Locale.ROOT, (Object[])new Object[]{Integer.parseInt(Collections.max(devInfo.getDevPools())) + 1});
                this.expModeList.add(newDDStr);
                expDiskMap.put(newDDStr, "new,none");
            }
        } else if (this.hasNewDDOption(isSelectSubConfig)) {
            String newDDStr = this.getFlashDevExpModeStr();
            this.expModeList.add(newDDStr);
            expDiskMap.put(newDDStr, "new,none");
        }
        if ((pools == null || pools.size() == 0) && (smartPool == null || smartPool.size() == 0) || engs == null || engs.size() == 0) {
            return expDiskMap;
        }
        if (engs != null && engs.size() == 2 && this.isInnerMetroNetWork()) {
            this.mergeMetroEngines(devInfo);
        }
        this.setExpDiskMode(configMode, expDiskMap, devInfo, engs, pools, smartPool);
        return expDiskMap;
    }

    private boolean isOceanProtectSupportPools(DevInfo4Exp devInfo) {
        return devInfo.getDevType().toUpperCase(Locale.ENGLISH).contains("OCEANPROTECT") && Products.compareVersion((String)devInfo.getProductVersion().toUpperCase(Locale.ENGLISH), (String)"1.6") >= 0;
    }

    private void setExpDiskMode(ExtendModel configMode, Map<String, String> expDiskMap, DevInfo4Exp devInfo, List<String> engs, List<String> pools, List<String> smartPool) {
        Pattern pattern = Pattern.compile("\\d+");
        Map<String, List<String>> poolOfEngs = this.getPoolOfEngs(devInfo);
        int maxPoolSize = this.strategySettingCardService.getMaxPoolSize(devInfo);
        for (String eng : engs) {
            String engId = EMPTY_POOL_EXP_DISK_NUM;
            Matcher matcher = pattern.matcher(eng);
            if (matcher.find()) {
                engId = matcher.group();
            }
            for (String pool : pools) {
                if (FsExpansionUtils.isNewDoraoFlashDev(devInfo) && this.isInnerMetroNetWork()) {
                    LOG.info("inner metro Net work, do not support exp pool.{}", (Object)pool);
                    continue;
                }
                if (poolOfEngs.containsKey(eng) && poolOfEngs.get(eng).size() == maxPoolSize && !poolOfEngs.get(eng).contains(pool)) continue;
                String doradoStr = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.expPoolOnEngine", (Object[])new Object[]{eng, pool});
                this.expModeList.add(doradoStr);
                expDiskMap.put(doradoStr, engId + "," + pool);
            }
            this.setSmartPoolInfo(configMode, expDiskMap, devInfo, smartPool, eng, engId);
        }
    }

    private String getFlashDevExpModeStr() {
        ExtendModel selectConfigItem = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        if (FsExpansionUtils.isNewDoraoFlashDev(devInfo) && (ExtendModel.CTRL_EXP_INSPECT.equals((Object)selectConfigItem) || ExtendModel.DISK_EXP_INSPECT.equals((Object)selectConfigItem))) {
            return ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.newPoolPerformanceLayer", (Object[])new Object[0]);
        }
        return ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.newPool");
    }

    private void setSmartPoolInfo(ExtendModel configMode, Map<String, String> expDiskMap, DevInfo4Exp devInfo, List<String> smartPool, String eng, String engId) {
        if (this.isNotSupportSmartPoolModel(configMode)) {
            return;
        }
        if (smartPool == null || smartPool.size() == 0) {
            return;
        }
        StringBuffer infoStr = new StringBuffer();
        for (String pool : smartPool) {
            String newOceanStr = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.expSmartPoolOnEngine", (Object[])new Object[]{eng, pool});
            this.expModeList.add(newOceanStr);
            expDiskMap.put(newOceanStr, engId + "," + pool + SMART_POOL_FLAG);
            infoStr.append(engId + ":" + pool);
        }
        devInfo.setSmartPoolExpPoolList(String.join((CharSequence)",", infoStr).split(","));
    }

    private boolean isFlashingDev(DevInfo4Exp devInfo) {
        return ConstantField.FLASHING_INTER_MODEL.contains(devInfo.getInternalModel());
    }

    private boolean hasNewDDOption(boolean isSelectSubConfig) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        ArrayList<String> engs = devInfo.getEngs();
        int devEngineNum = devInfo.getOriginEngNum();
        if (devEngineNum == 0) {
            devInfo.setOriginEngNum(engs.size());
            devEngineNum = engs.size();
        }
        boolean isMaxPoolSize = this.isMaxPoolSize4DoradoV6(devInfo, devEngineNum);
        ExtendModel selectConfigItem = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        if (ExtendModel.DISK_EXP_INSPECT.equals((Object)selectConfigItem)) {
            engs.clear();
            engs.addAll(this.setEngsWhenNotExpEngs());
            return !isMaxPoolSize;
        }
        if (ExtendModel.CTRL_EXP_INSPECT.equals((Object)selectConfigItem)) {
            if (isSelectSubConfig) {
                String subConfigMode = (String)this.layout.getSubConfigBox().getSelectedItem();
                String expCtrlStr = this.layout.getExpCtrlMap().get(subConfigMode);
                int expControllerNum = Integer.parseInt(expCtrlStr);
                int devControllerNum = devInfo.getDevCtrlsNum();
                boolean isMetro = this.isInnerMetroNetWork();
                if (isMetro && devControllerNum == 6 && expControllerNum == 8) {
                    return false;
                }
                engs.clear();
                engs.addAll(this.setEngsByExpCtrlNum(expControllerNum));
                int expEngineNum = engs.size();
                if (expEngineNum > devEngineNum) {
                    return true;
                }
                return !isMaxPoolSize;
            }
            engs.clear();
            engs.addAll(this.setEngsWhenNotExpEngs());
            return false;
        }
        engs.clear();
        engs.addAll(this.setEngsWhenNotExpEngs());
        return false;
    }

    private int hasNewDDOptionByHybridFlash(boolean isSelectSubConfig) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        ArrayList<String> engs = devInfo.getEngs();
        ExtendModel selectConfigItem = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        if (ExtendModel.DISK_EXP_INSPECT.equals((Object)selectConfigItem)) {
            engs.clear();
            engs.addAll(this.setEngsWhenNotExpEngs());
            return engs.size();
        }
        if (ExtendModel.CTRL_EXP_INSPECT.equals((Object)selectConfigItem) && isSelectSubConfig) {
            return this.getExpCtrlEngsNum(devInfo, engs);
        }
        engs.clear();
        engs.addAll(this.setEngsWhenNotExpEngs());
        return -1;
    }

    private int getExpCtrlEngsNum(DevInfo4Exp devInfo, ArrayList<String> engs) {
        String subConfigMode = (String)this.layout.getSubConfigBox().getSelectedItem();
        String expCtrlStr = this.layout.getExpCtrlMap().get(subConfigMode);
        int expControllerNum = Integer.parseInt(expCtrlStr);
        int devControllerNum = devInfo.getDevCtrlsNum();
        boolean isMetro = this.isInnerMetroNetWork();
        if (isMetro && devControllerNum == 6 && expControllerNum == 8) {
            return -1;
        }
        int devEngineNum = engs.size();
        engs.clear();
        engs.addAll(this.setEngsByExpCtrlNum(expControllerNum));
        int expEngineNum = engs.size();
        return Math.max(expEngineNum, devEngineNum);
    }

    private boolean isInnerMetroNetWork() {
        if (this.layout.getSubSel4InnerMetroBox().isVisible()) {
            String subSel4InnerMetro = (String)this.layout.getSubSel4InnerMetroBox().getSelectedItem();
            return subSel4InnerMetro.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.requireInnerMetroSelYes"));
        }
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        return devInfo.isHasInnerMetroLicense();
    }

    private boolean hasSharedCard() {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String deviceType = devInfo.getDevType().toUpperCase(Locale.ENGLISH);
        String version = devInfo.getProductVersion().toUpperCase(Locale.ENGLISH);
        if (ConstantField.DORADO_V6_HIGH.contains(deviceType)) {
            return true;
        }
        return ConstantField.ARM_V5_HIGH.contains(deviceType) && version.contains("KUNPENG");
    }

    private void mergeMetroEngines(DevInfo4Exp devInfo) {
        ArrayList<String> engs = devInfo.getEngs();
        String eng0 = engs.get(0);
        String eng1 = engs.get(1);
        String metroEngines = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.metroEngines", (Object[])new Object[]{eng0, eng1});
        engs.set(0, metroEngines);
        engs.remove(1);
        ArrayList<EngineDiskInfo> devEngineDiskInfo = devInfo.getDevEngineDiskInfo();
        for (EngineDiskInfo item : devEngineDiskInfo) {
            ArrayList<String> engineIds = item.getEngineIds();
            int eng1Index = engineIds.indexOf(eng1);
            if (eng1Index < 0 || engineIds.size() != 2) continue;
            engineIds.remove(eng1Index);
        }
    }

    private boolean isMaxPoolSize4DoradoV6(DevInfo4Exp devInfo, int devEngineNum) {
        if (devInfo.getDevPools().size() == 0) {
            return false;
        }
        Map<String, List<String>> poolNumberOfEngineMap = this.getPoolOfEngs(devInfo);
        if (poolNumberOfEngineMap.keySet().size() < devEngineNum) {
            return false;
        }
        int maxPoolSize = this.strategySettingCardService.getMaxPoolSize(devInfo);
        return poolNumberOfEngineMap.values().stream().map(List::size).noneMatch(poolSize -> poolSize < maxPoolSize);
    }

    private Map<String, List<String>> getPoolOfEngs(DevInfo4Exp devInfo) {
        return devInfo.getDevEngineDiskInfo().stream().flatMap(engineDiskInfo -> engineDiskInfo.getEngineIds().stream().map(engineId -> new AbstractMap.SimpleEntry<String, String>((String)engineId, engineDiskInfo.getPoolId()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private void setHardwareBomVisible(boolean isExpCtrlOrDisk) {
        if (!isExpCtrlOrDisk) {
            this.layout.getInterfaceBomBox().setVisible(false);
            this.layout.getNoticeBomBox().setVisible(false);
            this.layout.getDiskEnclosureBomBox().setVisible(false);
            return;
        }
        this.layout.getInterfaceBomBox().setVisible(true);
        this.layout.getDiskEnclosureBomBox().setVisible(true);
        this.layout.getNoticeBomBox().setVisible(true);
        this.layout.getNoticeBomBox().setVisible(this.layout.getCtrlBomBox().isVisible() || this.layout.getEncBomBox().isVisible());
    }

    private void initExpConfigMap() {
        boolean hasNewDiskMap;
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        ExtendModel configMode = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        String subConfigMode = (String)this.layout.getSubConfigBox().getSelectedItem();
        boolean isSelectSubConfig = this.layout.getSubConfigBox().isVisible() && !subConfigMode.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.extendCtrlselect"));
        boolean visible = false;
        boolean bomVisible = false;
        if (isSelectSubConfig) {
            String expCtrlStr = this.layout.getExpCtrlMap().get(subConfigMode);
            int expControllerNum = Integer.parseInt(expCtrlStr);
            devInfo.setExpCtrlsNum(expControllerNum);
            visible = ConstantField.DORADO_V6_HIGH_ONE_ENG_CTRL_NUM.contains(devInfo.getDevCtrlsNum()) && ConstantField.DORADO_V6_HIGH_TWO_ENG_CTRL_NUM.contains(expControllerNum) && ConstantField.DORADO_V6_INNER_METRO_DEV.contains(devInfo.getInternalModel());
            String deviceType = devInfo.getDevType();
            String version = devInfo.getProductVersion();
            if ((ConstantField.DORADO_V6_DEV.contains(deviceType.toUpperCase(Locale.ENGLISH)) || Products.isKunpeng((String)version)) && !ConstantField.LOW_END_ENHANCED.contains(deviceType.toUpperCase(Locale.ENGLISH))) {
                bomVisible = true;
            }
        }
        this.layout.setBomAreaVisible(bomVisible);
        this.layout.setExpandDDBomVisible(ExtendModel.DD_EXP_INSPECT.equals((Object)configMode));
        this.layout.setSubSel4InnerMetroBoxVisible(visible);
        ExtendModel selectConfigItem = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        boolean bl = hasNewDiskMap = !ExtendModel.DISK_EXP_INSPECT.equals((Object)selectConfigItem) || devInfo.isCreateDomain();
        if (ExtendModel.DD_EXP_INSPECT.equals((Object)configMode)) {
            hasNewDiskMap = false;
        }
        LOG.info("initExpConfigMap devType={}", (Object)devInfo.getDevType());
        HashMap<String, String> expDiskMap = ConstantField.DORADO_V6_DEV.contains(devInfo.getDevType().toUpperCase(Locale.ENGLISH)) ? this.getDiskMap4DoradoV6(hasNewDiskMap, isSelectSubConfig, configMode) : (ConstantField.DORADO_DEV.contains(devInfo.getDevType().toUpperCase(Locale.ENGLISH)) ? this.getDiskMap4Dorado(hasNewDiskMap) : this.getDiskMap4V3(hasNewDiskMap, isSelectSubConfig));
        this.layout.getExpDiskMap().clear();
        this.layout.setExpDiskMap(expDiskMap);
    }

    private void initListener() {
        this.layout.getAddConfigBtn().addActionListener(new AddConfigBtnListener(this));
        this.layout.getConfigBox().addActionListener((ActionListener)new ConfigBoxActionListener(this.layout, this));
        this.layout.getSubConfigBox().addItemListener((ItemListener)new SubConfigBoxItemListener(this));
        this.layout.getSubConfigBox().addPopupMenuListener((PopupMenuListener)new SubConfigBoxPopupListener(this));
        this.layout.getSubSel4VeritasBox().addItemListener((ItemListener)new SubConfigBoxItemListener(this));
        this.layout.getSubSel4VeritasBox().addPopupMenuListener((PopupMenuListener)new SubConfigBoxPopupListener(this));
        this.layout.getHighDensityDiskEnclosureBox().addItemListener((ItemListener)new HighDensityDiskEnclosureSelBoxListener(this));
        this.layout.getOpenGuideLink4DMP().addClickListener((ToolHyperLinkLabel.ClickListener)new OpenHelpFile(GUIDE4DMP, InspectContext.getInstance().getMainDialog()));
        this.layout.getSubSel4InnerMetroBox().addItemListener((ItemListener)new SubConfigBoxItemListener(this));
        this.layout.getSubSel4InnerMetroBox().addPopupMenuListener((PopupMenuListener)new SubConfigBoxPopupListener(this));
        this.layout.getCtrlBomJTF().getDocument().addDocumentListener(new CtrlBomInputListener(this));
        this.layout.getEncBomJTF().getDocument().addDocumentListener(new EncBomInputListener(this));
        this.layout.getInterfaceCardBomJTF().getDocument().addDocumentListener(new InterfaceCardBomInputListener(this));
        this.layout.getInterfaceBomJTF().getDocument().addDocumentListener(new InterfaceBomInputListener(this));
        this.layout.getInterfaceBomJTF().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (StrategySettingCard.this.layout.getInterfaceBomJTF().getText().equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.interface.prompt.txt"))) {
                    StrategySettingCard.this.layout.getInterfaceBomJTF().setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.layout.getDiskEnclosureBomJTF().getDocument().addDocumentListener(new DiskEnclosureBomInputListener(this));
        this.layout.getDiskEnclosureBomJTF().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (StrategySettingCard.this.layout.getDiskEnclosureBomJTF().getText().equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.disk.enclosure.prompt.txt"))) {
                    StrategySettingCard.this.layout.getDiskEnclosureBomJTF().setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    private void addOneRow(TableRow row) {
        this.layout.getModel().addRow(new TableRow[]{row});
    }

    private TableRow createRow() {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String deviceType = devInfo.getDevType();
        String version = devInfo.getProductVersion();
        ExtendModel configMode = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        boolean isolation = StrategySettingCard.isMoveCardScenario(deviceType, version);
        Strategy strategy = new Strategy();
        String[] expModes = new String[this.expModeList.size()];
        this.expModeList.toArray(expModes);
        String[] isolationModes = expModes;
        TableRow<Strategy, Strategy> row = new TableRow<Strategy, Strategy>(StrategySettingCardLayout.HEADERS.length, (Object)strategy, (Object)strategy);
        if (isolation) {
            row = new DefaultTableRow(StrategySettingCardLayout.MOVECARD_HEADERS.length, (Object)strategy, (Object)strategy);
            isolationModes = this.getExpModes(devInfo.getCtrlsDD());
        }
        this.redundantEnclosure.addOneColumn = this.redundantEnclosure.needAddOneColumn(configMode);
        if (this.redundantEnclosure.addOneColumn) {
            row = new DefaultTableRow(StrategySettingCardLayout.V6_HEADERS.length, (Object)strategy, (Object)strategy);
        }
        row = this.createRowColumn(row, isolation, configMode, isolationModes, devInfo, expModes, deviceType);
        LOG.info("generate one strategy row");
        return row;
    }

    private TableRow<Strategy, Strategy> createRowColumn(TableRow<Strategy, Strategy> row, boolean isolation, ExtendModel configMode, String[] isolationModes, DevInfo4Exp devInfo, String[] expModes, String deviceType) {
        int index = 0;
        LOG.info("createRowColumn configMode {}.", (Object)configMode.toString());
        Object[] diskType = this.getLimitDiskTypeForNewDorado();
        String[] diskBom = this.getBomOfDisk();
        if (isolation) {
            Object[] defaultList = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default")};
            if (!ExtendModel.CTRL_EXP_INSPECT.equals((Object)configMode)) {
                row.setValueAt(index++, (Object)new IsmTableCell.ComboBoxCell((Object[])isolationModes, (Object)isolationModes[0], (ItemListener)new ComboxListener(devInfo)));
            } else {
                row.setValueAt(index++, (Object)new IsmTableCell.ComboBoxCell((Object[])expModes, (Object)expModes[0]));
            }
            row.setValueAt(index++, (Object)new IsmTableCell.ComboBoxCell(defaultList, (Object)defaultList[0]));
        } else if (this.redundantEnclosure.enclosureRedundant) {
            row.setValueAt(index++, (Object)new IsmTableCell.ComboBoxCell((Object[])expModes, (Object)expModes[0], (ItemListener)new ExpModeComboxListener()));
        } else {
            row.setValueAt(index++, (Object)new IsmTableCell.ComboBoxCell((Object[])expModes, (Object)expModes[0], (ItemListener)new DiskTypeComboxListener()));
        }
        if (this.redundantEnclosure.addOneColumn) {
            Object[] enclosureList = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.diskenclosure.noneed")};
            row.setValueAt(index++, (Object)new IsmTableCell.ComboBoxCell(enclosureList, (Object)enclosureList[0]));
            if (row.getValueAt(index - 1) instanceof IsmTableCell.ComboBoxCell) {
                IsmTableCell.ComboBoxCell enclosureIDCell = (IsmTableCell.ComboBoxCell)row.getValueAt(index - 1);
                enclosureIDCell.setEditable(false);
            }
        }
        IsmTableCell.MsgTextCell msgTextCell = new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)BOM_CODE, (String)"", (int)20, (int)0), "", ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.input.tip"));
        row.setValueAt(index++, (Object)msgTextCell);
        this.setupAutoComplete(msgTextCell, bomLists);
        row.setValueAt(index++, (Object)new IsmTableCell.ComboBoxCell(diskType, (Object)diskType[0]));
        row.setValueAt(index++, (Object)new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)REG_CAP, (String)"", (int)20, (int)0), "", ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.input.tip")));
        row.setValueAt(index++, (Object)new IsmTableCell.ComboBoxCell((Object[])CAP_UNIT, (Object)CAP_UNIT[0]));
        row.setValueAt(index++, (Object)new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)REG_COUNT, (String)"", (int)12, (int)0), "", ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.input.tip")));
        row.setValueAt(index++, (Object)this.delCell);
        return row;
    }

    private void setupAutoComplete(final IsmTableCell.MsgTextCell msgTextCell, final List<BomList> items) {
        final JTextField customTextField = msgTextCell.getCustomTextField();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        JComboBox cbInput = new JComboBox(model){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 0);
            }
        };
        StrategySettingCard.setAdjusting(cbInput, false);
        for (BomList item : items) {
            model.addElement(item.getId());
        }
        cbInput.setSelectedItem(null);
        cbInput.addActionListener(new CbInputClickAction(cbInput, customTextField));
        customTextField.getDocument().addDocumentListener(new BomTxtInputDocumentListener(cbInput, customTextField, model, items));
        customTextField.addFocusListener(new FocusListener(){
            TableRow row = null;

            @Override
            public void focusGained(FocusEvent e) {
                this.row = StrategySettingCard.this.layout.getTable().getMarkedRow();
            }

            @Override
            public void focusLost(FocusEvent e) {
                String input = customTextField.getText();
                if (input != null && !input.isEmpty()) {
                    StrategySettingCard.this.judgeBom(input, items, msgTextCell, this.row);
                }
            }
        });
        customTextField.setLayout(new BorderLayout());
        customTextField.add((Component)cbInput, "South");
    }

    private void judgeBom(String input, List<BomList> items, IsmTableCell.MsgTextCell msgTextCell, TableRow row) {
        if (!this.isSupportedDiskBom(input, items)) {
            DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
            String deviceType = devInfo.getDevType();
            String[] models = new String[]{"S2600T", "S5500T", "S5600T", "S5800T", "S6800T"};
            List<String> strings = Arrays.asList(models);
            if (!strings.contains(deviceType) || notSupportBomlistsByInternalModel.contains(input)) {
                LOG.info("bom is not support");
                this.showYesno(msgTextCell, row);
            }
        } else if (!this.isMacthVersion(input, items)) {
            LOG.info("version is not match");
            this.showYesno(msgTextCell, row);
        } else {
            this.updateDiskTypeAndCapUnit(row, input, msgTextCell);
            LOG.info("bom is supported");
        }
    }

    private void updateDiskTypeAndCapUnit(TableRow row, String input, IsmTableCell.MsgTextCell msgTextCell) {
        String[] diskType;
        String diskTypeValue = "";
        String diskCapacityNumberValue = "";
        String diskCapacityUnitValue = "";
        for (BomList bomlist : bomLists) {
            if (!bomlist.getId().equals(input)) continue;
            diskTypeValue = bomlist.getDesc()[0];
            diskCapacityNumberValue = bomlist.getDesc()[1];
            diskCapacityUnitValue = bomlist.getDesc()[2];
        }
        if (this.checkPerformanceLayerBom(row, diskTypeValue, diskCapacityNumberValue, diskCapacityUnitValue, msgTextCell)) {
            return;
        }
        int diskTypeIndex = this.getDiskTypeIndexNum();
        for (String diskTypeStr : diskType = this.getLimitDiskType()) {
            if (!diskTypeStr.equals(diskTypeValue)) continue;
            row.setValueAt(diskTypeIndex++, (Object)diskTypeValue);
            row.setValueAt(diskTypeIndex++, (Object)diskCapacityNumberValue);
            row.setValueAt(diskTypeIndex++, (Object)diskCapacityUnitValue);
            return;
        }
        this.showYesno(msgTextCell, row);
    }

    private int getDiskTypeIndexNum() {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String deviceType = devInfo.getDevType();
        String version = devInfo.getProductVersion();
        int index = 2;
        if (StrategySettingCard.isMoveCardScenario(deviceType, version) || this.redundantEnclosure.addOneColumn) {
            index = 3;
        }
        return index;
    }

    private boolean checkPerformanceLayerBom(TableRow row, String diskTypeValue, String diskCapacityNumberValue, String diskCapacityUnitValue, IsmTableCell.MsgTextCell msgTextCell) {
        String[] diskType;
        List<String> poolList;
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String deviceType = devInfo.getDevType();
        String version = devInfo.getProductVersion();
        IsmTableCell.ComboBoxCell comboxCell = (IsmTableCell.ComboBoxCell)row.getValueAt(0);
        String expModel = (String)comboxCell.getComboBox().getSelectedItem();
        ExtendModel configMode = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        ArrayList<String> engList = devInfo.getEngs();
        if (!this.isPerformanceLayerSelected(engList, poolList = devInfo.getSmartPool(), expModel) && !this.isFlashDevCreateNewPoolSelected(expModel)) {
            return false;
        }
        Map<String, Object> cellMap = this.getCellMapOfDiskTypeAndDiskCapacity();
        if (cellMap.isEmpty()) {
            return true;
        }
        for (String limitType : diskType = this.getPerformanceLayerDiskLimit()) {
            if (!limitType.equals(diskTypeValue)) continue;
            int index = this.getDiskTypeIndexNum();
            row.setValueAt(index++, (Object)diskTypeValue);
            row.setValueAt(index++, (Object)diskCapacityNumberValue);
            row.setValueAt(index++, (Object)diskCapacityUnitValue);
            return true;
        }
        this.showYesno(msgTextCell, row);
        return true;
    }

    private boolean nothasValue(String input) {
        for (BomList bomlist : bomLists) {
            if (!bomlist.getId().equals(input)) continue;
            String diskTypeValue = bomlist.getDesc()[0];
            String diskCapacityNumberValue = bomlist.getDesc()[1];
            String diskCapacityUnitValue = bomlist.getDesc()[2];
            if (!diskTypeValue.isEmpty() && !diskCapacityNumberValue.isEmpty() && !diskCapacityUnitValue.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void showYesno(IsmTableCell.MsgTextCell msgTextCell, TableRow row) {
        String selectMode;
        WarningDialog wdlg = DialogUtils.showYesNoDialog((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.continue.info"));
        if (wdlg.getValue() == 1) {
            LOG.info("clicked cancel button");
            msgTextCell.setText("");
        }
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String deviceType = devInfo.getDevType();
        String version = devInfo.getProductVersion();
        Object[] diskType = this.getLimitDiskTypeForNewDorado();
        String diskNumReg = REG_COUNT;
        List<String> smartPoolList = devInfo.getSmartPool();
        ArrayList<String> engList = devInfo.getEngs();
        int colIndex = this.getDiskTypeIndexNum();
        IsmTableCell.ComboBoxCell selectModeBox = (IsmTableCell.ComboBoxCell)row.getValueAt(0);
        String string = selectMode = selectModeBox.getSelectedItem() == null ? "" : (String)selectModeBox.getSelectedItem();
        if (this.isPerformanceLayerSelected(engList, smartPoolList, selectMode) || this.isFlashDevCreateNewPoolSelected(selectMode)) {
            diskType = this.getPerformanceLayerDiskLimit();
            diskNumReg = REG_COUNT_NO_SUPPORT_0;
        }
        if (this.isNewPool(selectMode)) {
            diskNumReg = REG_COUNT_NO_SUPPORT_0;
        }
        row.setValueAt(colIndex++, (Object)new IsmTableCell.ComboBoxCell(diskType, (Object)diskType[0]));
        row.setValueAt(colIndex++, (Object)new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)REG_CAP, (String)"", (int)20, (int)0), "", ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.input.tip")));
        row.setValueAt(colIndex++, (Object)new IsmTableCell.ComboBoxCell((Object[])CAP_UNIT, (Object)CAP_UNIT[0]));
        row.setValueAt(colIndex++, (Object)new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)diskNumReg, (String)"", (int)12, (int)0), "", ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.input.tip")));
    }

    private boolean isMacthVersion(String input, List<BomList> items) {
        String version = "";
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String productVersion = devInfo.getProductVersion();
        boolean num = false;
        for (BomList bomlist : items) {
            if (!bomlist.getId().equals(input)) continue;
            version = bomlist.getVersion();
        }
        if (version == null || version.isEmpty()) {
            return true;
        }
        if (Products.isKunpeng((String)productVersion)) {
            productVersion = productVersion.replace("Kunpeng", "").trim();
        }
        if (productVersion.length() != version.length()) {
            if (productVersion.length() > version.length()) {
                productVersion = productVersion.substring(0, version.length());
            } else {
                version = version.substring(0, productVersion.length());
            }
        }
        return Products.compareVersion((String)productVersion, (String)version) >= 0;
    }

    private String toKunPeng(String internalModel) {
        String version = "";
        for (int i = 0; i < NEW_ARM_DEVS_DIFF_PRODUCT_STRING.length; ++i) {
            String[] split = NEW_ARM_DEVS_DIFF_PRODUCT_STRING[i].split(",");
            if (!split[1].contains(internalModel)) continue;
            version = split[0];
        }
        return version;
    }

    private void setValueOfDiskTypeAndDiskCapacityAnddiskCapacityUnit(String input) {
        Map<String, Object> cellMap = this.getCellMapOfDiskTypeAndDiskCapacity();
        if (cellMap.isEmpty()) {
            return;
        }
        IsmTableCell.MsgTextCell diskType = (IsmTableCell.MsgTextCell)cellMap.get("diskType");
        IsmTableCell.MsgTextCell diskCapacityNumber = (IsmTableCell.MsgTextCell)cellMap.get("diskCapacityNumber");
        IsmTableCell.ComboBoxCell diskCapacityUnit = (IsmTableCell.ComboBoxCell)cellMap.get("diskCapacityUnit");
        String diskTypeValue = "";
        String diskCapacityNumberValue = "";
        String diskCapacityUnitValue = "";
        for (BomList bomlist : bomLists) {
            if (!bomlist.getId().equals(input)) continue;
            diskTypeValue = bomlist.getDesc()[0];
            diskCapacityNumberValue = bomlist.getDesc()[1];
            diskCapacityUnitValue = bomlist.getDesc()[2];
        }
        diskType.setText(diskTypeValue);
        diskCapacityNumber.setText(diskCapacityNumberValue);
        diskCapacityUnit.setSelectedItem((Object)diskCapacityUnitValue);
        diskType.setEditable(false);
        diskCapacityNumber.setEditable(false);
        diskCapacityUnit.setEditable(false);
    }

    private boolean isSupportedDiskBom(String input, List<BomList> items) {
        ArrayList<String> ids = new ArrayList<String>();
        for (BomList item : items) {
            ids.add(item.getId());
        }
        return ids.contains(input);
    }

    private String[] getBomOfDisk() {
        HashMap<String, Disk> devDiskBom = InspectContext.getInstance().getDevInfo().getDevDiskBom();
        String[] bomOfDisk = new String[devDiskBom.keySet().size() + 1];
        int index = 0;
        bomOfDisk[index] = ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.customize");
        for (String bom : devDiskBom.keySet()) {
            bomOfDisk[++index] = bom;
        }
        return bomOfDisk;
    }

    private void setValues(String[] values) {
        int row = this.layout.getTable().getSelectedRow();
        if (row != -1) {
            this.layout.getModel().getRow(row).setValueAt(1, (Object)new IsmTableCell.ComboBoxCell((Object[])values, (Object)values[0]));
        }
    }

    private String[] getExpDDList(DevInfo4Exp devInfo) {
        String[] expModeInfo;
        ArrayList<String> expList = new ArrayList<String>();
        expList.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"));
        for (String info : expModeInfo = devInfo.getExpModeInfoList()) {
            String[] expInfo = info.split(":");
            if (expInfo.length < 2) continue;
            String engId = expInfo[0];
            String dd = expInfo[1];
            String displayEngId = this.getDisplayEngId(engId);
            String doradoStr = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.2", (Object[])new Object[]{displayEngId, dd});
            expList.add(doradoStr);
        }
        return expList.toArray(new String[0]);
    }

    private String[] getNewDDList(DevInfo4Exp dev) {
        String lang = LanguageManager.getInstance().getCurrentLanguage().getLanguage();
        int devHight = dev.getDevHeight();
        int ctrlNum = dev.getDevCtrlsNum();
        Map<String, List<String>> ctrlsDD = dev.getCtrlsDD();
        return this.generateNewDDInList(devHight, ctrlNum, lang, ctrlsDD).toArray(new String[0]);
    }

    private String[] getExpModes(Map<String, List<String>> ctrlsDD) {
        ArrayList<String> expModes = new ArrayList<String>();
        ExtendModel configMode = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        expModes.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"));
        if (!ExtendModel.DD_EXP_INSPECT.equals((Object)configMode)) {
            expModes.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.0"));
        }
        if (!ctrlsDD.isEmpty()) {
            expModes.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.4"));
        }
        return expModes.toArray(new String[0]);
    }

    private List<String> generateNewDDInList(int devHeight, int ctrlNum, String lang, Map<String, List<String>> ctrlsDD) {
        ArrayList<String> exps = new ArrayList<String>();
        String defaultStr = ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default");
        exps.add(defaultStr);
        int i = 2;
        while (i <= ctrlNum) {
            int eng = i / 2;
            if (devHeight != 6) {
                exps.add(--eng + "A/" + eng + "B");
                i += 2;
                continue;
            }
            if (eng % 2 != 0) {
                exps.add((eng /= 2) + "A/" + eng + "B");
            } else {
                exps.add((eng /= 4) + "C/" + eng + "D");
            }
            i += 2;
        }
        List data = devHeight == 6 ? (List)ConstantField.DORADO18000_CROSS_DISK_DOMAIN.getOrDefault(ctrlNum, new ArrayList()) : (List)ConstantField.DORADO6000_CROSS_DISK_DOMAIN.getOrDefault(ctrlNum, new ArrayList());
        exps.addAll(data);
        ArrayList<String> expsCopy = new ArrayList<String>(exps);
        for (List<String> ctrs : ctrlsDD.values()) {
            boolean isCross = ctrs.size() == 4;
            Object[] ctrArr = new String[ctrs.size()];
            ctrs.toArray(ctrArr);
            String ctrStr = StringUtils.join((Object[])ctrArr, (String)"/");
            for (String exp : exps) {
                boolean remove = isCross ? this.isRemove((String[])ctrArr, ctrStr, exp) : exp.contains(ctrStr) && !exp.equals(ctrStr);
                if (!remove) continue;
                expsCopy.remove(exp);
            }
        }
        return this.getResult(expsCopy, defaultStr);
    }

    private List<String> getResult(List<String> expsCopy, String defaultStr) {
        ArrayList<String> result = new ArrayList<String>();
        for (String exp : expsCopy) {
            result.add(this.handle(exp, defaultStr));
        }
        return result;
    }

    private String handle(String s, String exter) {
        if (!s.equals(exter)) {
            String value = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.3", (Object[])new Object[]{s});
            this.moveCardExpList.put(value, s);
            return ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.3", (Object[])new Object[]{s});
        }
        return s;
    }

    private boolean isRemove(String[] ctrArr, String ctrStr, String eng) {
        boolean isCross;
        String[] engArr = eng.split("/");
        boolean bl = isCross = engArr.length == 4;
        if (!isCross) {
            return ctrStr.contains(eng);
        }
        int count = 0;
        block0: for (String curCtr : ctrArr) {
            for (String ctr : engArr) {
                if (!curCtr.equals(ctr)) continue;
                ++count;
                continue block0;
            }
        }
        if (count == 2) {
            return true;
        }
        if (count == 4) {
            return false;
        }
        return false;
    }

    private String[] getLimitDiskType() {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        LOG.info("getDevType:{}", (Object)devInfo.getDevType());
        if (ConstantField.DORADO_DEV.contains(devInfo.getDevType().toUpperCase(Locale.ENGLISH))) {
            return this.getDoradoLimitDiskType(devInfo, devInfo.getDevType());
        }
        if (ConstantField.DORADO_NAS_DEV.contains(devInfo.getDevType().toUpperCase(Locale.ENGLISH))) {
            return DORADO_NAS_LIMIT;
        }
        return DISK_TYPE;
    }

    private String[] getDoradoLimitDiskType(DevInfo4Exp devInfo, String productModel) {
        Map<String, Map<String, String>> internalMap;
        String vrc = "";
        String internal = devInfo.getInternalModel();
        String productVersion = devInfo.getProductVersion();
        LOG.info("internal:{},productVersion:{},productModel:{}", new Object[]{internal, productVersion, productModel});
        if (productVersion.contains(".")) {
            vrc = this.getVrcFromDigitalVersion(productVersion);
        } else {
            vrc = devInfo.getProductVersion().substring(0, 11);
            if (vrc.compareTo("V300R001C21") < 0) {
                return this.getDoradoSpecialLimit(devInfo.isNVMe());
            }
        }
        if (LIMIT_DISK_TYPE.containsKey(productModel) && (internalMap = LIMIT_DISK_TYPE.get(productModel)).containsKey(internal)) {
            if (internal.equals("Dorado5000_V3")) {
                return this.getDoradoSpecialLimit(devInfo.isNVMe());
            }
            Map<String, String> limitMap = internalMap.get(internal);
            if (ConstantField.SUPPORT_QLC_DISK_INTERNAL.contains(internal)) {
                return this.getSupportQLCDiskType(devInfo);
            }
            return this.getDoradoArray(vrc, limitMap);
        }
        return DISK_TYPE;
    }

    private String[] getSupportQLCDiskType(DevInfo4Exp devInfo) {
        List disks;
        ArrayList<EngineDiskInfo> devEnginDiskInfo = (ArrayList<EngineDiskInfo>)InspectContext.getInstance().getDevInfo().getDevEngineDiskInfo().clone();
        if (devEnginDiskInfo.isEmpty()) {
            devEnginDiskInfo = devInfo.getFreeDevEngineDiskInfo();
        }
        if ((disks = devEnginDiskInfo.stream().map(EngineDiskInfo::getDisks).flatMap(Collection::stream).collect(Collectors.toList())).stream().anyMatch(disk -> ConstantField.QLC_DISK_TYPE.contains(disk.getType()))) {
            return CAPACITY_OPTIMIZED_SSD_LIMIT;
        }
        return DORADO_NVME_LIMIT;
    }

    private String getVrcFromDigitalVersion(String productVersion) {
        String vrcStr = productVersion;
        Pattern pattern = Pattern.compile("\\d+\\.\\d+\\.\\w+");
        Matcher matcher = pattern.matcher(productVersion);
        if (matcher.find()) {
            int endIndex = matcher.end();
            vrcStr = productVersion.substring(0, endIndex);
        }
        return vrcStr;
    }

    public String[] getDoradoArray(String vrc, Map<String, String> limitMap) {
        for (Map.Entry<String, String> entry : limitMap.entrySet()) {
            if (!String.valueOf(entry.getValue()).contains(vrc) && Products.compareVersion((String)vrc, (String)String.valueOf(entry.getValue())) < 0) continue;
            LimitDiskType types = LimitDiskType.getByValue(entry.getKey());
            switch (types) {
                case NONE: {
                    LOG.info("Dorado disk type is NONE");
                    return DORADO_NO_LIMIT;
                }
                case SAS: {
                    LOG.info("Dorado disk type is SAS");
                    return DORADO_SAS_LIMIT;
                }
                case NV_ME: {
                    LOG.info("Dorado disk type is NVMe");
                    return DORADO_NVME_LIMIT;
                }
                case SAS_V6: {
                    LOG.info("Dorado disk type is SAS_V6");
                    return DORADO_V6_SAS_LIMIT;
                }
                case NVME_V6: {
                    LOG.info("Dorado disk type is NVMe_V6");
                    return DORADO_V6_NVME_LIMIT;
                }
                case HDD: {
                    LOG.info("OCEAN_PROTECT disk type is HDD");
                    return OCEAN_PROTECT_HDD_LIMIT;
                }
                case NEW_DORADO_HDD: {
                    LOG.info("NEW DORADO disk type is NEW_DORADO_HDD");
                    return NEW_DORADO_HDD_LIMIT;
                }
                case CAPACITY_OPTIMIZED_SSD: {
                    LOG.info("NEW DORADO disk type is NEW_DORADO_HDD");
                    return CAPACITY_OPTIMIZED_SSD_LIMIT;
                }
            }
        }
        return DISK_TYPE;
    }

    private String[] getDoradoSpecialLimit(boolean isNvme) {
        if (isNvme) {
            LOG.info("dorado disk type is NVMe");
            return DORADO_NVME_LIMIT;
        }
        LOG.info("dorado disk type is SAS");
        return DORADO_SAS_LIMIT;
    }

    private String getPhysicEng(String eng) {
        if (eng == null) {
            return eng;
        }
        if (eng.startsWith("ENG") || eng.startsWith("CTE")) {
            return eng;
        }
        if (com.huawei.ism.tool.base.utils.StringUtils.isDigit((String)eng)) {
            int logicEng = Integer.parseInt(eng);
            int height = InspectContext.getInstance().getDevInfo().getDevHeight();
            String[] expModeInfo = InspectContext.getInstance().getDevInfo().getExpModeInfoList();
            if (height == 6 && expModeInfo != null && expModeInfo.length > 0) {
                int pEngId = logicEng / 2;
                return "CTE" + pEngId;
            }
            DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
            String engHead = "CTE";
            if (devInfo.getEngs().contains("ENG0")) {
                engHead = "ENG";
            }
            return engHead + eng;
        }
        return eng;
    }

    private Strategy updateData(TableRow row) {
        String diskBom;
        Object selected;
        int index = 0;
        InnerParameter innerParameter = new InnerParameter();
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String deviceType = devInfo.getDevType();
        String version = devInfo.getProductVersion();
        ExtendModel configMode = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        if (StrategySettingCard.isMoveCardScenario(deviceType, version)) {
            innerParameter.isolation = true;
        }
        Strategy strategy = (Strategy)row.getIdentifier();
        innerParameter.expDiskMode = (String)((IsmTableCell.ComboBoxCell)row.getValueAt(index++)).getSelectedItem();
        if (innerParameter.isolation) {
            innerParameter.diskDd = (selected = row.getValueAt(index++)) instanceof String ? (String)selected : (selected instanceof IsmTableCell.ComboBoxCell ? (String)((IsmTableCell.ComboBoxCell)selected).getSelectedItem() : "");
            CharSequence[] values = this.getCtrls(innerParameter.diskDd);
            innerParameter.ctrls = this.getCtrlInfo(innerParameter.diskDd);
            innerParameter.crossEngs = String.join((CharSequence)",", values);
        }
        if (this.redundantEnclosure.addOneColumn && (selected = row.getValueAt(index++)) instanceof IsmTableCell.ComboBoxCell) {
            innerParameter.diskEnclosureId = (String)((IsmTableCell.ComboBoxCell)selected).getSelectedItem();
        }
        innerParameter.diskBom = diskBom = (String)((IsmTableCell.MsgTextCell)row.getValueAt(index++)).getEditor().getCellEditorValue();
        index = this.getValueOfBomList(row, innerParameter, index);
        innerParameter.diskNum = (String)((IsmTableCell.MsgTextCell)row.getValueAt(index++)).getEditor().getCellEditorValue();
        innerParameter.diskModelDisplay = innerParameter.diskType;
        innerParameter.diskWorkMode = "1";
        return this.setStrategy(innerParameter, configMode, strategy);
    }

    private Strategy setStrategy(InnerParameter innerParameter, ExtendModel configMode, Strategy strategy) {
        if (innerParameter.expDiskMode.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.4")) && !ExtendModel.CTRL_EXP_INSPECT.equals((Object)configMode)) {
            innerParameter.expDiskMode = innerParameter.diskDd;
        }
        if (innerParameter.diskType.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.HWCMSSD"))) {
            innerParameter.diskType = ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.combox.disk.type.SSD");
            innerParameter.diskWorkMode = EMPTY_POOL_EXP_DISK_NUM;
        }
        LOG.info("expDiskMode={}", (Object)innerParameter.expDiskMode);
        String expModeValue = this.layout.getExpDiskMap().get(innerParameter.expDiskMode);
        if (expModeValue == null || expModeValue.split(",").length != 2) {
            expModeValue = "none,none";
        }
        String[] expModes = expModeValue.split(",");
        String eng = expModes[0];
        String diskDomain = expModes[1];
        strategy.setPerformanceLayerModel(false);
        if (diskDomain.contains(SMART_POOL_FLAG)) {
            strategy.setPerformanceLayerModel(true);
            diskDomain = diskDomain.replace(SMART_POOL_FLAG, "");
        }
        strategy.setCrossEng(innerParameter.crossEngs);
        strategy.setExpDiskMode(innerParameter.expDiskMode);
        strategy.setEng(this.getPhysicEng(eng));
        strategy.setDiskDomain(diskDomain);
        strategy.setDiskModel(innerParameter.diskType);
        strategy.setDiskBom(innerParameter.diskBom);
        strategy.setDiskCapacity(innerParameter.diskCap);
        strategy.setUnit(Strategy.Unit.valueOf(innerParameter.capUnit));
        strategy.setDiskNum(innerParameter.diskNum);
        strategy.setLogicEng(eng);
        strategy.setCtrls(innerParameter.ctrls);
        strategy.setDiskWorkMode(innerParameter.diskWorkMode);
        strategy.setDiskModelDisplay(innerParameter.diskModelDisplay);
        strategy.setDiskEnclosureId(innerParameter.diskEnclosureId);
        return strategy;
    }

    private boolean checkExntedModel(ExtendModel configMode) {
        if (configMode.equals((Object)ExtendModel.EXTEND_DEFAULT)) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.verify.unselect.expMode.msg"));
            return false;
        }
        return true;
    }

    private boolean checkExtendCtrls(ExtendModel configMode, String subConfigMode) {
        if (ExtendModel.CTRL_EXP_INSPECT.equals((Object)configMode) && subConfigMode.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.extendCtrlselect"))) {
            ArrayList<String> expSpecList = InspectContext.getInstance().getDevInfo().getExpSpec();
            if (expSpecList == null || expSpecList.isEmpty()) {
                DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.startinpectoraction.expctrl.error"));
                return false;
            }
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.verify.unselect.expCtrlsNum.msg"));
            return false;
        }
        return true;
    }

    private boolean checkSel4Veritas(ExtendModel configMode, String subSel4Veritas) {
        if (this.layout.getSubSel4VeritasBox().isVisible() && subSel4Veritas.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.extendVeritasSelect"))) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.extendVeritasSelect"));
            return false;
        }
        return true;
    }

    private boolean checkSel4InnerMetro(String subSel4Veritas) {
        if (this.layout.getSubSel4InnerMetroBox().isVisible() && subSel4Veritas.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.requireInnerMetroSelect"))) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.requireInnerMetroSelect"));
            return false;
        }
        return true;
    }

    private boolean checkBomValid() {
        return this.checkCtrlBomValid() && this.checkEncBomValid() && this.checkDiskEncBomValid() && this.checkInterfaceBomValid() && this.checkInterfaceCardBomValid();
    }

    private boolean checkInterfaceCardBomValid() {
        if (!this.layout.getInterfaceCardBomBox().isVisible()) {
            return true;
        }
        String interfaceCardBom = InspectContext.getInstance().getInterfaceCardBom();
        LOG.info("new interface card bom:{}", (Object)interfaceCardBom);
        if (this.isBomInvalid(interfaceCardBom, true)) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.invalid.interface.card.bom"));
            return false;
        }
        return true;
    }

    private boolean checkInterfaceBomValid() {
        if (this.layout.getInterfaceBomBox().isVisible()) {
            String interfaceBom = InspectContext.getInstance().getInterfaceBom();
            LOG.info("new interface bom:{}", (Object)interfaceBom);
            if (com.huawei.ism.tool.base.utils.StringUtils.isNULLObjectOrNullStr((String)interfaceBom)) {
                InspectContext.getInstance().setInterfaceBom("");
            } else if (this.isBomInvalid(interfaceBom, true)) {
                DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.invalid.interface.bom"));
                return false;
            }
        } else {
            InspectContext.getInstance().setInterfaceBom("");
        }
        return true;
    }

    private boolean checkDiskEncBomValid() {
        if (this.layout.getDiskEnclosureBomBox().isVisible()) {
            String diskEnclosureBom = InspectContext.getInstance().getDiskEnclosureBom();
            LOG.info("new disk enc bom:{}", (Object)diskEnclosureBom);
            if (com.huawei.ism.tool.base.utils.StringUtils.isNULLObjectOrNullStr((String)diskEnclosureBom)) {
                InspectContext.getInstance().setDiskEnclosureBom("");
            } else if (this.isBomInvalid(diskEnclosureBom, true)) {
                DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.invalid.disk.enc.bom"));
                return false;
            }
        } else {
            InspectContext.getInstance().setDiskEnclosureBom("");
        }
        return true;
    }

    private boolean checkEncBomValid() {
        if (!this.layout.getEncBomBox().isVisible()) {
            return true;
        }
        String encBom = InspectContext.getInstance().getEncBom();
        LOG.info("new enclosure bom:{}", (Object)encBom);
        if (this.isBomInvalid(encBom, false)) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.invalid.enc.bom"));
            return false;
        }
        return true;
    }

    private boolean checkCtrlBomValid() {
        if (!this.layout.getCtrlBomBox().isVisible()) {
            return true;
        }
        String ctrlBom = InspectContext.getInstance().getCtrlBom();
        LOG.info("new controller bom:{}", (Object)ctrlBom);
        if (this.isBomInvalid(ctrlBom, false)) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.invalid.ctrl.bom"));
            return false;
        }
        return true;
    }

    private boolean isBomInvalid(String bom, boolean canAllNumbersBom) {
        if (bom == null) {
            return true;
        }
        String[] bomList = bom.split(",");
        String pattern = "(?![0-9]{8})(?![a-zA-Z]{8})[0-9A-Za-z]{8}";
        if (canAllNumbersBom) {
            pattern = "(?![a-zA-Z]{8})[0-9A-Za-z]{8}";
        }
        for (String bomNum : bomList) {
            if (bomNum.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean checkDiskExpConfig(List<TableRow> rows, ExtendModel configMode, String subConfigMode) {
        if (!this.layout.getAddConfigBtn().isVisible()) {
            if (ExtendModel.DD_EXP_INSPECT.equals((Object)configMode) || ExtendModel.NEW_OCEAN_STR_DD_EXP_INSPECT.equals((Object)configMode)) {
                DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.expdd.unsupport"));
                return false;
            }
            return true;
        }
        if (rows != null && !rows.isEmpty()) {
            return true;
        }
        if (!configMode.equals((Object)ExtendModel.CTRL_EXP_INSPECT)) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.unadd.error"));
            return false;
        }
        return this.checkDiskExpConfigForCtrlExp(configMode, subConfigMode);
    }

    private boolean checkDiskExpConfigForCtrlExp(ExtendModel configMode, String subConfigMode) {
        String expCtrlStr = this.layout.getExpCtrlMap().get(subConfigMode);
        int expCtrlNum = Integer.parseInt(expCtrlStr);
        int curCtrlNum = InspectContext.getInstance().getDevInfo().getDevCtrlsNum();
        if (expCtrlNum == 2) {
            WarningDialog expModeConfirm = DialogUtils.showYesNoDialog((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.unadd.warning"));
            return 0 == expModeConfirm.getValue();
        }
        if (this.isInnerMetroNetWork()) {
            WarningDialog expModeConfirm = DialogUtils.showYesNoDialog((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.unadd.warning"));
            return 0 == expModeConfirm.getValue();
        }
        if ((InspectContext.getInstance().getDevInfo().isHasSASbigCard() || this.hasSharedCard()) && curCtrlNum % PER_CTRL_NUM_4_6U != 0 && expCtrlNum - curCtrlNum == 2) {
            WarningDialog expModeConfirm = DialogUtils.showYesNoDialog((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.unadd.warning"));
            return 0 == expModeConfirm.getValue();
        }
        if (InspectUtils.isMicro(InspectContext.getInstance().getDevInfo()).booleanValue()) {
            return true;
        }
        DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.unadd.error"));
        return false;
    }

    private String checkMinDiskNum(InnerParameter innerParameter, boolean isolation, boolean isCross, List<TableRow> rows) {
        if (!this.isNeedCheckMinDiskNum(innerParameter)) {
            return "";
        }
        LOG.info("checkMinDiskNum:{}", (Object)innerParameter.diskNum);
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        if (this.isFlashingDev(devInfo)) {
            return this.checkHybridFlashMinDiskNum(innerParameter.diskType, innerParameter.diskNum);
        }
        if (ConstantField.NEW_DORADO_DEV.contains(devInfo.getDevType())) {
            return this.checkHybridV6MinDiskNum(devInfo, rows);
        }
        int minNum = MIN_DISK_NUM;
        if (ConstantField.DORADO_DEV.contains(devInfo.getDevType().toUpperCase(Locale.ENGLISH))) {
            minNum = 8;
        }
        if (this.supportSixPlate(devInfo)) {
            minNum = 6;
        }
        if (isolation && isCross || this.isInnerMetroNetWork()) {
            minNum = 16;
        }
        LOG.info("checkMinDiskNum minNum:{}", (Object)minNum);
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)innerParameter.diskNum) && Integer.parseInt(innerParameter.diskNum) != 0 && minNum > Integer.parseInt(innerParameter.diskNum)) {
            LOG.info("checkMinDiskNum minNum:{} is not enough!", (Object)minNum);
            return this.getMinDiskMsg(minNum, devInfo);
        }
        return "";
    }

    private boolean supportSixPlate(DevInfo4Exp devInfo) {
        String productModel = devInfo.getDevType().toUpperCase(Locale.ENGLISH);
        String productVersion = devInfo.getProductVersion();
        return ConstantField.DORADO_DEV_SUPPORT_6_PLATE.contains(productModel) && Products.compareVersion((String)productVersion, (String)MIN_PRODUCT_VERSION) >= 0;
    }

    private boolean supportMin4Disk(DevInfo4Exp devInfo) {
        String productModel = devInfo.getDevType().toUpperCase(Locale.ENGLISH);
        String productVersion = devInfo.getProductVersion();
        if (ConstantField.HYBRID_FLASH_MIN_4HDD.contains(productModel)) {
            return Products.compareVersion((String)productVersion, (String)MIN_PRODUCT_VERSION) >= 0;
        }
        return ConstantField.ENTRY_LEVEL_SUPPORT_MIN_4HDD.contains(productModel) && Products.compareVersion((String)productVersion, (String)MIN_PRODUCT_VERSION_ENTRY_LEVEL) >= 0;
    }

    private String getMinDiskMsg(int minNum, DevInfo4Exp devInfo) {
        if (FsExpansionUtils.isNewDoradoHddDev(devInfo)) {
            return ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.verify.emptyPool.minDiskNum.msg", (Object[])new Object[]{minNum});
        }
        if (FsExpansionUtils.isNewDoraoFlashDev(devInfo)) {
            return ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.verify.minDiskNum.newFlashDev.msg", (Object[])new Object[]{minNum});
        }
        return ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.verify.minDiskNum.msg", (Object[])new Object[]{minNum});
    }

    private boolean isNeedCheckMinDiskNum(InnerParameter innerParameter) {
        String createDdMode = ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.0");
        String createPoolMode = ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.newPool");
        String createFlashDevPoolMode = this.getFlashDevExpModeStr();
        return innerParameter.diskExpMode.equals(createDdMode) || innerParameter.diskExpMode.contains(createPoolMode) || this.isEmptyPool(innerParameter) || innerParameter.diskExpMode.contains(createFlashDevPoolMode);
    }

    private String checkHybridFlashMinDiskNum(String diskType, String diskNumStr) {
        int hyMinNum = ConstantField.HDD_DISK_MODEL.contains(diskType) ? 8 : 6;
        String version = InspectContext.getInstance().getDevInfo().getProductVersion();
        if (!ConstantField.HDD_DISK_MODEL.contains(diskType) && Products.compareVersion((String)version, (String)OCEAN_PROTECT_130) >= 0) {
            hyMinNum = 4;
        }
        if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)diskNumStr) && hyMinNum > Integer.parseInt(diskNumStr)) {
            return ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.verify.HybridFlash.minDiskNum.msg", (Object[])new Object[]{diskType, hyMinNum});
        }
        return "";
    }

    private String checkHybridV6MinDiskNum(DevInfo4Exp devInfo, List<TableRow> rows) {
        int minNum;
        rows = rows.stream().filter(row -> !this.isExpPerformanceLayer((TableRow)row)).collect(Collectors.toList());
        HashMap<String, EngineDiskInfo> expEngineDiskInfo = this.getExpEngineDiskInfoFromStrategy(rows);
        int n = minNum = this.supportMin4Disk(devInfo) ? 4 : 8;
        if (rows.stream().map(this::updateData).anyMatch(strategy -> !this.checkNotNewPool((Strategy)strategy) && Integer.parseInt(strategy.getDiskNum()) < minNum)) {
            return this.getMinDiskMsg(minNum, devInfo);
        }
        for (String key : expEngineDiskInfo.keySet()) {
            ArrayList<Disk> expDisks = expEngineDiskInfo.get(key).getDisks();
            int diskNum = 0;
            for (Disk expDisk : expDisks) {
                diskNum += Integer.parseInt(expDisk.getCount());
            }
            if (diskNum == 0 || diskNum >= minNum) continue;
            return this.getMinDiskMsg(minNum, devInfo);
        }
        return "";
    }

    private HashMap<String, ArrayList<String>> getDDMap() {
        String[] ddInfoList = InspectContext.getInstance().getDevInfo().getDdInfoList();
        if (null == ddInfoList) {
            return null;
        }
        HashMap<String, ArrayList<String>> ddMap = new HashMap<String, ArrayList<String>>();
        for (String info : ddInfoList) {
            String[] infoList = info.split(":");
            if (null == infoList || infoList.length < 2) continue;
            String eng = infoList[0];
            String dd = infoList[1];
            if (ddMap.containsKey(dd)) {
                ddMap.get(dd).add(eng);
                continue;
            }
            ArrayList<String> englist = new ArrayList<String>();
            englist.add(eng);
            ddMap.put(dd, englist);
        }
        return ddMap;
    }

    private boolean checkDiskConfig(List<TableRow> rows, ExtendModel configMode) {
        boolean condition;
        HashSet<String> unSelectSet = new HashSet<String>();
        HashSet<String> unInputSet = new HashSet<String>();
        HashSet<String> errInputSet = new HashSet<String>();
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String deviceType = devInfo.getDevType();
        String version = devInfo.getProductVersion();
        boolean isolation = StrategySettingCard.isMoveCardScenario(deviceType, version);
        this.initValue(rows, unSelectSet, unInputSet, errInputSet, isolation);
        this.setDiskInfo(rows, configMode, unSelectSet, unInputSet, errInputSet, isolation);
        StringBuffer errMsgBuffer = new StringBuffer();
        if (!this.verifyInput(unSelectSet, unInputSet, errInputSet, errMsgBuffer)) {
            return false;
        }
        if (rows.isEmpty()) {
            return true;
        }
        boolean bl = condition = !this.checkMirror(rows) || !this.checkDiskNum(rows) || !this.checkExpandDD(rows, configMode) || !this.checkSmartPool(configMode) || !this.checkDiskCap(rows);
        if (condition) {
            return false;
        }
        WarningDialog wdlg = DialogUtils.showYesNoDialog((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.confirm"));
        return 0 == wdlg.getValue();
    }

    private boolean isEmptyPool(InnerParameter innerParameter) {
        HashMap<String, EngineDiskInfo> devEngineDiskInfo = this.getDevEngineDiskInfo();
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        ArrayList<String> engs = devInfo.getEngs();
        ArrayList<String> pools = devInfo.getDevPools();
        if (!FsExpansionUtils.isNewDoradoHddDev(devInfo) && !FsExpansionUtils.isMicroFlashDev(devInfo)) {
            return false;
        }
        String expModel = innerParameter.diskExpMode;
        if (expModel.contains(ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.expPerformanceLayer"))) {
            return false;
        }
        String keyStr = "";
        String currentPoolId = "";
        for (String eng : engs) {
            for (String pool : pools) {
                if (!expModel.equalsIgnoreCase(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.expPoolOnEngine", (Object[])new Object[]{eng, pool}))) continue;
                keyStr = pool + "#" + eng;
                currentPoolId = pool;
            }
        }
        String keyWord = "";
        ArrayList<Disk> diskInfo = new ArrayList<Disk>();
        for (String eng : engs) {
            keyWord = currentPoolId + "#" + eng;
            if (devEngineDiskInfo.get(keyWord) == null) continue;
            diskInfo.addAll(devEngineDiskInfo.get(keyWord).getDisks());
        }
        LOG.info("diskInfo: {}", diskInfo);
        if (!diskInfo.isEmpty()) {
            return false;
        }
        if (devEngineDiskInfo.get(keyStr) == null) {
            return true;
        }
        return devEngineDiskInfo.get(keyStr).getDisks().isEmpty();
    }

    private void setDiskInfo(List<TableRow> rows, ExtendModel configMode, HashSet<String> unSelectSet, HashSet<String> unInputSet, HashSet<String> errInputSet, boolean isolation) {
        String diskEnclosureId = ResourceUtil.getString((String)"inspect.wizard.strategysetting.diskenclosure.noneed");
        String minDiskNumMsg = "";
        for (TableRow row : rows) {
            Object selected;
            InnerParameter innerParameter = new InnerParameter();
            innerParameter.diskEnclosureId = diskEnclosureId;
            innerParameter.isolation = isolation;
            int index = 0;
            innerParameter.diskDd = "";
            boolean isCross = false;
            innerParameter.diskExpMode = (String)((IsmTableCell.ComboBoxCell)row.getValueAt(index++)).getSelectedItem();
            if (isolation) {
                selected = row.getValueAt(index++);
                innerParameter.diskDd = this.getRowValue(selected);
                String ctrls = this.getCtrlInfo(innerParameter.diskDd);
                String[] ctrArr = ctrls.split("/");
                boolean bl = isCross = ctrArr.length == 4;
            }
            if (this.redundantEnclosure.addOneColumn && (selected = row.getValueAt(index++)) instanceof IsmTableCell.ComboBoxCell) {
                innerParameter.diskEnclosureId = (String)((IsmTableCell.ComboBoxCell)selected).getSelectedItem();
            }
            String diskBom = (String)((IsmTableCell.MsgTextCell)row.getValueAt(index++)).getEditor().getCellEditorValue();
            index = this.getValueOfBomList(row, innerParameter, index);
            innerParameter.diskNum = (String)((IsmTableCell.MsgTextCell)row.getValueAt(index++)).getEditor().getCellEditorValue();
            this.getUnInputSet(unSelectSet, unInputSet, innerParameter, configMode, diskBom);
            minDiskNumMsg = this.checkMinDiskNum(innerParameter, isolation, isCross, rows);
            if ("".equalsIgnoreCase(minDiskNumMsg)) continue;
            errInputSet.add(minDiskNumMsg);
        }
    }

    private void getUnInputSet(HashSet<String> unSelectSet, HashSet<String> unInputSet, InnerParameter innerParameter, ExtendModel configMode, String diskBom) {
        boolean temp;
        if (innerParameter.diskExpMode.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"))) {
            unSelectSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.extendMode"));
        }
        boolean bl = temp = innerParameter.isolation && innerParameter.diskDd.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default")) && !ExtendModel.CTRL_EXP_INSPECT.equals((Object)configMode);
        if (temp) {
            unSelectSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskDomainName"));
        }
        if (innerParameter.diskType.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"))) {
            unSelectSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskModel"));
        }
        if (innerParameter.diskEnclosureId.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.diskenclosure.noenclosure"))) {
            unSelectSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.EnclosureID"));
        }
        if (innerParameter.capUnit.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"))) {
            unSelectSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.unit"));
        }
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)innerParameter.diskCap)) {
            unInputSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskCapacity"));
        }
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)innerParameter.diskNum)) {
            unInputSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskCount"));
        }
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)diskBom)) {
            unInputSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskBom"));
        }
    }

    private void getUnInputSet(HashSet<String> unSelectSet, HashSet<String> unInputSet, InnerParameter innerParameter, String diskBom) {
        if (innerParameter.diskExpMode.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"))) {
            unSelectSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.extendMode"));
        }
        if (innerParameter.diskEnclosureId.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.diskenclosure.noenclosure"))) {
            unSelectSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.EnclosureID"));
        }
        if (innerParameter.diskType.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"))) {
            unSelectSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskModel"));
        }
        if (innerParameter.capUnit.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default"))) {
            unSelectSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.unit"));
        }
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)innerParameter.diskCap)) {
            unInputSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskCapacity"));
        }
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)innerParameter.diskNum)) {
            unInputSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskCount"));
        }
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)diskBom)) {
            unInputSet.add(ResourceUtil.getString((String)"inspect.wizard.strategysetting.headers.diskBom"));
        }
    }

    private boolean verifyInput(HashSet<String> unSelectSet, HashSet<String> unInputSet, HashSet<String> errInputSet, StringBuffer errMsgBuffer) {
        if (!unSelectSet.isEmpty()) {
            errMsgBuffer.append(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.verify.unselect.msg", (Object[])new Object[]{unSelectSet.toString().replace("[", "").replace("]", "")}));
            errMsgBuffer.append(System.lineSeparator());
        }
        if (!unInputSet.isEmpty()) {
            errMsgBuffer.append(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.verify.uninput.msg", (Object[])new Object[]{unInputSet.toString().replace("[", "").replace("]", "")}));
            errMsgBuffer.append(System.lineSeparator());
            if (InspectUtils.isNewOceanStor(InspectContext.getInstance().getDevInfo()).booleanValue()) {
                errMsgBuffer.append(ResourceUtil.getString((String)"inspect.wizard.strategysetting.newDorado.checkDiskConfig.expEmpPoolPrompt"));
            }
        }
        if (!errInputSet.isEmpty()) {
            errMsgBuffer.append(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.verify.inputerr.msg", (Object[])new Object[]{errInputSet.toString().replace("[", "").replace("]", "")}));
            errMsgBuffer.append(System.lineSeparator());
        }
        if (errMsgBuffer.length() != 0) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)errMsgBuffer.toString());
            return false;
        }
        return true;
    }

    private void initValue(List<TableRow> rows, HashSet<String> unSelectSet, HashSet<String> unInputSet, HashSet<String> errInputSet, boolean isolation) {
        String minDiskNumMsg = "";
        for (TableRow row : rows) {
            InnerParameter innerParameter = new InnerParameter();
            int index = 0;
            boolean isCross = false;
            innerParameter.diskExpMode = (String)((IsmTableCell.ComboBoxCell)row.getValueAt(index++)).getSelectedItem();
            if (isolation) {
                Object selected = row.getValueAt(index++);
                String diskDD = "";
                diskDD = selected instanceof String ? (String)selected : (selected instanceof IsmTableCell.ComboBoxCell ? (String)((IsmTableCell.ComboBoxCell)selected).getSelectedItem() : "");
                String ctrls = this.getCtrlInfo(diskDD);
                String[] ctrArr = ctrls.split("/");
                isCross = ctrArr.length == 4;
            }
            innerParameter.diskEnclosureId = ResourceUtil.getString((String)"inspect.wizard.strategysetting.diskenclosure.noneed");
            if (this.redundantEnclosure.addOneColumn) {
                innerParameter.diskEnclosureId = (String)((IsmTableCell.ComboBoxCell)row.getValueAt(index++)).getSelectedItem();
            }
            String diskBom = (String)((IsmTableCell.MsgTextCell)row.getValueAt(index++)).getEditor().getCellEditorValue();
            index = this.getValueOfBomList(row, innerParameter, index);
            innerParameter.diskNum = (String)((IsmTableCell.MsgTextCell)row.getValueAt(index++)).getEditor().getCellEditorValue();
            this.getUnInputSet(unSelectSet, unInputSet, innerParameter, diskBom);
            minDiskNumMsg = this.checkMinDiskNum(innerParameter, isolation, isCross, rows);
            if ("".equalsIgnoreCase(minDiskNumMsg)) continue;
            errInputSet.add(minDiskNumMsg);
        }
    }

    private int getValueOfBomList(TableRow row, InnerParameter innerParameter, int index) {
        Object obj = row.getValueAt(index);
        int actualIndex = index;
        if (obj instanceof IsmTableCell.ComboBoxCell) {
            innerParameter.diskType = (String)((IsmTableCell.ComboBoxCell)row.getValueAt(actualIndex++)).getSelectedItem();
            innerParameter.diskCap = (String)((IsmTableCell.MsgTextCell)row.getValueAt(actualIndex++)).getEditor().getCellEditorValue();
            innerParameter.capUnit = (String)((IsmTableCell.ComboBoxCell)row.getValueAt(actualIndex++)).getSelectedItem();
        } else {
            innerParameter.diskType = (String)row.getValueAt(actualIndex++);
            innerParameter.diskCap = (String)row.getValueAt(actualIndex++);
            innerParameter.capUnit = (String)row.getValueAt(actualIndex++);
        }
        return actualIndex;
    }

    private String getRowValue(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof IsmTableCell.ComboBoxCell) {
            return (String)((IsmTableCell.ComboBoxCell)object).getSelectedItem();
        }
        return "";
    }

    private String getMirrorKey(String key, HashMap<String, ArrayList<String>> ddMap) {
        if (null == key || null == ddMap || ddMap.isEmpty()) {
            return "";
        }
        String[] infos = key.split(",");
        if (infos.length < 5) {
            return "";
        }
        String dd = infos[0];
        String eng = infos[1];
        for (String e : ddMap.get(dd)) {
            if (eng.equalsIgnoreCase(e)) continue;
            return dd + "," + e + "," + infos[2] + "," + infos[3] + "," + infos[4];
        }
        return "";
    }

    private boolean verifyStrategy(Strategy strategy) {
        String dd = strategy.getDiskDomain();
        if (null == dd || !com.huawei.ism.tool.base.utils.StringUtils.isDigit((String)dd)) {
            return false;
        }
        String eng = strategy.getEng();
        if (null == eng || !com.huawei.ism.tool.base.utils.StringUtils.isDigit((String)eng)) {
            return false;
        }
        String diskNum = strategy.getDiskNum();
        return null != diskNum && com.huawei.ism.tool.base.utils.StringUtils.isDigit((String)diskNum);
    }

    private HashMap<String, Integer> statisticDisks(List<TableRow> rows) {
        HashMap<String, Integer> statisticDiskCfg = new HashMap<String, Integer>();
        for (TableRow row : rows) {
            Strategy strategy = this.updateData(row);
            if (!this.verifyStrategy(strategy)) continue;
            String dd = strategy.getDiskDomain();
            String eng = strategy.getLogicEng();
            String diskModel = strategy.getDiskModel();
            String un = strategy.getUnit().toString();
            String cap = strategy.getDiskCapacity();
            String key = dd + "," + eng + "," + diskModel + "," + cap + "," + un;
            if (statisticDiskCfg.containsKey(key)) {
                statisticDiskCfg.put(key, statisticDiskCfg.get(key) + Integer.parseInt(strategy.getDiskNum()));
                continue;
            }
            statisticDiskCfg.put(key, Integer.parseInt(strategy.getDiskNum()));
        }
        return statisticDiskCfg;
    }

    private StringBuffer getMirrorErrMsgs(HashMap<String, Integer> statisticDiskCfg, HashMap<String, ArrayList<String>> ddMap) {
        ArrayList<String> checkedKeys = new ArrayList<String>();
        ArrayList<String> checkedEng = new ArrayList<String>();
        StringBuffer allErrMsg = new StringBuffer();
        for (Map.Entry<String, Integer> entry : statisticDiskCfg.entrySet()) {
            String k = entry.getKey();
            String mirrorKey = this.getMirrorKey(k, ddMap);
            LOG.info("check mirror, cur={},mirror={}", (Object)k, (Object)mirrorKey);
            if (checkedKeys.contains(k) || checkedKeys.contains(mirrorKey)) continue;
            checkedKeys.add(k);
            checkedKeys.add(mirrorKey);
            int diskNum = entry.getValue();
            if ("".equalsIgnoreCase(mirrorKey) || statisticDiskCfg.containsKey(mirrorKey) && statisticDiskCfg.get(mirrorKey) == diskNum) continue;
            String[] ls = k.split(",");
            String[] ms = mirrorKey.split(",");
            if (ls.length < 3 || ms.length < 3) {
                String errMsg = ResourceUtil.getString((String)"inspect.wizard.strategysetting.mirror.error");
                allErrMsg.append(errMsg);
                return allErrMsg;
            }
            String eng0 = this.getDisplayEngId(ls[1]);
            String eng1 = this.getDisplayEngId(ms[1]);
            String cKey = eng0 + "," + eng1;
            if (checkedEng.contains(cKey)) continue;
            checkedEng.add(cKey);
            checkedEng.add(eng1 + "," + eng0);
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.mirror.fail", (Object[])new Object[]{eng0, eng1});
            allErrMsg.append(errMsg + System.lineSeparator());
        }
        return allErrMsg;
    }

    private boolean checkExpandDD(List<TableRow> rows, ExtendModel configMode) {
        if (!configMode.equals((Object)ExtendModel.DD_EXP_INSPECT)) {
            return true;
        }
        LOG.info("start to check dd.");
        ArrayList<String> selDDs = new ArrayList<String>();
        for (TableRow row : rows) {
            String[] expModes;
            String diskDomain;
            String expDM = (String)((IsmTableCell.ComboBoxCell)row.getValueAt(0)).getSelectedItem();
            if (expDM.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.4"))) {
                expDM = (String)((IsmTableCell.ComboBoxCell)row.getValueAt(1)).getSelectedItem();
            }
            LOG.info("expDiskMode={}", (Object)expDM);
            String expModeValue = this.layout.getExpDiskMap().get(expDM);
            if (expModeValue == null || expModeValue.split(",").length != 2) {
                expModeValue = "none,none";
            }
            if ((diskDomain = (expModes = expModeValue.split(","))[1]).contains(SMART_POOL_FLAG)) continue;
            selDDs.add(diskDomain);
        }
        if (selDDs.size() < 2) {
            return true;
        }
        String cmpDiskDD = (String)selDDs.get(0);
        for (String domainId : selDDs) {
            if (cmpDiskDD.equals(domainId)) continue;
            String errMsg = ResourceUtil.getString((String)"inspect.wizard.strategysetting.expdd.error");
            DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)errMsg);
            return false;
        }
        return true;
    }

    private boolean checkMirror(List<TableRow> rows) {
        LOG.info("start check mirror cfg.");
        HashMap<String, ArrayList<String>> ddMap = this.getDDMap();
        if (null == ddMap || ddMap.isEmpty()) {
            LOG.info("disk domain and engine info is null.");
            return true;
        }
        LOG.info("disk domain mirror info is:{}", ddMap);
        HashMap<String, Integer> statisticDiskCfg = this.statisticDisks(rows);
        if (null == statisticDiskCfg || statisticDiskCfg.isEmpty()) {
            LOG.info("statistic disk cfg is null.");
            return true;
        }
        LOG.info("statistic disk cfg is :{}", statisticDiskCfg);
        StringBuffer allErrMsg = this.getMirrorErrMsgs(statisticDiskCfg, ddMap);
        if (allErrMsg.length() > 0) {
            DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)allErrMsg.toString());
            return false;
        }
        return true;
    }

    private boolean checkSmartPool(ExtendModel configMode) {
        if (this.isNotSupportSmartPoolModel(configMode)) {
            return true;
        }
        if (!this.setDiskCapacityExpansion()) {
            return false;
        }
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        try {
            String inspectConfPath = InspectContext.INSPECT_CONFPATH;
            String expInfoPath = inspectConfPath + File.separator + "products" + File.separator + "expinfo";
            String pyframe = inspectConfPath + File.separator + "products" + File.separator + "pyframe";
            String jythonFile = expInfoPath + File.separator + "script";
            String scriptFilePath = jythonFile + File.separator + "getExpInfo.py";
            String packagePath = inspectConfPath + File.separator + "products" + File.separator + "V3V300R003C00";
            JythonExecuter executer = new JythonExecuter(Arrays.asList(new File(pyframe), new File(jythonFile), new File(packagePath)));
            try {
                executer.compileScript(new File(scriptFilePath));
            }
            catch (SignException e) {
                LOG.error("verify Script error!", (Throwable)e);
                return false;
            }
            catch (FileNotFoundException e) {
                LOG.error("py file not found!scriptFilePath:{}", (Object)new File(scriptFilePath).getName());
                return false;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (!this.initParams(devInfo, params)) {
                DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)devInfo.getErrMsg());
                return false;
            }
            List ret = executer.invokeFunction("get_exp_performance_layer_evaluate_result", params);
            LOG.info("get_exp_performance_layer_evaluate_result Ret={}", (Object)ret);
            if (!((Boolean)ret.get(0)).booleanValue()) {
                String errMsg = (String)ret.get(1);
                DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)errMsg);
                return false;
            }
        }
        catch (ToolException e) {
            LOG.error("toolexception.", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean initParams(DevInfo4Exp devInfo, Map<String, Object> params) {
        ICliConnection cliConnection;
        params.put("logger", LOG);
        params.put("lang", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
        params.put("expDiskList", this.expDiskList);
        InnerISshJudge ender = new InnerISshJudge();
        try {
            cliConnection = SshConnectionManager.getSshConnection((DevNode)devInfo.getDevNode(), (ISshJudge)ender, (boolean)true, (boolean)false);
        }
        catch (ToolException e) {
            LOG.error("get ssh connection error!", (Throwable)e);
            devInfo.setErrMsg(ResourceUtil.getStringWithParams((String)"pre.expansion.cannotconnect2device", (Object[])new Object[]{devInfo.getDevNode().getIp()}));
            return false;
        }
        params.put("ssh", cliConnection);
        params.put("expEngines", devInfo.getEngs());
        params.put("is_new_oceanstor", InspectUtils.isNewOceanStor(devInfo));
        HashMap<String, String> deviceiInfo = new HashMap<String, String>();
        deviceiInfo.put("user", devInfo.getDevNode().getLoginUser().getUserName());
        deviceiInfo.put("pawd", devInfo.getDevNode().getLoginUser().getPassword());
        deviceiInfo.put("ip", devInfo.getDevNode().getIp());
        deviceiInfo.put("sn", devInfo.getDevNode().getDeviceSerialNumber());
        params.put("newDev", deviceiInfo);
        params.put("connectorFactory", ConnectorFactory.getInstance());
        return true;
    }

    private boolean checkDiskCap(List<TableRow> rows) {
        LOG.info("checkDiskCap start");
        StringBuffer allErrMsg = new StringBuffer();
        for (TableRow row : rows) {
            Float capf;
            Strategy strategy = this.updateData(row);
            String cap = strategy.getDiskCapacity();
            Strategy.Unit unit = strategy.getUnit();
            if (!Strategy.Unit.GB.equals((Object)unit) || !((capf = Float.valueOf(cap)).floatValue() < MIN_DISK_CAP.floatValue())) continue;
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.verify.minCapacity.msg", (Object[])new Object[]{cap + unit.toString()});
            allErrMsg.append(errMsg + System.lineSeparator());
        }
        if (allErrMsg.length() > 0) {
            DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)allErrMsg.toString());
            return false;
        }
        return true;
    }

    private boolean checkDiskNum(List<TableRow> rows) {
        LOG.info("start check max disk num.");
        String[] disks = InspectContext.getInstance().getDevInfo().getDisk4NVMe();
        if (null == disks) {
            return true;
        }
        HashMap<String, Integer> diskMap = new HashMap<String, Integer>();
        for (String s : disks) {
            String[] ss = s.split(":");
            if (ss.length < 2) continue;
            diskMap.put(ss[0], Integer.parseInt(ss[1]));
        }
        HashMap<String, Integer> statistic = new HashMap<String, Integer>();
        for (TableRow row : rows) {
            Strategy strategy = this.updateData(row);
            String eng = strategy.getEng();
            String num = strategy.getDiskNum();
            if (!com.huawei.ism.tool.base.utils.StringUtils.isDigit((String)eng) || !com.huawei.ism.tool.base.utils.StringUtils.isDigit((String)num)) continue;
            if (statistic.containsKey(eng)) {
                Integer count = (Integer)statistic.get(eng) + Integer.parseInt(num);
                statistic.put(eng, count);
                continue;
            }
            statistic.put(eng, Integer.parseInt(num));
        }
        StringBuffer allErrMsg = new StringBuffer();
        for (Map.Entry e : diskMap.entrySet()) {
            Integer ct;
            String k = (String)e.getKey();
            if (!statistic.containsKey(k) || (ct = Integer.valueOf((Integer)e.getValue() + (Integer)statistic.get(k))) <= 25) continue;
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.nvme.diskNum.fail", (Object[])new Object[]{"CTE" + k, 25});
            allErrMsg.append(errMsg + System.lineSeparator());
        }
        if (allErrMsg.length() > 0) {
            DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)allErrMsg.toString());
            return false;
        }
        return true;
    }

    private boolean checkData(List<TableRow> rows, ExtendModel configMode, String subConfigMode, String subSel4Veritas, String subSel4InnerMetro, String highDensityDiskEnclosure) {
        if (!this.checkExntedModel(configMode)) {
            return false;
        }
        if (!this.checkExtendCtrls(configMode, subConfigMode)) {
            return false;
        }
        if (!this.checkSel4Veritas(configMode, subSel4Veritas)) {
            return false;
        }
        if (!this.checkSel4InnerMetro(subSel4InnerMetro)) {
            return false;
        }
        if (!this.checkHighDensityDiskEnclosureBoxSelect(highDensityDiskEnclosure)) {
            return false;
        }
        if (!this.checkBomValid()) {
            return false;
        }
        if (!this.checkDiskExpConfig(rows, configMode, subConfigMode)) {
            return false;
        }
        if (!this.checkDiskConfig(rows, configMode)) {
            return false;
        }
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        if (ConstantField.DORADO_V6_DEV.contains(devInfo.getDevType().toUpperCase(Locale.ENGLISH)) && !this.checkDiskConfig4DoradoV6(rows)) {
            return false;
        }
        return ExpandScmPanel.getInstance().verify(configMode);
    }

    private boolean checkHighDensityDiskEnclosureBoxSelect(String highDensityDiskEnclosure) {
        if (this.layout.getHighDensityDiskEnclosureBox().isVisible() && highDensityDiskEnclosure.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.highDensityDiskEnclosureSelect"))) {
            DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.highDensityDiskEnclosureSelect"));
            return false;
        }
        return true;
    }

    private boolean checkNewDoradoFlashExpPool(Map<String, EngineDiskInfo> expEngineDiskInfo, Map<String, EngineDiskInfo> devEngineDiskInfo) {
        for (String key : expEngineDiskInfo.keySet()) {
            ArrayList<Disk> totalDisks = expEngineDiskInfo.get(key).getDisks();
            if (!devEngineDiskInfo.containsKey(key) && (totalDisks.size() != 1 || EMPTY_POOL_EXP_DISK_NUM.equals(((Disk)totalDisks.get(0)).getCount()))) continue;
            LOG.info("new dorado flash dev, but not exp exist engine:{} or not exp empty pool.", (Object)key);
            this.showExpFlashErrMsg();
            return false;
        }
        return true;
    }

    private void showExpFlashErrMsg() {
        String errMsg = ResourceUtil.getString((String)"inspect.wizard.strategysetting.newDorado.checkDiskConfig.newDoradoFlashExpEmpPoolPrompt");
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
    }

    private boolean checkIsMixSedStrategy(List<String> sedPool, Strategy strategy) {
        return this.checkNotNewPool(strategy) && (sedPool.contains(strategy.getDiskDomain()) && !strategy.getDiskModel().endsWith(SED) || strategy.getDiskModel().endsWith(SED) && !sedPool.isEmpty() && !sedPool.contains(strategy.getDiskDomain()));
    }

    private boolean checkSedDiskMix(List<TableRow> rows, HashMap<String, EngineDiskInfo> devEngineDiskInfo) {
        List sedPool = devEngineDiskInfo.keySet().stream().filter(poolEngKey -> this.filterSedPool(devEngineDiskInfo, (String)poolEngKey)).map(poolEngKey -> poolEngKey.split("#")[0]).collect(Collectors.toList());
        List errPools = rows.stream().map(this::updateData).filter(strategy -> this.checkIsMixSedStrategy(sedPool, (Strategy)strategy)).map(Strategy::getDiskDomain).distinct().collect(Collectors.toList());
        LOG.info("mix sed pool is:{}", errPools);
        errPools = errPools.stream().filter(this::filterNotEncryptionPool).collect(Collectors.toList());
        LOG.info("mix sed pool after filter encry is:{}", errPools);
        if (!errPools.isEmpty()) {
            String errorMsg = String.join((CharSequence)", ", errPools);
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.expPoolMixSed", (Object[])new Object[]{errorMsg}));
            return false;
        }
        return true;
    }

    private boolean filterNotEncryptionPool(String errPool) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        Object[] encryptionDomainList = devInfo.getEncryptionDiskDomainList();
        if (Utils.isNullArray((Object[])encryptionDomainList)) {
            return true;
        }
        String domainId = devInfo.getDevPoolAndDiskDomainMapping().get(errPool);
        return !Arrays.stream(encryptionDomainList).anyMatch(encryDomain -> encryDomain.equals(domainId));
    }

    private boolean filterSedPool(HashMap<String, EngineDiskInfo> devEngineDiskInfo, String poolEngKey) {
        return devEngineDiskInfo.get(poolEngKey).getDisks().stream().anyMatch(disk -> disk.getType().endsWith(SED));
    }

    private boolean checkDiskConfig4DoradoV6(List<TableRow> rows) {
        if (this.checkRedundantMuxedPool(rows)) {
            LOG.info("Capacity expansion is not supported for both storage pools with and without enclosure redundancy.");
            return false;
        }
        List<TableRow> actualRows = rows.stream().filter(row -> !this.isExpPerformanceLayer((TableRow)row)).collect(Collectors.toList());
        HashMap<String, EngineDiskInfo> expEngineDiskInfo = this.getExpEngineDiskInfoFromStrategy(actualRows);
        HashMap<String, EngineDiskInfo> devEngineDiskInfo = this.getDevEngineDiskInfo();
        if (!this.checkSedDiskMix(actualRows, devEngineDiskInfo)) {
            LOG.info("Exist some pool mix sed disk.");
            return false;
        }
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        if (FsExpansionUtils.isNewDoraoFlashDev(devInfo)) {
            return this.checkNewDoradoFlashExpPool(expEngineDiskInfo, devEngineDiskInfo);
        }
        if (!this.checkNewPoolContainSSDAndHDD4Hybrid(actualRows)) {
            return false;
        }
        if (!this.checkExpInDev(expEngineDiskInfo, devEngineDiskInfo)) {
            return false;
        }
        if (!this.checkEngineNumInExpPool(expEngineDiskInfo, devEngineDiskInfo)) {
            return false;
        }
        if (!this.checkExpPoolDiskConsistency(expEngineDiskInfo, devEngineDiskInfo, actualRows)) {
            return false;
        }
        if (this.redundantEnclosure.addOneColumn) {
            HashMap<String, EngineDiskInfo> totalEngineDiskInfo = this.getTotalEngineDiskInfo(expEngineDiskInfo, devEngineDiskInfo);
            LOG.info("expEngineDiskInfo:{}", (Object)JSON.toJSONString(expEngineDiskInfo));
            LOG.info("devEngineDiskInfo:{}", (Object)JSON.toJSONString(devEngineDiskInfo));
            if (!this.redundantEnclosure.checkEnclosureRedundantRules(totalEngineDiskInfo)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkRedundantMuxedPool(List<TableRow> rows) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        if (!InspectUtils.isNewOceanStor(devInfo).booleanValue()) {
            return false;
        }
        ArrayList expEnclosureIds = rows.stream().map(this::updateData).map(Strategy::getDiskEnclosureId).collect(Collectors.toCollection(ArrayList::new));
        LOG.info("expEnclosureIds:{}", (Object)expEnclosureIds);
        String nonEnclosureId = ResourceUtil.getString((String)"inspect.wizard.strategysetting.diskenclosure.noneed");
        if (expEnclosureIds.stream().anyMatch(expEnclosureId -> Objects.equals(expEnclosureId, nonEnclosureId)) && !expEnclosureIds.stream().allMatch(expEnclosureId -> Objects.equals(expEnclosureId, nonEnclosureId))) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.checkDiskConfig.RedundantMuxedPool"));
            return true;
        }
        return false;
    }

    private boolean isExpPerformanceLayer(TableRow row) {
        String diskExpMode = (String)((IsmTableCell.ComboBoxCell)row.getValueAt(0)).getSelectedItem();
        return diskExpMode.contains(ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.expPerformanceLayer"));
    }

    private boolean checkNewPoolContainSSDAndHDD4Hybrid(List<TableRow> rows) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        if (!this.isFlashingDev(devInfo)) {
            return true;
        }
        ArrayList<Strategy> strategyList = new ArrayList<Strategy>();
        for (TableRow row : this.layout.getModel().getAllRows()) {
            Strategy strategy = this.updateData(row);
            String expDiskMode = strategy.getExpDiskMode();
            if (!expDiskMode.contains(ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.newPool")) && !expDiskMode.contains(ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.newPoolPerformanceLayer"))) continue;
            strategyList.add(strategy);
        }
        Map<String, List<Strategy>> strategyByExpDiskMode = strategyList.stream().collect(Collectors.groupingBy(Strategy::getExpDiskMode));
        for (Map.Entry<String, List<Strategy>> entry : strategyByExpDiskMode.entrySet()) {
            Pattern pattern = Pattern.compile("ID:\\d+");
            Matcher matcher = pattern.matcher(entry.getKey());
            String poolId = "--";
            if (matcher.find()) {
                poolId = matcher.group(0).trim().split(":")[1];
            }
            boolean isContainHdd = false;
            boolean isContainSsd = false;
            for (Strategy strategy : entry.getValue()) {
                if (ConstantField.HDD_DISK_MODEL.contains(strategy.getDiskModel())) {
                    isContainHdd = true;
                    continue;
                }
                isContainSsd = true;
            }
            if (isContainHdd && isContainSsd) continue;
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.hybridFlash.diskType", (Object[])new Object[]{poolId});
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        return true;
    }

    private boolean checkExpPoolDiskConsistency(HashMap<String, EngineDiskInfo> expEngineDiskInfo, HashMap<String, EngineDiskInfo> devEngineDiskInfo, List<TableRow> rows) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        LOG.info("------checkExpPoolDiskConsistency----:devEngineDiskInfo{}", (Object)JSONUtils.toJson(devEngineDiskInfo));
        HashMap<String, EngineDiskInfo> totalEngineDiskInfo = this.getTotalEngineDiskInfo(expEngineDiskInfo, devEngineDiskInfo);
        LOG.info("------checkExpPoolDiskConsistency----:totalEngineDiskInfo{}", (Object)JSONUtils.toJson(totalEngineDiskInfo));
        HashMap<String, ArrayList<Disk>> tmpPoolDisks = new HashMap<String, ArrayList<Disk>>();
        HashMap<String, String> errPool = new HashMap<String, String>();
        boolean flag = true;
        String allErrMsg = "";
        StringBuilder stringBuilder = new StringBuilder();
        List<String> allEmptyPoolList = this.getExpEmptyPoolOnNewDorado(totalEngineDiskInfo);
        for (String key : totalEngineDiskInfo.keySet()) {
            ArrayList<Disk> totalDisks = new ArrayList<Disk>();
            String[] keyList = key.split("#");
            String poolId = keyList[0];
            ArrayList tmpDisks = (ArrayList)tmpPoolDisks.get(poolId);
            totalEngineDiskInfo.get(key).getDisks().forEach(disk -> this.mergeDiskToTotal(totalDisks, (Disk)disk));
            LOG.info("getDevEngineDiskInfo:poolId:{}, before merge:{}, after merge:{}", new Object[]{poolId, totalEngineDiskInfo.get(key).getDisks(), totalDisks});
            if (allEmptyPoolList.contains(poolId)) {
                LOG.info("exp empty pool no need check mirror.{}", (Object)poolId);
                continue;
            }
            if (this.checkExpEmptyPool(poolId, rows)) {
                return false;
            }
            if (tmpDisks == null) {
                tmpPoolDisks.put(poolId, totalDisks);
                continue;
            }
            String tmpErrPool = (String)errPool.get(poolId);
            if (this.checkDisksEqual(tmpDisks, totalDisks, poolId) || tmpErrPool != null) continue;
            String diskMsg = this.getDiskMsg(totalEngineDiskInfo, poolId);
            stringBuilder.append(diskMsg);
            flag = false;
            errPool.put(poolId, poolId);
        }
        if (!flag) {
            this.showDiskConsistencyErrorMsg(devInfo, stringBuilder);
        }
        return flag;
    }

    private void showDiskConsistencyErrorMsg(DevInfo4Exp devInfo, StringBuilder stringBuilder) {
        String allErrMsg = stringBuilder.toString();
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        String errorMsg = ResourceUtil.getString((String)"inspect.wizard.strategysetting.checkDiskConfig.expPoolDiskConsistency");
        String title = ResourceUtil.getString((String)"inspect.wizard.strategysetting.checkDiskConfig.expPoolDiskConsistency.title");
        String errDes = ResourceUtil.getString((String)"inspect.wizard.strategysetting.checkDiskConfig.expPoolDiskConsistency.des");
        DialogUtils.showMultiErrorDialogNoIgnoreButton((Window)mainDialog, (String)errorMsg, (String[])new String[]{title, errDes}, this.getErrorInfo(allErrMsg));
    }

    private List<List<String>> getErrorInfo(String allErrMsg) {
        return Arrays.stream(allErrMsg.split("\\n")).filter(ele -> !ele.isEmpty()).map(info -> Arrays.stream(info.split(": ")).collect(Collectors.toList())).sorted((o1, o2) -> this.getEngNum((String)o1.get(0)) - this.getEngNum((String)o2.get(0))).collect(Collectors.toList());
    }

    private int getEngNum(String str) {
        Matcher matcher = ENG_NUM.matcher(str);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    private boolean checkNotNewPool(Strategy strategy) {
        return !strategy.getExpDiskMode().contains(ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.newPool"));
    }

    private boolean filterStoragePool(String poolId, Strategy strategy) {
        return this.checkNotNewPool(strategy) && poolId.equals(strategy.getDiskDomain()) && EMPTY_POOL_EXP_DISK_NUM.equals(strategy.getDiskNum());
    }

    private boolean checkExpEmptyPool(String poolId, List<TableRow> rows) {
        if (rows.stream().map(this::updateData).anyMatch(strategy -> this.filterStoragePool(poolId, (Strategy)strategy))) {
            LOG.info("exist empty pool exp. not invalid:{}", (Object)poolId);
            String allErrMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.newDorado.checkDiskConfig.expPoolDiskZeroDiskNumPoolExp", (Object[])new Object[]{poolId});
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)allErrMsg);
            return true;
        }
        return false;
    }

    private List<String> getExpEmptyPoolOnNewDorado(Map<String, EngineDiskInfo> totalEngineDiskInfo) {
        ArrayList<String> emptyPoolList = new ArrayList<String>();
        HashMap emptyPoolDisksOnAllEng = new HashMap();
        totalEngineDiskInfo.keySet().forEach(key -> {
            String[] keyList = key.split("#");
            String poolId = keyList[0];
            ArrayList<Disk> totalDisks = ((EngineDiskInfo)totalEngineDiskInfo.get(key)).getDisks();
            emptyPoolList.add(poolId);
            if (emptyPoolDisksOnAllEng.get(poolId) != null) {
                ((List)emptyPoolDisksOnAllEng.get(poolId)).addAll(totalDisks);
            } else {
                emptyPoolDisksOnAllEng.put(poolId, totalDisks);
            }
        });
        if (emptyPoolList.isEmpty()) {
            return emptyPoolList;
        }
        return emptyPoolList.stream().filter(emptyPool -> this.filterEmptyEngine(emptyPoolDisksOnAllEng, (String)emptyPool)).collect(Collectors.toList());
    }

    private boolean filterEmptyEngine(Map<String, List<Disk>> emptyPoolDisksOnAllEng, String emptyPool) {
        List<Object> engineDisks = emptyPoolDisksOnAllEng.get(emptyPool) == null ? new ArrayList() : emptyPoolDisksOnAllEng.get(emptyPool);
        return engineDisks.stream().mapToInt(disk -> Integer.parseInt(disk.getCount())).sum() == 0;
    }

    private boolean checkEngineNumInExpPool(HashMap<String, EngineDiskInfo> expEngineDiskInfo, HashMap<String, EngineDiskInfo> devEngineDiskInfo) {
        int supportMaxEngNum = this.strategySettingCardService.getSupportMaxEngNum(InspectContext.getInstance().getDevInfo());
        HashMap<String, EngineDiskInfo> totalEngineDiskInfo = this.getTotalEngineDiskInfo(expEngineDiskInfo, devEngineDiskInfo);
        HashMap<String, Set<String>> poolEngine = new HashMap<String, Set<String>>();
        this.getPoolEngine(totalEngineDiskInfo, poolEngine);
        List erroKeyList = poolEngine.keySet().stream().filter(key -> ((Set)poolEngine.get(key)).size() > supportMaxEngNum).collect(Collectors.toList());
        if (!erroKeyList.isEmpty()) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.engineNumInExpPool", (Object[])new Object[]{String.join((CharSequence)",", erroKeyList), supportMaxEngNum});
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        return true;
    }

    private void getPoolEngine(HashMap<String, EngineDiskInfo> totalEngineDiskInfo, Map<String, Set<String>> poolEngine) {
        totalEngineDiskInfo.keySet().forEach(key -> {
            String[] keyList = key.split("#");
            String poolId = keyList[0];
            String engineName = keyList[1];
            if (!poolEngine.containsKey(poolId)) {
                poolEngine.put(poolId, new HashSet());
            }
            ((Set)poolEngine.get(poolId)).add(engineName);
        });
    }

    private String getDiskMsg(HashMap<String, EngineDiskInfo> totalEngineDiskInfo, String poolId) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String diskMsg = "";
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : totalEngineDiskInfo.keySet()) {
            String[] keyList = key.split("#");
            String currentPoolId = keyList[0];
            String currentEngineId = keyList[1];
            if (!currentPoolId.equalsIgnoreCase(poolId)) continue;
            ArrayList totalDisks = new ArrayList();
            totalEngineDiskInfo.get(key).getDisks().forEach(disk -> this.mergeDiskToTotal(totalDisks, (Disk)disk));
            for (Disk disk2 : totalDisks) {
                String poolDiskMsg = this.getPoolDiskMsg(devInfo, currentPoolId, currentEngineId, disk2);
                stringBuilder.append(poolDiskMsg);
            }
        }
        diskMsg = stringBuilder.toString();
        return diskMsg;
    }

    @NotNull
    private String getPoolDiskMsg(DevInfo4Exp devInfo, String currentPoolId, String currentEngineId, Disk disk) {
        String diskType = disk.getType();
        String diskCapacity = disk.getInputCapacity() + disk.getInputUnit();
        String diskNumber = disk.getCount();
        String poolDiskMsg = "";
        poolDiskMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.diskInfo", (Object[])new Object[]{currentEngineId, currentPoolId, diskType, diskCapacity, diskNumber});
        return poolDiskMsg;
    }

    private boolean checkDisksEqual(ArrayList<Disk> tmpDisks, ArrayList<Disk> totalDisks, String poolId) {
        List<Disk> tempDisks = this.combineSoftEncryptedDisks(tmpDisks, poolId);
        List<Disk> tempTotalDisks = this.combineSoftEncryptedDisks(totalDisks, poolId);
        if (tempDisks.size() != tempTotalDisks.size()) {
            return false;
        }
        for (Disk disk2 : tempTotalDisks) {
            String disk2Type = disk2.getType();
            double disk2Capacity = Double.parseDouble(disk2.getCapacity());
            int disk2Count = Integer.parseInt(disk2.getCount());
            boolean matchFlag = false;
            for (Disk disk1 : tempDisks) {
                String disk1Type = disk1.getType();
                double disk1Capacity = Double.parseDouble(disk1.getCapacity());
                int disk1Count = Integer.parseInt(disk1.getCount());
                if (!this.redundantEnclosure.checkDiskType(disk1Type, disk2Type, poolId) || !this.isSameDiskCapacity(disk2Capacity, disk1Capacity) || disk2Count != disk1Count) continue;
                matchFlag = true;
            }
            if (matchFlag) continue;
            return false;
        }
        return true;
    }

    private List<Disk> combineSoftEncryptedDisks(ArrayList<Disk> disks, String poolId) {
        if (this.filterNotEncryptionPool(poolId)) {
            return disks;
        }
        ArrayList encryptedDisks = (ArrayList)disks.stream().filter(disk -> disk.getType().contains(SED)).map(Disk::partialClone).collect(Collectors.toList());
        encryptedDisks.forEach(disk -> disk.setType(disk.getType().split(SED)[0].trim()));
        ArrayList newDisks = (ArrayList)disks.stream().filter(disk -> !disk.getType().contains(SED)).map(Disk::partialClone).collect(Collectors.toList());
        this.combineSsdDisks(encryptedDisks, newDisks);
        LOG.info("newDisks is {}", (Object)newDisks);
        return newDisks;
    }

    private void combineSsdDisks(ArrayList<Disk> encryptedDisks, ArrayList<Disk> newDisks) {
        encryptedDisks.forEach(encryptedDisk -> this.combineDisks(newDisks, (Disk)encryptedDisk));
    }

    private void combineDisks(ArrayList<Disk> newDisks, Disk encryptedDisk) {
        for (Disk tempDisk : newDisks) {
            if (!this.needCombine(encryptedDisk, tempDisk)) continue;
            tempDisk.setCount(this.getTempDiskCount(tempDisk, encryptedDisk));
            return;
        }
        newDisks.add(encryptedDisk);
    }

    private boolean needCombine(Disk encryptedDisk, Disk tempDisk) {
        return encryptedDisk.getType().equals(tempDisk.getType()) && this.isSameDiskCapacity(Double.parseDouble(encryptedDisk.getCapacity()), Double.parseDouble(tempDisk.getCapacity()));
    }

    private String getTempDiskCount(Disk tempDisk, Disk encryptedDisk) {
        return String.valueOf(Integer.parseInt(tempDisk.getCount()) + Integer.parseInt(encryptedDisk.getCount()));
    }

    private HashMap<String, EngineDiskInfo> getTotalEngineDiskInfo(HashMap<String, EngineDiskInfo> expEngineDiskInfo, HashMap<String, EngineDiskInfo> devEngineDiskInfo) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        HashMap<String, EngineDiskInfo> totalEngineDiskInfo = new HashMap<String, EngineDiskInfo>();
        for (String key : devEngineDiskInfo.keySet()) {
            EngineDiskInfo copyEngineInfo = new EngineDiskInfo();
            copyEngineInfo.setDiskDomainId(devEngineDiskInfo.get(key).getDiskDomainId());
            copyEngineInfo.setEngineIds(devEngineDiskInfo.get(key).getEngineIds());
            copyEngineInfo.setPoolId(devEngineDiskInfo.get(key).getPoolId());
            copyEngineInfo.setDisks(devEngineDiskInfo.get(key).getDisks());
            totalEngineDiskInfo.put(key, copyEngineInfo);
        }
        for (String key : expEngineDiskInfo.keySet()) {
            EngineDiskInfo totalEngineDisk = totalEngineDiskInfo.get(key);
            EngineDiskInfo expEngineDisk = expEngineDiskInfo.get(key);
            if (totalEngineDisk == null) {
                totalEngineDiskInfo.put(key, expEngineDisk);
                continue;
            }
            ArrayList<Disk> expDisks = expEngineDisk.getDisks();
            ArrayList<Disk> devDisks = totalEngineDisk.getDisks();
            ArrayList<Disk> totalDisks = null;
            totalDisks = this.getTotalDisks(devDisks, expDisks);
            totalEngineDisk.setDisks(totalDisks);
        }
        return totalEngineDiskInfo;
    }

    private ArrayList<Disk> getTotalDisks(ArrayList<Disk> disks1, ArrayList<Disk> disks2) {
        ArrayList<Disk> totalDisks = new ArrayList<Disk>();
        LOG.info("getTotalDisks: srcDisks:{}, expDisks:{}", disks1, disks2);
        if (disks1 != null && disks1.size() > 0) {
            for (Disk disk1 : disks1) {
                Disk disk = new Disk(disk1.getType(), disk1.getCapacity(), disk1.getCount(), disk1.getInputCapacity(), disk1.getInputUnit());
                disk.setEnclosureInfo(disk1.getEnclosureInfo());
                totalDisks = this.mergeDiskToTotal(totalDisks, disk);
                LOG.info("getTotalDisks: srcDisks disk:{}, total disk:{}", (Object)disk, totalDisks);
            }
        }
        if (disks2 != null && disks2.size() > 0) {
            for (Disk disk2 : disks2) {
                totalDisks = this.mergeDiskToTotal(totalDisks, disk2);
            }
        }
        return totalDisks;
    }

    private ArrayList<Disk> mergeDiskToTotal(ArrayList<Disk> totalDisks, Disk disk2) {
        String disk2Type = disk2.getType();
        double disk2Capacity = Double.parseDouble(disk2.getCapacity());
        ArrayList<DiskEnclosure> disk2EnclosureInfos = disk2.getEnclosureInfo();
        int disk2Count = Integer.parseInt(disk2.getCount());
        boolean matchFlag = false;
        for (Disk totalDisk : totalDisks) {
            String totalType = totalDisk.getType();
            double totalCapacity = Double.parseDouble(totalDisk.getCapacity());
            int totalCount = Integer.parseInt(totalDisk.getCount());
            if (!disk2Type.equalsIgnoreCase(totalType) || !this.isSameDiskCapacity(disk2Capacity, totalCapacity)) continue;
            matchFlag = true;
            this.mergeSameCpacityDisk(totalDisk, disk2EnclosureInfos, totalCount += disk2Count);
        }
        if (!matchFlag) {
            Disk disk = new Disk(disk2.getType(), disk2.getCapacity(), disk2.getCount(), disk2.getInputCapacity(), disk2.getInputUnit());
            disk.setEnclosureInfo(disk2.getEnclosureInfo());
            totalDisks.add(disk);
        }
        return totalDisks;
    }

    private void mergeSameCpacityDisk(Disk totalDisk, ArrayList<DiskEnclosure> disk2EnclosureInfos, int totalCount) {
        ArrayList<DiskEnclosure> newEnclosureInfos = new ArrayList<DiskEnclosure>();
        for (DiskEnclosure disk2EnclosureInfo : disk2EnclosureInfos) {
            boolean isNewDiskEnclosure = true;
            ArrayList<DiskEnclosure> totalEnclosureInfos = totalDisk.getEnclosureInfo();
            for (DiskEnclosure totalEnclosureInfo : totalEnclosureInfos) {
                if (!totalEnclosureInfo.getName().equals(disk2EnclosureInfo.getName())) continue;
                int totalNum = Integer.parseInt(totalEnclosureInfo.getCount()) + Integer.parseInt(disk2EnclosureInfo.getCount());
                totalEnclosureInfo.setCount(Integer.toString(totalNum));
                isNewDiskEnclosure = false;
                break;
            }
            totalDisk.setEnclosureInfo(totalEnclosureInfos);
            if (!isNewDiskEnclosure) continue;
            newEnclosureInfos.add(disk2EnclosureInfo);
        }
        ArrayList<DiskEnclosure> copyEnclosureInfo = totalDisk.getEnclosureInfo();
        copyEnclosureInfo.addAll(newEnclosureInfos);
        totalDisk.setEnclosureInfo(copyEnclosureInfo);
        totalDisk.setCount(Integer.toString(totalCount));
    }

    private boolean checkExpInDev(HashMap<String, EngineDiskInfo> expEngineDiskInfo, HashMap<String, EngineDiskInfo> devEngineDiskInfo) {
        EngineDiskInfo devEngineDisk;
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        for (String key : devEngineDiskInfo.keySet()) {
            devEngineDisk = devEngineDiskInfo.get(key);
            ArrayList<Disk> devDisks = devEngineDisk.getDisks();
            if (!FsExpansionUtils.isNewDoradoHddDev(devInfo) || this.checkDevDiskType(key, devDisks)) continue;
            return false;
        }
        for (String key : expEngineDiskInfo.keySet()) {
            ArrayList<Disk> devDisks;
            devEngineDisk = devEngineDiskInfo.get(key);
            ArrayList<Disk> expDisks = expEngineDiskInfo.get(key).getDisks();
            if (FsExpansionUtils.isNewDoradoHddDev(devInfo) && !this.checkDevDiskType(key, expDisks)) {
                return false;
            }
            if (devEngineDisk == null || !this.checkExpDiskRule(devInfo, key, expDisks, devDisks = devEngineDisk.getDisks())) continue;
            return false;
        }
        return true;
    }

    private boolean checkDevDiskType(String key, ArrayList<Disk> devDisks) {
        if (devDisks.size() < 2) {
            return true;
        }
        String poolId = key.split("#")[0];
        if (this.filterNotEncryptionPool(poolId) && devDisks.stream().map(Disk::getType).distinct().count() < 2L) {
            return true;
        }
        if (!this.filterNotEncryptionPool(poolId) && devDisks.stream().map(Disk::ignoreSedFlag).distinct().count() < 2L) {
            return true;
        }
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDevDiskType.diskType", (Object[])new Object[]{poolId});
        DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
        return false;
    }

    private boolean checkExpDiskRule(DevInfo4Exp devInfo, String key, ArrayList<Disk> expDisks, ArrayList<Disk> devDisks) {
        return this.isFlashingDev(devInfo) ? this.checkExpDiskRule4MixedDiskType(key, expDisks, devDisks) : !this.checkExpDiskRuleByOneDiskType(expDisks, devDisks, key);
    }

    private boolean checkExpDiskRule4MixedDiskType(String key, ArrayList<Disk> expDisks, ArrayList<Disk> devDisks) {
        Map<String, List<Disk>> devDiskMap = devDisks.stream().collect(Collectors.groupingBy(devDisk -> devDisk.getType()));
        Map<String, List<Disk>> expDiskMap = expDisks.stream().collect(Collectors.groupingBy(expDisk -> expDisk.getType()));
        for (Map.Entry<String, List<Disk>> entry : devDiskMap.entrySet()) {
            String diskType = entry.getKey();
            ArrayList devDisks4OneType = (ArrayList)entry.getValue();
            ArrayList expDisk4OneType = (ArrayList)expDiskMap.get(diskType);
            if (expDisk4OneType == null || this.checkExpDiskRuleByOneDiskType(expDisk4OneType, devDisks4OneType, key)) continue;
            return true;
        }
        return false;
    }

    private boolean checkExpDiskRuleByOneDiskType(ArrayList<Disk> expDisks, ArrayList<Disk> devDisks, String key) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String poolId = key.split("#")[0];
        String engineId = key.split("#")[1];
        HashMap<String, String> devPoolAndDiskDomainMapping = InspectContext.getInstance().getDevInfo().getDevPoolAndDiskDomainMapping();
        String ddId = devPoolAndDiskDomainMapping.get(poolId);
        ArrayList<Disk> actualExpDisks = this.mergeNewDoradoExpDisk(expDisks, devInfo);
        if (InspectContext.getInstance().getDevInfo().getDomainRedundancyStrategy().get(ddId).equals("Enclosure")) {
            if (devDisks.isEmpty()) {
                LOG.info("dev disk is empty.");
                return true;
            }
            return this.redundantEnclosure.checkCapacityEnclosureRedundant(actualExpDisks, devDisks, key);
        }
        if (actualExpDisks.size() > 1 && this.filterNotEncryptionPool(poolId)) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.expDiskTypeNumber", (Object[])new Object[]{poolId, engineId, 1});
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        if ((InspectUtils.isMicro(devInfo).booleanValue() || FsExpansionUtils.isNewDoradoHddDev(devInfo)) && devDisks.isEmpty()) {
            return true;
        }
        ArrayList devDiskTypes = (ArrayList)this.combineSoftEncryptedDisks(devDisks, poolId);
        if (devDiskTypes.size() == 1) {
            return this.checkExpOnOneType(actualExpDisks, devDiskTypes, key);
        }
        return this.checkExpOnTwoType(actualExpDisks, devDiskTypes, key);
    }

    private ArrayList<Disk> mergeNewDoradoExpDisk(ArrayList<Disk> expDisks, DevInfo4Exp devInfo) {
        ArrayList<Disk> newDoradoExpDisks = new ArrayList<Disk>();
        if (!FsExpansionUtils.isNewDoradoHddDev(devInfo)) {
            return expDisks;
        }
        for (Disk disk2 : expDisks) {
            double disk2Capacity = Double.parseDouble(disk2.getCapacity());
            ArrayList<DiskEnclosure> disk2EnclosureInfos = disk2.getEnclosureInfo();
            int disk2Count = Integer.parseInt(disk2.getCount());
            boolean matchFlag = false;
            for (Disk totalDisk : newDoradoExpDisks) {
                double totalCapacity = Double.parseDouble(totalDisk.getCapacity());
                int totalCount = Integer.parseInt(totalDisk.getCount());
                if (!this.isSameDiskCapacity(disk2Capacity, totalCapacity)) continue;
                matchFlag = true;
                this.mergeSameCpacityDisk(totalDisk, disk2EnclosureInfos, totalCount += disk2Count);
            }
            if (matchFlag) continue;
            newDoradoExpDisks.add(disk2);
        }
        return newDoradoExpDisks;
    }

    private boolean checkExpOnOneType(ArrayList<Disk> expDisks, ArrayList<Disk> devDisks, String key) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String poolId = key.split("#")[0];
        String engineId = key.split("#")[1];
        String expType = expDisks.get(0).getType();
        Double expCapacity = Double.parseDouble(expDisks.get(0).getCapacity());
        String devType = devDisks.get(0).getType();
        Double devCapacity = Double.parseDouble(devDisks.get(0).getCapacity());
        LOG.info("expType: {}, devType:{}", (Object)expType, (Object)devType);
        if (!this.redundantEnclosure.checkDiskType(expType, devType, poolId)) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.diskType", (Object[])new Object[]{poolId, engineId});
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        if (expCapacity < devCapacity) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.diskCapacity", (Object[])new Object[]{poolId, engineId, expType});
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        return true;
    }

    private boolean checkExpOnTwoType(ArrayList<Disk> expDisks, ArrayList<Disk> devDisks, String key) {
        String poolId = key.split("#")[0];
        String engineId = key.split("#")[1];
        Double devMaxCapacity = 0.0;
        String devMaxType = "";
        String devInputCapacity = "";
        String devInputUnit = "";
        for (Disk devDisk : devDisks) {
            Double diskCapacity = Double.parseDouble(devDisk.getCapacity());
            if (!(diskCapacity > devMaxCapacity)) continue;
            devMaxCapacity = diskCapacity;
            devMaxType = devDisk.getType();
            devInputCapacity = devDisk.getInputCapacity();
            devInputUnit = devDisk.getInputUnit();
        }
        String expType = expDisks.get(0).getType();
        Double expCapacity = Double.parseDouble(expDisks.get(0).getCapacity());
        LOG.info("expType :{}, devMaxType:{}, expCapacity:{},devMaxCapacity:{}", new Object[]{expType, devMaxType, expCapacity, devMaxCapacity});
        if (!this.redundantEnclosure.checkDiskType(expType, devMaxType, poolId) || !this.isSameDiskCapacity(devMaxCapacity, expCapacity)) {
            String diskMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.disk", (Object[])new Object[]{devMaxType, devInputCapacity + devInputUnit});
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.onlyDisk", (Object[])new Object[]{poolId, engineId, diskMsg});
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        return true;
    }

    private boolean isSameDiskCapacity(double diskCapacity1, double diskCapacity2) {
        double deltaCapacty = Math.abs(diskCapacity1 - diskCapacity2);
        return deltaCapacty <= 10.0;
    }

    private HashMap<String, EngineDiskInfo> getDevEngineDiskInfo() {
        HashMap<String, EngineDiskInfo> devEngineDiskInfo = new HashMap<String, EngineDiskInfo>();
        ArrayList devEnginDiskInfo = (ArrayList)InspectContext.getInstance().getDevInfo().getDevEngineDiskInfo().clone();
        for (EngineDiskInfo engineDiskInfo : devEnginDiskInfo) {
            ArrayList<String> engineIds = engineDiskInfo.getEngineIds();
            String poolId = engineDiskInfo.getPoolId();
            ArrayList disks = new ArrayList();
            engineDiskInfo.getDisks().forEach(disk -> this.mergeDiskToTotal(disks, (Disk)disk));
            LOG.info("getDevEngineDiskInfo:engineIds:{}, before merge:{}, after merge:{}", new Object[]{engineIds, engineDiskInfo.getDisks(), disks});
            for (String engineId : engineIds) {
                String engineName = this.getEngineName(engineId);
                String keyStr = poolId + "#" + engineName;
                EngineDiskInfo devEngineDisk = devEngineDiskInfo.get(keyStr);
                if (devEngineDisk == null) {
                    devEngineDisk = new EngineDiskInfo();
                }
                ArrayList<Disk> newDisks = devEngineDisk.getDisks();
                newDisks.addAll(disks);
                devEngineDisk.setDisks(newDisks);
                devEngineDiskInfo.put(keyStr, devEngineDisk);
            }
        }
        return devEngineDiskInfo;
    }

    private HashMap<String, EngineDiskInfo> getExpEngineDiskInfoFromStrategy(List<TableRow> rows) {
        HashMap<String, EngineDiskInfo> expEngineDiskInfo = new HashMap<String, EngineDiskInfo>();
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        for (TableRow row : rows) {
            Strategy strategy = this.updateData(row);
            String poolId = strategy.getDiskDomain();
            String engineId = strategy.getEng();
            String engineName = this.getEngineName(engineId);
            String keyStr = poolId + "#" + engineName;
            if ("new".equalsIgnoreCase(engineId)) continue;
            EngineDiskInfo expEngineDisk = expEngineDiskInfo.get(keyStr);
            if (expEngineDisk == null) {
                expEngineDisk = new EngineDiskInfo();
            }
            Disk expDisk = new Disk();
            expDisk.setType(strategy.getDiskModel());
            expDisk.setCapacity(this.getDiskCapacityByGB(strategy.getDiskCapacity(), strategy.getUnit().toString()));
            expDisk.setCount(strategy.getDiskNum());
            expDisk.setInputCapacity(strategy.getDiskCapacity());
            expDisk.setInputUnit(strategy.getUnit().toString());
            ArrayList<DiskEnclosure> expEnclosureInfo = new ArrayList<DiskEnclosure>();
            DiskEnclosure expDiskEnclosure = new DiskEnclosure("", strategy.getDiskEnclosureId(), strategy.getDiskNum());
            expEnclosureInfo.add(expDiskEnclosure);
            expDisk.setEnclosureInfo(expEnclosureInfo);
            ArrayList<Disk> newDisks = expEngineDisk.getDisks();
            newDisks.add(expDisk);
            expEngineDisk.setDisks(newDisks);
            expEngineDiskInfo.put(keyStr, expEngineDisk);
        }
        for (String key : expEngineDiskInfo.keySet()) {
            ArrayList<Disk> disks = expEngineDiskInfo.get(key).getDisks();
            ArrayList<Disk> summaryDisks = this.getTotalDisks(null, disks);
            expEngineDiskInfo.get(key).setDisks(summaryDisks);
        }
        return expEngineDiskInfo;
    }

    private String getEngineName(String engineId) {
        if (engineId.equalsIgnoreCase("new")) {
            return engineId;
        }
        ArrayList<String> engines = InspectContext.getInstance().getDevInfo().getEngs();
        int index = Integer.parseInt(engineId.substring(3));
        return (String)engines.get(index);
    }

    private String getDiskCapacityByGB(String diskCapacity, String unit) {
        double labelToRealByGB = 0.9313225746154785;
        HashMap<String, Double> unitMap = new HashMap<String, Double>();
        unitMap.put("MB", 0.001);
        unitMap.put("GB", 1.0);
        unitMap.put("TB", 1000.0);
        double labelCapacity = Double.parseDouble(diskCapacity);
        double labelCapacityByGB = labelCapacity * (Double)unitMap.get(unit);
        double capacityByGB = labelCapacityByGB * labelToRealByGB;
        return Double.toString(capacityByGB);
    }

    private boolean verify() {
        ExtendModel configMode = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        String subConfigMode = (String)this.layout.getSubConfigBox().getSelectedItem();
        String subSel4Veritas = (String)this.layout.getSubSel4VeritasBox().getSelectedItem();
        String subSel4InnerMetro = (String)this.layout.getSubSel4InnerMetroBox().getSelectedItem();
        String highDensityDiskEnclosure = (String)this.layout.getHighDensityDiskEnclosureBox().getSelectedItem();
        LOG.info("extend config mode: {}, subConfig mode: {}, select Veritas: {}", new Object[]{configMode, subConfigMode, subSel4Veritas});
        if (!this.checkData(this.layout.getModel().getAllRows(), configMode, subConfigMode, subSel4Veritas, subSel4InnerMetro, highDensityDiskEnclosure)) {
            return false;
        }
        this.setExpMode(configMode);
        if (!this.setDiskCapacityExpansion()) {
            return false;
        }
        this.setInspectContext(configMode, subConfigMode, subSel4Veritas, subSel4InnerMetro);
        return true;
    }

    private boolean setDiskCapacityExpansion() {
        this.expDiskList.clear();
        this.expStrategyList.clear();
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        for (TableRow row : this.layout.getModel().getAllRows()) {
            String outDiskEnclosureId;
            Strategy strategy = this.updateData(row);
            LOG.info("verify strategy: {}", (Object)strategy);
            HashMap<String, String> strategyMap = strategy.toMap();
            String internelDiskEncId = outDiskEnclosureId = strategy.getDiskEnclosureId();
            strategyMap.put("needCheckEnclosureRedundant", EMPTY_POOL_EXP_DISK_NUM);
            if (!outDiskEnclosureId.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.diskenclosure.noneed"))) {
                strategyMap.put("needCheckEnclosureRedundant", "1");
                internelDiskEncId = devInfo.getDiskEnclosureInnerOutNameMap().get(outDiskEnclosureId);
                if (internelDiskEncId == null) {
                    LOG.error("get internel enclosure ID of {} fail!", (Object)outDiskEnclosureId);
                    JDialog mainDialog = InspectContext.getInstance().getMainDialog();
                    String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.getDiskInnerIDErr", (Object[])new Object[0]);
                    DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
                    return false;
                }
            }
            strategyMap.put("diskEnclosureName", outDiskEnclosureId);
            strategyMap.put("diskEnclosureId", internelDiskEncId);
            this.expDiskList.add(strategyMap);
            this.expStrategyList.add(strategy);
        }
        return true;
    }

    private void setExpMode(ExtendModel configMode) {
        LOG.info("verity configMode: {}", (Object)configMode);
        if (configMode.equals((Object)ExtendModel.CTRL_EXP_INSPECT)) {
            this.expMode = "EXTEND_CTRL";
        } else if (configMode.equals((Object)ExtendModel.DISK_EXP_INSPECT)) {
            this.expMode = "EXTEND_DISK";
        } else if (configMode.equals((Object)ExtendModel.LINK_EXP_INSPECT)) {
            this.expMode = "EXTEND_LINK";
        } else if (configMode.equals((Object)ExtendModel.DD_EXP_INSPECT)) {
            this.expMode = "EXTEND_DD";
        } else if (ExtendModel.SCM_EXP_INSPECT.equals((Object)configMode)) {
            this.expMode = "EXTEND_SCM";
        } else if (configMode.equals((Object)ExtendModel.NEW_OCEAN_STR_DD_EXP_INSPECT)) {
            this.expMode = "EXTEND_DD";
        } else {
            LOG.info("no match expansion mode");
        }
    }

    private void setInspectContext(ExtendModel configMode, String subConfigMode, String subSel4Veritas, String subSel4InnerMetro) {
        if ("EXTEND_CTRL".equalsIgnoreCase(this.expMode)) {
            this.expCtrl = this.layout.getExpCtrlMap().get(subConfigMode);
            InspectContext.getInstance().setExpCtrlOri(InspectContext.getInstance().getDevInfo().getDevCtrlsNum());
            InspectContext.getInstance().setExpCtrlEnv(this.expCtrl);
            this.checkVeritas = !subSel4Veritas.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.extendVeritasSelNo"));
            InspectContext.getInstance().setCheckVeritasEnv(this.checkVeritas);
            this.requireInnerMetro = subSel4InnerMetro.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.requireInnerMetroSelYes"));
            InspectContext.getInstance().setRequireInnerMetro(this.requireInnerMetro);
        } else {
            this.expCtrl = "";
            InspectContext.getInstance().setExpCtrlOri(0);
            InspectContext.getInstance().setExpCtrlEnv(null);
        }
        LOG.info("verity expCtrl: {}", (Object)this.expCtrl);
        InspectContext.getInstance().setExpDiskListEnv(this.expDiskList);
        InspectContext.getInstance().setExpStrategyList(this.expStrategyList);
        InspectContext.getInstance().setExpMode(this.expMode);
        InspectContext.getInstance().setExpModeOri(configMode.toString());
        ExpandScmPanel.getInstance().saveData(configMode);
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step.extend.setting");
    }

    public int getStep() {
        return this.getStep(CardModelEnum.STRATEGYSETTING);
    }

    protected ToolWizardDialog.Card getNextCard() {
        this.resetBomWhenClickNextCard();
        if (!this.verify()) {
            return this;
        }
        InspectWorktaker worktaker = InspectContext.getInstance().getInspectWorktaker();
        List checkDevs = (List)worktaker.get("check_dev_nodes");
        ExtendModel configMode = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        String subConfigMode = Objects.toString(this.layout.getSubConfigBox().getSelectedItem());
        LOG.info(String.format(Locale.ENGLISH, "extend config mode: %s, subConfig mode: %s", new Object[]{configMode, subConfigMode}));
        for (CheckDevNode checkDevNode : checkDevs) {
            if (!"".equals(this.expMode)) {
                CheckItemPlatformAdapterInInspect.getInstance().addCheckConfigItem(checkDevNode.getCheckItems(), checkDevNode);
            }
            InspectContext.getInstance().filterItemWhitScene(checkDevNode, configMode.getKey());
        }
        return InspectUIUtil.getNextCard(CardModelEnum.STRATEGYSETTING, this);
    }

    private void resetBomWhenClickNextCard() {
        String ctrlBom = this.layout.getCtrlBomJTF().getText().trim();
        if (this.layout.getCtrlBomBox().isVisible() && !this.isBomInvalid(ctrlBom, false)) {
            InspectContext.getInstance().setCtrlBom(ctrlBom);
        }
        String encBom = this.layout.getEncBomJTF().getText().trim();
        if (this.layout.getEncBomBox().isVisible() && !this.isBomInvalid(encBom, false)) {
            InspectContext.getInstance().setEncBom(encBom);
        }
        String diskEnclosureBom = this.layout.getDiskEnclosureBomJTF().getText().trim();
        if (this.layout.getDiskEnclosureBomBox().isVisible() && !this.isBomInvalid(diskEnclosureBom, false)) {
            InspectContext.getInstance().setDiskEnclosureBom(diskEnclosureBom);
        }
        String interfaceBom = this.layout.getInterfaceBomJTF().getText().trim();
        if (this.layout.getInterfaceBomBox().isVisible() && !this.isBomInvalid(interfaceBom, true)) {
            InspectContext.getInstance().setInterfaceBom(interfaceBom);
        }
        String interfaceCardBom = this.layout.getInterfaceCardBomJTF().getText().trim();
        if (this.layout.getInterfaceCardBomBox().isVisible() && !this.isBomInvalid(interfaceCardBom, true)) {
            InspectContext.getInstance().setInterfaceCardBom(interfaceCardBom);
        }
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        if (navigation == ToolWizardDialog.Navigation.Next) {
            if (null == this.layout) {
                return false;
            }
            boolean validFlag = this.layout.getConfigBox().getItemAt(0) != ExtendModel.EXTEND_DEFAULT || this.layout.getConfigBox().getSelectedIndex() != 0;
            return validFlag;
        }
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    private String getCtrlInfo(String src) {
        return this.moveCardExpList.getOrDefault(src, "");
    }

    private String[] getCtrls(String src) {
        String[] ctrlsArr;
        String ctrls = this.getCtrlInfo(src);
        HashMap<String, List> crossEng = new HashMap<String, List>();
        for (String ctr : ctrlsArr = ctrls.split("/")) {
            if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)ctr)) continue;
            String eng = String.valueOf(ctr.charAt(0));
            char index = ctr.charAt(1);
            String logic = index == 'A' || index == 'B' ? EMPTY_POOL_EXP_DISK_NUM : "1";
            List cross = crossEng.getOrDefault(eng, new ArrayList());
            if (!cross.contains(logic)) {
                cross.add(logic);
            }
            crossEng.put(eng, cross);
        }
        ArrayList<String> crossList = new ArrayList<String>();
        for (Map.Entry m : crossEng.entrySet()) {
            String eng = "CTE" + (String)m.getKey();
            List values = (List)m.getValue();
            CharSequence[] logicList = new String[values.size()];
            values.toArray(logicList);
            crossList.add(eng + ":" + String.join((CharSequence)"/", logicList));
        }
        return crossList.toArray(new String[0]);
    }

    private boolean isNotSupportSmartPoolModel(ExtendModel configMode) {
        return ExtendModel.SCM_EXP_INSPECT.equals((Object)configMode);
    }

    private void changeSmartPoolDiskTypeComboxSelection(JComboBox jComboBox, ExtendModel configMode, DevInfo4Exp devInfo) {
        if (this.isNotSupportSmartPoolModel(configMode)) {
            LOG.info("not dd exp smart pool, return, no need change disk type.");
            return;
        }
        String selectMode = jComboBox.getSelectedItem() == null ? "" : (String)jComboBox.getSelectedItem();
        List<String> smartPoolList = devInfo.getSmartPool();
        ArrayList<String> engList = devInfo.getEngs();
        int rowIndex = this.layout.getTable().getSelectedRow();
        int diskTypeColumn = this.getDiskTypeIndexNum();
        TableRow row = this.layout.getModel().getRow(rowIndex);
        String diskNumReg = REG_COUNT;
        if (this.isPerformanceLayerSelected(engList, smartPoolList, selectMode)) {
            Object[] originType = this.getPerformanceLayerDiskLimit();
            row.setValueAt(diskTypeColumn, (Object)new IsmTableCell.ComboBoxCell(originType, (Object)originType[0]));
            diskNumReg = REG_COUNT_NO_SUPPORT_0;
        } else {
            Object[] originType = this.getLimitDiskTypeForNewDorado();
            row.setValueAt(diskTypeColumn, (Object)new IsmTableCell.ComboBoxCell(originType, (Object)originType[0]));
            LOG.info("isPerformanceLayer: false, reset data model");
        }
        if (this.isNewPool(selectMode)) {
            diskNumReg = REG_COUNT_NO_SUPPORT_0;
        }
        row.setValueAt(diskTypeColumn + 1, (Object)new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)REG_CAP, (String)"", (int)20, (int)0), "", ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.input.tip")));
        row.setValueAt(diskTypeColumn + 2, (Object)new IsmTableCell.ComboBoxCell((Object[])CAP_UNIT, (Object)CAP_UNIT[0]));
        row.setValueAt(diskTypeColumn + 3, (Object)new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)diskNumReg, (String)"", (int)12, (int)0), "", ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.input.tip")));
    }

    private String[] getLimitDiskTypeForNewDorado() {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        if (FsExpansionUtils.isNewDoradoHddDev(devInfo) && !FsExpansionUtils.isQLCProductDev(devInfo)) {
            LOG.info("new dorado hdd dev use hdd disk limit type.");
            return NEW_DORADO_HDD_LIMIT;
        }
        LOG.info("use default disk type.");
        return this.getLimitDiskType();
    }

    private void changeFlashDevDiskType(JComboBox jComboBox) {
        String selectMode;
        String string = selectMode = jComboBox.getSelectedItem() == null ? "" : (String)jComboBox.getSelectedItem();
        if (this.isFlashDevCreateNewPoolSelected(selectMode)) {
            int diskTypeColumn = this.getDiskTypeIndexNum();
            int rowIndex = this.layout.getTable().getSelectedRow();
            TableRow row = this.layout.getModel().getRow(rowIndex);
            Object[] diskType = this.getPerformanceLayerDiskLimit();
            row.setValueAt(diskTypeColumn, (Object)new IsmTableCell.ComboBoxCell(diskType, (Object)diskType[0]));
            row.setValueAt(diskTypeColumn + 1, (Object)new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)REG_CAP, (String)"", (int)20, (int)0), "", ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.input.tip")));
            row.setValueAt(diskTypeColumn + 2, (Object)new IsmTableCell.ComboBoxCell((Object[])CAP_UNIT, (Object)CAP_UNIT[0]));
            String diskNumReg = REG_COUNT;
            if (this.isNewPool(selectMode)) {
                diskNumReg = REG_COUNT_NO_SUPPORT_0;
            }
            row.setValueAt(diskTypeColumn + 3, (Object)new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)diskNumReg, (String)"", (int)12, (int)0), "", ResourceUtil.getString((String)"inspect.wizard.strategysetting.table.input.tip")));
        }
    }

    private String[] getPerformanceLayerDiskLimit() {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String[] diskType = SMART_POOL_DISK_LIMIT;
        if (FsExpansionUtils.isQLCProductDev(devInfo)) {
            diskType = CAPACITY_OPTIMIZED_SSD_LIMIT;
        }
        return diskType;
    }

    private boolean isNewPool(String selectMode) {
        return selectMode.equalsIgnoreCase(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.newPoolPerformanceLayer", (Object[])new Object[0])) || selectMode.equalsIgnoreCase(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.newPool", (Object[])new Object[0]));
    }

    private boolean isPerformanceLayerSelected(ArrayList<String> engList, List<String> smartPoolList, String selectMode) {
        for (String eng : engList) {
            for (String pool : smartPoolList) {
                if (!selectMode.equalsIgnoreCase(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.expSmartPoolOnEngine", (Object[])new Object[]{eng, pool}))) continue;
                LOG.info("current selected performance layer! id:{}, need change disk_type", (Object)pool);
                return true;
            }
        }
        return false;
    }

    private boolean isFlashDevCreateNewPoolSelected(String selectMode) {
        return selectMode.equalsIgnoreCase(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.newPoolPerformanceLayer", (Object[])new Object[0]));
    }

    private Map<String, Object> getCellMapOfDiskTypeAndDiskCapacity() {
        Object diskCapacityUnit;
        Object diskCapacityNumber;
        Object diskType;
        String version;
        HashMap<String, Object> map = new HashMap<String, Object>();
        int rowIndex = this.layout.getTable().getSelectedRow();
        if (rowIndex == -1) {
            return map;
        }
        TableRow row = this.layout.getModel().getRow(rowIndex);
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        String deviceType = devInfo.getDevType();
        if (StrategySettingCard.isMoveCardScenario(deviceType, version = devInfo.getProductVersion()) || this.redundantEnclosure.addOneColumn) {
            diskType = row.getValueAt(3);
            diskCapacityNumber = row.getValueAt(4);
            diskCapacityUnit = row.getValueAt(5);
        } else {
            diskType = row.getValueAt(2);
            diskCapacityNumber = row.getValueAt(3);
            diskCapacityUnit = row.getValueAt(4);
        }
        map.put("diskType", diskType);
        map.put("diskCapacityNumber", diskCapacityNumber);
        map.put("diskCapacityUnit", diskCapacityUnit);
        return map;
    }

    private <T> T getEnclosureID() {
        int rowIndex = this.layout.getTable().getSelectedRow();
        ExtendModel configMode = (ExtendModel)((Object)this.layout.getConfigBox().getSelectedItem());
        Object object = null;
        if (rowIndex == -1) {
            return Optional.ofNullable(object).orElse(object);
        }
        TableRow row = this.layout.getModel().getRow(rowIndex);
        if (this.redundantEnclosure.addOneColumn) {
            object = row.getValueAt(1);
        }
        return Optional.ofNullable(object).orElse(object);
    }

    private void setValueOfDiskTypeAndDiskCapacity(String bom) {
        Map<String, Object> cellMap = this.getCellMapOfDiskTypeAndDiskCapacity();
        if (cellMap.isEmpty()) {
            return;
        }
        HashMap<String, Disk> devDiskBom = InspectContext.getInstance().getDevInfo().getDevDiskBom();
        Disk diskBom = (Disk)devDiskBom.get(bom);
        IsmTableCell.ComboBoxCell diskType = (IsmTableCell.ComboBoxCell)cellMap.get("diskType");
        IsmTableCell.MsgTextCell diskCapacityNumber = (IsmTableCell.MsgTextCell)cellMap.get("diskCapacityNumber");
        IsmTableCell.ComboBoxCell diskCapacityUnit = (IsmTableCell.ComboBoxCell)cellMap.get("diskCapacityUnit");
        diskType.setSelectedItem((Object)diskBom.getType());
        diskCapacityNumber.setText(diskBom.getInputCapacity());
        diskCapacityUnit.setSelectedItem((Object)diskBom.getInputUnit());
    }

    private void setEditableOfDiskTypeAndDiskCapacity(boolean flag) {
        Map<String, Object> cellMap = this.getCellMapOfDiskTypeAndDiskCapacity();
        if (cellMap.isEmpty()) {
            return;
        }
        IsmTableCell.ComboBoxCell diskType = (IsmTableCell.ComboBoxCell)cellMap.get("diskType");
        IsmTableCell.MsgTextCell diskCapacityNumber = (IsmTableCell.MsgTextCell)cellMap.get("diskCapacityNumber");
        IsmTableCell.ComboBoxCell diskCapacityUnit = (IsmTableCell.ComboBoxCell)cellMap.get("diskCapacityUnit");
        diskType.setEditable(flag);
        diskCapacityNumber.setEditable(flag);
        diskCapacityUnit.setEditable(flag);
    }

    private void initValueOfDiskTypeAndDiskCapacity() {
        String[] diskTypeList = this.getLimitDiskType();
        Map<String, Object> cellMap = this.getCellMapOfDiskTypeAndDiskCapacity();
        IsmTableCell.ComboBoxCell diskType = (IsmTableCell.ComboBoxCell)cellMap.get("diskType");
        IsmTableCell.MsgTextCell diskCapacityNumber = (IsmTableCell.MsgTextCell)cellMap.get("diskCapacityNumber");
        IsmTableCell.ComboBoxCell diskCapacityUnit = (IsmTableCell.ComboBoxCell)cellMap.get("diskCapacityUnit");
        diskType.setSelectedItem((Object)diskTypeList[0]);
        diskCapacityNumber.setText("");
        diskCapacityUnit.setSelectedItem((Object)CAP_UNIT[0]);
    }

    private void setEditableOfEnclosureID(boolean flag) {
        if (this.getEnclosureID() instanceof IsmTableCell.ComboBoxCell) {
            IsmTableCell.ComboBoxCell enclosureID = (IsmTableCell.ComboBoxCell)this.getEnclosureID();
            if (enclosureID != null) {
                enclosureID.setEditable(flag);
            } else {
                LOG.info("enclosureID is null!");
            }
        }
    }

    private void initRuleOfEnclosureID(String engId) {
        String[] engIds;
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        HashMap<String, ArrayList<String>> diskEnclosureIdMap = devInfo.getDiskEnclosureIdMap();
        Matcher matcher = Pattern.compile(REG_SPLIT_PATTERN).matcher(engId);
        List diskEnclosureIdList = null;
        diskEnclosureIdList = matcher.find() ? (diskEnclosureIdMap.get((engIds = engId.split(matcher.group()))[0].trim()) == null ? new ArrayList() : (List)diskEnclosureIdMap.get(engIds[0].trim())) : (diskEnclosureIdMap.get(engId) == null ? new ArrayList() : (List)diskEnclosureIdMap.get(engId));
        String[] rules = diskEnclosureIdList.toArray(new String[diskEnclosureIdList.size()]);
        if (rules.length == 0) {
            rules = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.diskenclosure.noenclosure")};
        }
        if (this.getEnclosureID() instanceof IsmTableCell.ComboBoxCell) {
            IsmTableCell.ComboBoxCell enclosureID = (IsmTableCell.ComboBoxCell)this.getEnclosureID();
            if (enclosureID == null) {
                LOG.error("enclosureID is null!");
                return;
            }
            enclosureID.setSelectedItem((Object)rules[0]);
            enclosureID.updateItems(rules, rules[0]);
        }
    }

    private void setRuleOfEnclosureID() {
        String[] rules = new String[]{ResourceUtil.getString((String)"inspect.wizard.strategysetting.diskenclosure.noneed")};
        if (!(this.getEnclosureID() instanceof IsmTableCell.ComboBoxCell)) {
            return;
        }
        IsmTableCell.ComboBoxCell enclosureID = (IsmTableCell.ComboBoxCell)this.getEnclosureID();
        if (enclosureID == null) {
            LOG.error("enclosureID is null!");
            return;
        }
        enclosureID.updateItems(rules, rules[0]);
    }

    private static boolean isAdjusting(JComboBox cbInput) {
        if (cbInput.getClientProperty("is_adjusting") instanceof Boolean) {
            return (Boolean)cbInput.getClientProperty("is_adjusting");
        }
        return false;
    }

    private static void setAdjusting(JComboBox cbInput, boolean adjusting) {
        cbInput.putClientProperty("is_adjusting", adjusting);
    }

    private class ExpModeComboxListener
    implements ItemListener {
        private ExpModeComboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1) {
                return;
            }
            JComboBox jComboBox = (JComboBox)e.getSource();
            StrategySettingCard.this.changeFlashDevDiskType(jComboBox);
            DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
            String selectMode = jComboBox.getSelectedItem() == null ? "" : (String)jComboBox.getSelectedItem();
            ArrayList<String> engList = devInfo.getEngs();
            ArrayList<String> poolList = devInfo.getDevPools();
            ExtendModel configMode = (ExtendModel)((Object)StrategySettingCard.this.layout.getConfigBox().getSelectedItem());
            HashMap<String, String> devPoolAndDiskDomainMap = devInfo.getDevPoolAndDiskDomainMapping();
            boolean isEnclosureRedundant = false;
            for (String eng : engList) {
                boolean match = false;
                for (String pool : poolList) {
                    if (!selectMode.equalsIgnoreCase(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.expPoolOnEngine", (Object[])new Object[]{eng, pool}))) continue;
                    isEnclosureRedundant = this.checkEnclosureRedundant(eng, pool, configMode, devInfo, devPoolAndDiskDomainMap);
                    match = true;
                    break;
                }
                if (!match) continue;
                break;
            }
            List<String> performanceIdList = devInfo.getSmartPool();
            for (String eng : engList) {
                boolean match = false;
                for (String performance : performanceIdList) {
                    if (!selectMode.equalsIgnoreCase(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.expmode.expSmartPoolOnEngine", (Object[])new Object[]{eng, performance}))) continue;
                    isEnclosureRedundant = this.checkPerformanceEncRedundant(eng, performance, configMode, devInfo);
                    match = true;
                    break;
                }
                if (!match) continue;
                break;
            }
            if (!isEnclosureRedundant && configMode.getKey().equals("ddExpInspect")) {
                StrategySettingCard.this.setRuleOfEnclosureID();
                StrategySettingCard.this.setEditableOfEnclosureID(false);
            }
            StrategySettingCard.this.changeSmartPoolDiskTypeComboxSelection(jComboBox, configMode, devInfo);
        }

        private boolean checkPerformanceEncRedundant(String eng, String performanceId, ExtendModel configMode, DevInfo4Exp devInfo) {
            Map<String, String> performanceRedundancyStrategy = devInfo.getPerformanceRedundancyStrategy();
            if (performanceRedundancyStrategy.get(performanceId).equals("enclosure")) {
                if (configMode.getKey().equals("ddExpInspect")) {
                    StrategySettingCard.this.initRuleOfEnclosureID(eng);
                    StrategySettingCard.this.setEditableOfEnclosureID(true);
                } else {
                    JDialog mainDialog = InspectContext.getInstance().getMainDialog();
                    String errMsg = ResourceUtil.getString((String)"inspect.wizard.strategysetting.checkDiskConfig.isPerformanceEnclosureRedundant");
                    DialogUtils.showInfoDialog((JDialog)mainDialog, (String)errMsg, (Dimension)new Dimension(230, 180));
                }
                return true;
            }
            return false;
        }

        private boolean checkEnclosureRedundant(String eng, String pool, ExtendModel configMode, DevInfo4Exp devInfo, HashMap<String, String> devPoolAndDiskDomainMap) {
            String ddID = devPoolAndDiskDomainMap.get(pool);
            HashMap<String, String> domainRedundancyStrategy = devInfo.getDomainRedundancyStrategy();
            if (domainRedundancyStrategy.get(ddID).equals("Enclosure")) {
                if (configMode.getKey().equals("ddExpInspect")) {
                    StrategySettingCard.this.initRuleOfEnclosureID(eng);
                    StrategySettingCard.this.setEditableOfEnclosureID(true);
                } else {
                    JDialog mainDialog = InspectContext.getInstance().getMainDialog();
                    String errMsg = ResourceUtil.getString((String)"inspect.wizard.strategysetting.checkDiskConfig.isEnclosureRedundant");
                    DialogUtils.showInfoDialog((JDialog)mainDialog, (String)errMsg, (Dimension)new Dimension(230, 180));
                }
                return true;
            }
            return false;
        }
    }

    private class DiskTypeComboxListener
    implements ItemListener {
        private DiskTypeComboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1) {
                return;
            }
            JComboBox jComboBox = (JComboBox)e.getSource();
            DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
            ExtendModel configMode = (ExtendModel)((Object)StrategySettingCard.this.layout.getConfigBox().getSelectedItem());
            StrategySettingCard.this.changeSmartPoolDiskTypeComboxSelection(jComboBox, configMode, devInfo);
            StrategySettingCard.this.changeFlashDevDiskType(jComboBox);
        }
    }

    private class BomComboxListener
    implements ItemListener {
        private BomComboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            String bom;
            if (event.getStateChange() != 1) {
                return;
            }
            JComboBox jComboBox = (JComboBox)event.getSource();
            String string = bom = jComboBox.getSelectedItem() == null ? "" : (String)jComboBox.getSelectedItem();
            if (bom.equalsIgnoreCase(ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.customize"))) {
                StrategySettingCard.this.setEditableOfDiskTypeAndDiskCapacity(true);
                StrategySettingCard.this.initValueOfDiskTypeAndDiskCapacity();
            } else {
                StrategySettingCard.this.setValueOfDiskTypeAndDiskCapacity(bom);
                StrategySettingCard.this.setEditableOfDiskTypeAndDiskCapacity(false);
            }
        }
    }

    private class ComboxListener
    implements ItemListener {
        private Object params;

        public ComboxListener(Object params) {
            this.params = params;
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                String defaultStr = ResourceUtil.getString((String)"inspect.wizard.strategysetting.select.default");
                String newDDStr = ResourceUtil.getString((String)"inspect.wizard.strategysetting.expmode.0");
                JComboBox jComboBox = (JComboBox)event.getSource();
                String select = jComboBox.getSelectedItem() == null ? "" : (String)jComboBox.getSelectedItem();
                DevInfo4Exp dev = (DevInfo4Exp)this.params;
                if (select.equals(defaultStr)) {
                    return;
                }
                String[] types = select.equals(newDDStr) ? StrategySettingCard.this.getNewDDList(dev) : StrategySettingCard.this.getExpDDList(dev);
                StrategySettingCard.this.setValues(types);
            }
        }

        public Object getParams() {
            return this.params;
        }

        public void setParams(Object params) {
            this.params = params;
        }
    }

    private class DelCellAction
    implements ActionListener {
        private DelCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WarningDialog wdlg2 = DialogUtils.showYesNoDialog((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.delete"));
            if (0 == wdlg2.getValue()) {
                TableRow row = StrategySettingCard.this.layout.getTable().getMarkedRow();
                if (row != null) {
                    StrategySettingCard.this.layout.getModel().removeRow(new TableRow[]{row});
                    LOG.info("delete row {}", row.getIdentifier());
                } else {
                    LOG.info("delete row is null.");
                }
            }
        }
    }

    private class BomTxtInputDocumentListener
    implements DocumentListener {
        JComboBox cbInput;
        JTextField bomTxtInput;
        DefaultComboBoxModel model;
        List<BomList> items;

        public BomTxtInputDocumentListener(JComboBox cbInput, JTextField bomTxtInput, DefaultComboBoxModel model, List<BomList> items) {
            this.cbInput = cbInput;
            this.bomTxtInput = bomTxtInput;
            this.model = model;
            this.items = items;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateList();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateList();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateList();
        }

        private void updateList() {
            StrategySettingCard.setAdjusting(this.cbInput, true);
            this.model.removeAllElements();
            String input = this.bomTxtInput.getText();
            if (!input.isEmpty()) {
                for (BomList item : this.items) {
                    if (!item.getId().toLowerCase().startsWith(input.toLowerCase())) continue;
                    this.model.addElement(item.getId());
                }
            }
            this.cbInput.setPopupVisible(this.model.getSize() > 0);
            StrategySettingCard.setAdjusting(this.cbInput, false);
        }
    }

    private class CbInputClickAction
    implements ActionListener {
        JComboBox cbInput;
        JTextField bomTxtInput;

        public CbInputClickAction(JComboBox cbInput, JTextField bomTxtInput) {
            this.cbInput = cbInput;
            this.bomTxtInput = bomTxtInput;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!StrategySettingCard.isAdjusting(this.cbInput) && this.cbInput.getSelectedItem() != null) {
                this.bomTxtInput.setText(this.cbInput.getSelectedItem().toString());
            }
        }
    }

    private static class SubConfigBoxPopupListener
    implements PopupMenuListener {
        StrategySettingCard ssc;

        public SubConfigBoxPopupListener(StrategySettingCard ssc) {
            this.ssc = ssc;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            String devInitErrMsg = InspectContext.getInstance().getDevInfo().getErrMsg();
            if (!com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)devInitErrMsg)) {
                DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)devInitErrMsg);
                ((JButton)this.ssc.getNavigationButtons().get(ToolWizardDialog.Navigation.Next)).setEnabled(false);
                return;
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private static class SubConfigBoxItemListener
    implements ItemListener {
        private StrategySettingCard card;

        public SubConfigBoxItemListener(StrategySettingCard card) {
            this.card = card;
            card.updateNavigationBar();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            LOG.info("Select item from second combox: {}", e.getItem());
            this.card.layout.getModel().removeAll();
            this.card.layout.getModel().fireTableStructureChanged();
            this.card.layout.setTableHeaderSize();
            this.card.initExpConfigMap();
            this.card.updateNavigationBar();
        }
    }

    private static class HighDensityDiskEnclosureSelBoxListener
    implements ItemListener {
        private StrategySettingCard card;

        public HighDensityDiskEnclosureSelBoxListener(StrategySettingCard card) {
            this.card = card;
            card.updateNavigationBar();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            LOG.info("Select item from second combox: {}", e.getItem());
            this.card.layout.getModel().removeAll();
            this.card.layout.getModel().fireTableStructureChanged();
            this.card.layout.setTableHeaderSize();
            this.card.initExpConfigMap();
            this.card.updateNavigationBar();
            if (ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.highDensityDiskEnclosureSelYes").equals((String)this.card.layout.getHighDensityDiskEnclosureBox().getSelectedItem())) {
                InspectContext.getInstance().setInclude12HighEnclosure("yes");
            }
            if (ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.highDensityDiskEnclosureSelNo").equals((String)this.card.layout.getHighDensityDiskEnclosureBox().getSelectedItem())) {
                InspectContext.getInstance().setInclude12HighEnclosure("no");
            }
        }
    }

    private static class ConfigBoxActionListener
    implements ActionListener {
        private StrategySettingCardLayout layout;
        private StrategySettingCard card;
        private ExtendModel lastSelected = ExtendModel.EXTEND_DEFAULT;

        public ConfigBoxActionListener(StrategySettingCardLayout layout, StrategySettingCard card) {
            this.layout = layout;
            this.card = card;
            card.updateNavigationBar();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<String> devDomains;
            InspectContext.getInstance().cleanBom();
            JComboBox cb = (JComboBox)e.getSource();
            ExtendModel selectItem = (ExtendModel)((Object)cb.getSelectedItem());
            DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
            String deviceType = devInfo.getDevType();
            String version = devInfo.getProductVersion();
            LOG.info("Select item from first combox: {}", (Object)selectItem);
            if (this.lastSelected.equals((Object)selectItem)) {
                return;
            }
            if (this.checkConfigMode(selectItem, devInfo)) {
                LOG.warn("computing dev is not support exp extend model.");
                return;
            }
            if (StrategySettingCard.isMoveCardScenario(deviceType, version)) {
                this.layout.updateTable();
            }
            this.lastSelected = selectItem;
            boolean isInputVisiable = !ExtendModel.EXTEND_DEFAULT.equals((Object)selectItem) && !ExtendModel.LINK_EXP_INSPECT.equals((Object)selectItem);
            boolean supportExpCtrl = true;
            ArrayList<String> expSpecList = InspectContext.getInstance().getDevInfo().getExpSpec();
            if (ExtendModel.CTRL_EXP_INSPECT.equals((Object)selectItem) && (expSpecList == null || expSpecList.isEmpty())) {
                isInputVisiable = false;
                supportExpCtrl = false;
            }
            if (ExtendModel.SCM_EXP_INSPECT.equals((Object)selectItem) || ExtendModel.INTF_CARD_EXP_INSPECT.equals((Object)selectItem)) {
                isInputVisiable = false;
            }
            if (ExtendModel.DISK_EXP_INSPECT.equals((Object)selectItem) && Products.isOceanStoComputingDev((String)deviceType)) {
                LOG.info("select item is disk exp.");
                isInputVisiable = false;
            }
            this.resetUI(selectItem, deviceType, version);
            LOG.info("supportExpCtrl: {}", (Object)supportExpCtrl);
            if (!supportExpCtrl) {
                this.hideExpCtrlComponent();
                return;
            }
            this.setSpecifyDevtypeHighDensityDiskEnclosureBoxVisible(selectItem, deviceType);
            this.layout.setSubConfigVisiable(ExtendModel.CTRL_EXP_INSPECT.equals((Object)selectItem));
            if (ExtendModel.CTRL_EXP_INSPECT.equals((Object)selectItem) || ExtendModel.DISK_EXP_INSPECT.equals((Object)selectItem)) {
                this.layout.getSubConfigSpaceBox().setVisible(ExtendModel.CTRL_EXP_INSPECT.equals((Object)selectItem));
                this.card.setHardwareBomVisible(true);
            } else {
                this.card.setHardwareBomVisible(false);
            }
            if ((ExtendModel.DD_EXP_INSPECT.equals((Object)selectItem) || ExtendModel.NEW_OCEAN_STR_DD_EXP_INSPECT.equals((Object)selectItem)) && (null == (devDomains = devInfo.getDevDomains()) || devDomains.isEmpty())) {
                isInputVisiable = false;
            }
            this.card.initExpConfigMap();
            this.layout.setInputAreaVisiable(isInputVisiable);
            this.card.updateNavigationBar();
        }

        private boolean checkConfigMode(ExtendModel configMode, DevInfo4Exp devInfo) {
            String deviceType = devInfo.getDevType();
            if (Products.isOceanStoComputingDev((String)deviceType) && !configMode.conSupportedExpModelByComputing()) {
                JDialog mainDialog = InspectContext.getInstance().getMainDialog();
                String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.not.support.extendModel", (Object[])new Object[]{configMode.getDes()});
                DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
                return true;
            }
            return false;
        }

        private void resetUI(ExtendModel selectItem, String deviceType, String version) {
            ExpandScmPanel.getInstance().active(selectItem.equals((Object)ExtendModel.SCM_EXP_INSPECT));
            this.layout.getModel().removeAll();
            this.layout.updateModel(deviceType, version, selectItem);
            this.layout.getModel().fireTableStructureChanged();
            this.layout.setTableHeaderSize();
        }

        private void hideExpCtrlComponent() {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            this.layout.setHighDensityDiskEnclosureBoxVisible(false);
            this.layout.setSubConfigVisiable(false);
            this.layout.setInputAreaVisiable(false);
            this.card.updateNavigationBar();
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)InspectContext.getInstance().getDevInfo().getErrMsg());
        }

        private void setSpecifyDevtypeHighDensityDiskEnclosureBoxVisible(ExtendModel selectItem, String deviceType) {
            String[] highDensityDiskEnclosureDevType;
            for (String devType : highDensityDiskEnclosureDevType = this.layout.getHighDensityDiskEnclosureDevType()) {
                if (devType.equalsIgnoreCase(deviceType)) {
                    this.layout.setHighDensityDiskEnclosureBoxVisible(ExtendModel.DISK_EXP_INSPECT.equals((Object)selectItem));
                    break;
                }
                this.layout.setHighDensityDiskEnclosureBoxVisible(false);
            }
        }
    }

    private static class AddConfigBtnListener
    implements ActionListener {
        private StrategySettingCard card;

        public AddConfigBtnListener(StrategySettingCard card) {
            this.card = card;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean isSelectHighDensityDiskEnclosure;
            ExtendModel selectConfigItem = (ExtendModel)((Object)this.card.layout.getConfigBox().getSelectedItem());
            String subConfigMode = (String)this.card.layout.getSubConfigBox().getSelectedItem();
            String subSel4Veritas = (String)this.card.layout.getSubSel4VeritasBox().getSelectedItem();
            String subSel4InnerMetro = (String)this.card.layout.getSubSel4InnerMetroBox().getSelectedItem();
            String highDensityDiskEnclosureBox = (String)this.card.layout.getHighDensityDiskEnclosureBox().getSelectedItem();
            boolean isSelectSubConfig = this.card.layout.getSubConfigBox().isVisible() && !subConfigMode.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.extendCtrlselect"));
            boolean isSelectSub4Veritas = !this.card.layout.getSubSel4VeritasBox().isVisible() || !subSel4Veritas.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.extendVeritasSelect"));
            boolean isSelectSub4InnerMetro = !this.card.layout.getSubSel4InnerMetroBox().isVisible() || !subSel4InnerMetro.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.requireInnerMetroSelect"));
            boolean bl = isSelectHighDensityDiskEnclosure = !this.card.layout.getHighDensityDiskEnclosureBox().isVisible() || !highDensityDiskEnclosureBox.equals(ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.highDensityDiskEnclosureSelect"));
            if (ExtendModel.CTRL_EXP_INSPECT.equals((Object)selectConfigItem) && !this.isSelectAllBox(isSelectSubConfig, isSelectSub4Veritas, isSelectSub4InnerMetro)) {
                return;
            }
            if (ExtendModel.DISK_EXP_INSPECT.equals((Object)selectConfigItem) && !isSelectHighDensityDiskEnclosure) {
                DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.highDensityDiskEnclosureSelect"));
                return;
            }
            this.card.addOneRow(this.card.createRow());
            LOG.info("add one strategy row");
        }

        private boolean isSelectAllBox(boolean isSelectSubConfig, boolean isSelectSub4Veritas, boolean isSelectSub4InnerMetro) {
            if (!isSelectSubConfig) {
                DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.verify.unselect.expCtrlsNum.msg"));
                return false;
            }
            if (!isSelectSub4Veritas) {
                DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.extendVeritasSelect"));
                return false;
            }
            if (!isSelectSub4InnerMetro) {
                DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.wizard.strategysetting.combox.requireInnerMetroSelect"));
                return false;
            }
            return true;
        }
    }

    private static class DiskEnclosureBomInputListener
    implements DocumentListener {
        private StrategySettingCard card;

        public DiskEnclosureBomInputListener(StrategySettingCard card) {
            this.card = card;
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            String bom = this.card.layout.getDiskEnclosureBomJTF().getText().trim();
            InspectContext.getInstance().setDiskEnclosureBom(bom);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            String bom = this.card.layout.getDiskEnclosureBomJTF().getText().trim();
            InspectContext.getInstance().setDiskEnclosureBom(bom);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            String bom = this.card.layout.getDiskEnclosureBomJTF().getText().trim();
            InspectContext.getInstance().setDiskEnclosureBom(bom);
        }
    }

    private static class InterfaceCardBomInputListener
    implements DocumentListener {
        private StrategySettingCard card;

        public InterfaceCardBomInputListener(StrategySettingCard card) {
            this.card = card;
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            String bom = this.card.layout.getInterfaceCardBomJTF().getText().trim();
            InspectContext.getInstance().setInterfaceCardBom(bom);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            String bom = this.card.layout.getInterfaceCardBomJTF().getText().trim();
            InspectContext.getInstance().setInterfaceCardBom(bom);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            String bom = this.card.layout.getInterfaceCardBomJTF().getText().trim();
            InspectContext.getInstance().setInterfaceCardBom(bom);
        }
    }

    private static class InterfaceBomInputListener
    implements DocumentListener {
        private StrategySettingCard card;

        public InterfaceBomInputListener(StrategySettingCard card) {
            this.card = card;
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            String bom = this.card.layout.getInterfaceBomJTF().getText().trim();
            InspectContext.getInstance().setInterfaceBom(bom);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            String bom = this.card.layout.getInterfaceBomJTF().getText().trim();
            InspectContext.getInstance().setInterfaceBom(bom);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            String bom = this.card.layout.getInterfaceBomJTF().getText().trim();
            InspectContext.getInstance().setInterfaceBom(bom);
        }
    }

    private static class EncBomInputListener
    implements DocumentListener {
        private StrategySettingCard card;

        public EncBomInputListener(StrategySettingCard card) {
            this.card = card;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            String s = this.card.layout.getEncBomJTF().getText().trim();
            InspectContext.getInstance().setEncBom(s);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            String s = this.card.layout.getEncBomJTF().getText().trim();
            InspectContext.getInstance().setEncBom(s);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            String s = this.card.layout.getEncBomJTF().getText().trim();
            InspectContext.getInstance().setEncBom(s);
        }
    }

    private static class CtrlBomInputListener
    implements DocumentListener {
        private StrategySettingCard card;

        public CtrlBomInputListener(StrategySettingCard card) {
            this.card = card;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            String s = this.card.layout.getCtrlBomJTF().getText().trim();
            InspectContext.getInstance().setCtrlBom(s);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            String s = this.card.layout.getCtrlBomJTF().getText().trim();
            InspectContext.getInstance().setCtrlBom(s);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            String s = this.card.layout.getCtrlBomJTF().getText().trim();
            InspectContext.getInstance().setCtrlBom(s);
        }
    }

    private class InnerParameter {
        String crossEngs = "";
        String diskDd = "";
        String ctrls = "";
        String diskModelDisplay = "";
        String diskWorkMode;
        String expDiskMode;
        String diskType;
        String diskCap;
        String capUnit;
        String diskBom;
        String diskNum;
        String diskEnclosureId = ResourceUtil.getString((String)"inspect.wizard.strategysetting.diskenclosure.noneed");
        boolean isolation = false;
        String diskExpMode;
        double devMaxCapacity;
        String devInputUnit;
        String devInputCapacity;
        String devMaxType;
        String poolId;
        String engineId;

        private InnerParameter() {
        }
    }
}

