/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.SupportScenes;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.logic.warning.SceneIdAndNameKeyValue;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCard;
import com.huawei.ism.tool.inspect.ui.wizard.WelcomeCardLayout;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WelcomeCard
extends InspectCard {
    private static final Logger LOGGER = LoggerFactory.getLogger(WelcomeCard.class);
    private static final long serialVersionUID = 9080325822481224317L;
    private WelcomeCardLayout welcomeCardLayout = new WelcomeCardLayout();

    public WelcomeCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        this.welcomeCardLayout.init();
        this.addLayout(this.welcomeCardLayout);
        WORKTAKER.clear();
    }

    public ToolWizardDialog.Card getNextCard() {
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        ToolWizardDialog.Navigation[] navs = new ToolWizardDialog.Navigation[]{ToolWizardDialog.Navigation.Cancel, ToolWizardDialog.Navigation.Next, ToolWizardDialog.Navigation.Previous};
        InspectContext.getInstance().setBureauCheckSelected(false);
        InspectContext.getInstance().getIsScenesInspect().clear();
        InspectContext.getInstance().setNfvMode(false);
        String period = InspectContext.getInstance().getPeriod();
        String selectRadioButtonName = "";
        for (JRadioButton radioButton : this.welcomeCardLayout.getRadioList()) {
            String radioName = radioButton.getName();
            String string = selectRadioButtonName = radioButton.isSelected() ? radioName : selectRadioButtonName;
            if (null != radioName && radioName.startsWith("warning_check") && radioButton.isSelected()) {
                if (this.handleSelected(mainDialog, radioButton, period)) continue;
                return null;
            }
            InspectContext.getInstance().getIsScenesInspect().put(radioButton.getName(), radioButton.isSelected());
            if (!radioButton.isSelected()) continue;
            LOGGER.info("Inspect next step >> Choose {} type][Success", (Object)radioButton.getName());
            if (!radioButton.getName().equals("bureau_check")) continue;
            InspectContext.getInstance().setBureauCheckSelected(true);
            this.handleBureauJcomBoxSelected();
        }
        this.setSceneToContext(this.welcomeCardLayout.getRadioList());
        SelectDeviceCard selectDeviceCard = new SelectDeviceCard(this, navs);
        selectDeviceCard.initData();
        if (SceneUtils.isScene() && selectRadioButtonName.contains("warning_check")) {
            if (SelectDeviceCard.getDevSupport() == 3) {
                DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"scene.warningcheck.dev.no.support"));
                InspectContext.getInstance().getCloseObserver().onClose();
            } else if (SelectDeviceCard.getDevSupport() == 2) {
                DialogUtils.showInfoDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"scene.warningcheck.dev.part.support"));
            }
        }
        InspectContext.getInstance().updateNavigationBar(selectDeviceCard);
        return selectDeviceCard;
    }

    private void handleBureauJcomBoxSelected() {
        SceneIdAndNameKeyValue bureauJcomboxKv = (SceneIdAndNameKeyValue)((Object)this.welcomeCardLayout.getBureauJcomboBox().getSelectedItem());
        InspectContext.getInstance().setNfvMode(!"normal_mode".equals(bureauJcomboxKv.getKey()));
    }

    private boolean handleSelected(JDialog mainDialog, JRadioButton radioButton, String period) {
        SceneIdAndNameKeyValue firstJcomboxKv = (SceneIdAndNameKeyValue)((Object)this.welcomeCardLayout.getJcomboBox().getSelectedItem());
        SceneIdAndNameKeyValue secondJcomboxKv = (SceneIdAndNameKeyValue)((Object)this.welcomeCardLayout.getJcomboBox2().getSelectedItem());
        if (StringUtils.isNULLStr((String)((String)firstJcomboxKv.getKey()))) {
            DialogUtils.showInfoDialog((JDialog)mainDialog, (String)((String)firstJcomboxKv.getValue() + period));
            return false;
        }
        SupportScenes scenes = new SupportScenes();
        scenes.setScenesId("warning_check " + (String)firstJcomboxKv.getKey());
        List<SupportScenes> supportScenesTmp = InspectContext.getInstance().buildSecondJcombox(scenes, SysConfiguration.getInstance().createdSceneList());
        if (!supportScenesTmp.isEmpty()) {
            if (StringUtils.isNULLStr((String)((String)secondJcomboxKv.getKey()))) {
                DialogUtils.showInfoDialog((JDialog)mainDialog, (String)((String)secondJcomboxKv.getValue() + period));
                return false;
            }
            radioButton.setName("warning_check " + (String)firstJcomboxKv.getKey() + " " + (String)secondJcomboxKv.getKey());
            InspectContext.getInstance().getIsScenesInspect().put(radioButton.getName(), radioButton.isSelected());
        } else {
            radioButton.setName("warning_check " + (String)firstJcomboxKv.getKey());
            InspectContext.getInstance().getIsScenesInspect().put(radioButton.getName(), radioButton.isSelected());
        }
        return true;
    }

    private void setSceneToContext(List<JRadioButton> radioList) {
        for (JRadioButton jRadioButton : radioList) {
            if (!jRadioButton.isSelected()) continue;
            WORKTAKER.put("select_sceneId", jRadioButton.getName());
        }
    }

    public int getStep() {
        return this.getStep(CardModelEnum.WELCOME);
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"inspsctor.wizard.step1");
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }

    protected boolean isValid(ToolWizardDialog.Navigation paramNavigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation paramNavigation) {
        return true;
    }
}

