/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard.itemtreebuilder.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DstorageSceneCheckItems;
import com.huawei.ism.tool.inspect.ui.wizard.itemtreebuilder.ItemTreeBuilder;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import javax.swing.tree.MutableTreeNode;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsStorageItemTreeBuilder
implements ItemTreeBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DsStorageItemTreeBuilder.class);
    private static final Map<String, String> FILTER_ITEMS = new HashMap<String, String>();

    private static void initModel() {
        String confiFile = String.join((CharSequence)File.separator, ContextUtil.getToolBoxPath(), "temp", "sceneTemplates", "upgradeConfigDevice.json");
        File file = new File(confiFile);
        if (!file.exists()) {
            return;
        }
        String json = StreamUtils.readStringFormFile((File)file);
        JSONArray objects = JSON.parseArray((String)json);
        for (int i = 0; i < objects.size(); ++i) {
            JSONObject jsonObject = objects.getJSONObject(i);
            String deviceId = jsonObject.getString("id");
            String upgradeMode = jsonObject.getString("upgradeMode");
            if (StringUtils.isEmpty((CharSequence)deviceId) || StringUtils.isEmpty((CharSequence)upgradeMode)) {
                log.warn("device init upgrade model failed :{} ,{}", (Object)deviceId, (Object)upgradeMode);
                continue;
            }
            if ("ONLINE".equals(upgradeMode)) {
                FILTER_ITEMS.put(deviceId, "checkDpcSupportOfflineUpgrade");
                continue;
            }
            FILTER_ITEMS.put(deviceId, "checkDpcSupportOnlineUpgrade");
        }
    }

    @Override
    public void buildDistributedStorageCheckItemTree(CheckDevNode checkDevNode, CheckTreeNode itemRootNodeFather, Predicate<CheckItem> filterFunc) {
        for (DstorageSceneCheckItems dstorageSceneCheckItems : checkDevNode.getDstorageSceneCheckItemsList()) {
            String sceneId = dstorageSceneCheckItems.getSceneId();
            String sceneName = this.getSceneName(checkDevNode, sceneId);
            CheckTreeNode sceneRootNode = new CheckTreeNode();
            sceneRootNode.setUserObject((Object)sceneName);
            Map<String, List<CheckItem>> checkItems = dstorageSceneCheckItems.getCheckItems();
            ArrayList<String> keys = new ArrayList<String>(checkItems.keySet());
            this.removeSomeItem(checkDevNode, checkItems);
            CheckItemUtils.addSubItems(checkItems, keys, sceneRootNode, sceneRootNode, filterFunc);
            if (sceneRootNode.getChildCount() == 0) continue;
            sceneRootNode.setGroup(sceneRootNode);
            itemRootNodeFather.add((MutableTreeNode)sceneRootNode);
        }
    }

    private void removeSomeItem(CheckDevNode checkDevNode, Map<String, List<CheckItem>> checkItems) {
        for (Map.Entry<String, List<CheckItem>> stringListEntry : checkItems.entrySet()) {
            stringListEntry.getValue().removeIf(item -> item.getItemId().equals(FILTER_ITEMS.get(DsStorageItemTreeBuilder.getDevId(checkDevNode))));
        }
    }

    private static String getDevId(CheckDevNode checkDevNode) {
        DevNode devNodeSafe = checkDevNode.getDevNodeSafe();
        return devNodeSafe.getIp() + devNodeSafe.getDeviceSerialNumber();
    }

    private String getSceneName(CheckDevNode checkDevNode, String sceneId) {
        String sceneName = ResourceUtil.getString((ResourceBundle)checkDevNode.getResourceBundle(), (String)sceneId);
        if (Objects.nonNull(checkDevNode.getExpansionResource()) && "--".equals(sceneName)) {
            sceneName = ResourceUtil.getString((ResourceBundle)checkDevNode.getExpansionResource(), (String)sceneId);
        }
        return sceneName;
    }

    static {
        if (InspectUtils.isDistributedBatchUpgrade()) {
            DsStorageItemTreeBuilder.initModel();
        }
    }
}

