/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard.model;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.itemtreebuilder.ItemTreeBuilderFactor;
import com.huawei.ism.tool.inspect.ui.wizard.model.builder.DeviceTreeNodeBuilder;
import com.huawei.ism.tool.inspect.ui.wizard.model.listener.ApplyBtnListener;
import com.huawei.ism.tool.inspect.ui.wizard.model.listener.DeviceTreeListener;
import com.huawei.ism.tool.inspect.ui.wizard.model.listener.ItemTreeCellEditorListener;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckBoxTree;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckItemDataModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckItemDataModel.class);
    private static final String SELECT_DEVICE_STRING = "inspsctor.wizard.selectitem.inpectitems";
    private final ToolHyperLinkLabel modifyLbl = new ToolHyperLinkLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectitem.options.modify"));
    private final JButton applyBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.button.apply"), (char)'A');
    private final JLabel rightLabel = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectitem.inpectitems"));
    private boolean isHappened = false;
    private CheckTreeNode itemRootNodeFather;
    private CheckTreeNode itemRootNode;
    private CheckTreeNode itemRootNodeDepth;
    private CheckTreeNode highlightTreeNode;
    private JTree deviceTree;
    private String chooseIpStr;
    private List<CheckDevNode> checkNodes;
    private CheckBoxTree itemTree;
    private InspectCard selectItemCard;
    private Predicate<CheckItem> filterFunc;

    public void initData(List<CheckDevNode> checkDevNodes, InspectCard selectItemCard, Predicate<CheckItem> filterFunc) {
        this.checkNodes = checkDevNodes;
        this.filterFunc = filterFunc;
        this.selectItemCard = selectItemCard;
        ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes = InspectUtils.classifyDevs(checkDevNodes);
        this.initDeviceTree(checkTypeNodes);
        this.initItemTree(checkTypeNodes);
        this.bindListener();
        this.setComponentName();
    }

    public void setCardData(JScrollPane deviceScroll, JScrollPane itemScroll) {
        deviceScroll.setViewportView(this.deviceTree);
        itemScroll.setViewportView((Component)this.itemTree);
        deviceScroll.setBorder(BorderFactory.createEtchedBorder());
        itemScroll.setBorder(BorderFactory.createEtchedBorder());
        this.deviceTree.setSelectionPath(this.deviceTree.getPathForRow(1));
    }

    private void bindListener() {
        this.addDeviceTreeListener();
        this.addItemChangeListener();
        this.initApplyBtnListener();
    }

    private void addDeviceTreeListener() {
        DeviceTreeListener deviceTreeListener = new DeviceTreeListener(this);
        this.deviceTree.addMouseListener(deviceTreeListener);
        this.deviceTree.addTreeSelectionListener(deviceTreeListener);
    }

    public boolean isDistributedStorage(CheckDevNode checkNode) {
        return Objects.nonNull(checkNode.getDevNode()) && checkNode.getDevNode().isLikeDsStorage();
    }

    public List<CheckDevNode> getBrothersNodes() throws ToolException {
        ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes = InspectUtils.classifyDevs(this.checkNodes);
        TreePath selectTree = this.getSelectTreePath(this.deviceTree);
        String selectDevIp = this.getSelectDevIp(checkTypeNodes, selectTree);
        return this.getBrothersNodesIncludeSelf(checkTypeNodes, selectTree).stream().map(this::getEffectiveNode).filter(node -> !selectDevIp.equals(node.getDevNodeSafe().getIp())).collect(Collectors.toList());
    }

    private CheckDevNode getEffectiveNode(CheckDevNode node) {
        return this.hasNoCheckItemAndHasChildren(node) ? node.getChildrens().stream().findFirst().orElse(new CheckDevNode()) : node;
    }

    public List<CheckDevNode> getBrothersNodesIncludeSelf(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes, TreePath selectTree) {
        String selectDeviceModel = this.getSelectDeviceModel(selectTree);
        if (this.isIntegration(selectTree)) {
            return this.flatCheckTypeNodes(checkTypeNodes, selectDeviceModel).filter(checkDevNode -> !checkDevNode.getChildrens().isEmpty()).map(checkDevNode -> checkDevNode.getChildrens().get(0)).collect(Collectors.toList());
        }
        return this.flatCheckTypeNodes(checkTypeNodes, selectDeviceModel).collect(Collectors.toList());
    }

    private Stream<CheckDevNode> flatCheckTypeNodes(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes, String selectDeviceModel) {
        return checkTypeNodes.keySet().stream().filter(key -> key.contains(selectDeviceModel)).map(arg_0 -> checkTypeNodes.get(arg_0)).flatMap(Collection::stream);
    }

    private void setHighlightNode(CheckTreeNode treeNode) {
        if (Objects.isNull(this.highlightTreeNode)) {
            treeNode.setHilight(true);
            this.highlightTreeNode = treeNode;
        }
    }

    public boolean hasNoCheckItemAndHasChildren(CheckDevNode checkDevNode) {
        return MapUtils.isEmpty(checkDevNode.getCheckItems()) && !checkDevNode.getChildrens().isEmpty();
    }

    public String getSelectDevIp(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes, TreePath selectTree) {
        if (this.isIntegration(selectTree)) {
            String deviceModel = this.getSelectDeviceModel(selectTree);
            return this.getIntegrationHeadIp(checkTypeNodes, deviceModel, selectTree);
        }
        return selectTree.getLastPathComponent().toString();
    }

    private boolean isIntegration(TreePath selectTree) {
        return !StringUtils.isNULLStr((String)selectTree.getParentPath().getParentPath().getLastPathComponent().toString());
    }

    private String getSelectDeviceModel(TreePath selectTree) {
        String deviceModel = selectTree.getParentPath().getParentPath().getLastPathComponent().toString();
        if (StringUtils.isNULLStr((String)deviceModel)) {
            return selectTree.getParentPath().getLastPathComponent().toString();
        }
        if (deviceModel.contains("(")) {
            return deviceModel.substring(0, deviceModel.indexOf("("));
        }
        return deviceModel;
    }

    private void initItemTree(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes) {
        this.itemTree = this.createItemCheckBoxTree(checkTypeNodes);
        this.itemTree.setShowsRootHandles(true);
    }

    private CheckBoxTree createItemCheckBoxTree(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes) {
        this.initItemRoot();
        this.setItemRootData(checkTypeNodes);
        return new CheckBoxTree(this.itemRootNodeFather, true);
    }

    private void setItemRootData(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes) {
        checkTypeNodes.keyList().stream().findFirst().map(arg_0 -> checkTypeNodes.get(arg_0)).flatMap(this::findFirstDeviceNode).ifPresent(this::buildItemTreeData);
    }

    private void buildItemTreeData(CheckDevNode selectCheckDevNode) {
        this.setChooseIpStr(selectCheckDevNode);
        this.updateLabelText();
        this.initItemTreeData(selectCheckDevNode);
    }

    private Optional<CheckDevNode> findFirstDeviceNode(List<CheckDevNode> checkDevNodes) {
        return checkDevNodes.stream().findFirst();
    }

    public void updateLabelText() {
        this.rightLabel.setText(ResourceUtil.getStringWithParams((String)SELECT_DEVICE_STRING, (Object[])new Object[]{this.chooseIpStr}));
    }

    private void initItemRoot() {
        this.itemRootNodeFather = new CheckTreeNode();
        this.itemRootNode = new CheckTreeNode();
        this.itemRootNodeDepth = new CheckTreeNode();
    }

    public void initItemTreeData(CheckDevNode checkDevNode) {
        this.removeCurShowItems();
        this.itemRootNodeFather.setUserObject((Object)checkDevNode.getFirstNode().getIp());
        this.selectRootNode();
        String typeName = checkDevNode.getDevNodeSafe().getItDeviceType().getName();
        ItemTreeBuilderFactor.getBuilderByType(typeName).buildDistributedStorageCheckItemTree(this.getFirstCheckDevNode(checkDevNode), this.getRootNode(checkDevNode), this.filterFunc);
    }

    private CheckDevNode getFirstCheckDevNode(CheckDevNode checkDevNode) {
        return checkDevNode.getAllCheckNode().stream().findFirst().orElse(checkDevNode);
    }

    private void selectRootNode() {
        if (this.itemRootNode.getChildCount() != 0) {
            this.itemRootNode.setSelected(true);
            return;
        }
        this.itemRootNodeFather.setSelected(true);
    }

    private void removeCurShowItems() {
        if (Objects.nonNull(this.itemRootNodeFather)) {
            this.itemRootNodeFather.removeAllChildren();
        }
    }

    private CheckTreeNode getRootNode(CheckDevNode checkDevNode) {
        if (this.isDistributedStorage(checkDevNode) || this.isWarningCheckScenario()) {
            return this.itemRootNodeFather;
        }
        this.itemRootNodeFather.add((MutableTreeNode)this.itemRootNode);
        return this.itemRootNode;
    }

    private boolean isWarningCheckScenario() {
        return InspectContext.getInstance().getSelectInspectType().contains("warning_check");
    }

    private void initDeviceTree(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes) {
        this.deviceTree = new DeviceTreeNodeBuilder(this::needShowCurNode, this::setHighlightNode).builderTreeNode(checkTypeNodes);
        this.deviceTree.setShowsRootHandles(true);
    }

    private boolean needShowCurNode(CheckDevNode checkDevNode) {
        CheckTreeNode checkTreeNode = new CheckTreeNode();
        ItemTreeBuilderFactor.getBuilderByType(checkDevNode.getDevNodeSafe().getItDeviceType().getName()).buildDistributedStorageCheckItemTree(checkDevNode, checkTreeNode, this.filterFunc);
        return checkTreeNode.getChildCount() != 0 || Objects.nonNull(checkTreeNode.getUserObject());
    }

    public TreePath getSelectTreePath(JTree deviceTree) throws ToolException {
        TreePath selectTree = deviceTree.getSelectionPath();
        if (Objects.isNull(selectTree)) {
            throw new ToolException("selectTree is null");
        }
        return selectTree;
    }

    public void setChooseIpStr(CheckDevNode checkNode) {
        this.chooseIpStr = checkNode.getFirstNode().getIp();
        if (StringUtils.isNULLStr((String)this.chooseIpStr)) {
            log.info("node ip not found");
        }
    }

    private String getIntegrationHeadIp(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes, String deviceModel, TreePath selectTree) {
        Set deviceModelKeys = checkTypeNodes.keySet();
        return deviceModelKeys.stream().filter(key -> key.contains(deviceModel)).map(arg_0 -> checkTypeNodes.get(arg_0)).map(checkDevNodes -> checkDevNodes.stream().findFirst().orElseGet(CheckDevNode::new)).filter(checkDevNode -> !checkDevNode.getChildrens().isEmpty()).map(devNode -> this.getSelectDevIp(devNode.getChildrens(), selectTree)).reduce(selectTree.getLastPathComponent().toString(), (preIp, curIp) -> curIp);
    }

    private String getSelectDevIp(List<CheckDevNode> devNodes, TreePath selectTree) {
        String selectDevIp = selectTree.getLastPathComponent().toString();
        String headIp = devNodes.stream().findFirst().orElseGet(CheckDevNode::new).getDevNodeSafe().getIp();
        return devNodes.stream().anyMatch(checkNode -> checkNode.getDevNode().getIp().equals(selectDevIp)) ? headIp : selectDevIp;
    }

    private void addItemChangeListener() {
        TreeCellEditor editor = this.itemTree.getCellEditor();
        editor.addCellEditorListener(new ItemTreeCellEditorListener(this));
    }

    private void initApplyBtnListener() {
        this.applyBtn.addActionListener(new ApplyBtnListener(this));
    }

    private void setComponentName() {
        this.deviceTree.setName("inspect_deviceTree");
        this.itemTree.setName("inspect_itemTree");
        this.modifyLbl.setName("modify_Label");
        this.applyBtn.setName("inspect_button");
    }

    @Generated
    public ToolHyperLinkLabel getModifyLbl() {
        return this.modifyLbl;
    }

    @Generated
    public JButton getApplyBtn() {
        return this.applyBtn;
    }

    @Generated
    public JLabel getRightLabel() {
        return this.rightLabel;
    }

    @Generated
    public boolean isHappened() {
        return this.isHappened;
    }

    @Generated
    public void setHappened(boolean isHappened) {
        this.isHappened = isHappened;
    }

    @Generated
    public CheckTreeNode getItemRootNodeFather() {
        return this.itemRootNodeFather;
    }

    @Generated
    public CheckTreeNode getItemRootNode() {
        return this.itemRootNode;
    }

    @Generated
    public CheckTreeNode getItemRootNodeDepth() {
        return this.itemRootNodeDepth;
    }

    @Generated
    public CheckTreeNode getHighlightTreeNode() {
        return this.highlightTreeNode;
    }

    @Generated
    public void setHighlightTreeNode(CheckTreeNode highlightTreeNode) {
        this.highlightTreeNode = highlightTreeNode;
    }

    @Generated
    public JTree getDeviceTree() {
        return this.deviceTree;
    }

    @Generated
    public String getChooseIpStr() {
        return this.chooseIpStr;
    }

    @Generated
    public List<CheckDevNode> getCheckNodes() {
        return this.checkNodes;
    }

    @Generated
    public CheckBoxTree getItemTree() {
        return this.itemTree;
    }

    @Generated
    public InspectCard getSelectItemCard() {
        return this.selectItemCard;
    }
}

