/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard.model;

import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.ui.action.BmcNodeAuthAction;
import com.huawei.ism.tool.inspect.ui.wizard.FirstCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.model.builder.DeviceTreeNodeBuilder;
import com.huawei.ism.tool.inspect.ui.wizard.model.listener.ClusterNodeDeviceTreeListener;
import com.huawei.ism.tool.inspect.ui.wizard.model.listener.ListSelectionListenerImpl;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.ui.PatchComponent;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionListener;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectClusterNodeModel
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectClusterNodeModel.class);
    private static final long serialVersionUID = 1L;
    private final JLabel rightLabel = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectcluster.nodes"));
    private final List<DstoragePatchInfo.Type> supportInspectTypes = Arrays.asList(DstoragePatchInfo.Type.COLLECT, DstoragePatchInfo.Type.INSPECT);
    private final transient PatchComponent component = new PatchComponent((Window)InspectContext.getInstance().getMainDialog(), this.supportInspectTypes);
    private JTree deviceTree;
    private CheckTreeNode highlightTreeNode;
    private IsmTable clusterNodesTbl = null;
    private CheckDevNode chooseChkDevNode;
    private DefaultTableModel clusterNodesTblModel = null;
    private FirstCardLayout cardLayout;
    private transient Predicate<ClusterNode> clusterNodeFilterFunc;
    private transient BooleanSupplier isAuthCardFunc;

    public void setClusterNodesTbl(IsmTable clusterNodesTbl) {
        this.clusterNodesTbl = clusterNodesTbl;
        this.clusterNodesTblModel = (DefaultTableModel)clusterNodesTbl.getModel();
    }

    public void initData(List<CheckDevNode> checkDevNodes, BooleanSupplier isAuthCardFunc) {
        this.isAuthCardFunc = isAuthCardFunc;
        this.initTree(checkDevNodes);
        this.bindListener();
    }

    private void initTree(List<CheckDevNode> checkDevNodes) {
        this.deviceTree = new DeviceTreeNodeBuilder(null, this::setHighlightTreeNode).builderTreeNode(InspectUtils.classifyDevs(checkDevNodes));
        this.deviceTree.setShowsRootHandles(true);
    }

    private void setHighlightTreeNode(CheckTreeNode highlightTreeNode) {
        if (Objects.nonNull(this.highlightTreeNode)) {
            return;
        }
        this.highlightTreeNode = highlightTreeNode;
        this.highlightTreeNode.setHilight(true);
    }

    public void setCardData(JScrollPane deviceScroll, TableScrollPane itemScroll) {
        deviceScroll.setViewportView(this.deviceTree);
        itemScroll.setViewportView(this.clusterNodesTbl);
        deviceScroll.setBorder(BorderFactory.createEtchedBorder());
        itemScroll.setBorder(BorderFactory.createEtchedBorder());
        this.deviceTree.setSelectionPath(this.deviceTree.getPathForRow(1));
    }

    public void bindListener() {
        this.deviceTree.addTreeSelectionListener(new ClusterNodeDeviceTreeListener(this, this.clusterNodeFilterFunc));
        this.deviceTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SelectClusterNodeModel.this.processHighlight();
            }
        });
        this.clusterNodesTbl.addListSelectionListener((ListSelectionListener)new ListSelectionListenerImpl(this));
    }

    public void bindFilterFiledChangeListener(TableScrollPane nodesScroll) {
        nodesScroll.getFilterFiled().addEndChangeListener(event -> this.markRowIfClusterIsSelected());
    }

    private void markRowIfClusterIsSelected() {
        List selectedNodes = this.getChooseChkDevNode().getDevNode().getClusterNodes().stream().filter(ClusterNode::isSelected).collect(Collectors.toList());
        List<TableRow> rows = this.getClusterNodesTbl().getAllRows().stream().filter(row -> selectedNodes.contains(row.getIdentifier())).collect(Collectors.toList());
        this.getClusterNodesTbl().markTableRow(rows.toArray(new TableRow[0]));
    }

    private void processHighlight() {
        if (!this.highlightTreeNode.isHilight()) {
            return;
        }
        this.highlightTreeNode.setHilight(false);
        this.deviceTree.repaint();
    }

    public boolean isAuthCard() {
        return Objects.nonNull(this.isAuthCardFunc) && this.isAuthCardFunc.getAsBoolean();
    }

    public void modifyTableRow(TableRow<ClusterNode, ClusterNode> row, ClusterNode cn) {
        if (InspectContext.getInstance().isBureauCheckSelected()) {
            this.modifyRowByBureau(row, cn);
            return;
        }
        int index = 0;
        row.setValueAt(index++, (Object)cn.getManagementIp());
        row.setValueAt(index++, (Object)String.join((CharSequence)",", cn.getRoles()));
        row.setValueAt(index++, (Object)cn.getName());
        row.setValueAt(index, this.filterClusterNodeIds(cn));
    }

    private Object filterClusterNodeIds(ClusterNode cn) {
        return cn.getId() == -1 ? "--" : Integer.valueOf(cn.getId());
    }

    private void modifyRowByBureau(TableRow<ClusterNode, ClusterNode> row, ClusterNode cn) {
        int index = 0;
        row.setValueAt(index++, (Object)cn.getManagementIp());
        row.setValueAt(index++, (Object)String.join((CharSequence)",", cn.getRoles()));
        row.setValueAt(index++, (Object)cn.getBmcNode().getIp());
        if (this.needAuth()) {
            row.setValueAt(index++, this.getBmcAuthCell(cn));
        }
        row.setValueAt(index++, this.filterClusterNodeIds(cn));
        row.setValueAt(index++, (Object)cn.getCabinet());
        row.setValueAt(index, (Object)cn.getName());
    }

    private boolean needAuth() {
        return !InspectContext.getInstance().isDetachCheck() || this.isAuthCard();
    }

    private Object getBmcAuthCell(ClusterNode cn) {
        if (!cn.includedStorageService() || cn.isHGNode()) {
            return ResourceUtil.getString((String)"bmc.auth.layout.title.nosupport");
        }
        String operation = ResourceUtil.getString((String)"bmc.auth.layout.title.modifyDev");
        if (cn.getBmcNode() != null && cn.getBmcNode().getLoginUser() == null) {
            operation = ResourceUtil.getString((String)"bmc.auth.layout.title.auth");
        }
        return new IsmTableCell.HyperlinkCell(operation, (ActionListener)new BmcNodeAuthAction(cn));
    }

    public void refreshTable(List<AbstractDevice> abstractDevices) {
        List<AbstractDevice> iBMCDevices = abstractDevices.stream().filter(this::isIBmcDeviceNode).collect(Collectors.toList());
        if (iBMCDevices.isEmpty()) {
            return;
        }
        log.info("auth successfully nodes:{}", iBMCDevices);
        this.modifyRowAndNode(iBMCDevices);
    }

    private boolean isIBmcDeviceNode(AbstractDevice iBmcDev) {
        return ITDeviceType.SERVER_IBMC.equals((Object)iBmcDev.getItDeviceType()) && iBmcDev instanceof IBMCDevice;
    }

    private void modifyRowAndNode(List<AbstractDevice> iBMCDevices) {
        Map<String, IBMCDevice> deviceMap = iBMCDevices.stream().collect(Collectors.toMap(AbstractDevice::getIp, device -> (IBMCDevice)device, this::dealDuplicatedIp));
        this.clusterNodesTbl.getMarkedRows().stream().filter(row -> Objects.nonNull(deviceMap.get(this.getBmcIp((TableRow)row)))).forEach(row -> this.modifyRow((IBMCDevice)deviceMap.get(this.getBmcIp((TableRow)row)), (TableRow<ClusterNode, ClusterNode>)row));
    }

    private IBMCDevice dealDuplicatedIp(AbstractDevice device, AbstractDevice duplicatedDevice) {
        log.info("tow row has same bmc ip : {}, {}", (Object)device, (Object)duplicatedDevice);
        return (IBMCDevice)device;
    }

    private String getBmcIp(TableRow row) {
        return ((ClusterNode)row.getUserObject()).getBmcNode().getIp();
    }

    private void modifyRow(IBMCDevice ibmcDevice, TableRow<ClusterNode, ClusterNode> row) {
        ClusterNode node = (ClusterNode)row.getUserObject();
        this.modifyBmcNode(ibmcDevice, this.getBmcNode(node));
        this.modifyTableRow(row, node);
    }

    private DevNode getBmcNode(ClusterNode node) {
        DevNode bmcNode = node.getBmcNode();
        if (bmcNode == null) {
            bmcNode = new DevNode();
            node.setBmcNode(bmcNode);
        }
        return bmcNode;
    }

    private void modifyBmcNode(IBMCDevice ibmcDevice, DevNode bmcNode) {
        bmcNode.setIp(ibmcDevice.getIp());
        bmcNode.setLoginUser(new User(ibmcDevice.getHwServerDev().getUserName(), ibmcDevice.getHwServerDev().getUserPwd()));
        bmcNode.setProductModel(ibmcDevice.getProductName());
        bmcNode.setDeviceSerialNumber(ibmcDevice.getDeviceSerialNumber());
        bmcNode.setPort(ibmcDevice.getHwServerDev().getSshPort());
        bmcNode.setRedFishPort(ibmcDevice.getHwServerDev().getRedFishPort());
    }

    @Generated
    public JLabel getRightLabel() {
        return this.rightLabel;
    }

    @Generated
    public List<DstoragePatchInfo.Type> getSupportInspectTypes() {
        return this.supportInspectTypes;
    }

    @Generated
    public PatchComponent getComponent() {
        return this.component;
    }

    @Generated
    public JTree getDeviceTree() {
        return this.deviceTree;
    }

    @Generated
    public CheckTreeNode getHighlightTreeNode() {
        return this.highlightTreeNode;
    }

    @Generated
    public IsmTable getClusterNodesTbl() {
        return this.clusterNodesTbl;
    }

    @Generated
    public CheckDevNode getChooseChkDevNode() {
        return this.chooseChkDevNode;
    }

    @Generated
    public void setChooseChkDevNode(CheckDevNode chooseChkDevNode) {
        this.chooseChkDevNode = chooseChkDevNode;
    }

    @Generated
    public DefaultTableModel getClusterNodesTblModel() {
        return this.clusterNodesTblModel;
    }

    @Generated
    public FirstCardLayout getCardLayout() {
        return this.cardLayout;
    }

    @Generated
    public void setCardLayout(FirstCardLayout cardLayout) {
        this.cardLayout = cardLayout;
    }

    @Generated
    public Predicate<ClusterNode> getClusterNodeFilterFunc() {
        return this.clusterNodeFilterFunc;
    }

    @Generated
    public void setClusterNodeFilterFunc(Predicate<ClusterNode> clusterNodeFilterFunc) {
        this.clusterNodeFilterFunc = clusterNodeFilterFunc;
    }
}

