/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard.model.builder;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckBoxTree;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.tree.MutableTreeNode;
import lombok.Generated;

public class DeviceTreeNodeBuilder {
    private final Predicate<CheckDevNode> needShowFilterFunc;
    private final Consumer<CheckTreeNode> setHighlightFunc;

    public CheckBoxTree builderTreeNode(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes) {
        return new CheckBoxTree(this.getDeviceRootNode(checkTypeNodes), false);
    }

    private CheckTreeNode getDeviceRootNode(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes) {
        CheckTreeNode deviceRootNode = new CheckTreeNode();
        List keys = checkTypeNodes.keyList();
        keys.stream().map(key -> this.createChildNode((String)key, (List)checkTypeNodes.get(key))).filter(treeNode -> treeNode.getChildCount() > 0).forEach(arg_0 -> deviceRootNode.add(arg_0));
        return deviceRootNode;
    }

    private CheckTreeNode createChildNode(String key, List<CheckDevNode> checkDevs) {
        CheckTreeNode checkTreeNode = new CheckTreeNode((Object)key, true, true);
        checkTreeNode.setSelected(true);
        this.initChildrenNode(checkTreeNode, checkDevs);
        return checkTreeNode;
    }

    private void initChildrenNode(CheckTreeNode parentCheckTreeNode, List<CheckDevNode> checkDevs) {
        checkDevs.stream().filter(this::needCurDeviceNode).forEach(devNode -> this.addChildNodeToParent(parentCheckTreeNode, (CheckDevNode)devNode));
    }

    private void addChildNodeToParent(CheckTreeNode parentCheckTreeNode, CheckDevNode devNode) {
        CheckTreeNode childTreeNode = this.createChildTreeNode(devNode);
        parentCheckTreeNode.add((MutableTreeNode)childTreeNode);
        this.initChildrenNode(childTreeNode, devNode.getChildrens());
        this.setHighlightNode(childTreeNode);
    }

    private void setHighlightNode(CheckTreeNode treeNode) {
        if (Objects.isNull(this.setHighlightFunc)) {
            return;
        }
        this.setHighlightFunc.accept(treeNode);
    }

    private CheckTreeNode createChildTreeNode(CheckDevNode devNode) {
        CheckTreeNode childTreeNode = new CheckTreeNode((Object)devNode, true, true);
        if (Objects.nonNull(devNode.getDevNode())) {
            childTreeNode.setToolTips(devNode.getDevNode().getDeviceName());
        }
        return childTreeNode;
    }

    private boolean needCurDeviceNode(CheckDevNode checkDevNode) {
        return Objects.isNull(this.needShowFilterFunc) || this.needShowFilterFunc.test(checkDevNode);
    }

    @Generated
    public DeviceTreeNodeBuilder(Predicate<CheckDevNode> needShowFilterFunc, Consumer<CheckTreeNode> setHighlightFunc) {
        this.needShowFilterFunc = needShowFilterFunc;
        this.setHighlightFunc = setHighlightFunc;
    }
}

