/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard.model.listener;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.ui.dialogs.SelectDeviceApplyItemLayout;
import com.huawei.ism.tool.inspect.ui.wizard.model.CheckItemDataModel;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.tree.TreePath;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyBtnListener
implements ActionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplyBtnListener.class);
    private final CheckItemDataModel dataModel;

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.showUpdateCheckDevNodeInfoDialog();
        }
        catch (ToolException toolException) {
            log.error("apply button event handle error", (Throwable)toolException);
        }
    }

    private void showUpdateCheckDevNodeInfoDialog() throws ToolException {
        InspectContext.getInstance().setUseApply(true);
        List<CheckDevNode> brothersNodes = this.dataModel.getBrothersNodes();
        CheckDevNode checkDev = this.getSelectDevNode();
        SelectDeviceApplyItemLayout app = new SelectDeviceApplyItemLayout(brothersNodes, checkDev);
        app.setVisible(true);
    }

    private CheckDevNode getSelectDevNode() {
        try {
            ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes = InspectUtils.classifyDevs(this.dataModel.getCheckNodes());
            TreePath selectTree = this.dataModel.getSelectTreePath(this.dataModel.getDeviceTree());
            String selectDevIp = this.dataModel.getSelectDevIp(checkTypeNodes, selectTree);
            List<CheckDevNode> brothersNodes = this.dataModel.getBrothersNodesIncludeSelf(checkTypeNodes, selectTree);
            return this.getCheckDevNode(selectDevIp, brothersNodes);
        }
        catch (ToolException | RuntimeException e) {
            log.debug("get depth or apply devNode error!", e);
            return new CheckDevNode();
        }
    }

    private CheckDevNode getCheckDevNode(String selectDevIp, List<CheckDevNode> brothersNodes) {
        return brothersNodes.stream().map(node -> this.dataModel.hasNoCheckItemAndHasChildren((CheckDevNode)node) ? node.getChildrens().get(0) : node).filter(node -> selectDevIp.equals(node.getDevNodeSafe().getIp())).findFirst().orElseGet(CheckDevNode::new);
    }

    @Generated
    public ApplyBtnListener(CheckItemDataModel dataModel) {
        this.dataModel = dataModel;
    }
}

