/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard.model.listener;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.ui.wizard.model.SelectClusterNodeModel;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.event.MouseAdapter;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeDeviceTreeListener
extends MouseAdapter
implements TreeSelectionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterNodeDeviceTreeListener.class);
    private static final int RIGHT_LABEL_LENGTH = 45;
    private static final int RIGHT_LABEL_LENGTH_IN_MERGE_CHECK = 23;
    private final SelectClusterNodeModel dataMode;
    private final Predicate<ClusterNode> clusterNodeFilterFunc;

    public ClusterNodeDeviceTreeListener(SelectClusterNodeModel dataMode, Predicate<ClusterNode> clusterNodeFilterFunc) {
        this.dataMode = dataMode;
        this.clusterNodeFilterFunc = clusterNodeFilterFunc;
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        this.changeSelectDevice(event);
    }

    private void changeSelectDevice(TreeSelectionEvent event) {
        TreePath treePath = event.getPath();
        CheckTreeNode treeNode = (CheckTreeNode)treePath.getLastPathComponent();
        Object userObject = treeNode.getUserObject();
        if (!(userObject instanceof CheckDevNode)) {
            return;
        }
        CheckDevNode checkNode = (CheckDevNode)userObject;
        this.initClusterNodesTree(checkNode);
        this.dataMode.setChooseChkDevNode(checkNode);
        this.updateRightLabel(checkNode);
        this.dataMode.getComponent().setCurrentNode(checkNode.getDevNode());
    }

    public void initClusterNodesTree(CheckDevNode chkDevNode) {
        DevNode devNode = chkDevNode.getDevNode();
        this.dataMode.getClusterNodesTblModel().removeAll();
        if (devNode.isLikeDsStorage()) {
            this.addClusterNodesToTable(chkDevNode);
        }
    }

    private void updateRightLabel(CheckDevNode checkNode) {
        int maxLength;
        String title = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.selectnodes.to.inspect", (Object[])new Object[]{checkNode});
        int n = maxLength = InspectContext.getInstance().isBureauCheckSelected() && !InspectContext.getInstance().isDetachCheck() ? 23 : 45;
        if (checkNode.toString().length() > maxLength) {
            String showIp = checkNode.toString().substring(0, maxLength - 3) + "...";
            String showTitle = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.selectnodes.to.inspect", (Object[])new Object[]{showIp});
            this.dataMode.getRightLabel().setToolTipText(title);
            this.dataMode.getRightLabel().setText(showTitle);
        } else {
            this.dataMode.getRightLabel().setText(title);
        }
    }

    private void addClusterNodesToTable(CheckDevNode chkDevNode) {
        DevNode devNode = chkDevNode.getDevNode();
        if (InspectUtils.isDistributedFrw()) {
            this.dataMode.getClusterNodesTbl().markTableRow((TableRow[])devNode.getClusterNodes().stream().filter(clusterNode -> !this.isFilterFuncMatched((ClusterNode)clusterNode)).filter(clusterNode -> this.isStorageNodeSelected(devNode, (ClusterNode)clusterNode)).peek(cn -> this.dataMode.getClusterNodesTblModel().addRow(new TableRow[]{this.constructClusterNodeRow((ClusterNode)cn)})).filter(ClusterNode::isSelected).map(this::constructClusterNodeRow).toArray(TableRow[]::new));
        } else {
            this.dataMode.getClusterNodesTbl().markTableRow((TableRow[])devNode.getClusterNodes().stream().filter(clusterNode -> !this.isFilterFuncMatched((ClusterNode)clusterNode)).peek(cn -> this.dataMode.getClusterNodesTblModel().addRow(new TableRow[]{this.constructClusterNodeRow((ClusterNode)cn)})).filter(ClusterNode::isSelected).map(this::constructClusterNodeRow).toArray(TableRow[]::new));
        }
    }

    private boolean isStorageNodeSelected(DevNode devNode, ClusterNode clusterNode) {
        return devNode.getSelectedNodeIps().contains(clusterNode.getManagementIp()) && clusterNode.isStorageNode();
    }

    private boolean isFilterFuncMatched(ClusterNode clusterNode) {
        return Objects.nonNull(this.clusterNodeFilterFunc) && this.clusterNodeFilterFunc.test(clusterNode);
    }

    private TableRow<ClusterNode, ClusterNode> constructClusterNodeRow(ClusterNode cn) {
        DefaultTableRow row = new DefaultTableRow(this.dataMode.getClusterNodesTblModel().getAllColumnCount(), (Object)cn, (Object)cn);
        this.dataMode.modifyTableRow((TableRow<ClusterNode, ClusterNode>)row, cn);
        return row;
    }

    private boolean needSelected(List<String> selectDpcNodes, ClusterNode clusterNode) {
        return selectDpcNodes.contains(clusterNode.getManagementIp()) || !clusterNode.isOnlyComputeNode();
    }
}

