/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard.model.listener;

import com.huawei.ism.tool.inspect.utils.TableUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeListListener
implements ListSelectionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterNodeListListener.class);
    private static final String TABLE_EVENT_NAME = "DefaultListSelectionModel";
    private final List<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
    private final IsmTable clusterNodesTbl;

    public ClusterNodeListListener(IsmTable clusterNodesTbl, JCheckBox ... allCheckBoxs) {
        this.clusterNodesTbl = clusterNodesTbl;
        this.checkBoxes.addAll(Arrays.asList(allCheckBoxs));
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        String sourceName = event.getSource().toString();
        if (sourceName.contains(TABLE_EVENT_NAME)) {
            this.synCheckBox();
        }
    }

    private void synCheckBox() {
        List<TableRow> allFilteredRows = TableUtils.getAllFilteredRows(this.clusterNodesTbl);
        if (CollectionUtils.isEmpty(allFilteredRows)) {
            return;
        }
        List markedRows = this.clusterNodesTbl.getMarkedRows();
        this.checkBoxes.forEach(checkBox -> checkBox.setSelected(this.isAllCurrentTypeSelect(allFilteredRows, markedRows, (JCheckBox)checkBox)));
    }

    private boolean isAllCurrentTypeSelect(List<TableRow> allFilteredRows, List<TableRow> allMarkedRows, JCheckBox checkBox) {
        List<TableRow> allRows = TableUtils.getSelectRowsByType(allFilteredRows, checkBox.getName());
        List<TableRow> markedRows = TableUtils.getSelectRowsByType(allMarkedRows, checkBox.getName());
        return !allRows.isEmpty() && allRows.size() == markedRows.size();
    }
}

