/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.wizard.model.listener;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.ui.wizard.model.CheckItemDataModel;
import com.huawei.ism.tool.inspect.ui.wizard.model.listener.ModifyButtonActionListener;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceTreeListener
extends MouseAdapter
implements TreeSelectionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceTreeListener.class);
    private final CheckItemDataModel dataMode;

    public DeviceTreeListener(CheckItemDataModel dataMode) {
        this.dataMode = dataMode;
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        try {
            this.changeSelectDevice(event);
        }
        catch (ToolException exception) {
            log.error("data change error", (Throwable)exception);
        }
    }

    private void changeSelectDevice(TreeSelectionEvent event) throws ToolException {
        Object userObject = this.getUserObject(event);
        if (!(userObject instanceof CheckDevNode)) {
            this.dataMode.getApplyBtn().setEnabled(false);
            return;
        }
        CheckDevNode checkNode = (CheckDevNode)userObject;
        if (checkNode.getCheckItems().isEmpty()) {
            this.dataMode.getApplyBtn().setEnabled(false);
            return;
        }
        boolean isDistributedStorage = this.dataMode.isDistributedStorage(checkNode);
        this.setApplyBtnVisible(isDistributedStorage);
        this.updateItemTreeScroll(checkNode);
        this.updateApplyBtnStatus(isDistributedStorage);
        this.bindModifyLblListener(checkNode);
    }

    private void bindModifyLblListener(CheckDevNode checkNode) {
        this.dataMode.getModifyLbl().addClickListener((ToolHyperLinkLabel.ClickListener)new ModifyButtonActionListener(checkNode, this.dataMode.getDeviceTree()));
    }

    private void updateItemTreeScroll(CheckDevNode checkNode) {
        this.updateItemTreeData(checkNode);
        this.setItemTreeExpansionStatus(checkNode);
        this.dataMode.setChooseIpStr(checkNode);
        this.dataMode.updateLabelText();
    }

    private void updateApplyBtnStatus(boolean isDistributedStorage) throws ToolException {
        ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes = InspectUtils.classifyDevs(this.dataMode.getCheckNodes());
        TreePath selectTree = this.dataMode.getSelectTreePath(this.dataMode.getDeviceTree());
        boolean isButtonEnable = this.checkButtonEnable(selectTree, checkTypeNodes);
        this.setApplyBtnStatus(isDistributedStorage, isButtonEnable);
    }

    private Object getUserObject(TreeSelectionEvent event) {
        TreePath treePath = event.getPath();
        CheckTreeNode treeNode = (CheckTreeNode)treePath.getLastPathComponent();
        return treeNode.getUserObject();
    }

    private void setApplyBtnStatus(boolean isDistributedStorage, boolean isButtonEnable) throws ToolException {
        this.dataMode.getApplyBtn().setEnabled(isButtonEnable && !isDistributedStorage && !this.dataMode.getBrothersNodes().isEmpty());
    }

    private boolean checkButtonEnable(TreePath selectTree, ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes) {
        String key = selectTree.getParentPath().getParentPath().getLastPathComponent().toString();
        String selectDevIp = selectTree.getLastPathComponent().toString();
        if (StringUtils.isNULLStr((String)key)) {
            return true;
        }
        String ip = this.getHeadDeviceIp((List)checkTypeNodes.get((Object)key));
        if (selectDevIp.equals(ip)) {
            return true;
        }
        this.dataMode.getApplyBtn().setEnabled(false);
        return false;
    }

    private void setApplyBtnVisible(boolean isDistributedStorage) {
        if (isDistributedStorage) {
            this.dataMode.getApplyBtn().setVisible(false);
        }
    }

    private void updateItemTreeData(CheckDevNode checkNode) {
        this.dataMode.initItemTreeData(checkNode);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel((TreeNode)this.dataMode.getItemRootNodeFather(), true);
        this.dataMode.getItemTree().setModel((TreeModel)defaultTreeModel);
    }

    private void setItemTreeExpansionStatus(CheckDevNode checkDevNode) {
        boolean isDistributedStorage = checkDevNode.getDevNode().isDsStorage();
        if (isDistributedStorage) {
            this.expandItemTree();
            return;
        }
        Object[] baseTreePath = this.dataMode.getItemRootNode().getPath();
        this.dataMode.getItemTree().expandPath(new TreePath(baseTreePath));
        Object[] depthTreePath = this.dataMode.getItemRootNodeDepth().getPath();
        this.dataMode.getItemTree().expandPath(new TreePath(depthTreePath));
    }

    private void expandItemTree() {
        IntStream.range(0, this.dataMode.getItemRootNodeFather().getChildCount()).forEach(this::expandPath);
    }

    private void expandPath(int index) {
        CheckTreeNode sceneNode = (CheckTreeNode)this.dataMode.getItemRootNodeFather().getChildAt(index);
        this.dataMode.getItemTree().expandPath(new TreePath(sceneNode.getPath()));
    }

    private String getHeadDeviceIp(List<CheckDevNode> checkNodes) {
        return checkNodes.stream().findFirst().map(this::getFirstChildIp).orElse("");
    }

    private String getFirstChildIp(CheckDevNode node) {
        return node.getChildrens().stream().findFirst().map(child -> child.getDevNodeSafe().getIp()).orElse("");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.processHighlight();
    }

    private void processHighlight() {
        if (!this.dataMode.getHighlightTreeNode().isHilight()) {
            return;
        }
        this.dataMode.getHighlightTreeNode().setHilight(false);
        this.dataMode.getDeviceTree().repaint();
    }
}

